/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingTermVectorsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.BlockPackedReaderIterator;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingTermVectorsReader
extends TermVectorsReader
implements Closeable {
    private final FieldInfos fieldInfos;
    final CompressingStoredFieldsIndexReader indexReader;
    final IndexInput vectorsStream;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final Decompressor decompressor;
    private final int chunkSize;
    private final int numDocs;
    private boolean closed;
    private final BlockPackedReaderIterator reader;

    private CompressingTermVectorsReader(CompressingTermVectorsReader reader) {
        this.fieldInfos = reader.fieldInfos;
        this.vectorsStream = reader.vectorsStream.clone();
        this.indexReader = reader.indexReader.clone();
        this.packedIntsVersion = reader.packedIntsVersion;
        this.compressionMode = reader.compressionMode;
        this.decompressor = reader.decompressor.clone();
        this.chunkSize = reader.chunkSize;
        this.numDocs = reader.numDocs;
        this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
        this.closed = false;
    }

    public CompressingTermVectorsReader(Directory d, SegmentInfo si, String segmentSuffix, FieldInfos fn, IOContext context, String formatName, CompressionMode compressionMode) throws IOException {
        this.compressionMode = compressionMode;
        String segment = si.name;
        boolean success = false;
        this.fieldInfos = fn;
        this.numDocs = si.getDocCount();
        IndexInput indexStream = null;
        try {
            String indexStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "tvx");
            indexStream = d.openInput(indexStreamFN, context);
            String codecNameIdx = String.valueOf(formatName) + "Index";
            CodecUtil.checkHeader(indexStream, codecNameIdx, 0, 0);
            assert ((long)CodecUtil.headerLength(codecNameIdx) == indexStream.getFilePointer());
            this.indexReader = new CompressingStoredFieldsIndexReader(indexStream, si);
            indexStream.close();
            indexStream = null;
            String vectorsStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "tvd");
            this.vectorsStream = d.openInput(vectorsStreamFN, context);
            String codecNameDat = String.valueOf(formatName) + "Data";
            CodecUtil.checkHeader(this.vectorsStream, codecNameDat, 0, 0);
            assert ((long)CodecUtil.headerLength(codecNameDat) == this.vectorsStream.getFilePointer());
            this.packedIntsVersion = this.vectorsStream.readVInt();
            this.chunkSize = this.vectorsStream.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
            success = true;
        }
        catch (Throwable throwable) {
            if (!success) {
                IOUtils.closeWhileHandlingException(this, indexStream);
            }
            throw throwable;
        }
        if (!success) {
            IOUtils.closeWhileHandlingException(this, indexStream);
        }
    }

    CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    CompressingStoredFieldsIndexReader getIndex() {
        return this.indexReader;
    }

    IndexInput getVectorsStream() {
        return this.vectorsStream;
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.vectorsStream);
            this.closed = true;
        }
    }

    @Override
    public TermVectorsReader clone() {
        return new CompressingTermVectorsReader(this);
    }

    @Override
    public Fields get(int doc) throws IOException {
        int k;
        Object lengths;
        Object startOffsets;
        int j;
        int k2;
        LongsRef next;
        int j2;
        int termCount;
        PackedInts.Reader flags;
        int i;
        int numFields;
        int totalFields;
        int skip;
        this.ensureOpen();
        long startPointer = this.indexReader.getStartPointer(doc);
        this.vectorsStream.seek(startPointer);
        int docBase = this.vectorsStream.readVInt();
        int chunkDocs = this.vectorsStream.readVInt();
        if (doc < docBase || doc >= docBase + chunkDocs || docBase + chunkDocs > this.numDocs) {
            throw new CorruptIndexException("docBase=" + docBase + ",chunkDocs=" + chunkDocs + ",doc=" + doc + " (resource=" + this.vectorsStream + ")");
        }
        if (chunkDocs == 1) {
            skip = 0;
            numFields = totalFields = this.vectorsStream.readVInt();
        } else {
            this.reader.reset(this.vectorsStream, chunkDocs);
            int sum = 0;
            int i2 = docBase;
            while (i2 < doc) {
                sum = (int)((long)sum + this.reader.next());
                ++i2;
            }
            skip = sum;
            numFields = (int)this.reader.next();
            sum += numFields;
            i2 = doc + 1;
            while (i2 < docBase + chunkDocs) {
                sum = (int)((long)sum + this.reader.next());
                ++i2;
            }
            totalFields = sum;
        }
        if (numFields == 0) {
            return null;
        }
        int token = this.vectorsStream.readByte() & 0xFF;
        assert (token != 0);
        int bitsPerFieldNum = token & 0x1F;
        int totalDistinctFields = token >>> 5;
        if (totalDistinctFields == 7) {
            totalDistinctFields += this.vectorsStream.readVInt();
        }
        PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, ++totalDistinctFields, bitsPerFieldNum, 1);
        int[] fieldNums = new int[totalDistinctFields];
        int i3 = 0;
        while (i3 < totalDistinctFields) {
            fieldNums[i3] = (int)it.next();
            ++i3;
        }
        int[] fieldNumOffs = new int[numFields];
        int bitsPerOff = PackedInts.bitsRequired(fieldNums.length - 1);
        PackedInts.Reader allFieldNumOffs = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, totalFields, bitsPerOff);
        switch (this.vectorsStream.readVInt()) {
            case 0: {
                PackedInts.Reader fieldFlags = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, fieldNums.length, CompressingTermVectorsWriter.FLAGS_BITS);
                PackedInts.Mutable f = PackedInts.getMutable(totalFields, CompressingTermVectorsWriter.FLAGS_BITS, 0.0f);
                i = 0;
                while (i < totalFields) {
                    int fieldNumOff = (int)allFieldNumOffs.get(i);
                    assert (fieldNumOff >= 0 && fieldNumOff < fieldNums.length);
                    int fgs = (int)fieldFlags.get(fieldNumOff);
                    f.set(i, fgs);
                    ++i;
                }
                flags = f;
                break;
            }
            case 1: {
                flags = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, totalFields, CompressingTermVectorsWriter.FLAGS_BITS);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        i = 0;
        while (i < numFields) {
            fieldNumOffs[i] = (int)allFieldNumOffs.get(skip + i);
            ++i;
        }
        int bitsRequired = this.vectorsStream.readVInt();
        PackedInts.Reader numTerms = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, totalFields, bitsRequired);
        int sum = 0;
        i = 0;
        while (i < totalFields) {
            sum = (int)((long)sum + numTerms.get(i));
            ++i;
        }
        int totalTerms = sum;
        int docOff = 0;
        int docLen = 0;
        int[] fieldLengths = new int[numFields];
        int[][] prefixLengths = new int[numFields][];
        int[][] suffixLengths = new int[numFields][];
        this.reader.reset(this.vectorsStream, totalTerms);
        int toSkip = 0;
        int i4 = 0;
        while (i4 < skip) {
            toSkip = (int)((long)toSkip + numTerms.get(i4));
            ++i4;
        }
        this.reader.skip(toSkip);
        i4 = 0;
        while (i4 < numFields) {
            termCount = (int)numTerms.get(skip + i4);
            int[] fieldPrefixLengths = new int[termCount];
            prefixLengths[i4] = fieldPrefixLengths;
            j2 = 0;
            while (j2 < termCount) {
                next = this.reader.next(termCount - j2);
                k2 = 0;
                while (k2 < next.length) {
                    fieldPrefixLengths[j2++] = (int)next.longs[next.offset + k2];
                    ++k2;
                }
            }
            ++i4;
        }
        this.reader.skip((long)totalTerms - this.reader.ord());
        this.reader.reset(this.vectorsStream, totalTerms);
        toSkip = 0;
        i4 = 0;
        while (i4 < skip) {
            j = 0;
            while ((long)j < numTerms.get(i4)) {
                docOff = (int)((long)docOff + this.reader.next());
                ++j;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < numFields) {
            termCount = (int)numTerms.get(skip + i4);
            int[] fieldSuffixLengths = new int[termCount];
            suffixLengths[i4] = fieldSuffixLengths;
            j2 = 0;
            while (j2 < termCount) {
                next = this.reader.next(termCount - j2);
                k2 = 0;
                while (k2 < next.length) {
                    fieldSuffixLengths[j2++] = (int)next.longs[next.offset + k2];
                    ++k2;
                }
            }
            fieldLengths[i4] = CompressingTermVectorsReader.sum(suffixLengths[i4]);
            docLen += fieldLengths[i4];
            ++i4;
        }
        int totalLen = docOff + docLen;
        i4 = skip + numFields;
        while (i4 < totalFields) {
            j = 0;
            while ((long)j < numTerms.get(i4)) {
                totalLen = (int)((long)totalLen + this.reader.next());
                ++j;
            }
            ++i4;
        }
        int[] termFreqs = new int[totalTerms];
        this.reader.reset(this.vectorsStream, totalTerms);
        i4 = 0;
        while (i4 < totalTerms) {
            LongsRef next2 = this.reader.next(totalTerms - i4);
            int k3 = 0;
            while (k3 < next2.length) {
                termFreqs[i4++] = 1 + (int)next2.longs[next2.offset + k3];
                ++k3;
            }
        }
        int totalPositions = 0;
        int totalOffsets = 0;
        int totalPayloads = 0;
        int i5 = 0;
        int termIndex = 0;
        while (i5 < totalFields) {
            int f = (int)flags.get(i5);
            int termCount2 = (int)numTerms.get(i5);
            int j3 = 0;
            while (j3 < termCount2) {
                int freq = termFreqs[termIndex++];
                if ((f & 1) != 0) {
                    totalPositions += freq;
                }
                if ((f & 2) != 0) {
                    totalOffsets += freq;
                }
                if ((f & 4) != 0) {
                    totalPayloads += freq;
                }
                ++j3;
            }
            assert (i5 != totalFields - 1 || termIndex == totalTerms) : String.valueOf(termIndex) + " " + totalTerms;
            ++i5;
        }
        int[][] positionIndex = this.positionIndex(skip, numFields, numTerms, termFreqs);
        Object positions = totalPositions > 0 ? (Object)this.readPositions(skip, numFields, flags, numTerms, termFreqs, 1, totalPositions, positionIndex) : new int[numFields][];
        if (totalOffsets > 0) {
            float[] charsPerTerm = new float[fieldNums.length];
            int i6 = 0;
            while (i6 < charsPerTerm.length) {
                charsPerTerm[i6] = Float.intBitsToFloat(this.vectorsStream.readInt());
                ++i6;
            }
            startOffsets = this.readPositions(skip, numFields, flags, numTerms, termFreqs, 2, totalOffsets, positionIndex);
            lengths = this.readPositions(skip, numFields, flags, numTerms, termFreqs, 2, totalOffsets, positionIndex);
            i6 = 0;
            while (i6 < numFields) {
                int[] fStartOffsets = startOffsets[i6];
                int[] fPositions = positions[i6];
                if (fStartOffsets != null && fPositions != null) {
                    float fieldCharsPerTerm = charsPerTerm[fieldNumOffs[i6]];
                    int j4 = 0;
                    while (j4 < startOffsets[i6].length) {
                        int n = j4;
                        fStartOffsets[n] = fStartOffsets[n] + (int)(fieldCharsPerTerm * (float)fPositions[j4]);
                        ++j4;
                    }
                }
                if (fStartOffsets != null) {
                    int[] fPrefixLengths = prefixLengths[i6];
                    int[] fSuffixLengths = suffixLengths[i6];
                    int[] fLengths = lengths[i6];
                    int j5 = 0;
                    int end = (int)numTerms.get(skip + i6);
                    while (j5 < end) {
                        int termLength = fPrefixLengths[j5] + fSuffixLengths[j5];
                        int[] nArray = lengths[i6];
                        int n = positionIndex[i6][j5];
                        nArray[n] = nArray[n] + termLength;
                        k = positionIndex[i6][j5] + 1;
                        while (k < positionIndex[i6][j5 + 1]) {
                            int n2 = k;
                            fStartOffsets[n2] = fStartOffsets[n2] + fStartOffsets[k - 1];
                            int n3 = k++;
                            fLengths[n3] = fLengths[n3] + termLength;
                        }
                        ++j5;
                    }
                }
                ++i6;
            }
        } else {
            startOffsets = lengths = new int[numFields][];
        }
        if (totalPositions > 0) {
            int i7 = 0;
            while (i7 < numFields) {
                int[] fPositions = positions[i7];
                int[] fpositionIndex = positionIndex[i7];
                if (fPositions != null) {
                    int j6 = 0;
                    int end = (int)numTerms.get(skip + i7);
                    while (j6 < end) {
                        int k4 = fpositionIndex[j6] + 1;
                        while (k4 < fpositionIndex[j6 + 1]) {
                            int n = k4;
                            fPositions[n] = fPositions[n] + fPositions[k4 - 1];
                            ++k4;
                        }
                        ++j6;
                    }
                }
                ++i7;
            }
        }
        int[][] payloadIndex = new int[numFields][];
        int totalPayloadLength = 0;
        int payloadOff = 0;
        int payloadLen = 0;
        if (totalPayloads > 0) {
            int freq;
            int j7;
            int termCount3;
            this.reader.reset(this.vectorsStream, totalPayloads);
            int termIndex2 = 0;
            int i8 = 0;
            while (i8 < skip) {
                int f = (int)flags.get(i8);
                termCount3 = (int)numTerms.get(i8);
                if ((f & 4) != 0) {
                    j7 = 0;
                    while (j7 < termCount3) {
                        freq = termFreqs[termIndex2 + j7];
                        k = 0;
                        while (k < freq) {
                            int l = (int)this.reader.next();
                            payloadOff += l;
                            ++k;
                        }
                        ++j7;
                    }
                }
                termIndex2 += termCount3;
                ++i8;
            }
            totalPayloadLength = payloadOff;
            i8 = 0;
            while (i8 < numFields) {
                int f = (int)flags.get(skip + i8);
                termCount3 = (int)numTerms.get(skip + i8);
                if ((f & 4) != 0) {
                    int totalFreq = positionIndex[i8][termCount3];
                    payloadIndex[i8] = new int[totalFreq + 1];
                    int posIdx = 0;
                    payloadIndex[i8][posIdx] = payloadLen;
                    int j8 = 0;
                    while (j8 < termCount3) {
                        int freq2 = termFreqs[termIndex2 + j8];
                        int k5 = 0;
                        while (k5 < freq2) {
                            int payloadLength = (int)this.reader.next();
                            payloadIndex[i8][posIdx + 1] = payloadLen += payloadLength;
                            ++posIdx;
                            ++k5;
                        }
                        ++j8;
                    }
                    assert (posIdx == totalFreq);
                }
                termIndex2 += termCount3;
                ++i8;
            }
            totalPayloadLength += payloadLen;
            i8 = skip + numFields;
            while (i8 < totalFields) {
                int f = (int)flags.get(i8);
                termCount3 = (int)numTerms.get(i8);
                if ((f & 4) != 0) {
                    j7 = 0;
                    while (j7 < termCount3) {
                        freq = termFreqs[termIndex2 + j7];
                        k = 0;
                        while (k < freq) {
                            totalPayloadLength = (int)((long)totalPayloadLength + this.reader.next());
                            ++k;
                        }
                        ++j7;
                    }
                }
                termIndex2 += termCount3;
                ++i8;
            }
            assert (termIndex2 == totalTerms) : String.valueOf(termIndex2) + " " + totalTerms;
        }
        BytesRef suffixBytes = new BytesRef();
        this.decompressor.decompress(this.vectorsStream, totalLen + totalPayloadLength, docOff + payloadOff, docLen + payloadLen, suffixBytes);
        suffixBytes.length = docLen;
        BytesRef payloadBytes = new BytesRef(suffixBytes.bytes, suffixBytes.offset + docLen, payloadLen);
        int[] fieldFlags = new int[numFields];
        int i9 = 0;
        while (i9 < numFields) {
            fieldFlags[i9] = (int)flags.get(skip + i9);
            ++i9;
        }
        int[] fieldNumTerms = new int[numFields];
        int i10 = 0;
        while (i10 < numFields) {
            fieldNumTerms[i10] = (int)numTerms.get(skip + i10);
            ++i10;
        }
        int[][] fieldTermFreqs = new int[numFields][];
        int termIdx = 0;
        int i11 = 0;
        while (i11 < skip) {
            termIdx = (int)((long)termIdx + numTerms.get(i11));
            ++i11;
        }
        i11 = 0;
        while (i11 < numFields) {
            int termCount4 = (int)numTerms.get(skip + i11);
            fieldTermFreqs[i11] = new int[termCount4];
            int j9 = 0;
            while (j9 < termCount4) {
                fieldTermFreqs[i11][j9] = termFreqs[termIdx++];
                ++j9;
            }
            ++i11;
        }
        assert (CompressingTermVectorsReader.sum(fieldLengths) == docLen) : String.valueOf(CompressingTermVectorsReader.sum(fieldLengths)) + " != " + docLen;
        return new TVFields(fieldNums, fieldFlags, fieldNumOffs, fieldNumTerms, fieldLengths, prefixLengths, suffixLengths, fieldTermFreqs, positionIndex, (int[][])positions, (int[][])startOffsets, (int[][])lengths, payloadBytes, payloadIndex, suffixBytes);
    }

    private int[][] positionIndex(int skip, int numFields, PackedInts.Reader numTerms, int[] termFreqs) {
        int termCount;
        int[][] positionIndex = new int[numFields][];
        int termIndex = 0;
        int i = 0;
        while (i < skip) {
            termCount = (int)numTerms.get(i);
            termIndex += termCount;
            ++i;
        }
        i = 0;
        while (i < numFields) {
            termCount = (int)numTerms.get(skip + i);
            positionIndex[i] = new int[termCount + 1];
            int j = 0;
            while (j < termCount) {
                int freq = termFreqs[termIndex + j];
                positionIndex[i][j + 1] = positionIndex[i][j] + freq;
                ++j;
            }
            termIndex += termCount;
            ++i;
        }
        return positionIndex;
    }

    private int[][] readPositions(int skip, int numFields, PackedInts.Reader flags, PackedInts.Reader numTerms, int[] termFreqs, int flag, int totalPositions, int[][] positionIndex) throws IOException {
        int termCount;
        int f;
        int[][] positions = new int[numFields][];
        this.reader.reset(this.vectorsStream, totalPositions);
        int toSkip = 0;
        int termIndex = 0;
        int i = 0;
        while (i < skip) {
            f = (int)flags.get(i);
            termCount = (int)numTerms.get(i);
            if ((f & flag) != 0) {
                int j = 0;
                while (j < termCount) {
                    int freq = termFreqs[termIndex + j];
                    toSkip += freq;
                    ++j;
                }
            }
            termIndex += termCount;
            ++i;
        }
        this.reader.skip(toSkip);
        i = 0;
        while (i < numFields) {
            f = (int)flags.get(skip + i);
            termCount = (int)numTerms.get(skip + i);
            if ((f & flag) != 0) {
                int totalFreq = positionIndex[i][termCount];
                int[] fieldPositions = new int[totalFreq];
                positions[i] = fieldPositions;
                int j = 0;
                while (j < totalFreq) {
                    LongsRef nextPositions = this.reader.next(totalFreq - j);
                    int k = 0;
                    while (k < nextPositions.length) {
                        fieldPositions[j++] = (int)nextPositions.longs[nextPositions.offset + k];
                        ++k;
                    }
                }
            }
            termIndex += termCount;
            ++i;
        }
        this.reader.skip((long)totalPositions - this.reader.ord());
        return positions;
    }

    private static int sum(int[] arr) {
        int sum = 0;
        int[] nArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            int el = nArray[n2];
            sum += el;
            ++n2;
        }
        return sum;
    }

    @Override
    public long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    private static class TVDocsEnum
    extends DocsAndPositionsEnum {
        private Bits liveDocs;
        private int doc = -1;
        private int termFreq;
        private int positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private final BytesRef payload = new BytesRef();
        private int[] payloadIndex;
        private int basePayloadOffset;
        private int i;

        TVDocsEnum() {
        }

        public void reset(Bits liveDocs, int freq, int positionIndex, int[] positions, int[] startOffsets, int[] lengths, BytesRef payloads, int[] payloadIndex) {
            this.liveDocs = liveDocs;
            this.termFreq = freq;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.basePayloadOffset = payloads.offset;
            this.payload.bytes = payloads.bytes;
            this.payload.length = 0;
            this.payload.offset = 0;
            this.payloadIndex = payloadIndex;
            this.i = -1;
            this.doc = -1;
        }

        private void checkDoc() {
            if (this.doc == Integer.MAX_VALUE) {
                throw new IllegalStateException("DocsEnum exhausted");
            }
            if (this.doc == -1) {
                throw new IllegalStateException("DocsEnum not started");
            }
        }

        private void checkPosition() {
            this.checkDoc();
            if (this.i < 0) {
                throw new IllegalStateException("Position enum not started");
            }
            if (this.i >= this.termFreq) {
                throw new IllegalStateException("Read past last position");
            }
        }

        @Override
        public int nextPosition() throws IOException {
            if (this.doc != 0) {
                throw new IllegalStateException();
            }
            if (this.i >= this.termFreq - 1) {
                throw new IllegalStateException("Read past last position");
            }
            ++this.i;
            if (this.payloadIndex != null) {
                this.payload.offset = this.basePayloadOffset + this.payloadIndex[this.positionIndex + this.i];
                this.payload.length = this.payloadIndex[this.positionIndex + this.i + 1] - this.payloadIndex[this.positionIndex + this.i];
            }
            if (this.positions == null) {
                return -1;
            }
            return this.positions[this.positionIndex + this.i];
        }

        @Override
        public int startOffset() throws IOException {
            this.checkPosition();
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.positionIndex + this.i];
        }

        @Override
        public int endOffset() throws IOException {
            this.checkPosition();
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.positionIndex + this.i] + this.lengths[this.positionIndex + this.i];
        }

        @Override
        public BytesRef getPayload() throws IOException {
            this.checkPosition();
            if (this.payloadIndex == null || this.payload.length == 0) {
                return null;
            }
            return this.payload;
        }

        @Override
        public int freq() throws IOException {
            this.checkDoc();
            return this.termFreq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.doc == -1 && (this.liveDocs == null || this.liveDocs.get(0))) {
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public long cost() {
            return 1L;
        }
    }

    private class TVFields
    extends Fields {
        private final int[] fieldNums;
        private final int[] fieldFlags;
        private final int[] fieldNumOffs;
        private final int[] numTerms;
        private final int[] fieldLengths;
        private final int[][] prefixLengths;
        private final int[][] suffixLengths;
        private final int[][] termFreqs;
        private final int[][] positionIndex;
        private final int[][] positions;
        private final int[][] startOffsets;
        private final int[][] lengths;
        private final int[][] payloadIndex;
        private final BytesRef suffixBytes;
        private final BytesRef payloadBytes;

        public TVFields(int[] fieldNums, int[] fieldFlags, int[] fieldNumOffs, int[] numTerms, int[] fieldLengths, int[][] prefixLengths, int[][] suffixLengths, int[][] termFreqs, int[][] positionIndex, int[][] positions, int[][] startOffsets, int[][] lengths, BytesRef payloadBytes, int[][] payloadIndex, BytesRef suffixBytes) {
            this.fieldNums = fieldNums;
            this.fieldFlags = fieldFlags;
            this.fieldNumOffs = fieldNumOffs;
            this.numTerms = numTerms;
            this.fieldLengths = fieldLengths;
            this.prefixLengths = prefixLengths;
            this.suffixLengths = suffixLengths;
            this.termFreqs = termFreqs;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.payloadBytes = payloadBytes;
            this.payloadIndex = payloadIndex;
            this.suffixBytes = suffixBytes;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < TVFields.this.fieldNumOffs.length;
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int fieldNum = TVFields.this.fieldNums[TVFields.this.fieldNumOffs[this.i++]];
                    return ((CompressingTermVectorsReader)((TVFields)TVFields.this).CompressingTermVectorsReader.this).fieldInfos.fieldInfo((int)fieldNum).name;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Terms terms(String field) throws IOException {
            FieldInfo fieldInfo = CompressingTermVectorsReader.this.fieldInfos.fieldInfo(field);
            if (fieldInfo == null) {
                return null;
            }
            int idx = -1;
            int i = 0;
            while (i < this.fieldNumOffs.length) {
                if (this.fieldNums[this.fieldNumOffs[i]] == fieldInfo.number) {
                    idx = i;
                    break;
                }
                ++i;
            }
            if (idx == -1 || this.numTerms[idx] == 0) {
                return null;
            }
            int fieldOff = 0;
            int fieldLen = -1;
            int i2 = 0;
            while (i2 < this.fieldNumOffs.length) {
                if (i2 < idx) {
                    fieldOff += this.fieldLengths[i2];
                } else {
                    fieldLen = this.fieldLengths[i2];
                    break;
                }
                ++i2;
            }
            assert (fieldLen >= 0);
            return new TVTerms(this.numTerms[idx], this.fieldFlags[idx], this.prefixLengths[idx], this.suffixLengths[idx], this.termFreqs[idx], this.positionIndex[idx], this.positions[idx], this.startOffsets[idx], this.lengths[idx], this.payloadIndex[idx], this.payloadBytes, new BytesRef(this.suffixBytes.bytes, this.suffixBytes.offset + fieldOff, fieldLen));
        }

        @Override
        public int size() {
            return this.fieldNumOffs.length;
        }
    }

    private class TVTerms
    extends Terms {
        private final int numTerms;
        private final int flags;
        private final int[] prefixLengths;
        private final int[] suffixLengths;
        private final int[] termFreqs;
        private final int[] positionIndex;
        private final int[] positions;
        private final int[] startOffsets;
        private final int[] lengths;
        private final int[] payloadIndex;
        private final BytesRef termBytes;
        private final BytesRef payloadBytes;

        TVTerms(int numTerms, int flags, int[] prefixLengths, int[] suffixLengths, int[] termFreqs, int[] positionIndex, int[] positions, int[] startOffsets, int[] lengths, int[] payloadIndex, BytesRef payloadBytes, BytesRef termBytes) {
            this.numTerms = numTerms;
            this.flags = flags;
            this.prefixLengths = prefixLengths;
            this.suffixLengths = suffixLengths;
            this.termFreqs = termFreqs;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.payloadIndex = payloadIndex;
            this.payloadBytes = payloadBytes;
            this.termBytes = termBytes;
        }

        @Override
        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            TVTermsEnum termsEnum = reuse != null && reuse instanceof TVTermsEnum ? (TVTermsEnum)reuse : new TVTermsEnum();
            termsEnum.reset(this.numTerms, this.flags, this.prefixLengths, this.suffixLengths, this.termFreqs, this.positionIndex, this.positions, this.startOffsets, this.lengths, this.payloadIndex, this.payloadBytes, new ByteArrayDataInput(this.termBytes.bytes, this.termBytes.offset, this.termBytes.length));
            return termsEnum;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public long size() throws IOException {
            return this.numTerms;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.numTerms;
        }

        @Override
        public int getDocCount() throws IOException {
            return 1;
        }

        @Override
        public boolean hasOffsets() {
            return (this.flags & 2) != 0;
        }

        @Override
        public boolean hasPositions() {
            return (this.flags & 1) != 0;
        }

        @Override
        public boolean hasPayloads() {
            return (this.flags & 4) != 0;
        }
    }

    private static class TVTermsEnum
    extends TermsEnum {
        private int numTerms;
        private int startPos;
        private int ord;
        private int[] prefixLengths;
        private int[] suffixLengths;
        private int[] termFreqs;
        private int[] positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private int[] payloadIndex;
        private ByteArrayDataInput in;
        private BytesRef payloads;
        private final BytesRef term = new BytesRef(16);

        private TVTermsEnum() {
        }

        void reset(int numTerms, int flags, int[] prefixLengths, int[] suffixLengths, int[] termFreqs, int[] positionIndex, int[] positions, int[] startOffsets, int[] lengths, int[] payloadIndex, BytesRef payloads, ByteArrayDataInput in) {
            this.numTerms = numTerms;
            this.prefixLengths = prefixLengths;
            this.suffixLengths = suffixLengths;
            this.termFreqs = termFreqs;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.payloadIndex = payloadIndex;
            this.payloads = payloads;
            this.in = in;
            this.startPos = in.getPosition();
            this.reset();
        }

        void reset() {
            this.term.length = 0;
            this.in.setPosition(this.startPos);
            this.ord = -1;
        }

        @Override
        public BytesRef next() throws IOException {
            if (this.ord == this.numTerms - 1) {
                return null;
            }
            assert (this.ord < this.numTerms);
            ++this.ord;
            this.term.offset = 0;
            this.term.length = this.prefixLengths[this.ord] + this.suffixLengths[this.ord];
            if (this.term.length > this.term.bytes.length) {
                this.term.bytes = ArrayUtil.grow(this.term.bytes, this.term.length);
            }
            this.in.readBytes(this.term.bytes, this.prefixLengths[this.ord], this.suffixLengths[this.ord]);
            return this.term;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            int cmp;
            if (this.ord < this.numTerms && this.ord >= 0) {
                int cmp2 = this.term().compareTo(text);
                if (cmp2 == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp2 > 0) {
                    this.reset();
                }
            }
            do {
                BytesRef term;
                if ((term = this.next()) == null) {
                    return TermsEnum.SeekStatus.END;
                }
                cmp = term.compareTo(text);
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (cmp != 0);
            return TermsEnum.SeekStatus.FOUND;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            return 1;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.termFreqs[this.ord];
        }

        @Override
        public final DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            TVDocsEnum docsEnum = reuse != null && reuse instanceof TVDocsEnum ? (TVDocsEnum)reuse : new TVDocsEnum();
            docsEnum.reset(liveDocs, this.termFreqs[this.ord], this.positionIndex[this.ord], this.positions, this.startOffsets, this.lengths, this.payloads, this.payloadIndex);
            return docsEnum;
        }

        @Override
        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            if (this.positions == null && this.startOffsets == null) {
                return null;
            }
            return (DocsAndPositionsEnum)this.docs(liveDocs, reuse, flags);
        }
    }
}

