/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;

public final class StemmerOverrideFilter
extends TokenFilter {
    private final StemmerOverrideMap stemmerOverrideMap;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);
    private final FST.BytesReader fstReader;
    private final FST.Arc<BytesRef> scratchArc = new FST.Arc();
    private final CharsRef spare = new CharsRef();

    public StemmerOverrideFilter(TokenStream input, StemmerOverrideMap stemmerOverrideMap) {
        super(input);
        this.stemmerOverrideMap = stemmerOverrideMap;
        this.fstReader = stemmerOverrideMap.getBytesReader();
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            BytesRef stem;
            if (this.fstReader == null) {
                return true;
            }
            if (!this.keywordAtt.isKeyword() && (stem = this.stemmerOverrideMap.get(this.termAtt.buffer(), this.termAtt.length(), this.scratchArc, this.fstReader)) != null) {
                this.spare.chars = this.termAtt.buffer();
                char[] buffer = this.spare.chars;
                UnicodeUtil.UTF8toUTF16(stem.bytes, stem.offset, stem.length, this.spare);
                if (this.spare.chars != buffer) {
                    this.termAtt.copyBuffer(this.spare.chars, this.spare.offset, this.spare.length);
                }
                this.termAtt.setLength(this.spare.length);
                this.keywordAtt.setKeyword(true);
            }
            return true;
        }
        return false;
    }

    public static class Builder {
        private final BytesRefHash hash = new BytesRefHash();
        private final BytesRef spare = new BytesRef();
        private final ArrayList<CharSequence> outputValues = new ArrayList();
        private final boolean ignoreCase;
        private final CharsRef charsSpare = new CharsRef();

        public Builder() {
            this(false);
        }

        public Builder(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        public boolean add(CharSequence input, CharSequence output) {
            int length = input.length();
            if (this.ignoreCase) {
                this.charsSpare.grow(length);
                char[] buffer = this.charsSpare.chars;
                int i = 0;
                while (i < length) {
                    i += Character.toChars(Character.toLowerCase(Character.codePointAt(input, i)), buffer, i);
                }
                UnicodeUtil.UTF16toUTF8(buffer, 0, length, this.spare);
            } else {
                UnicodeUtil.UTF16toUTF8(input, 0, length, this.spare);
            }
            if (this.hash.add(this.spare) >= 0) {
                this.outputValues.add(output);
                return true;
            }
            return false;
        }

        public StemmerOverrideMap build() throws IOException {
            ByteSequenceOutputs outputs = ByteSequenceOutputs.getSingleton();
            org.apache.lucene.util.fst.Builder<BytesRef> builder = new org.apache.lucene.util.fst.Builder<BytesRef>(FST.INPUT_TYPE.BYTE4, outputs);
            int[] sort = this.hash.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
            IntsRef intsSpare = new IntsRef();
            int size = this.hash.size();
            int i = 0;
            while (i < size) {
                int id = sort[i];
                BytesRef bytesRef = this.hash.get(id, this.spare);
                UnicodeUtil.UTF8toUTF32(bytesRef, intsSpare);
                builder.add(intsSpare, new BytesRef(this.outputValues.get(id)));
                ++i;
            }
            return new StemmerOverrideMap(builder.finish(), this.ignoreCase);
        }
    }

    public static final class StemmerOverrideMap {
        private final FST<BytesRef> fst;
        private final boolean ignoreCase;

        StemmerOverrideMap(FST<BytesRef> fst, boolean ignoreCase) {
            this.fst = fst;
            this.ignoreCase = ignoreCase;
        }

        FST.BytesReader getBytesReader() {
            if (this.fst == null) {
                return null;
            }
            return this.fst.getBytesReader();
        }

        BytesRef get(char[] buffer, int bufferLen, FST.Arc<BytesRef> scratchArc, FST.BytesReader fstReader) throws IOException {
            BytesRef pendingOutput = (BytesRef)this.fst.outputs.getNoOutput();
            BytesRef matchOutput = null;
            int bufUpto = 0;
            this.fst.getFirstArc(scratchArc);
            while (bufUpto < bufferLen) {
                int codePoint = Character.codePointAt(buffer, bufUpto, bufferLen);
                if (this.fst.findTargetArc(this.ignoreCase ? Character.toLowerCase(codePoint) : codePoint, scratchArc, scratchArc, fstReader) == null) {
                    return null;
                }
                pendingOutput = this.fst.outputs.add(pendingOutput, (BytesRef)scratchArc.output);
                bufUpto += Character.charCount(codePoint);
            }
            if (scratchArc.isFinal()) {
                matchOutput = this.fst.outputs.add(pendingOutput, (BytesRef)scratchArc.nextFinalOutput);
            }
            return matchOutput;
        }
    }
}

