/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.windows;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.library.ResourceGetter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class InfoWindow {
    private static final Logger logger = Logger.getLogger(InfoWindow.class.getName());
    protected static final String AUTO_CLOSURE = "";
    protected static final String OK = Messages.getString((String)"MsgBox.OK", (String[])new String[0]);
    protected static final String ANNULER = Messages.getString((String)"MsgBox.ANNULER", (String[])new String[0]);
    public static boolean opened = false;
    public static InfoWindow window = null;
    public static int newViewAutoCloseDelay = -1;
    protected int timeToStay;
    protected Shell shell;
    protected Image image;
    protected Color color;
    protected String[] texte;
    protected Point location;
    protected int newAutoCloseDelay;
    protected Composite compSpecialArea;
    protected SashForm sashSpecialArea;
    private Boolean ok = Boolean.FALSE;
    private KeyListener keyListenCloseIt = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.character == '\r') {
                InfoWindow.this.close();
            } else if (e.character == '\u001b') {
                InfoWindow.this.close();
            }
        }
    };
    private MouseTrackListener trackListener = new MouseTrackListener(){

        public void mouseEnter(MouseEvent e) {
            logger.fine(e.getSource().getClass().getName());
        }

        public void mouseExit(MouseEvent e) {
            logger.fine(e.getSource().getClass().getName());
        }

        public void mouseHover(MouseEvent e) {
            logger.fine(e.getSource().getClass().getName());
        }
    };
    public static final int EDGE_LT = 2;
    public static final int EDGE_RT = 4;
    public static final int EDGE_LB = 8;
    public static final int EDGE_RB = 16;
    public static final int EDGES_LEFT = 10;
    public static final int EDGES_RIGHT = 20;
    public static final int EDGES_TOP = 6;
    public static final int EDGES_BOTTOM = 24;
    public static final int EDGES_ALL = 30;

    public InfoWindow(Shell s, String[] texte, int timeToStay, Font f) {
        this(s, texte, timeToStay, f, null);
    }

    public InfoWindow(Shell s, String[] texte, int timeToStay, Font f, Point pos) {
        if (window != null && InfoWindow.window.shell != null && !InfoWindow.window.shell.isDisposed()) {
            window.close();
        }
        this.location = pos;
        this.texte = texte;
        this.newAutoCloseDelay = 0;
        this.timeToStay = timeToStay;
        if (timeToStay > 1000) {
            this.addAutoClose();
        }
        this.shell = new Shell(s, 16392);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        InfoWindow.this.shell.close();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
        this.createArea(texte, f);
    }

    public void createSpecialArea() {
    }

    protected void createArea(String[] texte, Font f) {
        int yy;
        int xx;
        window = this;
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.shell.setLayout((Layout)new FillLayout());
        Composite compParent = new Composite((Composite)this.shell, 0);
        compParent.setBackground(white);
        FormLayout form = new FormLayout();
        form.marginHeight = 5;
        form.marginWidth = 5;
        compParent.setLayout((Layout)form);
        this.compSpecialArea = new Composite(compParent, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100, -40);
        this.compSpecialArea.setLayoutData((Object)data);
        this.compSpecialArea.setLayout((Layout)new FillLayout());
        this.sashSpecialArea = new SashForm(this.compSpecialArea, 65792);
        this.sashSpecialArea.setLayout((Layout)new FillLayout());
        this.createSpecialArea();
        Button btnCancel = new Button(compParent, 8);
        btnCancel.setText(Messages.getString((String)"ANNULER", (String[])new String[0]));
        data = new FormData();
        data.top = new FormAttachment((Control)this.compSpecialArea, 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        data.bottom = new FormAttachment(100);
        btnCancel.setLayoutData((Object)data);
        btnCancel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                InfoWindow.this.close();
            }
        });
        Button btnOk = new Button(compParent, 8);
        btnOk.setText(Messages.getString((String)"OK", (String[])new String[0]));
        data = new FormData();
        data.top = new FormAttachment((Control)this.compSpecialArea, 5);
        data.left = new FormAttachment((Control)btnCancel, 5);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        btnOk.setLayoutData((Object)data);
        btnOk.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                InfoWindow.this.ok = Boolean.TRUE;
                InfoWindow.this.close();
            }
        });
        this.shell.pack();
        Point p = this.shell.getSize();
        if (p.x > 900) {
            this.shell.setSize(900, p.y);
        }
        InfoWindow.addRoundedBoxOnResize(this.shell, 5, 30);
        this.shell.pack();
        Monitor primary = this.shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.shell.getBounds();
        if (this.location != null) {
            logger.fine("location = " + this.location.x + ", " + this.location.y);
            xx = this.location.x + rect.width + 10 > bounds.width ? this.location.x - bounds.width + rect.width + 20 : this.location.x;
            yy = this.location.y + rect.height + 10 > bounds.height ? this.location.y - bounds.height + rect.height + 20 : this.location.y;
        } else {
            xx = bounds.x + (bounds.width - rect.width) / 2;
            yy = bounds.y + (bounds.height - rect.height) / 2;
        }
        logger.fine("location xx-yy= " + xx + ", " + yy);
        this.shell.setLocation(xx, yy);
        this.setFocus();
    }

    public void setFocus() {
    }

    protected void setKeyListener(Composite control) {
        Control[] controlArray = control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                this.setKeyListener((Composite)c);
            } else {
                c.addKeyListener(this.keyListenCloseIt);
            }
            ++n2;
        }
    }

    protected void setMouseTrackListener(Composite control) {
        Control[] controlArray = control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                this.setMouseTrackListener((Composite)c);
            } else {
                c.addMouseTrackListener(this.trackListener);
            }
            ++n2;
        }
    }

    public void open() {
        if (this.shell != null && !this.shell.isDisposed()) {
            window = this;
            this.shell.open();
        }
    }

    public void close() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            this.shell.dispose();
            window = null;
        }
    }

    public int getNewAutoCloseDelay() {
        return this.newAutoCloseDelay;
    }

    public void setNewAutoCloseDelay(int newAutoCloseDeay) {
        this.newAutoCloseDelay = newAutoCloseDeay;
    }

    public static Region regionRoundedBox(Rectangle bounds, int radius, int edges) {
        Region res = new Region();
        res.add(bounds);
        Rectangle rect = new Rectangle(0, 0, 1, 0);
        int i = 0;
        while (i < radius) {
            int y = radius - (int)Math.round(Math.sqrt(radius * radius - (radius - i) * (radius - i)));
            rect.x = bounds.x + i;
            rect.y = bounds.y;
            rect.height = y + 1;
            if ((edges & 2) != 0) {
                res.subtract(rect);
            }
            rect.x = bounds.x + bounds.width - i - 1;
            if ((edges & 4) != 0) {
                res.subtract(rect);
            }
            rect.y = bounds.y + bounds.height - y - 1;
            if ((edges & 0x10) != 0) {
                res.subtract(rect);
            }
            rect.x = bounds.x + i;
            if ((edges & 8) != 0) {
                res.subtract(rect);
            }
            ++i;
        }
        return res;
    }

    public static void addRoundedBoxOnResize(final Shell c, final int radius, final int edges) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Rectangle r = c.getBounds();
                r.x = 0;
                r.y = 0;
                c.setRegion(InfoWindow.regionRoundedBox(r, radius, edges));
            }
        };
        c.addListener(11, listener);
        listener.handleEvent(null);
    }

    private void addAutoClose() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (InfoWindow.this.getNewAutoCloseDelay() != -1) {
                            InfoWindow.this.close();
                        }
                    }
                });
            }
        };
        Timer t = new Timer();
        t.schedule(task, this.timeToStay);
    }

    public Boolean getOk() {
        return this.ok;
    }
}

