/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.util;

import ca.infodata.ofys.ui.controls.util.IDialogSettings3;
import ca.infodata.util1.ByteSerialiser;
import ca.infodata.util1.HexCodec;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DialogSettings3
implements IDialogSettings3 {
    private String name;
    private Map<String, IDialogSettings3> sections;
    private Map<String, String> items;
    private Map<String, Object> arrayItems;
    private Map<String, Object> valueCache;
    private final String TAG_SECTION = "section";
    private final String TAG_NAME = "name";
    private final String TAG_KEY = "key";
    private final String TAG_VALUE = "value";
    private final String TAG_LIST = "list";
    private final String TAG_ITEM = "item";

    public DialogSettings3(String sectionName) {
        this.name = sectionName;
        this.items = new HashMap<String, String>();
        this.arrayItems = new HashMap<String, Object>();
        this.sections = new HashMap<String, IDialogSettings3>();
        this.valueCache = new HashMap<String, Object>();
    }

    @Override
    public IDialogSettings3 addNewSection(String sectionName) {
        DialogSettings3 section = this.newDialogSettings3(sectionName);
        this.addSection(section);
        return section;
    }

    protected DialogSettings3 newDialogSettings3(String sectionName) {
        return new DialogSettings3(sectionName);
    }

    protected void addSection(IDialogSettings3 section) {
        this.sections.put(section.getName(), section);
    }

    @Override
    public String get(String key) {
        return this.items.get(key);
    }

    @Override
    public boolean hasKey(String key) {
        return this.items.containsKey(key);
    }

    @Override
    public Serializable getSerializable(String key) {
        String value = this.get(key);
        if (value != null) {
            byte[] bytes = HexCodec.hexToBytes((String)value);
            return (Serializable)ByteSerialiser.deserialize((byte[])bytes);
        }
        return null;
    }

    public void putIntArray(String key, int[] value) {
        if (value == null) {
            this.put(key, (String)null);
        } else {
            this.put(key, new JoinList(",", value).toString());
        }
    }

    public int[] getIntArray(String key) {
        int[] intValue = (int[])this.valueCache.get(key);
        if (intValue != null) {
            return intValue;
        }
        String stringValue = this.items.get(key);
        if (stringValue == null) {
            intValue = null;
        } else {
            intValue = StringUtils.splitToInt((String)stringValue, (String)",");
            Arrays.sort(intValue);
        }
        this.valueCache.put(key, intValue);
        return intValue;
    }

    @Override
    public String[] getArray(String key) {
        return (String[])this.arrayItems.get(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.items.get(key));
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        if (this.hasKey(key)) {
            return Boolean.valueOf(this.items.get(key));
        }
        return def;
    }

    @Override
    public double getDouble(String key) throws NumberFormatException {
        String setting = this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Double(setting);
    }

    @Override
    public float getFloat(String key) throws NumberFormatException {
        String setting = this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Float(setting).floatValue();
    }

    public int getIntSafe(String key, int def) {
        String v = this.items.get(key);
        if (v == null) {
            return def;
        }
        try {
            return new Integer(v);
        }
        catch (Exception exception) {
            return def;
        }
    }

    @Override
    public int getInt(String key) throws NumberFormatException {
        String setting = this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Integer(setting);
    }

    @Override
    public long getLong(String key) throws NumberFormatException {
        String setting = this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Long(setting);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IDialogSettings3 getSection(String sectionName) {
        return this.sections.get(sectionName);
    }

    @Override
    public IDialogSettings3[] getSections() {
        Collection<IDialogSettings3> values = this.sections.values();
        IDialogSettings3[] result = new DialogSettings3[values.size()];
        values.toArray(result);
        return result;
    }

    @Override
    public void load(Reader r) {
        Document document = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = parser.parse(new InputSource(r));
            Node root = document.getFirstChild();
            while (root.getNodeType() == 8) {
                document.removeChild(root);
                root = document.getFirstChild();
            }
            this.load(document, (Element)root);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    @Override
    public void load(String fileName) throws IOException {
        FileInputStream stream = new FileInputStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, "utf-8"));
        this.load(reader);
        reader.close();
    }

    public void tryLoad(String fileName) {
        try {
            File file = new File(fileName);
            if (file.exists()) {
                this.load(fileName);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load(Document document, Element root) {
        Node n;
        this.name = root.getAttribute("name");
        NodeList l = root.getElementsByTagName("item");
        int i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                String key = ((Element)l.item(i)).getAttribute("key");
                String value = ((Element)l.item(i)).getAttribute("value");
                this.items.put(key, value);
            }
            ++i;
        }
        l = root.getElementsByTagName("list");
        i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                Element child = (Element)l.item(i);
                String key = child.getAttribute("key");
                NodeList list = child.getElementsByTagName("item");
                ArrayList<String> valueList = new ArrayList<String>();
                int j = 0;
                while (j < list.getLength()) {
                    Element node = (Element)list.item(j);
                    if (child == node.getParentNode()) {
                        valueList.add(node.getAttribute("value"));
                    }
                    ++j;
                }
                String[] value = new String[valueList.size()];
                valueList.toArray(value);
                this.arrayItems.put(key, value);
            }
            ++i;
        }
        l = root.getElementsByTagName("section");
        i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                DialogSettings3 s = this.newDialogSettings3("NoName");
                s.load(document, (Element)n);
                this.addSection(s);
            }
            ++i;
        }
    }

    @Override
    public void put(String key, String[] value) {
        this.valueCache.remove(key);
        this.arrayItems.put(key, value);
    }

    @Override
    public void put(String key, Serializable value) {
        if (value instanceof String[]) {
            this.put(key, (String[])value);
        } else if (value instanceof String) {
            this.put(key, (String)((Object)value));
        } else if (value instanceof Integer) {
            this.put(key, (Integer)value);
        } else {
            this.put(key, HexCodec.bytesToHex((byte[])ByteSerialiser.serialize((Object)value)));
        }
    }

    @Override
    public void put(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, String value) {
        this.valueCache.remove(key);
        this.items.put(key, value);
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void save(Writer writer) throws IOException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.save(document, document);
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public void save(String fileName) throws IOException {
        FileOutputStream stream = new FileOutputStream(fileName);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
        this.save(writer);
        writer.close();
    }

    public void trySave(String fileName) {
        try {
            this.save(fileName);
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void save(Document document, Node parent) {
        Element child;
        Element root = document.createElement("section");
        parent.appendChild(root);
        root.setAttribute("name", this.name == null ? "" : this.name);
        for (String key : this.items.keySet()) {
            child = document.createElement("item");
            root.appendChild(child);
            child.setAttribute("key", key == null ? "" : key);
            String string = this.items.get(key);
            child.setAttribute("value", string == null ? "" : string);
        }
        for (String key : this.arrayItems.keySet()) {
            child = document.createElement("list");
            root.appendChild(child);
            child.setAttribute("key", key == null ? "" : key);
            String[] value = (String[])this.arrayItems.get(key);
            if (value == null) continue;
            int index = 0;
            while (index < value.length) {
                Element c = document.createElement("item");
                child.appendChild(c);
                String string = value[index];
                c.setAttribute("value", string == null ? "" : string);
                ++index;
            }
        }
        Iterator<Object> i = this.sections.values().iterator();
        while (i.hasNext()) {
            ((DialogSettings3)i.next()).save(document, root);
        }
    }

    @Override
    public void clear() {
        this.items.clear();
        this.arrayItems.clear();
    }

    @Override
    public Set<Map.Entry<String, Object>> items() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.items);
        map.putAll(this.arrayItems);
        return map.entrySet();
    }

    @Override
    public void removeSection(String name) {
        this.sections.remove(name);
    }

    @Override
    public void removeItem(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.items.containsKey(name)) {
            this.items.remove(name);
        }
        if (this.arrayItems.containsKey(name)) {
            this.arrayItems.remove(name);
        }
    }
}

