/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.textAssistant;

import ca.infodata.ofys.ui.controls.popup.PopupFeature;
import ca.infodata.ofys.ui.controls.textAssistant.CompletionLabelProvider;
import ca.infodata.ofys.ui.controls.textAssistant.InformationPopup;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class ProposerPopup<A, K>
extends PopupFeature {
    private org.eclipse.swt.widgets.List list;
    private Label textBarLocation;
    private Label textBarAction;
    private CompletionLabelProvider<A> infoProvider;
    private CompletionLabelProvider<A> labelProvider;
    private Map<KeyStroke, K> specialsKeys;
    private boolean showTextBar;
    private int selectedIndex = 0;
    private InformationPopup infoPopup;

    public ProposerPopup(Control control, CompletionLabelProvider<A> infoProvider, CompletionLabelProvider<A> labelProvider) {
        super(control);
        this.showPopupDown = true;
        this.infoProvider = infoProvider;
        this.labelProvider = labelProvider;
        this.specialsKeys = new HashMap<KeyStroke, K>();
        this.showTextBar = false;
        this.setControlListner();
    }

    public ProposerPopup(Control control, CompletionLabelProvider<A> nameProvider, CompletionLabelProvider<A> infoProvider, boolean refresListOnChange, boolean showTextBar) {
        super(control);
        this.showPopupDown = true;
        this.infoProvider = infoProvider;
        this.labelProvider = nameProvider;
        this.specialsKeys = new HashMap<KeyStroke, K>();
        this.showTextBar = showTextBar;
        this.setControlListner();
    }

    @Override
    protected Shell createPopupControlOverride(Shell parent) {
        Shell s = this.createPopupListShell(parent);
        return s;
    }

    @Override
    public void refreshPopup() {
        if (this.getPopup() != null && !this.getPopup().isDisposed()) {
            List<A> items = this.getItemsList();
            this.list.removeAll();
            this.list.setData(items);
            for (A a : items) {
                this.list.add(this.labelProvider.get(a));
            }
            if (this.showTextBar) {
                String txtBarLoc = this.getTextBarLocationString();
                this.textBarLocation.setText(txtBarLoc == null ? "" : txtBarLoc);
                this.textBarLocation.setToolTipText(txtBarLoc == null ? "" : txtBarLoc);
                String txtBarAct = this.getTextBarActionString();
                this.textBarAction.setText(txtBarAct == null ? "" : txtBarAct);
                this.textBarAction.setToolTipText(txtBarAct == null ? "" : txtBarAct);
            }
        }
    }

    protected abstract String getTextBarLocationString();

    protected abstract String getTextBarActionString();

    public abstract List<A> getItemsList();

    protected abstract void specialKeyHitted(K var1);

    public void addSpecialKey(KeyStroke ks, K key) {
        this.specialsKeys.put(ks, (KeyStroke)key);
    }

    public A getSelection() {
        int si = this.list.getSelectionIndex();
        String a = null;
        if (si >= 0) {
            a = this.list.getItem(si);
        }
        return (A)a;
    }

    private Shell createPopupListShell(Shell parent) {
        FormData data;
        Color whiteColor = ResourceGetter.getColor((int)255, (int)255, (int)255);
        Color mediumGreyColor = ResourceGetter.getColor((int)112, (int)112, (int)99);
        Shell shell = new Shell(this.getControl().getShell(), 2048);
        shell.setBackground(mediumGreyColor);
        this.list = new org.eclipse.swt.widgets.List((Composite)shell, 8389380);
        Composite c = null;
        if (this.showTextBar) {
            c = new Composite((Composite)shell, 0x800000);
            c.setBackground(whiteColor);
            this.textBarLocation = new Label(c, 0x800040);
            this.textBarAction = new Label(c, 8519744);
            Font f = ResourceGetter.getFontSmallNormal();
            this.textBarAction.setFont(f);
            this.textBarLocation.setFont(f);
            this.textBarAction.setBackground(whiteColor);
            this.textBarLocation.setBackground(whiteColor);
            this.textBarAction.setForeground(mediumGreyColor);
            this.textBarLocation.setForeground(mediumGreyColor);
            FormLayout layout2 = new FormLayout();
            layout2.marginBottom = 0;
            layout2.marginTop = 0;
            layout2.marginLeft = 0;
            layout2.marginRight = 0;
            layout2.spacing = 0;
            c.setLayout((Layout)layout2);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(47);
            this.textBarLocation.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(53);
            data.right = new FormAttachment(100);
            this.textBarAction.setLayoutData((Object)data);
        }
        this.list.setBackground(whiteColor);
        int w = this.computeWidth();
        FormLayout layout = new FormLayout();
        layout.marginBottom = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.marginRight = 1;
        layout.spacing = 1;
        shell.setLayout((Layout)layout);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = w / 2;
        this.list.setLayoutData((Object)data);
        if (c != null) {
            data = new FormData();
            data.top = new FormAttachment((Control)this.list);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            c.setLayoutData((Object)data);
        }
        final org.eclipse.swt.widgets.List li = this.list;
        final CompletionLabelProvider<A> lblProv = this.infoProvider;
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int si = li.getSelectionIndex();
                String info = "";
                if (si >= 0) {
                    List o = (List)li.getData();
                    Object a = o.get(si);
                    info = lblProv.get(a);
                }
                ProposerPopup.this.infoPopup.setText(info);
            }
        });
        shell.pack();
        this.infoPopup = new InformationPopup(this.getControl().getShell(), shell, w - w / 2);
        this.popup = shell;
        this.setPopupListner();
        return shell;
    }

    private int computeWidth() {
        int w = 500;
        return w;
    }

    @Override
    public void openPopupWindow() {
        super.openPopupWindow();
        this.setFocusListner();
        this.addTraverserListenerToControl();
        this.popup.setFocus();
    }

    private void setPopupListner() {
        System.out.println("SET POPUP LISTNER");
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ProposerPopup.this.selectSelectedItem();
                ProposerPopup.this.hidePopupWindow();
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (ProposerPopup.this.getPopup() != null && !ProposerPopup.this.getPopup().isDisposed() && ProposerPopup.this.getPopup().isVisible()) {
                    event.doit = false;
                }
                Map.Entry findAKey = null;
                for (Map.Entry entry : ProposerPopup.this.specialsKeys.entrySet()) {
                    if ((((KeyStroke)entry.getKey()).getModifierKeys() != 0 || ((KeyStroke)entry.getKey()).getNaturalKey() != event.character) && (((KeyStroke)entry.getKey()).getNaturalKey() != event.keyCode || (((KeyStroke)entry.getKey()).getModifierKeys() & event.stateMask) != ((KeyStroke)entry.getKey()).getModifierKeys())) continue;
                    findAKey = entry;
                    break;
                }
                if (event.keyCode == 32 && event.stateMask == 262144) {
                    if (ProposerPopup.this.getPopup() != null && !ProposerPopup.this.getPopup().isDisposed() && ProposerPopup.this.getPopup().isVisible()) {
                        ProposerPopup.this.setToNextProposer();
                        ProposerPopup.this.refreshPopup();
                    } else {
                        ProposerPopup.this.resetToFirstProposer();
                        ProposerPopup.this.openPopupWindow();
                    }
                    ProposerPopup.this.select(0);
                } else if (event.keyCode == 0x1000002) {
                    ProposerPopup.this.selectNext();
                    event.doit = false;
                } else if (event.keyCode == 0x1000001) {
                    ProposerPopup.this.selectPrev();
                    event.doit = false;
                } else if (event.keyCode == 0x1000003) {
                    ProposerPopup.this.setToPrevProposer();
                    ProposerPopup.this.refreshPopup();
                    ProposerPopup.this.select(0);
                } else if (event.keyCode == 0x1000004) {
                    ProposerPopup.this.setToNextProposer();
                    ProposerPopup.this.refreshPopup();
                    ProposerPopup.this.select(0);
                } else if (findAKey != null) {
                    ProposerPopup.this.specialKeyHitted(findAKey.getValue());
                } else if ((event.character == '\n' || event.character == '\r') && event.stateMask == 0) {
                    ProposerPopup.this.selectSelectedItem();
                    ProposerPopup.this.hidePopupWindow();
                } else if (event.character == '\u001b') {
                    ProposerPopup.this.hidePopupWindow();
                } else if (event.stateMask == 0) {
                    ProposerPopup.this.getControl().notifyListeners(1, UI.newKeyEvent((KeyEvent)event));
                }
            }
        });
        this.list.getListeners(2);
        this.getPopup().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ProposerPopup.this.hidePopupWindow();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.getPopup().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ProposerPopup.this.infoPopup != null && !ProposerPopup.this.infoPopup.isDisposed()) {
                    ProposerPopup.this.infoPopup.getPopup().close();
                }
            }
        });
    }

    private void setControlListner() {
        this.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 32 && event.stateMask == 262144) {
                    if (ProposerPopup.this.getPopup() != null && !ProposerPopup.this.getPopup().isDisposed() && ProposerPopup.this.getPopup().isVisible()) {
                        ProposerPopup.this.setToNextProposer();
                        ProposerPopup.this.refreshPopup();
                    } else {
                        ProposerPopup.this.openPopupWindow();
                        ProposerPopup.this.select(0);
                    }
                }
            }
        });
    }

    private void select(int index) {
        if (index >= 0) {
            this.selectedIndex = index % this.list.getItemCount();
            this.list.setSelection(this.selectedIndex);
            this.list.notifyListeners(13, new Event());
        }
    }

    private void selectNext() {
        int i = this.selectedIndex;
        i = i == -1 ? 0 : ++i;
        this.select(i);
    }

    private void selectPrev() {
        int i = this.selectedIndex;
        i = i == -1 ? 0 : (i == 0 ? this.list.getItemCount() - 1 : --i);
        this.select(i);
    }

    private void selectSelectedItem() {
        int si = this.list.getSelectionIndex();
        if (si >= 0) {
            List<A> items = this.getItemsList();
            A a = items.get(si);
            this.selectItem(a);
        }
    }

    public abstract void selectItem(A var1);

    public abstract void resetToFirstProposer();

    public abstract void setToNextProposer();

    public abstract void setToPrevProposer();

    private void setFocusListner() {
        this.addTraverserListenerToControl();
    }

    @Override
    public final void hidePopupWindow() {
        if (this.getPopup() != null && !this.getPopup().isDisposed()) {
            this.getPopup().setVisible(false);
            this.removeTraverserListenerToControl();
            this.infoPopup.setText("");
        }
    }

    private void addTraverserListenerToControl() {
    }

    private void removeTraverserListenerToControl() {
    }

    @Override
    protected Listener getOnFocusOutListner() {
        return new Listener(){

            public void handleEvent(Event e) {
            }
        };
    }
}

