/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.proposal;

import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.proposal.TemplateContentProposalItem;
import ca.infodata.ofys.ui.controls.template.proposal.TemplateContentProposalProvider;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.ProviderAR;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TemplateContentProposalAdapter {
    private TemplateContentProposalProvider myContentProposalProvider;
    private MyContentProposalAdapter contentProposalAdapter;
    private final Control control;
    private final XCompletionProposalType type;
    private final IControlContentAdapter cca;
    private TemplateAccessorClient accessor;

    private static TextContentAdapter newTextCca() {
        TextContentAdapter cca = new TextContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
            }

            public void setControlContents(Control control, String text, int cursorPosition) {
            }
        };
        return cca;
    }

    public TemplateContentProposalAdapter(Text text, XCompletionProposalType type) {
        this((Control)text, type, (IControlContentAdapter)TemplateContentProposalAdapter.newTextCca());
    }

    public TemplateContentProposalAdapter(Control control, XCompletionProposalType type) {
        this(control, type, (IControlContentAdapter)TemplateContentProposalAdapter.newTextCca());
    }

    public TemplateContentProposalAdapter(Control control, XCompletionProposalType type, IControlContentAdapter cca) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        this.control = control;
        this.type = type;
        this.cca = cca;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void init() throws Exception {
        char[] autoActivationCharacters = new char[1];
        KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
        this.control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (UI.rightClick((MouseEvent)e)) {
                    TemplateContentProposalAdapter.this.showContentProposalPopup();
                }
            }
        });
        this.accessor = this.initAccessor();
        this.myContentProposalProvider = new TemplateContentProposalProvider(this.accessor, this.type);
        this.myContentProposalProvider.setFactory(this.initContentProposalItemFactory());
        this.contentProposalAdapter = new MyContentProposalAdapter(this.control, this.cca, this.myContentProposalProvider, keyStroke, autoActivationCharacters);
        this.contentProposalAdapter.setPropagateKeys(false);
        this.contentProposalAdapter.setProposalAcceptanceStyle(2);
        this.contentProposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal c) {
                TemplateContentProposalItem rep = (TemplateContentProposalItem)c;
                Log.logOperation((String)"TemplateContentProposalAdapter.proposalAccepted", (Object[])new Object[]{rep});
                if (rep != null) {
                    TemplateContentProposalAdapter.this.accessor.use(rep.getTemplate().getId());
                }
            }
        });
    }

    protected TemplateAccessorClient initAccessor() throws Exception {
        return TemplateAccessorClient.getInstance();
    }

    protected ProviderAR<XTemplate, TemplateContentProposalItem> initContentProposalItemFactory() {
        return null;
    }

    public boolean openProposalPopupOverride() {
        return true;
    }

    public void showContentProposalPopup() {
        this.contentProposalAdapter.openProposalPopup();
    }

    public TemplateContentProposalProvider getMyContentProposalProvider() {
        return this.myContentProposalProvider;
    }

    public MyContentProposalAdapter getContentProposalAdapter() {
        return this.contentProposalAdapter;
    }

    public Control getControl() {
        return this.control;
    }

    public XCompletionProposalType getType() {
        return this.type;
    }

    public IControlContentAdapter getCca() {
        return this.cca;
    }

    public TemplateAccessorClient getAccessor() {
        return this.accessor;
    }

    public class MyContentProposalAdapter
    extends ContentProposalAdapter {
        public MyContentProposalAdapter(Control control, IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
            super(control, controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
        }

        public void openProposalPopup() {
            if (!TemplateContentProposalAdapter.this.control.isDisposed() && TemplateContentProposalAdapter.this.control.isEnabled()) {
                Log.logOperation((String)"TemplateContentProposal.MyContentProposalAdapter.openProposalPopup", (Object[])new Object[0]);
                boolean doit = TemplateContentProposalAdapter.this.openProposalPopupOverride();
                if (doit) {
                    super.openProposalPopup();
                }
            }
        }
    }
}

