/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.editor.XTemplateWrapper;
import ca.infodata.util1.StringUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class XTemplateContainer
implements IEditorInput {
    private XCompletionProposalType type;
    private Integer typeValue;
    private EditableDataObjectList<XTemplateWrapper> list;

    public XTemplateContainer(XCompletionProposalType type, int value) {
        this.type = type;
        this.typeValue = value;
    }

    public XTemplateContainer(XCompletionProposalType type) {
        this.type = type;
        this.typeValue = type.getValue();
    }

    public void load() throws Exception {
        XTemplateWrapper xtw;
        List list2;
        this.list = new EditableDataObjectList();
        HashMap<Integer, XTemplateWrapper> maps = new HashMap<Integer, XTemplateWrapper>();
        Integer idUser = Application.get().getGlobalInstances().getSession().getUser().getId();
        if (Application.get().getGlobalInstances().hasRight(XRight.SEE_ALL_TEMPLATE)) {
            list2 = TemplateAccessorClient.getInstance().getAll(this.typeValue);
            for (XTemplate xTemplate : list2) {
                xtw = new XTemplateWrapper(xTemplate, XTemplateWrapper.XTemplateLevel.GLOBAL);
                maps.put(xtw.getId(), xtw);
            }
        } else {
            list2 = TemplateAccessorClient.getInstance().findMostUsedGlobal(this.typeValue, null, null, null);
            for (XTemplate xTemplate : list2) {
                xtw = new XTemplateWrapper(xTemplate, XTemplateWrapper.XTemplateLevel.GLOBAL);
                maps.put(xtw.getId(), xtw);
            }
            List list = TemplateAccessorClient.getInstance().findMostUsedClient(this.typeValue, null, null, null);
            for (XTemplate t : list) {
                XTemplateWrapper.XTemplateLevel xtl;
                XTemplateWrapper xtw2 = (XTemplateWrapper)((Object)maps.get(t.getId()));
                XTemplateWrapper.XTemplateLevel xTemplateLevel = xtl = t.getUserId() != null && t.getUserId().equals(idUser) ? XTemplateWrapper.XTemplateLevel.MINE : XTemplateWrapper.XTemplateLevel.CLIENT;
                if (xtw2 == null) {
                    xtw2 = new XTemplateWrapper(t, xtl);
                    maps.put(xtw2.getId(), xtw2);
                    continue;
                }
                xtw2.setLevel(xtl);
            }
        }
        for (Map.Entry entry : maps.entrySet()) {
            this.list.add((IMinimalEditableDataObject)((XTemplateWrapper)((Object)entry.getValue())));
        }
        Collections.sort(this.list, new Comparator<XTemplateWrapper>(){

            @Override
            public int compare(XTemplateWrapper x1, XTemplateWrapper x2) {
                if (x1 == null && x2 == null) {
                    return 0;
                }
                if (x1 == null) {
                    return -1;
                }
                if (x2 == null) {
                    return 1;
                }
                return StringUtils.compareAscii((String)x1.getName(), (String)x2.getName());
            }
        });
    }

    public Object getAdapter(Class c) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.type.toString();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public boolean isDirty() {
        return this.list == null ? false : this.list.isDirty();
    }

    public XCompletionProposalType getType() {
        return this.type;
    }

    public void setType(XCompletionProposalType type) {
        this.type = type;
    }

    public EditableDataObjectList<XTemplateWrapper> getList() {
        return this.list;
    }

    public void setList(EditableDataObjectList<XTemplateWrapper> list) {
        this.list = list;
    }

    public Integer getTypeValue() {
        return this.typeValue;
    }
}

