/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.completion;

import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.completion.TemplateProposition;
import ca.infodata.ofys.ui.controls.textAssistant.CompletionProposer;
import ca.infodata.ofys.ui.controls.textAssistant.CompletionProposition;
import ca.infodata.ofys.ui.controls.textAssistant.EmptyCompletionProposition;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class TemplateComplessionProposer
extends CompletionProposer<XTemplate, String> {
    private TemplateAccessorClient accessor;
    private XCompletionProposalType type;
    private TemplateProposerType proposerType;

    public TemplateComplessionProposer(TemplateAccessorClient accessor, XCompletionProposalType type, TemplateProposerType proposerType) {
        this.accessor = accessor;
        this.type = type;
        this.proposerType = proposerType;
    }

    @Override
    public List<TemplateProposition> getProposal() {
        return null;
    }

    @Override
    public List<CompletionProposition<XTemplate>> getProposalFrom(String text) {
        text = StringUtils.NormalizeToLowercase((String)text);
        List list = new ArrayList();
        if (this.proposerType != null) {
            switch (this.proposerType) {
                case USER_LAST_USED: {
                    list = this.accessor.findLastUsed(this.type, text);
                    break;
                }
                case USER_MOST_USED: {
                    list = this.accessor.findMostUsed(this.type, text);
                    break;
                }
                case CLIENT_MOST_USED: {
                    list = this.accessor.findMostUsedClient(this.type, text);
                    break;
                }
                case GLOBAL_MOST_USED: {
                    list = this.accessor.findMostUsedGlobal(this.type, text);
                }
            }
        }
        ArrayList<CompletionProposition<XTemplate>> liProp = new ArrayList<CompletionProposition<XTemplate>>();
        for (XTemplate t : list) {
            liProp.add(new TemplateProposition(t, this.accessor));
        }
        if (liProp.isEmpty()) {
            liProp.add(new EmptyCompletionProposition());
        }
        return liProp;
    }

    public String[] getHelperString() {
        if (this.proposerType != null) {
            switch (this.proposerType) {
                case USER_LAST_USED: {
                    return new String[]{"Derniers utilis\u00e9s", "'Ctrl+Esp' Plus utilis\u00e9s"};
                }
                case USER_MOST_USED: {
                    return new String[]{"Plus utilis\u00e9s", "'Ctrl+Esp' Locaux"};
                }
                case CLIENT_MOST_USED: {
                    return new String[]{"Locaux", "'Ctrl+Esp' Partag\u00e9s"};
                }
                case GLOBAL_MOST_USED: {
                    return new String[]{"Partag\u00e9s", "'Ctrl+Esp' Derniers"};
                }
            }
        }
        return new String[]{"", ""};
    }

    public static enum TemplateProposerType {
        USER_LAST_USED,
        USER_MOST_USED,
        CLIENT_MOST_USED,
        GLOBAL_MOST_USED;

    }
}

