/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.popup;

import ca.infodata.ofys.ui.library.UI;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class PopupFeature {
    protected int eventX;
    protected int eventY;
    protected Shell popup;
    private Listener popupCloseOnMouseDownListener;
    private Listener popupCloseOnMouseExitListener;
    private Listener popupFocusOutListener;
    private Control control;
    protected boolean showPopupDown = false;
    protected boolean closeOnMouseExit = false;
    protected boolean refreshOnShow = true;
    private Control popupFirstFocusControl;
    private int popupSizeY = -1;
    private int popupSizeX = -1;

    public PopupFeature(final Control control) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        if (control.isDisposed()) {
            throw new IllegalArgumentException("control is disposed");
        }
        this.control = control;
        this.popupCloseOnMouseDownListener = new Listener(){

            public void handleEvent(Event e) {
                PopupFeature.this.hideIfEventLocationIsOutsidePopupAndSourceControlBounds(e);
            }
        };
        this.popupCloseOnMouseExitListener = new Listener(){

            public void handleEvent(Event e) {
                PopupFeature.this.hideIfEventLocationIsOutsidePopupAndSourceControlBounds(e);
            }
        };
        final ControlListener popupMoveOnControlEventListener = new ControlListener(){

            public void controlResized(ControlEvent e) {
                this.follow();
            }

            public void controlMoved(ControlEvent e) {
                this.follow();
            }

            private void follow() {
                if (!control.isDisposed() && PopupFeature.this.popup != null && !PopupFeature.this.popup.isDisposed() && PopupFeature.this.popup.getVisible()) {
                    Point location = PopupFeature.this.computePopupLocation(control);
                    PopupFeature.this.popup.setLocation(location);
                }
            }
        };
        control.addControlListener(popupMoveOnControlEventListener);
        control.getShell().addControlListener(popupMoveOnControlEventListener);
        this.popupFocusOutListener = this.getOnFocusOutListner();
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                control.getShell().removeControlListener(popupMoveOnControlEventListener);
                control.getDisplay().removeFilter(3, PopupFeature.this.popupCloseOnMouseDownListener);
                control.getDisplay().removeFilter(5, PopupFeature.this.popupCloseOnMouseExitListener);
                if (PopupFeature.this.popup != null) {
                    PopupFeature.this.popup.dispose();
                    PopupFeature.this.popup = null;
                }
            }
        });
    }

    protected void hideIfEventLocationIsOutsidePopupAndSourceControlBounds(Event e) {
        if (!this.control.isDisposed() && this.popup != null && !this.popup.isDisposed() && this.popup.getVisible()) {
            Rectangle popupBounds;
            int x = e.x;
            int y = e.y;
            if (e.widget instanceof Control) {
                Point point = e.display.map((Control)e.widget, null, x, y);
                x = point.x;
                y = point.y;
            }
            if (!(popupBounds = this.popup.getBounds()).contains(x, y)) {
                Rectangle bounds = this.control.getBounds();
                Rectangle controlBounds = e.display.map((Control)this.control.getParent(), null, bounds);
                if (!controlBounds.contains(x, y)) {
                    this.hidePopupWindow();
                }
            }
        }
    }

    protected Listener getOnFocusOutListner() {
        return new Listener(){

            public void handleEvent(Event e) {
                if (PopupFeature.this.popup.getVisible()) {
                    PopupFeature.this.control.getDisplay().timerExec(100, new Runnable(){

                        @Override
                        public void run() {
                            if ((this).PopupFeature.this.popup != null && !(this).PopupFeature.this.popup.isDisposed() && !UI.hasFocus((Control)(this).PopupFeature.this.popup)) {
                                PopupFeature.this.hidePopupWindow();
                            }
                        }
                    });
                }
            }
        };
    }

    public void addOpenOnMouseEnterListener() {
        this.control.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (PopupFeature.this.popup == null || PopupFeature.this.popup.isDisposed() || !PopupFeature.this.popup.getVisible()) {
                    PopupFeature.this.openPopupWindow();
                }
            }
        });
    }

    public void hidePopupWindow() {
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.setVisible(false);
        }
    }

    public void openPopupWindow() {
        if (this.popup == null || this.popup.isDisposed()) {
            this.popup = this.createPopupControl(this.control.getShell());
            this.popup.addListener(16, this.popupFocusOutListener);
            this.control.getDisplay().addFilter(3, this.popupCloseOnMouseDownListener);
            if (this.closeOnMouseExit) {
                this.control.getDisplay().addFilter(5, this.popupCloseOnMouseExitListener);
            }
            Point size = new Point(this.popupSizeX == -1 ? this.popup.getSize().x : this.popupSizeX, this.popupSizeY == -1 ? this.popup.getSize().y : this.popupSizeY);
            this.popup.setSize(size);
            this.popup.setLocation(this.computePopupLocation(this.control));
            this.popup.open();
            Control focus = this.getPopupFirstFocusControl();
            if (focus != null) {
                focus.setFocus();
            }
            this.refreshPopup();
        } else if (this.popup.getVisible()) {
            this.hidePopupWindow();
        } else {
            if (this.refreshOnShow) {
                this.refreshPopup();
            }
            this.popup.setLocation(this.computePopupLocation(this.control));
            this.popup.setVisible(true);
            Control focus = this.getPopupFirstFocusControl();
            if (focus != null) {
                focus.setFocus();
            }
        }
    }

    private Shell createPopupControl(Shell parent) {
        Shell shell = this.createPopupControlOverride(parent);
        Control[] controlArray = shell.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.addListener(16, this.popupFocusOutListener);
            ++n2;
        }
        return shell;
    }

    protected Point computePopupLocation(Control control) {
        int x;
        int y;
        Display display = control.getDisplay();
        Rectangle displayBounds = display.getBounds();
        int displayX2 = displayBounds.x + displayBounds.width;
        if (this.showPopupDown) {
            y = control.getBounds().y + control.getBounds().height;
            x = control.getBounds().x;
            if (UI.OS_CARBON || UI.OS_COCOA) {
                if (control instanceof Button) {
                    x += 6;
                    y -= 4;
                } else {
                    ++x;
                    y -= 3;
                }
            }
        } else {
            int popupHeight = this.popup.getBounds().height;
            y = control.getBounds().y - popupHeight;
            x = control.getBounds().x;
        }
        Point point = control.getParent().toDisplay(x, y);
        int popupWidth = this.popup.getBounds().width;
        if (point.x + popupWidth > displayX2) {
            point.x = displayX2 - popupWidth;
        }
        return point;
    }

    public Shell getPopup() {
        return this.popup;
    }

    public Control getControl() {
        return this.control;
    }

    protected abstract Shell createPopupControlOverride(Shell var1);

    protected abstract void refreshPopup();

    protected Control getPopupFirstFocusControl() {
        if (this.popupFirstFocusControl != null && this.popupFirstFocusControl.isDisposed()) {
            this.popupFirstFocusControl = null;
        }
        return this.popupFirstFocusControl;
    }

    protected void setPopupFirstFocusControl(Control popupFirstFocusControl) {
        this.popupFirstFocusControl = popupFirstFocusControl;
    }

    public void setPopupSizeY(int popupSizeY) {
        this.popupSizeY = popupSizeY;
    }

    public void setPopupSizeX(int popupSizeX) {
        this.popupSizeX = popupSizeX;
    }
}

