/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LabelsControl {
    private StyledText styledText;
    private List<Control> controls;
    private List<StyleRange> styleRanges;
    private int MARGIN = 2;
    private boolean setText;

    public LabelsControl(Composite parent) {
        this.styledText = new StyledText(parent, 2052);
        this.controls = new ArrayList<Control>();
        this.styleRanges = new ArrayList<StyleRange>();
        this.styledText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (LabelsControl.this.setText) {
                    return;
                }
                if (e.start < LabelsControl.this.controls.size()) {
                    boolean bl = e.doit = e.end - e.start == 1 && e.text.length() == 0;
                    if (e.doit) {
                        Control control = (Control)LabelsControl.this.controls.remove(e.start);
                        if (control != null && !control.isDisposed()) {
                            control.dispose();
                        }
                        LabelsControl.this.styleRanges.remove(e.start);
                    }
                    return;
                }
            }
        });
        this.styledText.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                StyleRange style = event.style;
                int start = style.start;
                int offset = 0;
                for (Control control : LabelsControl.this.controls) {
                    if (start == offset) {
                        Point pt = control.getSize();
                        int x = event.x + LabelsControl.this.MARGIN;
                        int y = event.y + event.ascent - 2 * pt.y / 3;
                        control.setLocation(x, y);
                        break;
                    }
                    ++offset;
                }
            }
        });
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                String text;
                if (e.character == '\r' && (text = LabelsControl.this.getStyleText().getText()).trim().length() > 0) {
                    LabelsControl.this.addLabel(text.trim());
                    LabelsControl.this.getStyleText().setCaretOffset(LabelsControl.this.getStyleText().getText().length());
                }
            }
        });
    }

    private void refreshStyleRanges() {
        StyleRange[] ranges = this.styleRanges.toArray(new StyleRange[this.styleRanges.size()]);
        this.styledText.setStyleRanges(ranges);
    }

    private String computeText() {
        StringBuilder b = new StringBuilder(this.controls.size());
        int i = 0;
        while (i < this.controls.size()) {
            b.append(' ');
            ++i;
        }
        return b.toString();
    }

    public void removeLabel(String label) {
        Iterator<Control> controlIterator = this.controls.iterator();
        Iterator<StyleRange> styleIterator = this.styleRanges.iterator();
        while (controlIterator.hasNext()) {
            Control control = controlIterator.next();
            styleIterator.next();
            if (!((Button)control).getText().equals(label)) continue;
            control.dispose();
            controlIterator.remove();
            styleIterator.remove();
        }
        this.refreshStyleRanges();
    }

    public void addLabel(String label) {
        this.setText = true;
        this.getStyleText().setText(String.valueOf(this.computeText()) + " ");
        this.setText = false;
        Button button = new Button((Composite)this.styledText, 8);
        button.setText(label);
        StyleRange style = new StyleRange();
        style.start = this.controls.size();
        style.length = 1;
        button.pack();
        Rectangle rect = button.getBounds();
        int ascent = 2 * rect.height / 3;
        int descent = rect.height - ascent;
        style.metrics = new GlyphMetrics(ascent + this.MARGIN, descent + this.MARGIN, rect.width + 2 * this.MARGIN);
        this.controls.add((Control)button);
        this.styleRanges.add(style);
        this.refreshStyleRanges();
    }

    public StyledText getControl() {
        return this.styledText;
    }

    public StyledText getStyleText() {
        return this.styledText;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        LabelsControl control = new LabelsControl((Composite)shell);
        control.addLabel("test1");
        control.addLabel("test2");
        System.out.println(control.getControl().getText());
        shell.pack();
        shell.setSize(400, shell.getSize().y + 10);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private class MLabel
    extends Canvas
    implements PaintListener,
    DisposeListener {
        private final String text;
        private Point textSize;
        private Point controlSize;
        private Font fontBold;
        private Color background;
        private Color border;

        public MLabel(Composite parent, String text) {
            super(parent, 786432);
            this.text = text;
            this.background = new Color((Device)parent.getDisplay(), 50, 50, 255);
            this.border = new Color((Device)parent.getDisplay(), 0, 0, 0);
            Font font = this.getFont();
            FontData data = font.getFontData()[0];
            this.fontBold = new Font((Device)parent.getDisplay(), data.getName(), data.getHeight(), data.getStyle() | 1);
            this.addDisposeListener(this);
            this.addPaintListener(this);
            Label label = new Label(parent, 16384);
            label.setText(text);
            this.textSize = label.computeSize(-1, -1);
            this.controlSize = new Point(this.textSize.x + 20, this.textSize.y + 10);
            label.dispose();
        }

        public void paintControl(PaintEvent e) {
            e.gc.fillRectangle(0, 0, this.controlSize.x, this.controlSize.y);
            e.gc.setLineWidth(2);
            e.gc.setForeground(this.background);
            e.gc.drawRectangle(1, 1, this.controlSize.x - 2, this.controlSize.y - 2);
            e.gc.setForeground(this.border);
            e.gc.setFont(this.fontBold);
            e.gc.drawText(this.text, 8, 4, true);
        }

        public void widgetDisposed(DisposeEvent e) {
            this.background.dispose();
            this.border.dispose();
            this.fontBold.dispose();
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return this.controlSize;
        }
    }
}

