/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DRaw;
import ca.infodata.ofys.client.modules.template.TemplateDefinitionParser;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.TemplateAssistTextDialog;
import ca.infodata.ofys.ui.controls.webbrowser.AdvancedBrowser;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.IPair;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class CompletionProposalManager {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.controls.CompletionProposalManager");
    private XCompletionProposalType type;
    private XTemplate[] list;

    public CompletionProposalManager(XCompletionProposalType type) {
        this.type = type;
    }

    public XTemplate[] listSync() {
        if (this.list == null) {
            try {
                this.list = TemplateAccessorClient.getInstance().findMostUsedClient(this.type, null).toArray(new XTemplate[0]);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not load templates list", e);
            }
        }
        return this.list;
    }

    public String use(Shell parent, XTemplate proposal) {
        String text = proposal.getText();
        if (Boolean.TRUE.equals(proposal.getIsHtml())) {
            AdvancedBrowser browser = new AdvancedBrowser(UI.getWorkbenchShell(), text);
            browser.open();
            if (browser.isOkPressed()) {
                text = browser.getHtml();
            }
        } else {
            TemplateDefinitionParser parser = new TemplateDefinitionParser();
            List fields = parser.parse(text);
            if (this.containsNonRaw(fields)) {
                String s;
                ShellAdapter shellAdapter;
                final TemplateAssistTextDialog dialog = new TemplateAssistTextDialog(UI.getWorkbenchShell(), proposal.getName(), fields);
                IPair<Shell, Integer> rep = dialog.buildAndOpen2(shellAdapter = new ShellAdapter(){

                    public void shellActivated(ShellEvent shellevent) {
                        for (Control list : dialog.getLstListe()) {
                            if (list.isDisposed()) continue;
                            list.notifyListeners(13, new Event());
                        }
                    }
                });
                text = rep.getSecond() != null && (Integer)rep.getSecond() == 0 ? (s = dialog.getWriteText()) : "";
            }
        }
        if (text != null) {
            TemplateAccessorClient.getInstance().use(proposal.getId());
        }
        return text;
    }

    private boolean containsNonRaw(List<DField> fields) {
        for (DField f : fields) {
            if (f instanceof DRaw) continue;
            return true;
        }
        return false;
    }
}

