/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IVariablesReplacer;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.EditorsGenericFunctions;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.IDeleteablePart;
import ca.infodata.ofys.ui.controls.IEditorInputMappingDelegate;
import ca.infodata.ofys.ui.controls.IMultiPageEditorPart;
import ca.infodata.ofys.ui.controls.IRefreshablePart;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.controls.ISwitchTable;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.SubEditorInfo;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.util.LogUtils;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.EditorPart;

public abstract class BaseEditor
extends EditorPart
implements IBaseEditor,
IRefreshFont,
ISaveablePart,
ICancelablePart,
IDeleteablePart,
IRefreshablePart {
    private static final Logger logger = Logger.getLogger(BaseEditor.class.getName());
    protected boolean canScroll = true;
    protected EditorsGenericFunctions generic = this.initializeEditorsGeneric();
    protected FormToolkit toolkit;
    protected Composite containerComposite;
    protected Composite parentComposite;
    private ScrolledForm form;
    public static final String EDITOR_INPUT_MAPPING = "ca.infodata.ofys.ui.controls.editorInputMapping";

    protected EditorsGenericFunctions initializeEditorsGeneric() {
        return new EditorsGenericFunctions(this, true);
    }

    @Override
    public IEditorPart getEditorPart() {
        return this;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    @Override
    public void checkDirty() {
        this.generic.checkDirty();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.parentComposite.setEnabled(enabled);
    }

    public void dispose() {
        ResourceGetter.removeListener((IRefreshFont)this);
        this.disposed();
        super.dispose();
    }

    public void disposed() {
        this.generic.setDisposed();
    }

    public final boolean isUILoaded() {
        return this.generic.isUILoaded();
    }

    protected final void setDataLoaded() {
        this.generic.setDataLoaded(true);
    }

    public void setFocus() {
        this.generic.setFocus();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    @Override
    public void changeEditorInput(IEditorInput input) {
        try {
            if (!MiscUtil.areObjectsEquals((Object)this.getEditorInput(), (Object)input)) {
                this.setEnabled(false);
                this.setInput(input);
                this.initData();
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
    }

    @Override
    public final void initData() {
        this.initDataOverride();
    }

    @Override
    public abstract void initDataOverride();

    @Override
    public String getTitleToolTip() {
        return this.generic.getTitleToolTip();
    }

    @Override
    public String getSuperTitleToolTip() {
        return this.getEditorTitle();
    }

    @Override
    public String getEditorTitle() {
        return this.generic.getEditorTitle();
    }

    @Override
    public boolean isDirty() {
        return this.generic.isDirty();
    }

    @Override
    public boolean isSaveAllowed() {
        return this.generic.isSaveAllowed();
    }

    @Override
    public void justBeforeSaving() {
    }

    @Override
    public void doSave(IProgressMonitor progress) {
        this.justBeforeSaving();
        this.generic.doSave(null);
    }

    @Override
    public void doCancel(IProgressMonitor progress) {
        this.generic.doCancel();
    }

    @Override
    public final void doDelete(IProgressMonitor progress) {
        this.generic.doDelete(progress);
    }

    @Override
    public boolean isRefreshAllowed() {
        return this.generic.isRefreshAllowed();
    }

    @Override
    public void doRefresh(IProgressMonitor monitor) {
        this.generic.doRefresh();
    }

    @Override
    public void doCancel() {
        this.generic.doCancel();
    }

    @Override
    public void doDelete(Runnable callback) {
        this.generic.doDelete(callback);
    }

    @Override
    public void doRefresh() {
        this.generic.doRefresh();
    }

    @Override
    public void doSave(Runnable callback) {
        this.justBeforeSaving();
        this.generic.doSave(callback);
    }

    @Override
    public void doSave(Runnable callback, SaveCallback callbackDelegate, boolean askQuestion) {
        this.justBeforeSaving();
        this.generic.doSave(callback, callbackDelegate, askQuestion);
    }

    @Override
    public void initializeCompleteDataObject(EditableDataObject completeDataObject) {
        this.generic.initializeCompleteDataObject(completeDataObject);
    }

    @Override
    public boolean mustEditDataObject() {
        return this.generic.mustEditDataObject();
    }

    public abstract void createMyControl(Composite var1);

    @Override
    public abstract BaseAccessorClient getAccessor() throws CannotConnectToServerException;

    @Override
    public abstract boolean isDataDirty();

    @Override
    public abstract void setToolBarStatus();

    @Override
    public void showAllDataObject() {
        if (!this.isDisposed()) {
            this.generic.setMustEditDataObject(false);
            this.showDataObject();
            this.checkDirty();
            this.generic.setAllToolBarStatus();
            this.generic.setMustEditDataObject(true);
        }
    }

    public void createPartControl(Composite editorParent) {
        editorParent.setLayout((Layout)new FillLayout());
        this.parentComposite = editorParent;
        try {
            this.containerComposite = this.createPartControlCreateContainerComposite1(editorParent);
            this.containerComposite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    BaseEditor.this.disposed();
                }
            });
            this.createPartControlCreateMyControl2();
            this.createPartControlSetUILoaded4();
            ResourceGetter.addListener((IRefreshFont)this);
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            contextService.activateContext("ca.infodata.ofys.ui.controls.EditorPart.keybinding.context");
            this.initData();
        }
        catch (Exception e) {
            this.processException(e);
            ResourceGetter.removeListener((IRefreshFont)this);
            return;
        }
    }

    protected void createPartControlSetUILoaded4() {
        this.setUILoaded();
    }

    protected void createPartControlCreateMyControl2() {
        this.createMyControl(this.containerComposite);
    }

    protected Composite createPartControlCreateContainerComposite1(final Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.toolkit = UI.createToolKit((Widget)parent);
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.getBody().setLayout((Layout)new FormLayout());
        this.form.setAlwaysShowScrollBars(false);
        this.form.getHorizontalBar().setVisible(false);
        final Composite compMain = new Composite(this.form.getBody(), 0);
        this.toolkit.adapt(compMain);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        data.width = parent.getSize().x - 18;
        data.bottom = new FormAttachment(100);
        compMain.setLayoutData((Object)data);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FormData data = new FormData();
                data.left = new FormAttachment(0);
                data.top = new FormAttachment(0);
                BaseEditor.this.form.getVerticalBar().setVisible(BaseEditor.this.canScroll);
                if (BaseEditor.this.canScroll) {
                    data.width = parent.getSize().x - 18;
                    data.bottom = new FormAttachment(100);
                } else {
                    data.width = parent.getSize().x;
                    data.height = parent.getSize().y;
                }
                compMain.setLayoutData((Object)data);
                compMain.layout(true);
            }
        });
        return compMain;
    }

    protected void processException(Exception e) {
        if (this.getEditorInput() instanceof EditorInput) {
            String input = LogUtils.format((IDataObject)((EditorInput)this.getEditorInput()).getDataObject());
            logger.log(Level.SEVERE, "Failed to open editor " + this.getEditorSite().getId() + " for input " + input, e);
        } else {
            logger.log(Level.SEVERE, "Failed to open editor " + this.getEditorSite().getId() + " for input " + this.getEditorInput(), e);
        }
        this.generic.setDataLoaded(false);
        this.parentComposite.setLayout((Layout)new FormLayout());
        Control[] children = this.parentComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setVisible(false);
            children[i].setEnabled(false);
            children[i].setLayoutData(null);
            ++i;
        }
        Control message = ControlsPlugin.newUnexpectedExceptionControl(this.parentComposite);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        message.setLayoutData((Object)data);
        this.parentComposite.layout(true, true);
    }

    protected void setUILoaded() {
        this.generic.setUILoaded();
    }

    public final Composite getCompMain() {
        return this.containerComposite;
    }

    @Override
    public void registerSwitchTable(ISwitchTable table) {
        this.generic.registerSwitchTable(table);
    }

    @Override
    public final IVariablesReplacer<EditableDataObject> getVariablesReplacer() {
        return this.generic.getVariablesReplacer();
    }

    @Override
    public IVariablesReplacer<EditableDataObject> getVariablesReplacerNewInstance() {
        return null;
    }

    @Override
    public boolean isDisposed() {
        return this.generic.isDisposed();
    }

    @Override
    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    @Override
    public void setTitleImage(Image image) {
        super.setTitleImage(image);
    }

    @Override
    public boolean getLastKnowDirtyStatus() {
        return this.generic.getLastKnowDirtyStatus();
    }

    @Override
    public int getUniqueKey() {
        return this.generic.getUniqueKey();
    }

    @Override
    public void saved() {
    }

    @Override
    public void saveFailed() {
    }

    public static IEditorPart openEditor(ITreeElements treeElement) throws PartInitException {
        IEditorPart theEditor = BaseEditor.openEditor(treeElement.getEditorInput(), treeElement.getEditorClass());
        return theEditor;
    }

    public static SubEditorInfo openSubEditorFromSubEditorSafe(IEditorPart sourceSubEditor, IEditorInput input, String editor, REUSE_STRATEGY strategy) {
        try {
            IMultiPageEditorPart multiPageEditorPart = BaseEditor.getMultiPageEditorPartFromSubEditor(sourceSubEditor);
            if (multiPageEditorPart == null) {
                throw new IllegalArgumentException("sourceSubEditor is not part of an IMultiPageEditorPart");
            }
            return BaseEditor.openSubEditorSafe(multiPageEditorPart, input, editor, strategy);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to open subeditor " + editor + " in from subEditor " + sourceSubEditor + " with input " + input, e);
            return null;
        }
    }

    public static IMultiPageEditorPart getMultiPageEditorPartFromSubEditor(IEditorPart subEditorPart) {
        if (subEditorPart == null) {
            throw new NullPointerException("subEditorPart");
        }
        IEditorReference[] editorReferences = subEditorPart.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IMultiPageEditorPart multiPageEditorPart;
            int[] pages;
            IEditorPart editor = editorReferences[i].getEditor(false);
            if (editor != null && editor instanceof IMultiPageEditorPart && (pages = (multiPageEditorPart = (IMultiPageEditorPart)editor).getPages(subEditorPart.getClass())) != null) {
                int j = 0;
                while (j < pages.length) {
                    if (multiPageEditorPart.getPage(pages[j]) == subEditorPart) {
                        return multiPageEditorPart;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static SubEditorInfo openSubEditorSafe(IMultiPageEditorPart source, IEditorInput input, String editor, REUSE_STRATEGY strategy) {
        try {
            return BaseEditor.openSubEditor(source, input, editor, strategy);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to open subeditor " + editor + " in mainEditor " + source + " with input " + input, e);
            return null;
        }
    }

    public static SubEditorInfo openSubEditor(IMultiPageEditorPart source, IEditorInput input, String editor, REUSE_STRATEGY strategy) throws Exception {
        if (strategy == null) {
            strategy = REUSE_STRATEGY.DONT_REUSE_EDITOR;
        }
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (input == null) {
            throw new NullPointerException("input");
        }
        IMultiPageEditorPart multiPageEditorPart = source;
        Class<?> editorClass = Class.forName(editor);
        IEditorPart editorInstance = null;
        int page = -1;
        int[] pages = source.getPages(editorClass);
        if (pages != null && pages.length != 0) {
            if (strategy == REUSE_STRATEGY.REUSE_EDITOR_ON_SAME_INPUT || strategy == REUSE_STRATEGY.REUSE_EDITOR_ON_DIFFERENT_INPUT) {
                int i = 0;
                while (i < pages.length) {
                    page = pages[i];
                    editorInstance = source.getPage(page);
                    if (MiscUtil.areObjectsEquals((Object)input, (Object)editorInstance.getEditorInput())) break;
                    page = -1;
                    editorInstance = null;
                    ++i;
                }
            }
            if (page == -1 && strategy == REUSE_STRATEGY.REUSE_EDITOR_ON_DIFFERENT_INPUT) {
                page = pages[0];
                editorInstance = source.getPage(page);
            }
        }
        if (editorInstance == null || strategy == REUSE_STRATEGY.DONT_REUSE_EDITOR) {
            editorInstance = (IEditorPart)editorClass.newInstance();
            page = multiPageEditorPart.addPage(editorInstance, input);
            multiPageEditorPart.setPageImage(page, input.getImageDescriptor() == null ? null : input.getImageDescriptor().createImage());
            multiPageEditorPart.setPageText(page, input.getName());
        } else if (editorInstance instanceof IReusableEditor) {
            ((IReusableEditor)editorInstance).setInput(input);
            multiPageEditorPart.setPageImage(page, input.getImageDescriptor() == null ? null : input.getImageDescriptor().createImage());
            multiPageEditorPart.setPageText(page, input.getName());
        } else {
            logger.info(editorInstance + " does not implement IReusableEditor so its input could not be changed");
        }
        return new SubEditorInfo(page, editorInstance, multiPageEditorPart);
    }

    public static IEditorPart openEditorSafe(IEditorInput input, String editorId) {
        return BaseEditor.openEditorSafe(input, editorId, true);
    }

    public static IEditorPart openEditorSafe(IEditorInput input, String editorId, boolean activate) {
        try {
            IEditorPart editor = BaseEditor.openEditor(input, editorId, activate);
            if (editor != null && editor.getClass().getName().contains("Error")) {
                editor = null;
            }
            return editor;
        }
        catch (Exception e) {
            String s;
            try {
                s = String.valueOf(input);
            }
            catch (Exception e2) {
                s = e2.getMessage();
            }
            logger.log(Level.SEVERE, "Failed to open editor " + editorId + " with input " + s, e);
            return null;
        }
    }

    public static IEditorPart openEditorSafe(IEditorInput input) {
        String editorId = BaseEditor.getEditorIdMappingForInput(input);
        if (editorId != null) {
            return BaseEditor.openEditorSafe(input, editorId);
        }
        logger.log(Level.SEVERE, "no editorId found for input " + (input == null ? null : input.getClass().getName()));
        return null;
    }

    private static String getEditorIdMappingForInput(IEditorInput input) {
        IConfigurationElement[] config;
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.add(input);
        if (input instanceof EditorInput) {
            IDataObject dataObject = ((EditorInput)input).getDataObject();
            inputs.add(dataObject);
            if (dataObject instanceof IDDataObject) {
                inputs.add(((IDDataObject)dataObject).getReferingClass());
            }
        }
        ArrayList<String> editorIds = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EDITOR_INPUT_MAPPING);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ClassLoader loader;
                String name = e.getName();
                if ("editor".equals(name)) {
                    String inputClassS = e.getAttribute("inputClass");
                    loader = ResourceGetter.getNonNullClassLoader();
                    Class<?> inputClass = loader.loadClass(inputClassS);
                    String editorId = e.getAttribute("editorId");
                    if (StringUtils.isBlank((CharSequence)editorId)) {
                        throw new IllegalStateException("invalid editorId for inputClass " + inputClassS);
                    }
                    for (Object e2 : inputs) {
                        if (e2 instanceof Class && inputClass.isAssignableFrom((Class)e2)) {
                            editorIds.add(editorId);
                            continue;
                        }
                        if (e2.getClass().isAssignableFrom(inputClass)) {
                            editorIds.add(editorId);
                            continue;
                        }
                        if (inputClass.isAssignableFrom(e2.getClass())) {
                            editorIds.add(editorId);
                            continue;
                        }
                        if (!inputClass.isInstance(e2)) continue;
                        editorIds.add(editorId);
                    }
                } else if ("delegate".equals(name)) {
                    String delegateClassS = e.getAttribute("class");
                    loader = ResourceGetter.getNonNullClassLoader();
                    Class<?> delegateClass = loader.loadClass(delegateClassS);
                    IEditorInputMappingDelegate delegate = (IEditorInputMappingDelegate)delegateClass.newInstance();
                    String string = delegate.getEditorId(input);
                    if (string != null) {
                        editorIds.add(string);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Failed to find editor input mapping for input " + input == null ? null : input.getClass().getName(), ex);
            }
            ++n2;
        }
        if (editorIds.size() == 0) {
            return null;
        }
        if (editorIds.size() > 1) {
            String id = (String)editorIds.get(0);
            logger.warning("More than 1 editorId found for input " + input == null ? null : String.valueOf(input.getClass().getName()) + ". returning " + id);
            return id;
        }
        return (String)editorIds.get(0);
    }

    public static IEditorPart openEditor(IEditorInput input, String editorId) throws PartInitException {
        return BaseEditor.openEditor(input, editorId, true);
    }

    public static IEditorPart openEditor(IEditorInput input, String editorId, boolean activate) throws PartInitException {
        IEditorPart editor = null;
        IWorkbench workbench = ControlsPlugin.getDefault().getWorkbench();
        if (workbench.getWorkbenchWindows().length > 0 && workbench.getWorkbenchWindows()[0].getPages().length > 0) {
            IWorkbenchPage page = workbench.getWorkbenchWindows()[0].getPages()[0];
            if (editor == null) {
                int i = 0;
                while (i < page.getEditorReferences().length) {
                    IEditorPart theEditor = page.getEditorReferences()[i].getEditor(false);
                    if (theEditor != null && editorId.equals(theEditor.getClass().getName()) && !theEditor.isDirty()) {
                        if (theEditor instanceof IBaseEditor) {
                            editor = theEditor;
                            ((IBaseEditor)theEditor).changeEditorInput(input);
                            if (!activate) break;
                            page.activate((IWorkbenchPart)theEditor);
                            break;
                        }
                        if (!(theEditor instanceof IReusableEditor)) break;
                        editor = theEditor;
                        ((IReusableEditor)theEditor).setInput(input);
                        if (!activate) break;
                        page.activate((IWorkbenchPart)theEditor);
                        break;
                    }
                    ++i;
                }
            }
            if (editor == null) {
                editor = page.openEditor(input, editorId, activate, 3);
            }
        }
        return editor;
    }

    public static IEditorPart openEditorSafePlain(IEditorInput input, String editorId) {
        try {
            return BaseEditor.openEditorPlain(input, editorId);
        }
        catch (Exception e) {
            String s;
            try {
                s = String.valueOf(input);
            }
            catch (Exception e2) {
                s = e2.getMessage();
            }
            logger.log(Level.SEVERE, "Failed to open editor " + editorId + " with input " + s, e);
            return null;
        }
    }

    public static IEditorPart openEditorPlain(IEditorInput input, String editorId) throws PartInitException {
        IWorkbench workbench = ControlsPlugin.getDefault().getWorkbench();
        IEditorPart editor = workbench.getWorkbenchWindows().length > 0 && workbench.getWorkbenchWindows()[0].getPages().length > 0 ? workbench.getWorkbenchWindows()[0].getPages()[0].openEditor(input, editorId, true, 0) : null;
        return editor;
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbench workbench = ControlsPlugin.getDefault().getWorkbench();
        if (workbench.getWorkbenchWindows().length > 0 && workbench.getWorkbenchWindows()[0].getPages().length > 0) {
            return workbench.getWorkbenchWindows()[0].getPages()[0];
        }
        return null;
    }

    public static void closeEditorsSafe(IEditorInput editorInput) {
        try {
            BaseEditor.closeEditors(editorInput);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to close editors with input " + StringUtils.safeToString((Logger)logger, (Object)editorInput));
        }
    }

    public static void closeEditors(IEditorInput editorInput) throws Exception {
        IWorkbenchPage page = BaseEditor.getActivePage();
        if (page != null) {
            ArrayList<IEditorReference> list = new ArrayList<IEditorReference>(3);
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference e = iEditorReferenceArray[n2];
                if (MiscUtil.areObjectsEquals((Object)e.getEditorInput(), (Object)editorInput)) {
                    list.add(e);
                }
                ++n2;
            }
            if (list.size() > 0) {
                IEditorReference[] editorRefs = list.toArray(new IEditorReference[list.size()]);
                page.closeEditors(editorRefs, false);
            }
        }
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    public void firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    protected void setInput(IEditorInput input) {
        super.setInputWithNotify(input);
    }

    @Override
    public IStatus getLastSaveOrDeleteStatus() {
        return this.generic.getLastSaveOrDeleteStatus();
    }

    public static List<IEditorReference> findOpenEditorReferences(PredicateA<IEditorReference> filter) {
        ArrayList<IEditorReference> list = new ArrayList<IEditorReference>(5);
        IWorkbench workbench = ControlsPlugin.getDefault().getWorkbench();
        if (workbench.getWorkbenchWindows().length > 0 && workbench.getWorkbenchWindows()[0].getPages().length > 0) {
            IEditorReference[] editorReferences;
            IWorkbenchPage page = workbench.getWorkbenchWindows()[0].getPages()[0];
            IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference r = iEditorReferenceArray[n2];
                if (filter == null || filter.evaluate((Object)r)) {
                    list.add(r);
                }
                ++n2;
            }
        }
        return list;
    }

    public static void setActiveEditor(IEditorPart part) {
        if (part == null) {
            return;
        }
        IWorkbench workbench = ControlsPlugin.getDefault().getWorkbench();
        if (workbench.getWorkbenchWindows().length > 0 && workbench.getWorkbenchWindows()[0].getPages().length > 0) {
            IWorkbenchPage page = workbench.getWorkbenchWindows()[0].getPages()[0];
            IEditorPart activeEditor = page.getActiveEditor();
            if (activeEditor == part) {
                return;
            }
            page.activate((IWorkbenchPart)part);
        }
    }

    public static String getOpenEditorsLog() {
        StringBuilder b = new StringBuilder("OpenEditors\n");
        IWorkbench workbench = ControlsPlugin.getDefault().getWorkbench();
        if (workbench.getWorkbenchWindows().length > 0 && workbench.getWorkbenchWindows()[0].getPages().length > 0) {
            IEditorReference[] editorReferences;
            IWorkbenchPage page = workbench.getWorkbenchWindows()[0].getPages()[0];
            IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference er = iEditorReferenceArray[n2];
                String input = "unknown";
                try {
                    input = String.valueOf(er.getEditorInput());
                }
                catch (Exception exception) {}
                String isDirty = "unknown";
                try {
                    input = String.valueOf(er.isDirty());
                }
                catch (Exception exception) {}
                b.append(String.format("OpenEditor [id=%s, name=%s, dirty=%s, input=%s]", er.getId(), er.getName(), isDirty, input));
                b.append('\n');
                ++n2;
            }
        }
        return b.toString();
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public void refreshFont() {
        FontAwareComposite.refreshFont((Control)this.parentComposite);
        this.parentComposite.layout(true, true);
    }

    protected FormLayout getFormLayout() {
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.spacing = 5;
        layout.marginLeft = 5;
        layout.marginTop = 15;
        layout.marginBottom = 5;
        layout.marginHeight = 0;
        layout.marginRight = 5;
        return layout;
    }

    public FormLayout getFormLayoutNoSpacing() {
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.spacing = 0;
        layout.marginLeft = 5;
        layout.marginTop = 15;
        layout.marginBottom = 5;
        layout.marginHeight = 0;
        layout.marginRight = 5;
        return layout;
    }

    @Override
    public boolean isDeleteAllowed() {
        EditableDataObject completeDataObject;
        EditorInput input = this.generic.getEditorInput();
        if (input != null && (completeDataObject = input.getCompleteDataObject()) != null) {
            return completeDataObject.getId() != null;
        }
        return false;
    }

    public static final class EditorNameAndInputFilter
    implements PredicateA<IEditorReference> {
        private String name;
        private IEditorInput input;
        private boolean filterByName;
        private boolean filterByInput;

        public EditorNameAndInputFilter(String name, IEditorInput input) {
            this.name = name;
            this.input = input;
            this.filterByInput = true;
            this.filterByName = true;
        }

        public EditorNameAndInputFilter(String name) {
            this.name = name;
            this.filterByName = true;
            this.filterByInput = false;
        }

        public EditorNameAndInputFilter(IEditorInput input) {
            this.input = input;
            this.filterByName = false;
            this.filterByInput = true;
        }

        public boolean evaluate(IEditorReference r) {
            try {
                return !(this.filterByName && !r.getId().equals(this.name) || this.filterByInput && !r.getEditorInput().equals(this.input));
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum REUSE_STRATEGY {
        REUSE_EDITOR_ON_SAME_INPUT,
        REUSE_EDITOR_ON_DIFFERENT_INPUT,
        DONT_REUSE_EDITOR;

    }
}

