/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.ofys.ui.browser.sonar.IComponent;
import ca.infodata.ofys.ui.browser.sonar.JettyServerRequest;
import ca.infodata.ofys.ui.browser.sonar.SonarDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.WriterOutputStream;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class JettySonar
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(JettySonar.class.getName());
    public static final SonarDispatcher sonar = SonarDispatcher.getInstance();

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        SonarDispatcher.ViewConfig config = this.initViewConfig(target, request, response);
        String requestObject = "";
        boolean bodyRead = false;
        if (request.getMethod().equals("POST")) {
            JettyServerRequest serverRequest = new JettyServerRequest(request);
            try {
                serverRequest.parseMultipartFormData();
                Map<String, byte[]> parts = serverRequest.getParts();
                if (parts != null && !parts.isEmpty()) {
                    config.req.setParts(parts);
                    bodyRead = true;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (config == null) {
            return;
        }
        if (request.getMethod().equals("POST") && !bodyRead && (requestObject = this.doPost(request)).length() > 0) {
            config.req.params.put("jsonData", requestObject);
        }
        try {
            byte[] content = this.resolveRequest(config);
            if (config.req.response.isCommitted() || config.req.resolved.booleanValue()) {
                baseRequest.setHandled(true);
                return;
            }
            baseRequest.setHandled(true);
            JettySonar.doResponse(content, response);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Request error 500" + target + ": ", e);
            try {
                response.sendError(500);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private SonarDispatcher.ViewConfig initViewConfig(String target, HttpServletRequest request, HttpServletResponse response) {
        SonarDispatcher.ViewConfig config = sonar.getMatch(target);
        String path = request.getPathInfo();
        if (config == null || path == null) {
            return null;
        }
        config.req.path = path;
        config.req.request = request;
        config.req.response = response;
        config.req.resolved = false;
        try {
            config.req.params = this.getParams(request);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error acquiring parameters", e);
        }
        config.partial = true;
        config.async = true;
        return config;
    }

    private Map<String, String> getParams(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Map raw = request.getParameterMap();
        for (String key : raw.keySet()) {
            String[] str = (String[])raw.get(key);
            params.put(key, str[0]);
        }
        return params;
    }

    public byte[] resolveRequest(SonarDispatcher.ViewConfig config) {
        byte[] res = null;
        config = sonar.processQuery(config);
        IComponent view = sonar.getComponent(config);
        if (config.req.response.isCommitted()) {
            return null;
        }
        String content = JettySonar.resolveComponentToString(config, view);
        try {
            res = content.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String mime = JettySonar.getViewMime(view.getSkinPath(), this.isJson(config.req.params, view.isJson()));
        JettySonar.doResponseHeaders(config.req.response, res.length, mime);
        return res;
    }

    public static String resolveComponentToString(SonarDispatcher.ViewConfig config, IComponent view) {
        String content = "";
        boolean json = false;
        if (view != null) {
            if (view.getSkin() != null) {
                content = view.getSkin();
            } else {
                content = sonar.renderComponent(view, config);
                view.setSkin(content);
            }
        } else {
            return null;
        }
        json = config.req.params.containsKey("cb");
        if (json) {
            view.getResponse().put("cb", config.req.params.get("cb"));
        }
        if (json || config.req.params.containsKey("insert") || view.isJson()) {
            try {
                content = sonar.callback(view, config);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "JettySonar unable to resolve view", e);
            }
        }
        return content;
    }

    private boolean isJson(Map<String, String> params, boolean isJson) {
        return params.containsKey("cb") || params.containsKey("insert") || isJson;
    }

    public static String getViewMime(String path, boolean isJson) {
        MimeTypes mimeType = new MimeTypes();
        String mime = isJson ? "application/json" : (path != null && !path.isEmpty() ? mimeType.getMimeByExtension(path).toString() : "text/html");
        return mime;
    }

    private String doPost(HttpServletRequest request) throws EofException {
        String res = "";
        String line = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));
            while ((line = bufferedReader.readLine()) != null) {
                res = String.valueOf(res) + line + "\n";
            }
        }
        catch (EofException e) {
            throw e;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "JettySonar POST request processing error.", e);
        }
        return res;
    }

    protected static void doResponseHeaders(HttpServletResponse response, long length, String mimeType) {
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setCharacterEncoding("UTF8");
        if (response instanceof Response) {
            HttpFields fields = ((Response)response).getHttpFields();
            if (length > 0L) {
                fields.putLongField(HttpHeader.CONTENT_LENGTH, length);
            }
        } else if (length > 0L) {
            response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), String.valueOf(length));
        }
    }

    private static void doResponse(byte[] content, HttpServletResponse response) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(content);
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println(":::::::::::Could not send response!");
            try {
                out = new WriterOutputStream((Writer)response.getWriter(), "UTF-8");
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unable to send servlet response to client. The connection might have been closed or a network error might have occurred.", ex);
            }
        }
        catch (UnsupportedEncodingException e1) {
            logger.log(Level.SEVERE, "JettySonar encoding issue", e1);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to send servlet response to client. The connection might have been closed or a network error might have occurred.", e);
        }
    }

    public static void sendFile(String fileName, byte[] fileContent, HttpServletResponse response) {
        JettySonar.doResponseHeaders(response, fileContent.length, JettySonar.getViewMime(fileName, false));
        response.setHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
        JettySonar.doResponse(fileContent, response);
    }
}

