/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.control.AppointmentFormatterSettingsBased;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.control.ThermometerDrawer;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class BaseDrawer
implements IRefreshFont {
    private static final Logger logger = Logger.getLogger(BaseDrawer.class.getName());
    protected Font fontNormal;
    protected Font fontBold;
    protected AppointmentVisualStructure visualStructure;
    protected int drawingSpaceX;
    protected int drawingSpaceY;
    protected float lineHeight = 55.0f;
    protected int margin;
    protected int ymargin = 25;
    protected int siteMarkerWidth = 5;
    protected int appointmentSpace;
    protected int firstVisibleLine;
    protected int firstNotVisibleLine;
    protected int visibleSpace;
    protected int borderSelectionMargin;
    protected int drawingSpaceAjustment = LibPlugin.ON_LINUX ? 2 : 4;
    private Color selectionCursorBorderColor;
    protected GC gcBuffer;
    protected Map<RGB, Color> colors = new HashMap<RGB, Color>();
    protected Canvas canvas;
    protected ScrollBar scroll;
    protected boolean focus;
    public Cursor CURSOR_RESIZE;
    public Cursor CURSOR_MOVE;
    protected boolean isResizing;
    protected boolean isMoving;
    protected boolean drawBorder = true;
    protected boolean drawText = true;
    protected boolean drawMarker = true;
    protected boolean drawSelection = true;
    protected boolean drawReplacement = true;
    protected boolean drawGroup = true;
    protected boolean drawTimeText = true;
    protected boolean drawAppointmentOrPeriodIndicator = true;
    protected boolean drawIcons = true;
    private ProviderAR<XAppointmentPeriod, String> periodLabelProvider;
    private ProviderAR<IAppointment, String> appointmentLabelProvider;
    protected boolean firstDrawOccured;
    private Image imageFacturation;
    private Image imageScanned;
    Map<Integer, Integer> mapFontSize = new HashMap<Integer, Integer>();

    public BaseDrawer(Canvas canvas, ScrollBar scroll) {
        this.canvas = canvas;
        this.scroll = scroll;
        this.fontNormal = ResourceGetter.getFontNormal();
        this.fontBold = ResourceGetter.getFontBold();
        this.margin = 50;
        this.CURSOR_RESIZE = ResourceGetter.getCursor((int)7);
        this.CURSOR_MOVE = ResourceGetter.getCursor((int)21);
        this.imageFacturation = ResourceGetter.getImage((String)"images/facturation.gif");
        this.imageScanned = ResourceGetter.getImage((String)"images/print-icon32.png");
        this.periodLabelProvider = new ProviderAR<XAppointmentPeriod, String>(){

            public String get(XAppointmentPeriod period) {
                String nomPeriod;
                JoinList join = new JoinList(", ", 8);
                boolean inDebugMode = Application.get().getGlobalInstances().inDebugMode();
                if (inDebugMode) {
                    join.add((CharSequence)String.valueOf(period.getId()));
                }
                Integer idPeriodType = period.getAppointmentPeriodType();
                XAppointmentPeriodType periodType = null;
                if (idPeriodType != null) {
                    periodType = BaseDrawer.this.getPeriodType(idPeriodType);
                    join.add((CharSequence)periodType.getText());
                }
                if (StringUtils.isNotBlank((String)(nomPeriod = period.getNomPeriod()))) {
                    join.add((CharSequence)nomPeriod);
                }
                if (period.isClosed()) {
                    join.add((CharSequence)Messages.getString((String)"PERIODE_FERMEE", (String[])new String[0]));
                }
                if (periodType != null && !Boolean.TRUE.equals(periodType.getCanHaveAppointment())) {
                    join.add((CharSequence)("*" + Messages.getString((String)"NE_PEUT_PAS_AVOIR_DE_RENDEZVOUS", (String[])new String[0]) + "*"));
                }
                String visibleDate = null;
                LocalDate date = BaseDrawer.this.getVisualStructure().getDate();
                if (period.getVisibleNbMinBefore() != null && period.getVisibleNbMinBefore() > 0 && date != null) {
                    Calendar cal = date.toCalendar();
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.add(12, -period.getVisibleNbMinBefore().intValue() + period.startTime);
                    visibleDate = DateUtil.ttoc((long)cal.getTimeInMillis());
                }
                if (period.isSofyEnabled()) {
                    join.add((CharSequence)"Sofy");
                }
                if (visibleDate != null) {
                    join.add((CharSequence)("V " + visibleDate));
                }
                return join.toString();
            }
        };
        this.appointmentLabelProvider = new AppointmentFormatterSettingsBased("appointment/appointment_format_pref"){

            @Override
            public void changed(String preferenceId, String oldValue, String newValue) {
                super.changed(preferenceId, oldValue, newValue);
                Canvas c = BaseDrawer.this.getCanvas();
                if (c != null && !c.isDisposed()) {
                    c.getDisplay().asyncExec(() -> BaseDrawer.this.redraw());
                }
            }

            @Override
            public boolean canSeeAndModifyAppointment(IAppointment appointment) {
                return BaseDrawer.this.getVisualStructure().canSeeAndModifyAppointment((IVisualAppointment)appointment);
            }
        };
        this.setSelectionCursorBlack();
        this.fontNormal = ResourceGetter.getFontNormal();
        ResourceGetter.addListener((IRefreshFont)this);
    }

    public XAppointmentPeriodType getPeriodType(Integer idType) {
        return idType == null ? null : AppointmentPlugin.getDefault().getPeriodType(idType);
    }

    public XAppointmentType getAppointmentType(Integer idType) {
        return idType == null ? null : AppointmentPlugin.getDefault().getAppointmentType(idType);
    }

    public int computeThumb() {
        int drawingSpaceY = this.canvas.getBounds().height - this.drawingSpaceAjustment;
        int visibleSpace = (int)((float)drawingSpaceY / this.lineHeight + 1.0f);
        return visibleSpace;
    }

    public void drawControl(GC gc) {
        this.firstDrawOccured = true;
        this.drawingSpaceX = Math.max(1, this.canvas.getBounds().width - this.drawingSpaceAjustment);
        this.drawingSpaceY = Math.max(1, this.canvas.getBounds().height - this.drawingSpaceAjustment);
        this.borderSelectionMargin = 4;
        this.appointmentSpace = this.drawingSpaceX - this.margin;
        this.firstVisibleLine = this.scroll.getSelection();
        this.visibleSpace = (int)((float)this.drawingSpaceY / this.lineHeight) - 1;
        this.firstNotVisibleLine = this.firstVisibleLine + this.visibleSpace;
        Image buffer = new Image((Device)this.canvas.getDisplay(), this.drawingSpaceX, this.drawingSpaceY);
        this.gcBuffer = new GC((Drawable)buffer);
        try {
            this.gcBuffer.setAntialias(1);
        }
        catch (Exception exception) {}
        try {
            this.gcBuffer.setTextAntialias(1);
        }
        catch (Exception exception) {}
        if (this.scroll.getThumb() != this.visibleSpace) {
            this.scroll.setThumb(this.visibleSpace);
        }
        try {
            try {
                this.drawBackground();
                if (this.visualStructure != null) {
                    this.visualStructure.getAppointmentDateTemplate();
                    if (this.visualStructure.isUsable()) {
                        int nbLineByDay = this.visualStructure.getNbLineByDay();
                        int line = 0;
                        while (line <= nbLineByDay) {
                            this.drawTime(line);
                            if (line < this.visualStructure.getNbLineByDay()) {
                                this.drawPeriod(line);
                                this.drawPeriodMarker(line);
                            }
                            ++line;
                        }
                        if (this.visualStructure.getAppointmentDate() != null) {
                            this.drawAppointments();
                        }
                        this.drawMessageBox();
                        this.drawSelection();
                        this.drawSelectionCursor();
                        this.drawForeground();
                        this.drawAppointmentOrPeriodIndicator();
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to draw control", e);
                gc.drawImage(buffer, 0, 0);
                this.gcBuffer.dispose();
                buffer.dispose();
            }
        }
        finally {
            gc.drawImage(buffer, 0, 0);
            this.gcBuffer.dispose();
            buffer.dispose();
        }
    }

    protected void drawError() {
        Color foreground = this.gcBuffer.getForeground();
        Color background = this.gcBuffer.getBackground();
        this.gcBuffer.setForeground(this.getColor(0, 0, 0));
        this.gcBuffer.setBackground(this.getColor(0, 0, 0));
        int rwidth = this.drawingSpaceX;
        int rheight = 50;
        int rx1 = 0;
        int ry1 = this.drawingSpaceY / 2 - rheight / 2;
        this.gcBuffer.drawRectangle(rx1, ry1, rwidth, rheight);
        this.gcBuffer.fillRectangle(rx1, ry1, rwidth + 1, rheight + 1);
        String text = Messages.getString((String)"ERREUR", (String[])new String[0]);
        Point textSize = this.gcBuffer.textExtent(text, 1);
        int tx1 = rx1 + rwidth / 2 - textSize.x / 2;
        int ty1 = ry1 + rheight / 2 - textSize.y / 2;
        this.gcBuffer.setForeground(this.getColor(255, 0, 0));
        this.gcBuffer.drawText(text, tx1, ty1, true);
        this.gcBuffer.setForeground(foreground);
        this.gcBuffer.setBackground(background);
    }

    private void drawPeriodMarker(int line) {
        if (!this.drawMarker) {
            return;
        }
        int lineWidth = this.gcBuffer.getLineWidth();
        Color foreground = this.gcBuffer.getForeground();
        XAppointmentPeriod period = this.visualStructure.getPeriod(line);
        if (period != null) {
            int x = this.margin;
            int y = (int)((float)(this.visualStructure.getLine(period) - this.firstVisibleLine) * this.lineHeight) + this.ymargin;
            int height = (int)((float)this.visualStructure.getHeight(period) * this.lineHeight);
            Color colorTypePeriod = this.getPeriodColor(period.getAppointmentPeriodType());
            this.gcBuffer.setForeground(colorTypePeriod);
            this.gcBuffer.setLineStyle(1);
            this.gcBuffer.setLineWidth(5);
            this.gcBuffer.drawLine(x - 7, y + 1, x - 7, y + height - 1);
            this.gcBuffer.setLineWidth(2);
            this.gcBuffer.drawLine(x - 7 - 5, y + 1, x - 7 + 5, y + 1);
            this.gcBuffer.drawLine(x - 7 - 5, y - 1 + height, x - 7 + 5, y - 1 + height);
        }
        this.gcBuffer.setForeground(foreground);
        this.gcBuffer.setLineWidth(lineWidth);
    }

    public Point getGcSelectionFromVsSelection() {
        AppointmentVisualStructure.VsPoint selection;
        AppointmentVisualStructure visualStructure = this.getVisualStructure();
        if (visualStructure != null && visualStructure.isUsable() && (selection = visualStructure.getSelection()) != null) {
            return this.getGCPointFromVisualStructurePoint(selection);
        }
        return null;
    }

    public final Point getGCPointFromVisualStructurePoint(AppointmentVisualStructure.VsPoint vsPoint) {
        assert (vsPoint != null);
        assert (this.visualStructure != null);
        assert (this.visualStructure.isUsable());
        Point gc = new Point(0, 0);
        int line = vsPoint.line;
        int column = vsPoint.column;
        int nbColumn = Math.max(this.visualStructure.getLastColumnIndex(line) + 1, 1);
        if (column == -1) {
            gc.x = 0;
        } else if (column >= 0) {
            gc.x = this.margin + this.appointmentSpace / nbColumn * column;
        }
        if (line == -1) {
            gc.y = 0 + this.ymargin;
        } else if (line >= 0) {
            gc.y = (int)(this.lineHeight * (float)(line - this.firstVisibleLine)) + this.ymargin;
        }
        return gc;
    }

    protected final AppointmentVisualStructure.VsPoint getVSPointFromGCPoint(Point gcPoint) {
        int i;
        assert (gcPoint != null);
        assert (this.visualStructure != null);
        assert (this.visualStructure.isUsable());
        if (!this.firstDrawOccured) {
            return AppointmentVisualStructure.NULL_SELECTION;
        }
        int line = (int)((float)(gcPoint.y - this.ymargin - this.borderSelectionMargin) / this.lineHeight + (float)this.firstVisibleLine);
        if (line < 0 || line > this.visualStructure.getNbLineByDay() - 1) {
            return AppointmentVisualStructure.NULL_SELECTION;
        }
        int nbColumn = Math.max(this.visualStructure.getLastColumnIndex(line) + 1, 1);
        int column = nbColumn > 0 ? (gcPoint.x > this.margin ? ((i = this.appointmentSpace / nbColumn) > 0 ? (gcPoint.x - this.margin) / i : 0) : -1) : 0;
        return new AppointmentVisualStructure.VsPoint(column, line);
    }

    protected boolean isVisualStructurePointOnMargin(AppointmentVisualStructure.VsPoint vsPoint) {
        assert (vsPoint != null);
        return vsPoint.column <= -1;
    }

    protected abstract void drawForeground();

    protected void drawSelectionCursor() {
        if (!this.drawSelection) {
            return;
        }
        AppointmentVisualStructure.VsPoint selection = this.visualStructure.getSelection();
        if (this.getVisualStructure().getMode() == IAppointmentMode.Mode.APPOINTMENT && this.isSelectionValid(selection) && selection.line >= this.firstVisibleLine && selection.line < this.firstNotVisibleLine) {
            int lastColumnIndex = this.visualStructure.getLastColumnIndex(selection.line);
            int height = (int)this.lineHeight;
            int width = this.appointmentSpace;
            int alpha = 150;
            if (this.isVisualStructurePointOnMargin(selection)) {
                width = this.margin;
            } else if (lastColumnIndex > -1) {
                width = this.appointmentSpace / (lastColumnIndex + 1);
            }
            Point gcPoint = this.getGCPointFromVisualStructurePoint(selection);
            Color oldColor = this.gcBuffer.getForeground();
            int oldLineStyle = this.gcBuffer.getLineStyle();
            int oldLineWidth = this.gcBuffer.getLineWidth();
            int oldAlpha = this.gcBuffer.getAlpha();
            Color borderColor = this.selectionCursorBorderColor == null ? this.getColor(0, 0, 0) : this.selectionCursorBorderColor;
            this.gcBuffer.setForeground(borderColor);
            this.gcBuffer.setLineStyle(2);
            this.gcBuffer.setLineWidth(2);
            this.gcBuffer.setAlpha(alpha);
            this.gcBuffer.drawRectangle(gcPoint.x, gcPoint.y, width, height);
            this.gcBuffer.setLineStyle(oldLineStyle);
            this.gcBuffer.setLineWidth(oldLineWidth);
            this.gcBuffer.setForeground(oldColor);
            this.gcBuffer.setAlpha(oldAlpha);
        }
    }

    protected boolean isSelectionValid(AppointmentVisualStructure.VsPoint selection) {
        return selection != null && selection.column >= -1 && selection.line >= 0;
    }

    private void drawGCSelectionDot() {
        if (!this.drawSelection) {
            return;
        }
        if (this.getVisualStructure().getMode() == IAppointmentMode.Mode.APPOINTMENT && this.isSelectionValid(this.visualStructure.getSelection())) {
            Point gcPoint = this.getGCPointFromVisualStructurePoint(this.visualStructure.getSelection());
            Color oldColor = this.gcBuffer.getForeground();
            int oldLineWidth = this.gcBuffer.getLineWidth();
            Color borderColor = this.getColor(255, 0, 0);
            this.gcBuffer.setForeground(borderColor);
            this.gcBuffer.setLineWidth(10);
            this.gcBuffer.drawPoint(gcPoint.x, gcPoint.y);
            this.gcBuffer.drawOval(gcPoint.x, gcPoint.y, 2, 2);
            this.gcBuffer.setLineWidth(oldLineWidth);
            this.gcBuffer.setForeground(oldColor);
        }
    }

    protected void drawSelection() {
        if (!this.drawSelection) {
            return;
        }
        Color background = this.gcBuffer.getBackground();
        Color foreground = this.gcBuffer.getForeground();
        Font font = this.gcBuffer.getFont();
        AppointmentVisualStructure.VsPoint selection = this.visualStructure.getSelection();
        Point gcPoint = this.getGCPointFromVisualStructurePoint(selection);
        int lastColumnIndex = this.visualStructure.getLastColumnIndex(selection.line);
        IVisualAppointment appointment = this.visualStructure.getSelectedAppointment();
        if (appointment instanceof XReservedAppointment) {
            XReservedAppointment xr = (XReservedAppointment)appointment;
            long t = System.currentTimeMillis();
            if (xr.getTimeOfExpiration() >= t) {
                return;
            }
        }
        XAppointmentPeriod period = this.visualStructure.getSelectedPeriod();
        if (selection.line < 0 || this.isVisualStructurePointOnMargin(selection)) {
            return;
        }
        if (appointment != null) {
            this.drawAppointment(appointment);
        } else if (period != null) {
            XSite site;
            Color colorBackground;
            int width;
            int sectionNbLine = this.visualStructure.getLineByAppointment(period);
            int yline = selection.line;
            int sectionEndLine = yline + sectionNbLine;
            int y2line = selection.line;
            int line = selection.line;
            while (line < sectionEndLine) {
                XAppointmentPeriod period2 = this.visualStructure.getPeriod(line);
                if (this.visualStructure.getLastColumnIndex(line) != -1 || period2 != period) break;
                y2line = line++;
            }
            int y = (int)((float)(yline - this.firstVisibleLine) * this.lineHeight) + this.ymargin;
            int height = (int)((float)(y2line + 1 - yline) * this.lineHeight);
            int x = gcPoint.x;
            if (lastColumnIndex <= 0) {
                width = this.appointmentSpace;
            } else {
                int nbPieces = lastColumnIndex + 1;
                int extendRight = 0;
                int extendLeft = 0;
                int i = selection.column;
                while (i < nbPieces && this.getVisualStructure().getAppointment(i, selection.line) == null) {
                    ++i;
                    ++extendRight;
                }
                i = selection.column - 1;
                while (i >= 0 && this.getVisualStructure().getAppointment(i, selection.line) == null) {
                    --i;
                    ++extendLeft;
                }
                width = this.appointmentSpace / nbPieces * (extendLeft + extendRight);
                x = this.appointmentSpace / nbPieces * (selection.column - extendLeft) + this.margin;
            }
            if (period.isClosed()) {
                colorBackground = this.getColor(0, 0, 0);
            } else {
                Color darkenPeriodColor;
                Color periodColor = this.getPeriodColor(period.getAppointmentPeriodType());
                colorBackground = darkenPeriodColor = this.darkenColor(periodColor.getRGB());
            }
            Color borderColorSelection = this.getColor(50, 50, 50);
            this.gcBuffer.setBackground(colorBackground);
            this.gcBuffer.setForeground(borderColorSelection);
            this.gcBuffer.fillRectangle(x, y, width, height);
            if (period.getIdSite() != null && x == gcPoint.x && (site = SitePlugin.getDefault().getSite(period.getIdSite())) != null && site.getColor() != null) {
                Color siteColor = this.getColor(site.getColor());
                this.gcBuffer.setBackground(siteColor);
                this.gcBuffer.fillRectangle(x + 1, y + 1, this.siteMarkerWidth, height - 2);
            }
            if (this.drawBorder) {
                this.gcBuffer.drawRectangle(x, y, width, height);
            }
            if (this.drawText) {
                Color colorText = period.isClosed() ? this.getColor(255, 255, 255) : this.getColor(50, 50, 50);
                this.gcBuffer.setFont(this.fontNormal);
                this.gcBuffer.setForeground(colorText);
                this.gcBuffer.drawText((String)this.getPeriodLabelProvider().get((Object)period), x + 4 + this.siteMarkerWidth, y + 6, true);
            }
        }
        this.gcBuffer.setFont(font);
        this.gcBuffer.setBackground(background);
        this.gcBuffer.setForeground(foreground);
    }

    protected void drawAppointmentOrPeriodIndicator() {
        if (this.drawAppointmentOrPeriodIndicator) {
            Color background = this.gcBuffer.getBackground();
            List<? extends IAppointment> appointments = this.visualStructure.getAppointments();
            IEditableDataObjectList periods = this.visualStructure.getAppointmentDateTemplate().getPeriods();
            int firstVisibleTime = this.visualStructure.getTime(this.firstVisibleLine);
            boolean drawBeforeAppointmentIndicator = false;
            boolean drawBeforePeriodIndicator = false;
            if (this.visualStructure.getMode() == IAppointmentMode.Mode.APPOINTMENT) {
                for (IAppointment iAppointment : appointments) {
                    if (iAppointment.getEndTime() == null || iAppointment.getEndTime().intValue() >= firstVisibleTime) continue;
                    drawBeforeAppointmentIndicator = true;
                    break;
                }
            }
            if (!drawBeforeAppointmentIndicator) {
                for (XAppointmentPeriod xAppointmentPeriod : periods) {
                    if (xAppointmentPeriod.getEndTime() == null || xAppointmentPeriod.getEndTime() >= firstVisibleTime) continue;
                    drawBeforePeriodIndicator = true;
                    break;
                }
            }
            if (drawBeforeAppointmentIndicator || drawBeforePeriodIndicator) {
                if (drawBeforeAppointmentIndicator) {
                    this.gcBuffer.setBackground(this.getColor(ResourceGetter.RED_WARNING_COLOR));
                } else {
                    this.gcBuffer.setBackground(this.getColor(ResourceGetter.YELLOW_WARNING_COLOR));
                }
                this.gcBuffer.fillPolygon(new int[]{this.drawingSpaceAjustment + this.margin + 5, 5, this.drawingSpaceAjustment + this.margin + 10, 40, this.drawingSpaceAjustment + this.margin + 0, 40});
            }
            int n = this.visualStructure.getTime(this.firstNotVisibleLine);
            boolean drawAfterAppointmentIndicator = false;
            boolean drawAfterPeriodIndicator = false;
            if (this.visualStructure.getMode() == IAppointmentMode.Mode.APPOINTMENT) {
                for (IAppointment iAppointment : appointments) {
                    if (iAppointment.getStartTime() == null || iAppointment.getStartTime().intValue() < n) continue;
                    drawAfterAppointmentIndicator = true;
                    break;
                }
            }
            if (!drawAfterAppointmentIndicator) {
                for (XAppointmentPeriod xAppointmentPeriod : periods) {
                    if (xAppointmentPeriod.getStartTime() == null || xAppointmentPeriod.getStartTime() < n) continue;
                    drawAfterPeriodIndicator = true;
                    break;
                }
            }
            if (drawAfterAppointmentIndicator || drawAfterPeriodIndicator) {
                if (drawAfterAppointmentIndicator) {
                    this.gcBuffer.setBackground(this.getColor(ResourceGetter.RED_WARNING_COLOR));
                } else {
                    this.gcBuffer.setBackground(this.getColor(ResourceGetter.YELLOW_WARNING_COLOR));
                }
                this.gcBuffer.fillPolygon(new int[]{this.drawingSpaceAjustment + this.margin + 5, this.drawingSpaceY - 5, this.drawingSpaceAjustment + this.margin + 10, this.drawingSpaceY - 40, this.drawingSpaceAjustment + this.margin + 0, this.drawingSpaceY - 40});
            }
            this.gcBuffer.setBackground(background);
        }
    }

    protected void drawTime(int line) {
        if (this.drawTimeText) {
            int activeFontSize;
            Color colorText = this.getColor(0, 0, 0);
            this.gcBuffer.setForeground(colorText);
            this.gcBuffer.setFont(this.fontNormal);
            String time = this.lineNumberToTimeString(line);
            int fontSize = activeFontSize = ResourceGetter.getFontSizeIncrement();
            if (this.mapFontSize.containsKey(new Integer(fontSize))) {
                fontSize = this.mapFontSize.get(new Integer(activeFontSize));
                this.gcBuffer.setFont(ResourceGetter.getFontNormal((int)fontSize));
            } else {
                this.gcBuffer.setFont(ResourceGetter.getFontNormal((int)fontSize));
                int tw = this.gcBuffer.textExtent((String)"88:88").x;
                --fontSize;
                int maxWidth = this.margin - 13;
                while (tw - maxWidth > 0) {
                    this.gcBuffer.setFont(ResourceGetter.getFontNormal((int)(--fontSize)));
                    tw = this.gcBuffer.textExtent((String)"88:88").x;
                }
                this.mapFontSize.put(new Integer(activeFontSize), new Integer(fontSize));
            }
            this.gcBuffer.drawText(time, 5, (int)((float)(line - this.firstVisibleLine) * this.lineHeight - 8.0f + (float)this.ymargin), true);
            this.gcBuffer.setFont(ResourceGetter.getFontNormal());
        }
        int sizeLine = 4;
        if (line * this.visualStructure.getScale() % 60 == 0) {
            sizeLine = 8;
        }
        int yLine = (int)((float)(line - this.firstVisibleLine) * this.lineHeight) + this.ymargin;
        Color colorBorder = this.getColor(50, 50, 50);
        this.gcBuffer.setForeground(colorBorder);
        this.gcBuffer.setLineWidth(1);
        this.gcBuffer.drawLine(this.margin - sizeLine, yLine, this.margin, yLine);
    }

    protected String lineNumberToTimeString(int line) {
        int timeInMinute2;
        int timeInMinute1 = line * this.visualStructure.getScale() + this.visualStructure.getStartTimeMinute();
        int n = timeInMinute2 = timeInMinute1 == 1440 ? 1440 : timeInMinute1 % 1440;
        if (timeInMinute2 < 0 || timeInMinute2 > 1440) {
            return Messages.getString((String)"TEMPS_INVALIDE", (String[])new String[0]);
        }
        return DateUtil.convertTimeToString((Integer)timeInMinute2, (Character)Character.valueOf(':'));
    }

    protected abstract void drawPeriod(int var1);

    protected void drawBackground() {
        Color marginColor;
        Color backgroundColor;
        Color background = this.gcBuffer.getBackground();
        Color foreground = this.gcBuffer.getForeground();
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            backgroundColor = this.getColor(session.getClientPreferences().getColorDayBackground());
            marginColor = this.getColor(session.getClientPreferences().getColorDayHours());
        } else {
            backgroundColor = this.getColor(255, 255, 255);
            marginColor = this.getColor(194, 219, 245);
        }
        Color colorBorder = this.getColor(50, 50, 50);
        this.gcBuffer.setBackground(backgroundColor);
        this.gcBuffer.setForeground(colorBorder);
        this.gcBuffer.fillRectangle(0, 0, this.drawingSpaceX, this.drawingSpaceY);
        this.gcBuffer.drawLine(this.margin, 0, this.margin, this.drawingSpaceY);
        this.gcBuffer.setBackground(marginColor);
        this.gcBuffer.fillRectangle(0, 0, this.margin, this.drawingSpaceY);
        this.gcBuffer.setBackground(background);
        this.gcBuffer.setForeground(foreground);
    }

    private void drawFade(Color colorStart, Color colorEnd, int startX, int endX, int startY, int endY, int maxX) {
        double redToAdd = (double)(colorEnd.getRed() - colorStart.getRed()) / ((double)endX - (double)startX);
        double greenToAdd = (double)(colorEnd.getGreen() - colorStart.getGreen()) / ((double)endX - (double)startX);
        double blueToAdd = (double)(colorEnd.getBlue() - colorStart.getBlue()) / ((double)endX - (double)startX);
        double red = colorStart.getRed();
        double green = colorStart.getGreen();
        double blue = colorStart.getBlue();
        Color foreground = this.gcBuffer.getForeground();
        int i = startX;
        while (i < endX && i < maxX) {
            Color tempColor = this.getColor((int)(red += redToAdd), (int)(green += greenToAdd), (int)(blue += blueToAdd));
            this.gcBuffer.setForeground(tempColor);
            this.gcBuffer.drawLine(i, startY, i, endY);
            ++i;
        }
        this.gcBuffer.setForeground(foreground);
    }

    protected Color darkenColor(RGB colorToFade) {
        return this.getColor((int)((double)colorToFade.red * 0.75), (int)((double)colorToFade.green * 0.75), (int)((double)colorToFade.blue * 0.75));
    }

    protected final String formatTextForBounds(String text, int width, int height) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (text.isEmpty()) {
            return text;
        }
        text = text.replace('\r', '\u0000');
        String[] words = text.split(" ");
        JoinList lineList = new JoinList(String.valueOf('\n'));
        String line2 = "";
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            boolean doFit;
            StringBuilder line;
            String word = stringArray[n2];
            String[] split = word.split(String.valueOf('\n'));
            if (split.length == 1) {
                line = new StringBuilder();
                if (line2.isEmpty()) {
                    line.append(word);
                } else {
                    line.append(line2).append(" ").append(word);
                }
                boolean bl = doFit = this.gcBuffer.textExtent((String)line.toString()).x < width - 2;
                if (doFit) {
                    line2 = line.toString();
                } else {
                    lineList.add((CharSequence)line2);
                    line2 = word;
                }
            } else if (split.length > 1) {
                line = new StringBuilder();
                if (line2.isEmpty()) {
                    line.append(split[0]);
                } else {
                    line.append(line2).append(" ").append(split[0]);
                }
                boolean bl = doFit = this.gcBuffer.textExtent((String)line.toString()).x < width - 2;
                if (doFit) {
                    lineList.add((CharSequence)line.toString());
                } else {
                    lineList.add((CharSequence)line2);
                    lineList.add((CharSequence)split[0]);
                }
                int i = 1;
                while (i < split.length - 1) {
                    lineList.add((CharSequence)split[i]);
                    ++i;
                }
                line2 = split[split.length - 1];
            }
            ++n2;
        }
        lineList.add((CharSequence)line2);
        boolean removedTextToFitHeight = false;
        if (height != -1) {
            while (lineList.size() > 0 && this.gcBuffer.textExtent((String)lineList.toString()).y > height) {
                lineList.removeLastAdded();
                removedTextToFitHeight = true;
            }
        }
        String result = lineList.toString();
        if (removedTextToFitHeight) {
            result = String.valueOf(result) + " ...";
        }
        return result;
    }

    protected void drawAppointments() {
        if (this.visualStructure == null || this.visualStructure.getAppointmentDate() == null) {
            return;
        }
        ArrayList<Data> datas = new ArrayList<Data>();
        for (IAppointment iAppointment : this.visualStructure.getAppointments()) {
            AppointmentVisualStructure.VsPoint vsPoint = this.visualStructure.getPoint((IVisualAppointment)iAppointment);
            int startLine = vsPoint.line;
            int endLine = startLine + this.visualStructure.getHeight((IVisualAppointment)iAppointment) - 1;
            if ((startLine < this.firstVisibleLine - 1 || startLine > this.firstNotVisibleLine + 1) && (endLine < this.firstVisibleLine - 1 || startLine >= this.firstNotVisibleLine)) continue;
            datas.add(new Data((IVisualAppointment)iAppointment, vsPoint, this.visualStructure.getLastColumnIndex(startLine)));
        }
        List<XReservedAppointment> list = this.visualStructure.getReserverdAppointments();
        for (XReservedAppointment xr : list) {
            long t = System.currentTimeMillis();
            if (xr.getTimeOfExpiration() < t) continue;
            AppointmentVisualStructure.VsPoint vsPoint = this.visualStructure.getPoint((IVisualAppointment)xr);
            int startLine = vsPoint.line;
            int endLine = startLine + this.visualStructure.getHeight((IVisualAppointment)xr) - 1;
            if ((startLine < this.firstVisibleLine - 1 || startLine > this.firstNotVisibleLine + 1) && (endLine < this.firstVisibleLine - 1 || startLine >= this.firstNotVisibleLine)) continue;
            datas.add(new Data((IVisualAppointment)xr, vsPoint, this.visualStructure.getLastColumnIndex(startLine)));
        }
        Collections.sort(datas, new Comparator<Data>(){

            @Override
            public int compare(Data source, Data other) {
                int column = source.vsPoint.column - other.vsPoint.column;
                if (column == 0) {
                    return source.vsPoint.line - other.vsPoint.line;
                }
                return column;
            }
        });
        for (Data data : datas) {
            try {
                this.drawAppointment(data.appointment);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                logger.log(Level.SEVERE, "Failed to draw appointment " + data.appointment, e);
                throw e;
            }
        }
    }

    private void drawAppointment(IVisualAppointment appointment) {
        Color colorText;
        IAppointment appt;
        Color appointmentColor;
        Color background = this.gcBuffer.getBackground();
        Color foreground = this.gcBuffer.getForeground();
        Font font = this.gcBuffer.getFont();
        AppointmentVisualStructure.VsPoint vsPoint = this.visualStructure.getPoint(appointment);
        int nbColumn = Math.max(this.visualStructure.getLastColumnIndex(vsPoint.line) + 1, 1);
        boolean selected = appointment == this.visualStructure.getSelectedAppointment();
        Point gcPoint = this.getGCPointFromVisualStructurePoint(vsPoint);
        if (gcPoint.x == 0) {
            gcPoint.x = this.margin;
        }
        int width = this.appointmentSpace / nbColumn;
        int height = (int)((float)this.visualStructure.getHeight(appointment) * this.lineHeight);
        int xMax = 0;
        int dim = 3;
        if (appointment instanceof IAppointment) {
            appointmentColor = this.getColor(AppointmentPlugin.getDefault().getColorByStatus(((IAppointment)appointment).getStatus()));
            if (this.drawSelection && selected) {
                Color darkenAppointmentColor = this.darkenColor(appointmentColor.getRGB());
                this.gcBuffer.setBackground(darkenAppointmentColor);
                this.gcBuffer.fillRectangle(gcPoint.x, gcPoint.y, width, height);
            } else {
                this.gcBuffer.setBackground(appointmentColor);
                this.gcBuffer.fillRectangle(gcPoint.x, gcPoint.y, width, height);
            }
            xMax = this.drawAppointmentMoveHook(selected, (IAppointment)appointment, gcPoint.x, gcPoint.y, width, height);
            xMax -= gcPoint.x;
        } else if (appointment instanceof XReservedAppointment) {
            appointmentColor = this.getColor(255, 150, 150);
            this.gcBuffer.setBackground(appointmentColor);
            this.gcBuffer.fillRectangle(gcPoint.x + dim * 2, gcPoint.y + dim, width - dim * 3, height - dim * 2);
            xMax -= gcPoint.x;
        }
        if (this.drawBorder) {
            Color colorBorder = this.getColor(50, 50, 50);
            this.gcBuffer.setForeground(colorBorder);
            this.gcBuffer.drawRectangle(gcPoint.x, gcPoint.y, width, height);
            Color colorWhitish = this.getColor(225, 225, 225);
            this.gcBuffer.setForeground(colorWhitish);
            this.gcBuffer.drawLine(gcPoint.x + 1, gcPoint.y + height - 1, gcPoint.x + width - 2, gcPoint.y + height - 1);
        }
        if (appointment instanceof IAppointment) {
            XSite site;
            appt = (IAppointment)appointment;
            colorText = this.getColor(0, 0, 0);
            this.gcBuffer.setForeground(colorText);
            this.gcBuffer.drawText(this.formatTextForBounds((String)this.appointmentLabelProvider.get((Object)appt), xMax, height), gcPoint.x + 3 + this.siteMarkerWidth, gcPoint.y + 1, 3);
            if (appt.getSite() != null && (site = SitePlugin.getDefault().getSite(appt.getSite())) != null && site.getColor() != null) {
                Color background2 = this.gcBuffer.getBackground();
                Color siteColor = this.getColor(site.getColor());
                this.gcBuffer.setBackground(siteColor);
                this.gcBuffer.fillRectangle(gcPoint.x + 1, gcPoint.y + 1, this.siteMarkerWidth, height - 2);
                this.gcBuffer.setBackground(background2);
            }
            if (Boolean.TRUE.equals(appt.getIsDeleted())) {
                int lineWidth = this.gcBuffer.getLineWidth();
                this.gcBuffer.setForeground(this.getColor(255, 0, 0));
                this.gcBuffer.setLineWidth(1);
                this.gcBuffer.drawLine(gcPoint.x, gcPoint.y, gcPoint.x + width, gcPoint.y + height);
                this.gcBuffer.drawLine(gcPoint.x, gcPoint.y + height, gcPoint.x + width, gcPoint.y);
                this.gcBuffer.setLineWidth(lineWidth);
            }
            if (this.drawReplacement) {
                Integer xdateProf = this.getVisualStructure().getAppointmentDate().getProfessional();
                Integer appointmentProf = appointment.getIdProfessional();
                Set appointmentProfs = appt.getIdProfessionals();
                if (!xdateProf.equals(appointmentProf) && !appointmentProfs.contains(xdateProf)) {
                    this.gcBuffer.setFont(ResourceGetter.getFontBold((int)5));
                    this.gcBuffer.setForeground(this.getColor(255, 0, 0));
                    Point size = this.gcBuffer.textExtent("R");
                    this.gcBuffer.drawText("R", gcPoint.x + width - size.x - 15, gcPoint.y + height - size.y);
                }
            }
        } else if (appointment instanceof XReservedAppointment) {
            appt = (XReservedAppointment)appointment;
            colorText = this.getColor(0, 0, 0);
            this.gcBuffer.setForeground(colorText);
            this.gcBuffer.drawText(this.formatTextForBounds(appt.toString(), xMax, height), gcPoint.x + 3 + this.siteMarkerWidth + dim * 2, gcPoint.y + 1 + dim, 3);
        }
        this.gcBuffer.setBackground(background);
        this.gcBuffer.setForeground(foreground);
        this.gcBuffer.setFont(font);
    }

    protected Color getPeriodColor(Integer type) {
        if (type == null) {
            return this.getColor(250, 250, 250);
        }
        return this.getColor(this.getPeriodType(type).getColor());
    }

    public void setVisualStructure(AppointmentVisualStructure visualStructure) {
        Log.log((Logger)logger, (String)"BaseDrawer.setVisualStructure", (String[])new String[]{"visualStructure"}, (Object[])new Object[]{visualStructure});
        this.visualStructure = visualStructure;
        if (this.scroll != null && !this.scroll.isDisposed()) {
            if (visualStructure != null && visualStructure.isUsable()) {
                if (this.scroll.getMaximum() != visualStructure.getNbLineByDay()) {
                    this.scroll.setMaximum(visualStructure.getNbLineByDay());
                }
            } else {
                this.scroll.setMaximum(1);
            }
        }
    }

    public AppointmentVisualStructure getVisualStructure() {
        return this.visualStructure;
    }

    public void setCanvasToDrawOn(Canvas canvas) {
        this.canvas = canvas;
    }

    protected Color getColor(int red, int green, int blue) {
        return this.getColor(new RGB(red, green, blue));
    }

    protected Color getColor(int[] colors) {
        return this.getColor(new RGB(colors[0], colors[1], colors[2]));
    }

    protected Color getColor(RGB rgb) {
        Color color = this.colors.get(rgb);
        if (color == null || color.isDisposed()) {
            color = ResourceGetter.getColor((RGB)rgb);
            this.colors.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        for (Color color : this.colors.values()) {
            ResourceGetter.dispose((Object)color);
        }
        ResourceGetter.dispose((Object)this.CURSOR_MOVE);
        ResourceGetter.dispose((Object)this.CURSOR_RESIZE);
        ResourceGetter.dispose((Object)this.fontNormal);
        ResourceGetter.removeListener((IRefreshFont)this);
    }

    protected abstract void drawPeriodMoveHook(XAppointmentPeriod var1, int var2, int var3, int var4, int var5);

    protected int drawAppointmentMoveHook(boolean selected, IAppointment appointment, int x, int y, int width, int height) {
        int x2 = x + width;
        Color background = this.gcBuffer.getBackground();
        Color foreground = this.gcBuffer.getForeground();
        Color borderColor = this.getColor(0, 0, 0);
        Color patientStatusColor = this.getColor(AppointmentPlugin.getDefault().getColorByPatientStatus(appointment.getPatientStatus()));
        Color apointmentTypeColor = this.getColorByAppointmentType(appointment);
        if (selected) {
            patientStatusColor = this.darkenColor(patientStatusColor.getRGB());
            apointmentTypeColor = this.darkenColor(apointmentTypeColor.getRGB());
        }
        int rectWidth = 15;
        this.gcBuffer.setForeground(borderColor);
        this.gcBuffer.setBackground(patientStatusColor);
        this.gcBuffer.drawRectangle(x + width - rectWidth, y, rectWidth, height / 2);
        this.gcBuffer.fillRectangle(x + width - rectWidth + 1, y + 1, rectWidth - 1, height / 2);
        this.gcBuffer.setForeground(borderColor);
        this.gcBuffer.setBackground(apointmentTypeColor);
        this.gcBuffer.drawRectangle(x + width - rectWidth, y + height / 2, rectWidth, height / 2);
        this.gcBuffer.fillRectangle(x + width - rectWidth + 1, y + 1 + height / 2, rectWidth - 1, height / 2);
        if (!(this instanceof ThermometerDrawer)) {
            x2 = this.drawIcons(selected, appointment, x, y, width, height);
        }
        this.gcBuffer.setForeground(foreground);
        this.gcBuffer.setBackground(background);
        return x2 -= rectWidth;
    }

    private int drawIcons(boolean selected, IAppointment appointment, int x, int y, int width, int height) {
        XSession session;
        int x2 = x + width;
        if (appointment.getId() != null && (session = Application.get().getGlobalInstances().getSession()) != null) {
            List patients;
            ArrayList<Image> icons = new ArrayList<Image>(3);
            if (this.drawIcons && Application.get().getGlobalInstances().hasRight(XRight.BILLING_QC) && appointment.getIdProfessionals().size() == 1 && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)PersonUiPlugin.getDefault().getBaseProfessionnal((Integer)appointment.getIdProfessional()).noAgenceRamq)) {
                icons.add(this.imageFacturation);
            }
            if ((patients = appointment.getPatientsOrAdhoc((IJsonReader)Application.get().getGsonProcessor())).size() == 1) {
                if (Boolean.TRUE.equals(((IPatient)patients.get(0)).getIsScanned())) {
                    icons.add(this.imageScanned);
                }
            } else if (patients.size() > 1) {
                boolean allScanned = true;
                int i = 0;
                while (i < patients.size() && allScanned) {
                    allScanned = Boolean.TRUE.equals(((IPatient)patients.get(i)).getIsScanned()) && allScanned;
                    ++i;
                }
                if (allScanned) {
                    icons.add(this.imageScanned);
                }
            }
            int marginx = 15;
            int iconWidth = 30;
            for (Image icon : icons) {
                this.gcBuffer.drawImage(icon, (x2 -= iconWidth) - marginx, y + 2);
            }
        }
        return x2;
    }

    protected void drawMessageBox() {
        XBaseProfessionnal prof;
        XAppointmentDate xdate2;
        String text = "";
        XBaseAppointmentDate xdate = this.visualStructure.getBaseAppointmentDate();
        if (xdate != null) {
            text = xdate.getMessage();
            String text2 = xdate.getMessageAll();
            String string = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text) ? text2 : (text = String.valueOf(text) + (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text2) ? "" : " / " + text2));
        }
        if ((xdate2 = this.visualStructure.getAppointmentDate()) != null && xdate2.getProfessional() != null && (prof = PersonUiPlugin.getDefault().getWhoReplaceProf(xdate2.getProfessional(), xdate2.getDate())) != null) {
            String text2 = "Remplac\u00e9 par " + prof.getName();
            String string = text = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text) ? text2 : String.valueOf(text) + " \n " + text2;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)text)) {
            text = org.apache.commons.lang3.StringUtils.removeEnd((String)text.trim(), (String)String.valueOf('\n'));
            Color foreground = this.gcBuffer.getForeground();
            Color background = this.gcBuffer.getBackground();
            this.gcBuffer.setForeground(this.getColor(0, 0, 0));
            this.gcBuffer.setBackground(this.getColor(255, 25, 0));
            int rwidth = this.drawingSpaceX - this.margin;
            text = this.formatTextForBounds(text, rwidth - 16, -1);
            Point textSize = this.gcBuffer.textExtent(text, 3);
            int rheight = textSize.y + 10;
            int ry1 = this.drawingSpaceY - rheight;
            int rx1 = this.margin;
            this.gcBuffer.drawRectangle(rx1, ry1, rwidth, rheight);
            this.gcBuffer.fillRectangle(rx1, ry1, rwidth + 1, rheight + 1);
            int tx1 = rx1 + 7 + rwidth / 2 - textSize.x / 2;
            int ty1 = ry1 + 5;
            this.gcBuffer.setForeground(this.getColor(255, 255, 255));
            this.gcBuffer.drawText(text, tx1, ty1, 3);
            this.gcBuffer.setForeground(foreground);
            this.gcBuffer.setBackground(background);
        }
    }

    private Color getColorByAppointmentType(IAppointment appointment) {
        XAppointmentType type = this.getAppointmentType(appointment.getTypeAppointment());
        return this.getColor(AppointmentPlugin.getDefault().getColorByAppointmentType(type));
    }

    public abstract void setFocus(boolean var1);

    public abstract void setSelection(int var1, int var2);

    public abstract Cursor getCursorForMouseLocation(int var1, int var2);

    public abstract boolean resizeTo(int var1, int var2);

    public abstract boolean moveTo(int var1, int var2);

    protected Canvas getCanvas() {
        return this.canvas;
    }

    public ScrollBar getScroll() {
        return this.scroll;
    }

    public int getAppointmentHeight() {
        return (int)this.lineHeight;
    }

    public void setAppointmentHeight(int appointmentHeight) {
        this.lineHeight = appointmentHeight;
    }

    public void redraw() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public ProviderAR<XAppointmentPeriod, String> getPeriodLabelProvider() {
        return this.periodLabelProvider;
    }

    public void setPeriodLabelProvider(ProviderAR<XAppointmentPeriod, String> periodLabelProvider) {
        this.periodLabelProvider = periodLabelProvider;
    }

    public ProviderAR<IAppointment, String> getAppointmentLabelProvider() {
        return this.appointmentLabelProvider;
    }

    public void setAppointmentLabelProvider(ProviderAR<IAppointment, String> appointmentLabelProvider) {
        this.appointmentLabelProvider = appointmentLabelProvider;
    }

    public boolean isDrawSelection() {
        return this.drawSelection;
    }

    public void setDrawSelection(boolean drawSelection) {
        this.drawSelection = drawSelection;
    }

    public int getMargin() {
        return this.margin;
    }

    public int getAppointmentSpace() {
        return this.appointmentSpace;
    }

    public void setSelectionCursorBlack() {
        this.selectionCursorBorderColor = this.getColor(0, 0, 0);
        this.redraw();
    }

    public void setSelectionCursorRed() {
        this.selectionCursorBorderColor = this.getColor(255, 0, 0);
        this.redraw();
    }

    public int getDrawingSpaceX() {
        return this.drawingSpaceX;
    }

    public void setDrawingSpaceX(int drawingSpaceX) {
        this.drawingSpaceX = drawingSpaceX;
    }

    public int getDrawingSpaceY() {
        return this.drawingSpaceY;
    }

    public void setDrawingSpaceY(int drawingSpaceY) {
        this.drawingSpaceY = drawingSpaceY;
    }

    public int getDrawingSpaceAjustment() {
        return this.drawingSpaceAjustment;
    }

    public void setDrawingSpaceAjustment(int drawingSpaceAjustment) {
        this.drawingSpaceAjustment = drawingSpaceAjustment;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public boolean isDrawText() {
        return this.drawText;
    }

    public void setDrawText(boolean drawText) {
        this.drawText = drawText;
    }

    public boolean isDrawMarker() {
        return this.drawMarker;
    }

    public void setDrawMarker(boolean drawMarker) {
        this.drawMarker = drawMarker;
    }

    public boolean isDrawReplacement() {
        return this.drawReplacement;
    }

    public void setDrawReplacement(boolean drawReplacement) {
        this.drawReplacement = drawReplacement;
    }

    public boolean isDrawGroup() {
        return this.drawGroup;
    }

    public void setDrawGroup(boolean drawGroup) {
        this.drawGroup = drawGroup;
    }

    public boolean isDrawTimeText() {
        return this.drawTimeText;
    }

    public void setDrawTimeText(boolean drawTimeText) {
        this.drawTimeText = drawTimeText;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public boolean isDrawIcons() {
        return this.drawIcons;
    }

    public void setDrawIcons(boolean drawIcons) {
        this.drawIcons = drawIcons;
    }

    public void refreshFont() {
        if (!this.canvas.isDisposed()) {
            this.fontNormal = ResourceGetter.getFontNormal();
            this.redraw();
        }
    }

    private static final class Data {
        final IVisualAppointment appointment;
        final int lastColumnIndex;
        final AppointmentVisualStructure.VsPoint vsPoint;

        public Data(IVisualAppointment appointment, AppointmentVisualStructure.VsPoint vsPoint, int lastColumnIndex) {
            this.appointment = appointment;
            this.vsPoint = vsPoint;
            this.lastColumnIndex = lastColumnIndex;
        }

        public String toString() {
            return String.format("vsPoint:%s, lastColumnIndex:%d, %s", this.vsPoint, this.lastColumnIndex, this.appointment);
        }
    }

    public class SelectionEventWrapper
    extends EventObject {
        private static final long serialVersionUID = 7497267779632490726L;
        IAppointment selectedAppointment;
        XAppointmentPeriod selectedPeriod;
        XAppointmentDateTemplate selectedDateTemplate;
        XAppointmentDate selectedDate;
        int startTime;
        int endTime;
        boolean doit;

        public SelectionEventWrapper(IAppointment selectedAppointment, XAppointmentPeriod selectedPeriod, XAppointmentDateTemplate selectedDateTemplate, XAppointmentDate selectedDate, int startTime, int endTime) {
            super(BaseDrawer.this);
            this.doit = true;
            this.selectedAppointment = selectedAppointment;
            this.selectedPeriod = selectedPeriod;
            this.selectedDateTemplate = selectedDateTemplate;
            this.selectedDate = selectedDate;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public SelectionEventWrapper(SelectionEventWrapper event) {
            super(BaseDrawer.this);
            this.doit = event.doit;
            this.selectedAppointment = event.selectedAppointment;
            this.selectedPeriod = event.selectedPeriod;
            this.selectedDateTemplate = event.selectedDateTemplate;
            this.selectedDate = event.selectedDate;
            this.startTime = event.startTime;
            this.endTime = event.endTime;
        }
    }
}

