/**
 * plugin.js
 *
 * Copyright, Moxiecode Systems AB
 * Released under LGPL License.
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/*global tinymce:true */

tinymce.PluginManager.add('anchor', function(editor) {
	var handleOpen = function(e) {
		activeAuto();
		editor.assist.openAssistant();
	}
	var activeAuto = function() {
		if (typeof(editor.assist) != 'undefined' && editor.assist != null) {
			return;
		}
		var divEditor = $(editor.getContentAreaContainer());
		var editId = divEditor.attr("id");
		if ( typeof(editId) == 'undefined' || editId == null || typeof(editId.length) == 'undefined' || editId.length == null || editId.length == 0) {
			divEditor.attr("id", "div-editor-"+Math.floor(Math.random()*100000));
		}

		
		editor.assist = AutoComplete.NEW(
			divEditor.attr("id"),
			function(text) {
				var n = Math.floor(Math.random()*4);
				var cs = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s'];
				var arr = [];
				for (var i = 0; i < n; i++) {
					var n2 = Math.floor(Math.random()*10)+5;
					var o = {name: "", description: "desc: "};
					for (var j = 0; j < n2; j++) {
						var n3 = Math.floor(Math.random()*19);
						var c = cs[n3];
						o.name += c;
						o.description += c;
					}
					arr.push(o);
				}
				return arr;
			}, function(text) {
				var div = $("<div>");
				div.text(this.name);
				div.css("cursor","pointer");
				return div;
			}, function(text) {
				var div = $("<div>");
				div.text(this.description);
				return div;
			}, function(baseElement) {

			}, function(assistant) { //onselect
				editor.selection.setContent(this.description);
			}, function() {//positioning
				var sel = $(editor.selection.getNode());
				
				return sel.offset().top + sel.height() - $(editor.contentDocument).scrollTop() + 3;
			}, null //otherObject
			, function() {//endFocus on close
				editor.focus();
			}
			
		);
	}
	editor.on('init', function() {
		console.log("init");
		editor.addShortcut('Ctrl+Shift+A', '', handleOpen);
	});

	editor.addButton('auto', {
		image: 'tinymce/js/tinymce/plugins/autocomplete/img/autocomplete1_32.png',
		tooltip: 'Auto',
		onclick: handleOpen
	});

	editor.addMenuItem('auto', {
		image: 'tinymce/js/tinymce/plugins/autocomplete/img/autocomplete1_32.png',
		text: 'Auto',
		shortcut: 'Ctrl+Shift+A',
		context: 'insert',
		onclick: handleOpen,
		prependToContext: true
	});
});