var __optimizedAngle = 15;
function CanvasData(id) {
	this.lines = new Array();
	this.actLine = null;
	this.id = id || "drawValue";
	this.actColor = null;
	this.debugDiv = null;
	
	this.add = function(x,y) {
		var color = this.actColor || null;
		if (this.actLine == null) {
			this.closeActLine();
			this.actLine = new CanvasLine(color);
			this.lines.push(this.actLine);
		}
		
		this.actLine.add(x,y);
	}
	
	this.closeActLine = function() {
//		logDrawer("CanvasData.closeActLine");
		this.setColor(null);
		this.actLine = null;
	}
	
	this.pushInInput = function() {
//		logDrawer("CanvasData.pushInInput");
//		var st = JSON.stringify(this);
		var st = this.jstring();
	//	logDrawer(this.jstring());
		$("#"+this.id).val(st);
		if (this.debugDiv != null) {
			st = "";
			for (var i = 0; i < this.lines.length; i++) {
				st += this.lines[i].x.length+";";
			}
			this.debugDiv.text(st);
		}
	}
	
	this.setColor = function(color) {
		this.actColor = color || null;
	}
	
	this.jstring = function() {
		var st = "{\"lines\":[";
		
		for (var i = 0; i < this.lines.length; i++) {
			st += this.lines[i].jstring();
			if (i < this.lines.length-1) {
				st += ",";
			}
		}
		
		st += "],\"id\":\""+this.id+"\", \"actColor\":";
		if (this.actColor == null) {
			st += "null";
		} else {
			st += "\""+this.actColor+"\"";
		}
		
		st += "}";
		
		return st;
	}
}


function CanvasLine(color) {
	this.x = new Array();
	this.y = new Array();
	this.color = color || "#000000";
	
	this.add = function(x, y) {
		this.x.push(x);
		this.y.push(y);
	}
	
	this.jstring = function() {
		return JSON.stringify(this);
	}
}

var drawzones = new Array();

function DrawZone(idCanvas, idInput, debug,ajustLeft, ajustTop) {
	this.idCanvas = idCanvas || null;
	this.idInput = idInput || null;
	this.debugMode = debug || false;
/**/	this.ajustLeft = ajustLeft || 0;
	this.ajustTop = ajustTop || 0;
/**/	
	
	this.init = function() {
//		logDrawer("DrawZone.init");
		if (this.canGo()) {
			this.canvas.css("cursor","crosshair");
			drawzones.push(this);
			var that = this;
			// Click souris enfonc? sur le canvas, je dessine :
			this.canvas.mousedown(function(e) {
//		logDrawer("DrawZone.mousedown");
				
				if (!that.hasDraw) {
					that.hasDraw = 100;
				}
				that.painting = true;
				that.drawSaver.closeActLine();
				that.drawSaver.setColor(that.color);
				// Coordonn?es de la souris :
/*				that.cursorX = (e.pageX - $(that).offset().left);
				that.cursorY = (e.pageY - $(that).offset().top);
*/			});
			
			// Relachement du Click sur tout le document, j'arr?te de dessiner :
			$(document).mouseup(function() {
//		logDrawer("DrawZone.mouseup");
				that.painting = false;
				that.started = false;
				that.optimizedLines();
				that.drawSaver.pushInInput();
				
			});
			
			// Mouvement de la souris sur le canvas :
			this.canvas.mousemove(function(e) {
				// Si je suis en train de dessiner (click souris enfonc?) :
				if (that.painting) {
					// Set Coordonn?es de la souris :
/*					that.cursorX = (e.pageX - $(this).offset().left) - 10; // 10 = d?calage du curseur
					that.cursorY = (e.pageY - $(this).offset().top) - 10;
*/					that.cursorX = Math.round((e.pageX - $(this).offset().left) - 10+that.ajustLeft); // 10 = d?calage du curseur
					that.cursorY = Math.round((e.pageY - $(this).offset().top) - 10+that.ajustTop);
/**/					
					// Dessine une ligne :
					that.drawLine();
				}
			});
			
			if(this.debugMode) {
				var debugDiv = $("<div></div>");
				debugDiv.insertAfter(this.canvas);
				this.drawSaver.debugDiv = debugDiv;
			}

		}
	}
	
	// Fonction qui dessine une ligne :
	this.drawLine = function() {
		// Si c'est le d?but, j'initialise
		if (!this.started) {
			// Je place mon curseur pour la premi?re fois :
			this.context.beginPath();
			this.context.moveTo(this.cursorX, this.cursorY);
			this.drawSaver.add(this.cursorX, this.cursorY);
			this.started = true;
		} 
		// Sinon je dessine
		else {
			this.context.lineTo(this.cursorX, this.cursorY);
			this.drawSaver.add(this.cursorX, this.cursorY);
			this.context.strokeStyle = this.color;
			this.context.lineWidth = this.width_brush;
			this.context.stroke();
		}
	}
	
	// Clear du Canvas :
	this.clear_canvas = function() {
		this.context.clearRect(0,0, this.canvas.width(), this.canvas.height());
		var old = this.drawSaver;
		this.drawSaver = new CanvasData(old.id);
		this.drawSaver.debugDiv = old.debugDiv;
		this.drawSaver.pushInInput();
	}		
	
	this.canGo = function() {
		return this.idCanvas != null && this.idInput != null;
	}
	
	this.redraw = function() {
//		logDrawer("Re draw it");
		var st = $("#"+this.idInput).val();
//		logDrawer(st);
		var dObject = $.parseJSON(st);

		this.clear_canvas();

		var lines = dObject.lines;


		
		for (var j = 0; j < lines.length ; j++) {
		
			var x = lines[j].x;
			var y = lines[j].y;
			this.color = lines[j].color;
//			logDrawer("Redraw a "+x.length+" pts line of color "+this.color);
			for (var i = 0; i < x.length; i++) {
				if (i == 0) {
					this.painting = true;
					this.drawSaver.closeActLine();
					this.drawSaver.setColor(this.color);
				}
				this.cursorX = x[i];
				this.cursorY = y[i];
				this.drawLine();
			}
			this.painting = false;
			this.started = false;
		}
		this.drawSaver.pushInInput();
		
	}
	
	this.optimizedLines = function() {
		var oldDrawer = this.drawSaver;
		this.clear_canvas();
		for(var j = 0; j < oldDrawer.lines.length; j++) {
			var st = "";
			var line = oldDrawer.lines[j];
			var x = line.x;
			var y = line.y;
			this.color = line.color;

			var p1;
			var p2;
			var c;
			var count = 0;
			st += x.length+" to "
			for (var i = 0; i < x.length; i++) {
				c = {x:x[i],y:y[i]};
				if (i == 0) {
					this.painting = true;
					this.drawSaver.closeActLine();
					this.drawSaver.setColor(this.color);
				}
				var mustAdd = true;
				if (i > 0 && i < x.length-1) {
					p2 = {x:x[i+1],y:y[i+1]};
					var a = find_angle(p1,p2,c);
					if (a > 180-__optimizedAngle && a < 180+__optimizedAngle) {
						mustAdd = false;
					}
				}
				if (mustAdd){
					count++;
					p1 = {x:x[i],y:y[i]};
					this.cursorX = x[i];
					this.cursorY = y[i];
					this.drawLine();
				}
				
			}
			st += count;

//			logDrawer("op: " + st);
			this.painting = false;
			this.started = false;			
		}
		this.drawSaver.pushInInput();
	}
	
	this.checkForStartDraw = function() {
		//logDrawer("checkForStartDraw : "+this.hasDraw);
		if (this.canGo()) {
			if (this.hasDraw < 40) {
				if ($("#"+this.idInput).val().length > 0 ) {
					this.hasDraw = 100;
					this.redraw();
				} else {
					this.hasDraw++;
					var that = this;
					setTimeout(function() {that.checkForStartDraw();},500);
				}
			}
		}
	}
	
	this.showImpossible = function() {
		var posDiv = $("<div>");
		var msgDiv = $("<div>");
		
		posDiv.css("position","relative").css("top","0px");
		msgDiv.css("position","absolute").css("top","0px");
		msgDiv.text("Votre navigateur est trop d\u00E9suet pour permettre le dessin.")
		msgDiv.css("width", $("#"+this.idCanvas).width()+"px");
	
		posDiv.append(msgDiv);
		
		$("#"+this.idCanvas).before(posDiv);
	}

	if ( __isDrawable() ) {
		//Draw var
		this.hasDraw = 0;
		this.color = "#000";
		this.painting = false;
		this.started = false;
		this.width_brush = 1;
		this.canvas = $("#"+this.idCanvas);
		this.cursorX, this.cursorY;
		this.context = this.canvas[0].getContext('2d');
		// Trait arrondi :
		this.context.lineJoin = 'round';
		this.context.lineCap = 'round';
		this.drawSaver = new CanvasData(this.idInput);
		
		try {
		this.init();
		this.checkForStartDraw();
		} catch(err) { /*alert(err)*/};
	} else {
		this.showImpossible();
	}
}


function find_angle(p0,p1,c) {
    var p0c = Math.sqrt(Math.pow(c.x-p0.x,2)+
                        Math.pow(c.y-p0.y,2)); // p0->c (b)   
    var p1c = Math.sqrt(Math.pow(c.x-p1.x,2)+
                        Math.pow(c.y-p1.y,2)); // p1->c (a)
    var p0p1 = Math.sqrt(Math.pow(p1.x-p0.x,2)+
                         Math.pow(p1.y-p0.y,2)); // p0->p1 (c)
    return Math.acos((p1c*p1c+p0c*p0c-p0p1*p0p1)/(2*p1c*p0c))*(180/3.1416);
}



function logDrawer(msg) {
	var p  = $("<p></p>").text(msg);
	$("#log").append(p);
	try {
	console.log(msg);
	} catch(err) {}
}

function __isCanvasable() {
	var acceptCanvas = false;
	try{
		canvas = $("<canvas>");
		if (typeof canvas[0].getContext == 'function') {
			acceptCanvas = true;
		}
	}catch(e){};
	return acceptCanvas;
}

function __isDrawable() {
	var drawable = __isCanvasable();
	return drawable;
}
