/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util.math;

import ca.infodata.ofys.util.math.SieveOfEratosthenes;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Vector;

public class DirectSearchFactorization {
    private int max = 0;
    private Vector<Integer> trialDivisors = null;
    private int nDivisions = 0;

    protected DirectSearchFactorization(int max) {
        this.max = max;
        int sqrtn = (int)Math.ceil(Math.sqrt(max));
        this.trialDivisors = SieveOfEratosthenes.getPrimes(sqrtn);
        this.trialDivisors.addElement(new Integer(sqrtn));
    }

    protected long getNumDivisions() {
        return this.nDivisions;
    }

    public IntArrayList getPrimeFactorsInt(int n) {
        if (n > this.max) {
            String s = n + " > " + this.max;
            throw new IllegalArgumentException(s);
        }
        IntArrayList factors = new IntArrayList();
        this.nDivisions = 0;
        int k = 0;
        while (n > 1) {
            int divisor = this.trialDivisors.elementAt(k);
            int quotient = (int)Math.floor(n / divisor);
            int remainder = n % divisor;
            ++this.nDivisions;
            if (remainder == 0) {
                factors.add(divisor);
                n = quotient;
                continue;
            }
            if (quotient > divisor) {
                ++k;
                continue;
            }
            factors.add(n);
            break;
        }
        return factors;
    }

    public Vector<Integer> getPrimeFactors(int n) {
        if (n > this.max) {
            String s = n + " > " + this.max;
            throw new IllegalArgumentException(s);
        }
        Vector<Integer> factors = new Vector<Integer>();
        this.nDivisions = 0;
        int k = 0;
        while (n > 1) {
            Integer divisorObj = this.trialDivisors.elementAt(k);
            int divisor = divisorObj;
            int quotient = (int)Math.floor(n / divisor);
            int remainder = n % divisor;
            ++this.nDivisions;
            if (remainder == 0) {
                factors.addElement(new Integer(divisor));
                n = quotient;
                continue;
            }
            if (quotient > divisor) {
                ++k;
                continue;
            }
            factors.addElement(new Integer(n));
            break;
        }
        return factors;
    }
}

