/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import ca.infodata.ofys.util.MiscUtil;

public abstract class FieldUpdate<T> {
    private T value1;
    private T value2;
    private String fieldName;

    public FieldUpdate() {
    }

    public FieldUpdate(String fieldName, T value1, T value2) {
        this.value1 = value1;
        this.value2 = value2;
        this.fieldName = fieldName;
    }

    public final String formatUpdate() {
        if (MiscUtil.areObjectsEquals(this.value1, this.value2)) {
            return null;
        }
        if (this.isNull(this.getValue1())) {
            return this.formatUpdateFromNull();
        }
        if (this.isNull(this.getValue2())) {
            return this.formatUpdateToNull();
        }
        return this.formatUpdateOverride();
    }

    protected abstract String formatUpdateOverride();

    protected abstract String formatUpdateToNull();

    protected abstract String formatUpdateFromNull();

    protected boolean isNull(T value) {
        return value == null;
    }

    public T getValue1() {
        return this.value1;
    }

    public void setValue1(T value1) {
        this.value1 = value1;
    }

    public T getValue2() {
        return this.value2;
    }

    public void setValue2(T value2) {
        this.value2 = value2;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
}

