/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.task;

import ca.infodata.dsq.tools.JoinList;
import ca.infodata.ofys.data.middle.dataobjects.task.XTask;
import java.io.Serializable;
import java.util.Collection;

public final class XTaskCriteria
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public Integer idPatient;
    public Collection<Integer> ids;
    public Integer fromUser;
    public Integer toUser;
    public Integer toGroup;
    public Long dueStart;
    public Long dueEnd;
    public Boolean unassigned;
    public Boolean completed;
    public Integer limit;

    public XTaskCriteria setIdPatient(Integer idPatient) {
        this.idPatient = idPatient;
        return this;
    }

    public XTaskCriteria setFromUser(Integer fromUser) {
        this.fromUser = fromUser;
        return this;
    }

    public XTaskCriteria setToUser(Integer toUser) {
        this.toUser = toUser;
        return this;
    }

    public XTaskCriteria setToGroup(Integer toGroup) {
        this.toGroup = toGroup;
        return this;
    }

    public XTaskCriteria setUnassigned(Boolean unassigned) {
        this.unassigned = unassigned;
        return this;
    }

    public XTaskCriteria setCompleted(Boolean completed) {
        this.completed = completed;
        return this;
    }

    public XTaskCriteria setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Long getDueStart() {
        return this.dueStart;
    }

    public void setDueStart(Long dueStart) {
        this.dueStart = dueStart;
    }

    public Long getDueEnd() {
        return this.dueEnd;
    }

    public void setDueEnd(Long dueEnd) {
        this.dueEnd = dueEnd;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.idPatient != null) {
            sb.append("idPatient=" + this.idPatient);
        }
        if (this.fromUser != null) {
            sb.append("fromUser=" + this.fromUser);
        }
        if (this.toUser != null) {
            sb.append("toUser=" + this.toUser);
        }
        if (this.toGroup != null) {
            sb.append("toGroup=" + this.toGroup);
        }
        if (this.ids != null && this.ids.size() > 0) {
            sb.append("ids=" + new JoinList(",", this.ids).toString());
        }
        if (this.dueStart != null) {
            sb.append("dueStart=" + this.dueStart);
        }
        if (this.dueEnd != null) {
            sb.append("dueEnd=" + this.dueEnd);
        }
        if (Boolean.TRUE.equals(this.unassigned)) {
            sb.append("unassigned=true");
        }
        if (Boolean.TRUE.equals(this.completed)) {
            sb.append("completed=true");
        }
        if (sb.length() > 0) {
            sb.insert(0, "XTaskCriteria=[");
            sb.append("]");
        }
        return sb.toString();
    }

    public String toStringForHash() {
        return "xtk[idp" + this.idPatient + "fu" + this.fromUser + "tu" + this.toUser + "tg" + this.toGroup + "ds" + this.dueStart + "de" + this.dueEnd + "ua" + this.unassigned + "cd" + this.completed + "ids" + new JoinList("|", this.ids) + "]";
    }

    public boolean evaluate(XTask task) {
        if (task == null) {
            return false;
        }
        if (this.idPatient != null && !this.idPatient.equals(task.getIdPatient())) {
            return false;
        }
        if (this.fromUser != null && !this.fromUser.equals(task.getFromUser())) {
            return false;
        }
        if (this.toUser != null && !this.toUser.equals(task.getToUser())) {
            return false;
        }
        if (this.toGroup != null && !this.toGroup.equals(task.getToGroup())) {
            return false;
        }
        if (this.unassigned != null && (this.unassigned != false ? task.getToGroup() != null || task.getToUser() != null : task.getToGroup() == null && task.getToUser() == null)) {
            return false;
        }
        return this.completed == null || !(this.completed != false ? task.getCompletionDatetime() == null : task.getCompletionDatetime() != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.completed == null ? 0 : this.completed.hashCode());
        result = 31 * result + (this.fromUser == null ? 0 : this.fromUser.hashCode());
        result = 31 * result + (this.idPatient == null ? 0 : this.idPatient.hashCode());
        result = 31 * result + (this.toGroup == null ? 0 : this.toGroup.hashCode());
        result = 31 * result + (this.toUser == null ? 0 : this.toUser.hashCode());
        result = 31 * result + (this.unassigned == null ? 0 : this.unassigned.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XTaskCriteria other = (XTaskCriteria)obj;
        if (this.completed == null ? other.completed != null : !this.completed.equals(other.completed)) {
            return false;
        }
        if (this.fromUser == null ? other.fromUser != null : !this.fromUser.equals(other.fromUser)) {
            return false;
        }
        if (this.idPatient == null ? other.idPatient != null : !this.idPatient.equals(other.idPatient)) {
            return false;
        }
        if (this.toGroup == null ? other.toGroup != null : !this.toGroup.equals(other.toGroup)) {
            return false;
        }
        if (this.toUser == null ? other.toUser != null : !this.toUser.equals(other.toUser)) {
            return false;
        }
        return !(this.unassigned == null ? other.unassigned != null : !this.unassigned.equals(other.unassigned));
    }

    public XTaskCriteria clone() {
        try {
            return (XTaskCriteria)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

