/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.patient;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.util1.JoinList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public final class XConsentement
extends EditableDataObject {
    public static String[] fields = new String[]{"id", "version", "idPatientAnchor", "idUserAnchor", "droits", "datetimeStart", "datetimeEnd"};
    private static final long serialVersionUID = 1L;
    public static final int RIGHT_PATIENT = Integer.parseInt("1", 2);
    public static final int RIGHT_COMMUNICATION = Integer.parseInt("10", 2);
    public static final int RIGHT_ADDRESS = Integer.parseInt("100", 2);
    public static final int RIGHT_PATIENT_OTHER = Integer.parseInt("1000", 2);
    public static final int RIGHT_DOSSIER = Integer.parseInt("10000", 2);
    public static final int RIGHT_LABO = Integer.parseInt("100000", 2);
    public static final int RIGHT_DOCUMENT = Integer.parseInt("1000000", 2);
    public static final int RIGHT_EFORM = Integer.parseInt("10000000", 2);
    public static final int RIGHT_RDVS = Integer.parseInt("100000000", 2);
    public static final int RIGHT_BILLING = Integer.parseInt("1000000000", 2);
    private static final String rightPatient = Messages.getString("RIGHT_PATIENT", new String[0]);
    private static final String rightComm = Messages.getString("RIGHT_COMMUNICATION", new String[0]);
    private static final String rightAddress = Messages.getString("RIGHT_ADDRESS", new String[0]);
    private static final String rightPatientOther = Messages.getString("RIGHT_PATIENT_OTHER", new String[0]);
    private static final String rightDossier = Messages.getString("RIGHT_DOSSIER", new String[0]);
    private static final String rightLabo = Messages.getString("RIGHT_LABO", new String[0]);
    private static final String rightDocument = Messages.getString("RIGHT_DOCUMENT", new String[0]);
    private static final String rightEForm = Messages.getString("RIGHT_EFORM", new String[0]);
    private static final String rightRdvs = Messages.getString("RIGHT_RDVS", new String[0]);
    private static final String rightBilling = Messages.getString("RIGHT_BILLING", new String[0]);
    public static final List<Rights> rights = new ArrayList<Rights>();
    public int id = -1;
    public int idPatientAnchor = -1;
    public int idUserAnchor = -1;
    public long datetimeStart = -1L;
    public long datetimeEnd = -1L;
    public int droits = -1;
    private Boolean isActive = null;

    @Override
    public XConsentement clone() {
        XConsentement c = (XConsentement)super.clone();
        c.id = this.id;
        c.idPatientAnchor = this.idPatientAnchor;
        c.idUserAnchor = this.idUserAnchor;
        c.datetimeStart = this.datetimeStart;
        c.datetimeEnd = this.datetimeEnd;
        c.droits = this.droits;
        c.isActive = this.isActive;
        return c;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XConsentement) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XConsentement" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public final Integer getId() {
        return this.id == -1 ? null : new Integer(this.id);
    }

    @Override
    public final void setId(Integer id) {
        this.id = id == null ? -1 : id;
    }

    public final Integer getIdPatientAnchor() {
        return this.idPatientAnchor == -1 ? null : new Integer(this.idPatientAnchor);
    }

    public final void setIdPatientAnchor(Integer idPatientAnchor) {
        this.idPatientAnchor = idPatientAnchor == null ? -1 : idPatientAnchor;
        this.setUpdated();
    }

    public final Integer getIdUserAnchor() {
        return this.idUserAnchor == -1 ? null : new Integer(this.idUserAnchor);
    }

    public final void setIdUserAnchor(Integer idUserAnchor) {
        this.idUserAnchor = idUserAnchor == null ? -1 : idUserAnchor;
        this.setUpdated();
    }

    public final Long getDatetimeStart() {
        return this.datetimeStart == -1L ? null : new Long(this.datetimeStart);
    }

    public final void setDatetimeStart(Long datetimeStart) {
        this.datetimeStart = datetimeStart == null ? -1L : datetimeStart;
        this.setUpdated();
    }

    public final Long getDatetimeEnd() {
        return this.datetimeEnd == -1L ? null : new Long(this.datetimeEnd);
    }

    public final void setDatetimeEnd(Long datetimeEnd) {
        this.datetimeEnd = datetimeEnd == null ? -1L : datetimeEnd;
        this.setUpdated();
    }

    public final Integer getDroits() {
        return this.droits == -1 ? null : new Integer(this.droits);
    }

    public final void setDroits(Integer droits) {
        this.droits = droits == null ? -1 : droits;
        this.setUpdated();
    }

    public void setId(int id) {
        this.id = id;
        this.setUpdated();
    }

    public void setIdPatientAnchor(int idPatientAnchor) {
        this.idPatientAnchor = idPatientAnchor;
        this.setUpdated();
    }

    public void setIdUserAnchor(int idUserAnchor) {
        this.idUserAnchor = idUserAnchor;
        this.setUpdated();
    }

    public void setDatetimeStart(long datetimeStart) {
        this.datetimeStart = datetimeStart;
        this.setUpdated();
    }

    public void setDatetimeEnd(long datetimeEnd) {
        this.datetimeEnd = datetimeEnd;
        this.setUpdated();
    }

    public void setDroits(int droits) {
        this.droits = droits;
        this.setUpdated();
    }

    public final String getDroitsText() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.hasRightPatient()) {
            l.add(rightPatient);
        }
        if (this.hasRightComm()) {
            l.add(rightComm);
        }
        if (this.hasRightAddres()) {
            l.add(rightAddress);
        }
        if (this.hasRightPatientOther()) {
            l.add(rightPatientOther);
        }
        if (this.hasRightRdvs()) {
            l.add(rightRdvs);
        }
        if (this.hasRightBilling()) {
            l.add(rightBilling);
        }
        if (this.hasRightEForm()) {
            l.add(rightEForm);
        }
        if (this.hasRightDocument()) {
            l.add(rightDocument);
        }
        if (this.hasRightLabo()) {
            l.add(rightLabo);
        }
        if (this.hasRightDossier()) {
            l.add(rightDossier);
        }
        return new JoinList(", ", l).toString();
    }

    public void addRight(int r) {
        this.droits |= r;
        this.setUpdated();
    }

    public void removeRight(int r) {
        this.droits ^= r;
        this.setUpdated();
    }

    public boolean hasRight(int right) {
        return (this.droits & right) == right && this.isActive();
    }

    public boolean hasRightPatient() {
        return (this.droits & RIGHT_PATIENT) == RIGHT_PATIENT && this.isActive();
    }

    public boolean hasRightComm() {
        return (this.droits & RIGHT_COMMUNICATION) == RIGHT_COMMUNICATION && this.isActive();
    }

    public boolean hasRightAddres() {
        return (this.droits & RIGHT_ADDRESS) == RIGHT_ADDRESS && this.isActive();
    }

    public boolean hasRightPatientOther() {
        return (this.droits & RIGHT_PATIENT_OTHER) == RIGHT_PATIENT_OTHER && this.isActive();
    }

    public boolean hasRightDossier() {
        return (this.droits & RIGHT_DOSSIER) == RIGHT_DOSSIER && this.isActive();
    }

    public boolean hasRightLabo() {
        return (this.droits & RIGHT_LABO) == RIGHT_LABO && this.isActive();
    }

    public boolean hasRightDocument() {
        return (this.droits & RIGHT_DOCUMENT) == RIGHT_DOCUMENT && this.isActive();
    }

    public boolean hasRightEForm() {
        return (this.droits & RIGHT_EFORM) == RIGHT_EFORM && this.isActive();
    }

    public boolean hasRightRdvs() {
        return (this.droits & RIGHT_RDVS) == RIGHT_RDVS && this.isActive();
    }

    private boolean hasRightBilling() {
        return (this.droits & RIGHT_BILLING) == RIGHT_BILLING && this.isActive();
    }

    public static void main(String[] s) {
        XConsentement.sayRights("ALL", RIGHT_PATIENT | RIGHT_COMMUNICATION | RIGHT_ADDRESS | RIGHT_PATIENT_OTHER | RIGHT_DOSSIER | RIGHT_LABO | RIGHT_DOCUMENT | RIGHT_EFORM | RIGHT_RDVS);
        XConsentement.sayRights("RIGHT_PATIENT", RIGHT_COMMUNICATION | RIGHT_ADDRESS | RIGHT_PATIENT_OTHER | RIGHT_DOSSIER | RIGHT_LABO | RIGHT_DOCUMENT | RIGHT_EFORM | RIGHT_RDVS);
        XConsentement.sayRights("RIGHT_COMMUNICATION", RIGHT_PATIENT | RIGHT_ADDRESS | RIGHT_PATIENT_OTHER | RIGHT_DOSSIER | RIGHT_LABO | RIGHT_DOCUMENT | RIGHT_EFORM | RIGHT_RDVS);
        XConsentement.sayRights("RIGHT_ADDRESS", RIGHT_PATIENT | RIGHT_COMMUNICATION | RIGHT_PATIENT_OTHER | RIGHT_DOSSIER | RIGHT_LABO | RIGHT_DOCUMENT | RIGHT_EFORM | RIGHT_RDVS);
        XConsentement.sayRights("RIGHT_PATIENT_OTHER", RIGHT_PATIENT | RIGHT_COMMUNICATION | RIGHT_ADDRESS | RIGHT_DOSSIER | RIGHT_LABO | RIGHT_DOCUMENT | RIGHT_EFORM | RIGHT_RDVS);
        XConsentement.sayRights("RIGHT_DOSSIER", RIGHT_PATIENT | RIGHT_COMMUNICATION | RIGHT_ADDRESS | RIGHT_PATIENT_OTHER | RIGHT_LABO | RIGHT_DOCUMENT | RIGHT_EFORM | RIGHT_RDVS);
        XConsentement.sayRights("RIGHT_LABO", RIGHT_PATIENT | RIGHT_COMMUNICATION | RIGHT_ADDRESS | RIGHT_PATIENT_OTHER | RIGHT_DOSSIER | RIGHT_DOCUMENT | RIGHT_EFORM | RIGHT_RDVS);
        XConsentement.sayRights("RIGHT_DOCUMENT", RIGHT_PATIENT | RIGHT_COMMUNICATION | RIGHT_ADDRESS | RIGHT_PATIENT_OTHER | RIGHT_DOSSIER | RIGHT_LABO | RIGHT_EFORM | RIGHT_RDVS);
        XConsentement.sayRights("RIGHT_EFORM", RIGHT_PATIENT | RIGHT_COMMUNICATION | RIGHT_ADDRESS | RIGHT_PATIENT_OTHER | RIGHT_DOSSIER | RIGHT_LABO | RIGHT_DOCUMENT | RIGHT_RDVS);
        XConsentement.sayRights("RIGHT_RDVS", RIGHT_PATIENT | RIGHT_COMMUNICATION | RIGHT_ADDRESS | RIGHT_PATIENT_OTHER | RIGHT_DOSSIER | RIGHT_LABO | RIGHT_DOCUMENT | RIGHT_EFORM);
        XConsentement.sayRights("RIGHT_DOCUMENT & RIGHT_LABO", RIGHT_PATIENT | RIGHT_COMMUNICATION | RIGHT_ADDRESS | RIGHT_PATIENT_OTHER | RIGHT_DOSSIER | RIGHT_EFORM | RIGHT_RDVS);
    }

    public boolean isActive() {
        if (this.isActive == null) {
            long t = Calendar.getInstance().getTimeInMillis();
            this.isActive = this.datetimeStart < t && (this.datetimeEnd == -1L || this.datetimeEnd > t);
        }
        return this.isActive;
    }

    private static void sayRights(String s, int dd) {
        System.out.println(dd + "=Devrait \u00eatre false: " + s);
        System.out.println("RIGHT_PATIENT:" + ((dd & RIGHT_PATIENT) == RIGHT_PATIENT));
        System.out.println("RIGHT_COMMUNICATION:" + ((dd & RIGHT_COMMUNICATION) == RIGHT_COMMUNICATION));
        System.out.println("RIGHT_ADDRESS:" + ((dd & RIGHT_ADDRESS) == RIGHT_ADDRESS));
        System.out.println("RIGHT_PATIENT_OTHER:" + ((dd & RIGHT_PATIENT_OTHER) == RIGHT_PATIENT_OTHER));
        System.out.println("RIGHT_DOSSIER:" + ((dd & RIGHT_DOSSIER) == RIGHT_DOSSIER));
        System.out.println("RIGHT_LABO:" + ((dd & RIGHT_LABO) == RIGHT_LABO));
        System.out.println("RIGHT_DOCUMENT:" + ((dd & RIGHT_DOCUMENT) == RIGHT_DOCUMENT));
        System.out.println("RIGHT_EFORM:" + ((dd & RIGHT_EFORM) == RIGHT_EFORM));
        System.out.println("RIGHT_RDVS:" + ((dd & RIGHT_RDVS) == RIGHT_RDVS));
    }

    static {
        rights.add(new Rights(1, RIGHT_PATIENT, rightPatient));
        rights.add(new Rights(2, RIGHT_COMMUNICATION, rightComm));
        rights.add(new Rights(3, RIGHT_ADDRESS, rightAddress));
        rights.add(new Rights(4, RIGHT_PATIENT_OTHER, rightPatientOther));
        rights.add(new Rights(5, RIGHT_RDVS, rightRdvs));
        rights.add(new Rights(6, RIGHT_BILLING, rightBilling));
        rights.add(new Rights(8, RIGHT_EFORM, rightEForm));
        rights.add(new Rights(12, RIGHT_DOCUMENT, rightDocument));
        rights.add(new Rights(15, RIGHT_LABO, rightLabo));
        rights.add(new Rights(20, RIGHT_DOSSIER, rightDossier));
        Collections.sort(rights);
    }

    public static class Rights
    implements Comparable<Rights> {
        final int order;
        final int right;
        final String texte;

        public Rights(int o, int right, String texte) {
            this.order = o;
            this.right = right;
            this.texte = texte;
        }

        public final int getRight() {
            return this.right;
        }

        public final String getTexte() {
            return this.texte;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Rights) {
                return this.order == ((Rights)o).order;
            }
            return false;
        }

        @Override
        public int compareTo(Rights a1) {
            return this.order > a1.order ? 1 : (this.order < a1.order ? -1 : 0);
        }
    }
}

