/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.patient;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.io.Serializable;
import java.text.ParseException;

public class Age
implements Comparable<Age>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JOURS = Messages.getString("_JOURS", new String[0]);
    private static final String JOUR = Messages.getString("_JOUR", new String[0]);
    private static final String SEMS = Messages.getString("_SEMS", new String[0]);
    private static final String SEM = Messages.getString("_SEM", new String[0]);
    private static final String MOISS = Messages.getString("_MOISS", new String[0]);
    private static final String MOIS = Messages.getString("_MOIS", new String[0]);
    private static final String ANS = Messages.getString("_ANS", new String[0]);
    private static final String AN = Messages.getString("_AN", new String[0]);
    public int years;
    public int months;
    public int days;
    public int totalMonths;
    public int totalWeeks;
    public int totalDays;
    public LocalDate birthDay;

    public static String formatMonthDay(LocalDate birthdate, LocalDate date) {
        StringBuilder s = new StringBuilder();
        int m = date.getMonthDiff(birthdate);
        if (m == 1) {
            s.append(m).append(MOIS);
        } else if (m > 1) {
            s.append(m).append(MOISS);
        }
        if (date.day != birthdate.day) {
            int d = 0;
            if (date.day > birthdate.day) {
                d = date.day - birthdate.day;
            } else if (date.day < birthdate.day) {
                d = date.day + date.plusMonth(-1).getMonthEnd() - birthdate.day;
            }
            s.append(" ").append(d).append(d == 1 || d == -1 ? JOUR : JOURS);
        }
        return s.toString();
    }

    public static String formatYearMonth(LocalDate birthdate, LocalDate date) {
        StringBuilder s = new StringBuilder();
        int m = date.getMonthDiff(birthdate);
        if (m > 12) {
            int y = m / 12;
            s.append(y).append(y == 1 || y == -1 ? AN : ANS);
        }
        if ((m %= 12) == 1) {
            s.append(" ").append(m).append(MOIS);
        } else if (m > 1) {
            s.append(" ").append(m).append(MOISS);
        }
        return s.toString();
    }

    protected static LocalDate parse(String s) {
        try {
            return LocalDateFormat.parseWithFixedFormats((String)s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Age(int years, int months, int days, int totalMonths, int totalDays) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.totalMonths = this.years * 12 + months;
    }

    public Age(LocalDate ddn, LocalDate dc) {
        this.birthDay = ddn;
        this.years = dc.getYearDiff(ddn);
        this.months = dc.month - ddn.month;
        this.days = dc.day - ddn.day;
        this.totalMonths = dc.getMonthDiff(ddn);
        this.totalDays = dc.dayFrom1970 - ddn.dayFrom1970;
        this.totalWeeks = this.totalDays / 7;
    }

    public String formatMonthDay() {
        return this.format(true, false);
    }

    public String formatYearMonth() {
        return this.format(false, true);
    }

    public String format(boolean convertYearToMonth, boolean roundDayToMonth) {
        String s = "";
        int y = this.years;
        int m = this.months;
        int d = this.days;
        if (convertYearToMonth) {
            m += y * 12;
            y = 0;
        }
        if (roundDayToMonth) {
            if (d > 20) {
                ++m;
            }
            if (d < -20) {
                --m;
            }
            d = 0;
        }
        if (y != 0) {
            s = y > 1 || y < -1 ? s + y + ANS : s + y + AN;
        }
        if (m == 1) {
            s = s + " " + m + MOIS;
        } else if (m > 1) {
            s = s + " " + m + MOISS;
        }
        if (d != 0) {
            s = d > 1 || d < -1 ? s + " " + d + JOURS : s + " " + d + JOUR;
        }
        return s;
    }

    public String toStringNice() {
        String s = "";
        s = this.years < 3 ? (this.totalMonths < 3 ? this.totalWeeks + (this.totalWeeks > 1 ? SEMS : SEM) : this.totalMonths + (this.totalMonths > 1 ? MOISS : MOIS)) : this.formatYearMonth();
        return s;
    }

    public String toString() {
        return "Age [" + this.years + "y, " + this.months + "m, " + this.days + "d]";
    }

    @Override
    public int compareTo(Age o2) {
        int i = this.years - o2.years;
        if (i == 0 && (i = this.months - o2.months) == 0) {
            i = this.days - o2.days;
        }
        return i;
    }
}

