/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.medication;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.util.EnumWithValue;

public enum XDrugType implements EnumWithValue<XDrugType>
{
    REGULAR(0){

        public String toString() {
            return Messages.getString("MEDICAMENT_REGULIER", new String[0]);
        }
    }
    ,
    NARCOTIC(1){

        public String toString() {
            return Messages.getString("NARCOTIQUE", new String[0]);
        }
    }
    ,
    CONTROLED(2){

        public String toString() {
            return Messages.getString("MEDICAMENT_CONTROLE", new String[0]);
        }
    }
    ,
    FOURNITURE(3){

        public String toString() {
            return Messages.getString("FOURNITURE", new String[0]);
        }
    };

    public final int value;

    private XDrugType(int v) {
        this.value = v;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static XDrugType from(String name) {
        if (name != null) {
            for (XDrugType e : XDrugType.values()) {
                if (!e.name().equals(name)) continue;
                return e;
            }
        }
        return null;
    }

    public static XDrugType from(Integer value) {
        if (value != null) {
            for (XDrugType e : XDrugType.values()) {
                if (e.value != value) continue;
                return e;
            }
        }
        return REGULAR;
    }

    @Override
    public XDrugType fromValue(Integer id) {
        return XDrugType.from(id);
    }
}

