/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.interfaces;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.AbstractGenericCollectionDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.Listenable;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListenableSet<E>
extends AbstractGenericCollectionDecorator<E>
implements Set<E>,
Serializable,
Listenable,
Cloneable {
    private static final Logger logger = Logger.getLogger(MyChildrenListener.class.getName());
    private static final long serialVersionUID = 1L;
    private final IObjectListener<Object> childrenListener = new MyChildrenListener();
    private final boolean listenToChildren;
    private boolean isListenerEnabled;

    public static <T> Set<T> decorate(Set<T> set, boolean listenToChildren) {
        return new ListenableSet<T>(set, listenToChildren);
    }

    protected ListenableSet(Set<E> set, boolean listenToChildren) {
        super(set);
        this.listenToChildren = listenToChildren;
        this.setListenerEnabled(true);
    }

    public ListenableSet(boolean listenToChildren) {
        this(new HashSet(), listenToChildren);
    }

    private void deregisterChild(Object child) {
        if (this.listenToChildren && child instanceof Listenable) {
            ObjectListenerManager.removeListener(child, this.childrenListener);
            ((Listenable)child).setListenerEnabled(false);
        }
    }

    private void deregisterChildren(Collection<?> children) {
        if (this.listenToChildren) {
            for (Object e : children) {
                this.deregisterChild(e);
            }
        }
    }

    private void meModified() {
        if (this.isListenerEnabled) {
            ObjectListenerManager.fireObjectModified(this);
        }
    }

    private void registerChild(Object child) {
        if (this.listenToChildren && child instanceof Listenable) {
            ObjectListenerManager.addListener(child, this.childrenListener);
            ((Listenable)child).setListenerEnabled(true);
        }
    }

    private void registerChildren(Collection<?> children) {
        if (this.listenToChildren) {
            for (Object e : children) {
                this.registerChild(e);
            }
        }
    }

    @Override
    public boolean add(E e) {
        boolean add = super.add(e);
        if (add) {
            this.registerChild(e);
            this.meModified();
        }
        return add;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean addAll = super.addAll(c);
        if (addAll) {
            this.registerChildren(c);
            this.meModified();
        }
        return addAll;
    }

    @Override
    public void clear() {
        this.deregisterChildren(this);
        super.clear();
        this.meModified();
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = super.remove(o);
        if (remove) {
            this.deregisterChild(o);
            this.meModified();
        }
        return remove;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removeAll = super.removeAll(c);
        if (removeAll) {
            this.deregisterChildren(c);
            this.meModified();
        }
        return removeAll;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retainAll;
        ArrayList copy = null;
        if (this.listenToChildren) {
            copy = new ArrayList(this);
        }
        if (retainAll = super.retainAll(c)) {
            this.deregisterChildren(copy);
            this.registerChildren(c);
            this.meModified();
        }
        return retainAll;
    }

    @Override
    public boolean isListenerEnabled() {
        return this.isListenerEnabled;
    }

    @Override
    public void setListenerEnabled(boolean enable) {
        if (this.isListenerEnabled != enable) {
            this.isListenerEnabled = enable;
            if (this.listenToChildren) {
                this.registerChildren(super.getCollection());
            } else {
                this.deregisterChildren(super.getCollection());
            }
        }
    }

    public ListenableSet<E> clone() {
        try {
            ListenableSet c = (ListenableSet)super.clone();
            if (this.collection instanceof Cloneable) {
                Cloneable value = (Cloneable)((Object)this.collection);
                try {
                    Method m_clone = value.getClass().getMethod("clone", new Class[0]);
                    m_clone.setAccessible(true);
                    c.collection = (Collection)((Object)((Cloneable)m_clone.invoke((Object)value, new Object[0])));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                logger.log(Level.SEVERE, "ListenableList underlying list is not clonable. will use new ArrayList.");
                c.collection = new HashSet(this.collection);
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ListenableIterator(super.iterator());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.collection);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.collection = (Collection)in.readObject();
    }

    private class ListenableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> original;

        private ListenableIterator(Iterator<T> iterator) {
            this.original = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public T next() {
            return this.original.next();
        }

        @Override
        public void remove() {
            try {
                this.original.remove();
                ListenableSet.this.meModified();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class MyChildrenListener
    implements IObjectListener<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MyChildrenListener() {
        }

        @Override
        public void objectModified(Object object) {
            ListenableSet.this.meModified();
        }
    }
}

