/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.interfaces;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EmptyList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatusManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EditableDataObjectList<E extends IMinimalEditableDataObject>
implements Serializable,
Cloneable,
IEditableDataObjectList<E> {
    private static final Logger logger = Logger.getLogger(EditableDataObjectList.class.getName());
    private static final long serialVersionUID = 1L;
    public static final IEditableDataObjectList EMPTY_LIST = new EmptyList();
    protected List<E> list;

    public static final <T extends IMinimalEditableDataObject> IEditableDataObjectList<T> emptyList() {
        return EMPTY_LIST;
    }

    public EditableDataObjectList() {
        this.list = new ArrayList();
    }

    public EditableDataObjectList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public EditableDataObjectList(Collection<E> c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        this.list = new ArrayList(c.size());
        this.addAll(c);
    }

    private void checkForDuplicate(E e) {
        if (e != null && this.list.contains(e)) {
            logger.log(Level.FINE, "Devrait Pas tre ajout deux fois ! Object : " + e);
        }
    }

    @Override
    public boolean add(E e) {
        this.checkForDuplicate(e);
        return this.list.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.checkForDuplicate(element);
        this.list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (IMinimalEditableDataObject e : c) {
            this.checkForDuplicate(e);
        }
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (IMinimalEditableDataObject e : c) {
            this.checkForDuplicate(e);
        }
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public EditableDataObjectList<E> deepClone() {
        EditableDataObjectList<E> clone = new EditableDataObjectList<E>(this.list.size());
        for (IMinimalEditableDataObject e : this.list) {
            if (e != null) {
                clone.list.add((IMinimalEditableDataObject)e.clone());
                continue;
            }
            clone.list.add(e);
        }
        return clone;
    }

    @Override
    public EditableDataObjectList<E> deepCloneSetIdNull() {
        EditableDataObjectList<E> clone = new EditableDataObjectList<E>(this.list.size());
        for (IMinimalEditableDataObject e : this.list) {
            if (e != null) {
                clone.list.add((IMinimalEditableDataObject)e.cloneSetIdNull());
                continue;
            }
            clone.list.add(e);
        }
        return clone;
    }

    @Override
    public EditableDataObjectList<E> clone() {
        return this.deepClone();
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public E get(int index) {
        return (E)((IMinimalEditableDataObject)this.list.get(index));
    }

    @Override
    public List<E> getObject_NOT_WithStatus(EnumSet<ModificationStatus> statusSet) {
        ArrayList<IMinimalEditableDataObject> result = new ArrayList<IMinimalEditableDataObject>();
        for (IMinimalEditableDataObject e : this.list) {
            if (e == null || statusSet.contains(e.getModificationStatus())) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public List<E> getObject_NOT_WithStatus(ModificationStatus status) {
        ArrayList<IMinimalEditableDataObject> result = new ArrayList<IMinimalEditableDataObject>();
        for (IMinimalEditableDataObject e : this.list) {
            if (e == null || e.getModificationStatus() == status) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public List<E> getObject_WithStatus(EnumSet<ModificationStatus> statusSet) {
        ArrayList<IMinimalEditableDataObject> result = new ArrayList<IMinimalEditableDataObject>();
        for (IMinimalEditableDataObject e : this.list) {
            if (e == null || !statusSet.contains(e.getModificationStatus())) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public List<E> getObject_WithStatus(ModificationStatus status) {
        ArrayList<IMinimalEditableDataObject> result = new ArrayList<IMinimalEditableDataObject>();
        for (IMinimalEditableDataObject e : this.list) {
            if (e == null || e.getModificationStatus() != status) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isDirty() {
        boolean isDirty = false;
        for (IMinimalEditableDataObject object : this.list) {
            if (object == null || !object.isDirty()) continue;
            isDirty = true;
            break;
        }
        return isDirty;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public IStatus preValid() {
        MultiStatus status = new MultiStatus();
        for (IMinimalEditableDataObject e : this.getNotDeleted()) {
            status.add(e.valid());
        }
        return status;
    }

    @Override
    public IStatus preValidQuestion() {
        MultiStatus status = new MultiStatus();
        for (IMinimalEditableDataObject e : this.getNotDeleted()) {
            status.add(e.validQuestion());
        }
        return status;
    }

    public List<E> getList() {
        return this.list;
    }

    public void setList(List<E> list) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        this.list = list;
    }

    @Override
    public E remove(int index) {
        return (E)((IMinimalEditableDataObject)this.list.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return (E)((IMinimalEditableDataObject)this.list.set(index, element));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public List<E> getNotDeleted() {
        return this.getObject_NOT_WithStatus(ModificationStatusManager.deleted);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.list);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.list = (List)in.readObject();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean containsAllByTag(Collection<E> c) {
        if (this.containsAll(c)) {
            return true;
        }
        Iterator<E> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.containsByTag((IMinimalEditableDataObject)iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsByTag(E o) {
        if (this.contains(o)) {
            return true;
        }
        return this.indexOfByTag(o) >= 0;
    }

    @Override
    public int indexOfByTag(E o) {
        int index = this.indexOf(o);
        if (index != -1) {
            return index;
        }
        int size = this.list.size();
        if (o == null) {
            for (int i = 0; i < size; ++i) {
                if (this.list.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!o.equalsByTag((IMinimalEditableDataObject)this.list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean removeByTag(E o) {
        int index = this.indexOfByTag(o);
        if (index != -1) {
            this.remove(index);
        }
        return index != -1;
    }
}

