/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter;

import ca.infodata.ofys.data.middle.dataobjects.consultation.XConsultationRequest;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CSummary;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergy;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergyType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBloodPressure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBodyTemperature;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCustomMeasure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnostic;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnosticEnc;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocuments;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterBilling;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterNote;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterRaison;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterToBeCompleted;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterToBeRevised;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XFrequency;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XImmunization;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XIntervention;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabit;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XMeasurement;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPhysicalExamination;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPrevent;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XRappel;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class XEncounterModificationRequest
implements IMinimalEditableDataObject {
    private static final long serialVersionUID = 1L;
    private XEncounter encounter;
    public XEncounterNote socialHistoryObj;
    public XEncounterNote familyHistoryObj;
    public XEncounterNote medicalHistoryObj;
    public XEncounterNote ongoingConcernsObj;
    public XEncounterNote otherMedicationsObj;
    private List<XEncounterBilling> billings = new ArrayList<XEncounterBilling>();
    private List<XEncounterNote> notes = new ArrayList<XEncounterNote>();
    private List<XEncounterRaison> raisons = new ArrayList<XEncounterRaison>();
    public XEncounterToBeCompleted encounterToBeCompleted;
    public XEncounterToBeRevised encounterToBeRevised;
    private List<XLifeHabit> lifeHabits;
    private List<XDocuments> documents = new ArrayList<XDocuments>();
    private List<XPrevent> prevents;
    private List<XRappel> rappels;
    private List<XImmunization> immunizations;
    private List<XAllergy> allergies;
    private List<XConsultationRequest> consultations;
    private List<XPhysicalExamination> physicalExaminations = new ArrayList<XPhysicalExamination>();
    private List<XMeasurement> measurements = new ArrayList<XMeasurement>();
    private List<XFrequency> frequencies = new ArrayList<XFrequency>();
    private List<XBodyTemperature> bodyTemperatures = new ArrayList<XBodyTemperature>();
    private List<XBloodPressure> bloodPressures = new ArrayList<XBloodPressure>();
    private List<XPrescription> prescriptions = new ArrayList<XPrescription>();
    private List<XDiagnosticEnc> diagnosticEncs;
    private List<XDiagnostic> diagnostics;
    private List<XIntervention> interventions;
    private List<XCustomMeasure> customMeasures = new ArrayList<XCustomMeasure>();
    private IPatient patient;
    private Integer idPatient;

    public XEncounterModificationRequest(CSummary sum, XEncounterType type) {
        this();
        this.encounter = new XEncounter();
        this.encounter.setEncounterType(type);
        this.encounter.setProfessionnal(sum.getIdProfAnchor());
        this.encounter.idPatient = sum.getIdPatientAnchor();
        this.encounter.setSite(sum.getIdSite());
        this.encounter.setNew();
        this.idPatient = sum.getIdPatientAnchor();
        if (sum.getLstAllergy() != null) {
            for (CEncounter.Allergies allergies : sum.getLstAllergy()) {
                if (!allergies.isDirty()) continue;
                allergies.setDataType(XAllergyType.ALLERGY.value);
                XAllergy allergy = allergies.convertx();
                this.getAllergies().add(allergy);
            }
        }
        if (sum.getLstIntolerance() != null) {
            for (CEncounter.Intolerances intolerances : sum.getLstIntolerance()) {
                if (!intolerances.isDirty()) continue;
                intolerances.setDataType(XAllergyType.INTOLERANCE.value);
                XAllergy intolerance = intolerances.convertx();
                this.getAllergies().add(intolerance);
            }
        }
        if (sum.getLstRappel() != null) {
            for (CEncounter.Rappels rappels : sum.getLstRappel()) {
                if (!rappels.isDirty()) continue;
                this.getRappels().add(rappels.convertx());
            }
        }
        ArrayList<CEncounter.Immunizations> lstDirtyImmun = new ArrayList<CEncounter.Immunizations>();
        if (sum.getLstImmunization() != null) {
            for (CEncounter.Immunizations c : sum.getLstImmunization()) {
                if (!c.isDirty()) continue;
                lstDirtyImmun.add(c);
            }
        }
        if (sum.getLstAllImmunization() != null) {
            for (CEncounter.Immunizations c : sum.getLstAllImmunization()) {
                if (c.isDirty()) {
                    this.getImmunizations().add(c.convertx());
                    continue;
                }
                for (CEncounter.Immunizations immunizations : lstDirtyImmun) {
                    if (!immunizations.equals(c)) continue;
                    XImmunization xImmunization = immunizations.convertx();
                    c.tag = immunizations.tag;
                    c.modificationStatus = immunizations.modificationStatus;
                    this.getImmunizations().add(xImmunization);
                }
            }
            for (CEncounter.Immunizations ii : lstDirtyImmun) {
                if (ii.getId() != null) continue;
                XImmunization xImmunization = ii.convertx();
                this.getImmunizations().add(xImmunization);
                sum.addToLstAll(ii);
            }
        }
        ArrayList<CEncounter.Prescription> arrayList = new ArrayList<CEncounter.Prescription>();
        if (sum.getLstPrescription() != null) {
            for (CEncounter.Prescription prescription : sum.getLstPrescription()) {
                if (!prescription.isDirty()) continue;
                arrayList.add(prescription);
            }
        }
        if (sum.getLstAllPrescription() != null || XEncounterType.IMP_RX.equals(type)) {
            if (sum.getLstAllPrescription() != null) {
                for (CEncounter.Prescription prescription : sum.getLstAllPrescription()) {
                    if (prescription.isDirty()) {
                        this.getPrescriptions().add(prescription.convertx());
                        continue;
                    }
                    for (CEncounter.Prescription ii : arrayList) {
                        if (!ii.equals(prescription)) continue;
                        XPrescription x = ii.convertx();
                        prescription.tag = ii.tag;
                        prescription.modificationStatus = ii.modificationStatus;
                        this.getPrescriptions().add(x);
                    }
                }
            }
            for (CEncounter.Prescription prescription : arrayList) {
                if (prescription.getId() != null) continue;
                XPrescription xPrescription = prescription.convertx();
                this.getPrescriptions().add(xPrescription);
                sum.addToLstAll(prescription);
            }
        }
        if (sum.getLstDevice() != null) {
            for (CEncounter.Device device : sum.getLstDevice()) {
                if (!device.isDirty()) continue;
                this.getPrescriptions().add(device.convertx());
            }
        }
        if (sum.getLstIntervention() != null) {
            for (CEncounter.Interventions interventions : sum.getLstIntervention()) {
                if (!interventions.isDirty()) continue;
                this.getInterventions().add(interventions.convertx());
            }
        }
        if (sum.getLstLifeHabit() != null) {
            for (CEncounter.LifeHabits lifeHabits : sum.getLstLifeHabit()) {
                if (!lifeHabits.isDirty()) continue;
                this.getLifeHabits().add(lifeHabits.convertx());
            }
        }
        if (sum.getLstPrevent() != null) {
            for (CEncounter.Prevents prevents : sum.getLstPrevent()) {
                if (!prevents.isDirty()) continue;
                this.getPrevents().add(prevents.convertx());
            }
        }
        if (sum.getLstDx() != null) {
            for (CEncounter.Dx dx : sum.getLstDx()) {
                if (!dx.isDirty()) continue;
                this.getDiagnostics().add(dx.convertx());
            }
        }
        if (sum.getLstProb() != null) {
            for (CEncounter.Prob prob : sum.getLstProb()) {
                if (!prob.isDirty()) continue;
                this.getDiagnostics().add(prob.convertx());
            }
        }
        if (sum.familyHistoryObj != null && sum.familyHistoryObj.isDirty()) {
            this.familyHistoryObj = sum.familyHistoryObj.convertx();
            this.familyHistoryObj.setEntryDatetime(DateUtil.now());
        }
        if (sum.medicalHistoryObj != null && sum.medicalHistoryObj.isDirty()) {
            this.medicalHistoryObj = sum.medicalHistoryObj.convertx();
            this.medicalHistoryObj.setEntryDatetime(DateUtil.now());
        }
        if (sum.ongoingConcernsObj != null && sum.ongoingConcernsObj.isDirty()) {
            this.ongoingConcernsObj = sum.ongoingConcernsObj.convertx();
            this.ongoingConcernsObj.setEntryDatetime(DateUtil.now());
        }
        if (sum.otherMedicationsObj != null && sum.otherMedicationsObj.isDirty()) {
            this.otherMedicationsObj = sum.otherMedicationsObj.convertx();
            this.otherMedicationsObj.setEntryDatetime(DateUtil.now());
        }
        if (sum.socialHistoryObj != null && sum.socialHistoryObj.isDirty()) {
            this.socialHistoryObj = sum.socialHistoryObj.convertx();
            this.socialHistoryObj.setEntryDatetime(DateUtil.now());
        }
    }

    public XEncounterModificationRequest(CEncounter enc) {
        this();
        this.encounter = enc.convertx();
        this.idPatient = enc.getIdPatientAnchor();
        if (enc.getLstBilling() != null) {
            for (CEncounter.EncounterBilling encounterBilling : enc.getLstBilling()) {
                if (!encounterBilling.isDirty()) continue;
                this.getBillings().add(encounterBilling.convertx());
            }
        }
        if (enc.getLstNote() != null) {
            for (CEncounter.EncounterNote encounterNote : enc.getLstNote()) {
                if (!encounterNote.isDirty()) continue;
                this.getNotes().add(encounterNote.convertx());
            }
        }
        if (enc.getLstRaison() != null) {
            for (CEncounter.EncounterRaison encounterRaison : enc.getLstRaison()) {
                if (!encounterRaison.isDirty()) continue;
                this.getRaisons().add(encounterRaison.convertx());
            }
        }
        if (enc.getTbcObj() != null) {
            this.encounterToBeCompleted = enc.getTbcObj().convertx();
        }
        if (enc.getTbrObj() != null) {
            this.encounterToBeRevised = enc.getTbrObj().convertx();
        }
        if (enc.getLstDoc() != null) {
            for (CEncounter.Docs docs : enc.getLstDoc()) {
                if (!docs.isDirty()) continue;
                this.getDocuments().add(docs.convertx());
            }
        }
        if (enc.getLstPhysicalExam() != null) {
            for (CEncounter.PhysicalExam physicalExam : enc.getLstPhysicalExam()) {
                if (!physicalExam.isDirty()) continue;
                this.getPhysicalExaminations().add(physicalExam.convertx());
            }
        }
        if (enc.getLstMeasurement() != null) {
            for (CEncounter.Measurement measurement : enc.getLstMeasurement()) {
                if (!measurement.isDirty()) continue;
                this.getMeasurements().add(measurement.convertx());
            }
        }
        if (enc.getLstFreq() != null) {
            for (CEncounter.Freq freq : enc.getLstFreq()) {
                if (!freq.isDirty()) continue;
                this.getFrequencies().add(freq.convertx());
            }
        }
        if (enc.getLstBodyTemp() != null) {
            for (CEncounter.BodyTemp bodyTemp : enc.getLstBodyTemp()) {
                if (!bodyTemp.isDirty()) continue;
                this.getBodyTemperatures().add(bodyTemp.convertx());
            }
        }
        if (enc.getLstBloodPres() != null) {
            for (CEncounter.BloodPres bloodPres : enc.getLstBloodPres()) {
                if (!bloodPres.isDirty()) continue;
                this.getBloodPressures().add(bloodPres.convertx());
            }
        }
        if (enc.getLstCustMeasure() != null) {
            for (CEncounter.CustMeasure custMeasure : enc.getLstCustMeasure()) {
                if (!custMeasure.isDirty()) continue;
                this.getCustomMeasures().add(custMeasure.convertx());
            }
        }
        if (enc.getLstDxEnc() != null) {
            for (CEncounter.DxEnc dxEnc : enc.getLstDxEnc()) {
                if (!dxEnc.isDirty()) continue;
                this.getDiagnosticEncs().add(dxEnc.convertx());
            }
        }
        if (enc.getLstDx() != null) {
            for (CEncounter.Dx dx : enc.getLstDx()) {
                if (!dx.isDirty()) continue;
                this.getDiagnostics().add(dx.convertx());
            }
        }
        if (enc.getLstProb() != null) {
            for (CEncounter.Prob prob : enc.getLstProb()) {
                if (!prob.isDirty()) continue;
                this.getDiagnostics().add(prob.convertx());
            }
        }
        if (enc.getLstPrescription() != null) {
            for (CEncounter.Prescription prescription : enc.getLstPrescription()) {
                if (!prescription.isDirty()) continue;
                this.getPrescriptions().add(prescription.convertx());
            }
        }
        if (enc.getLstDevice() != null) {
            for (CEncounter.Device device : enc.getLstDevice()) {
                if (!device.isDirty()) continue;
                this.getPrescriptions().add(device.convertx());
            }
        }
        if (enc.getLstImmunization() != null) {
            for (CEncounter.Immunizations immunizations : enc.getLstImmunization()) {
                if (!immunizations.isDirty()) continue;
                this.getImmunizations().add(immunizations.convertx());
            }
        }
    }

    public XEncounterModificationRequest() {
        this.consultations = new ArrayList<XConsultationRequest>();
        this.allergies = new ArrayList<XAllergy>();
        this.lifeHabits = new ArrayList<XLifeHabit>();
        this.prevents = new ArrayList<XPrevent>();
        this.rappels = new ArrayList<XRappel>();
        this.immunizations = new ArrayList<XImmunization>();
        this.diagnosticEncs = new ArrayList<XDiagnosticEnc>();
        this.diagnostics = new ArrayList<XDiagnostic>();
        this.interventions = new ArrayList<XIntervention>();
    }

    public List<XDiagnosticEnc> getDiagnosticEncs() {
        return this.diagnosticEncs;
    }

    public List<XDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public List<XIntervention> getInterventions() {
        return this.interventions;
    }

    public XEncounter getEncounter() {
        return this.encounter;
    }

    public void setEncounter(XEncounter encounter) {
        this.encounter = encounter;
    }

    public List<XEncounterBilling> getBillings() {
        return this.billings;
    }

    public void setBillings(List<XEncounterBilling> billings) {
        this.billings = billings;
    }

    public List<XEncounterNote> getNotes() {
        return this.notes;
    }

    public List<XEncounterRaison> getRaisons() {
        return this.raisons;
    }

    public XEncounterToBeCompleted getEncounterToBeCompleted() {
        return this.encounterToBeCompleted;
    }

    public XEncounterToBeRevised getEncounterToBeRevised() {
        return this.encounterToBeRevised;
    }

    @Override
    public boolean isDirty() {
        boolean dirty = this.encounter == null ? false : this.encounter.isDirty();
        dirty = dirty || XEncounterModificationRequest.isDirty(this.notes);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.raisons);
        dirty = dirty || this.encounterToBeCompleted.isDirty();
        dirty = dirty || this.encounterToBeRevised.isDirty();
        dirty = dirty || XEncounterModificationRequest.isDirty(this.lifeHabits);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.prevents);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.documents);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.rappels);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.immunizations);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.allergies);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.consultations);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.physicalExaminations);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.measurements);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.frequencies);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.bodyTemperatures);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.bloodPressures);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.prescriptions);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.diagnostics);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.interventions);
        dirty = dirty || XEncounterModificationRequest.isDirty(this.customMeasures);
        return dirty;
    }

    private static boolean isDirty(Collection<? extends IMinimalEditableDataObject> c) {
        boolean dirty = false;
        Iterator<? extends IMinimalEditableDataObject> iterator = c.iterator();
        while (!dirty && iterator.hasNext()) {
            dirty = iterator.next().isDirty();
        }
        return true;
    }

    public List<XLifeHabit> getLifeHabits() {
        return this.lifeHabits;
    }

    public List<XPrevent> getPrevents() {
        return this.prevents;
    }

    public List<XRappel> getRappels() {
        return this.rappels;
    }

    public List<XDocuments> getDocuments() {
        return this.documents;
    }

    public List<XImmunization> getImmunizations() {
        return this.immunizations;
    }

    public List<XAllergy> getAllergies() {
        return this.allergies;
    }

    public List<XConsultationRequest> getConsultations() {
        return this.consultations;
    }

    @Override
    @Deprecated
    public Integer getId() {
        return null;
    }

    @Override
    @Deprecated
    public void setId(Integer id) {
    }

    @Override
    @Deprecated
    public void initialize() {
    }

    @Override
    public XEncounterModificationRequest clone() {
        try {
            XEncounterModificationRequest c = (XEncounterModificationRequest)super.clone();
            c.notes = MiscUtil.deepClone(this.notes);
            c.raisons = MiscUtil.deepClone(this.raisons);
            c.encounterToBeCompleted = this.encounterToBeCompleted.clone();
            c.encounterToBeRevised = this.encounterToBeRevised.clone();
            c.allergies = MiscUtil.deepClone(this.allergies);
            c.lifeHabits = MiscUtil.deepClone(this.lifeHabits);
            c.prevents = MiscUtil.deepClone(this.prevents);
            c.documents = MiscUtil.deepClone(this.documents);
            c.rappels = MiscUtil.deepClone(this.rappels);
            c.immunizations = MiscUtil.deepClone(this.immunizations);
            c.consultations = MiscUtil.deepClone(this.consultations);
            c.physicalExaminations = MiscUtil.deepClone(this.physicalExaminations);
            c.measurements = MiscUtil.deepClone(this.measurements);
            c.frequencies = MiscUtil.deepClone(this.frequencies);
            c.bodyTemperatures = MiscUtil.deepClone(this.bodyTemperatures);
            c.bloodPressures = MiscUtil.deepClone(this.bloodPressures);
            c.prescriptions = MiscUtil.deepClone(this.prescriptions);
            c.diagnostics = MiscUtil.deepClone(this.diagnostics);
            c.interventions = MiscUtil.deepClone(this.interventions);
            c.customMeasures = MiscUtil.deepClone(this.customMeasures);
            c.patient = this.patient == null ? null : this.patient.clone();
            c.encounter = this.encounter == null ? null : this.encounter.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public void setModificationStatus(ModificationStatus newStatus) {
    }

    @Override
    public ModificationStatus getModificationStatus() {
        return null;
    }

    @Override
    public IStatus valid() {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validQuestion() {
        return Status.OK_STATUS;
    }

    @Override
    public Integer getTag() {
        return null;
    }

    @Override
    public void setTag() {
    }

    @Override
    public void setTag(Integer tag) {
    }

    @Override
    public boolean equalsByTag(IMinimalEditableDataObject other) {
        return false;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
    }

    public Integer getIdPatient() {
        return this.idPatient;
    }

    public void setIdPatient(Integer patient) {
        this.idPatient = patient;
    }

    public List<XPhysicalExamination> getPhysicalExaminations() {
        return this.physicalExaminations;
    }

    public List<XMeasurement> getMeasurements() {
        return this.measurements;
    }

    public List<XFrequency> getFrequencies() {
        return this.frequencies;
    }

    public List<XBodyTemperature> getBodyTemperatures() {
        return this.bodyTemperatures;
    }

    public List<XBloodPressure> getBloodPressures() {
        return this.bloodPressures;
    }

    public List<XPrescription> getPrescriptions() {
        return this.prescriptions;
    }

    @Override
    public String toString() {
        return String.format("XEncounterModificationRequest [encounter=%s, encounterNotes=%s, encounterRaisons=%s, encounterToBeCompleted=%s, encounterToBeRevised=%s, lifeHabits=%s, prevents=%s, documents=%s, rappels=%s, immunizations=%s, allergies=%s, consultations=%s, physicalExaminations=%s, measurements=%s, frequencies=%s, bodyTemperatures=%s, bloodPressures=%s, prescriptions=%s, diagnostics=%s, interventions=%s, patient=%s]", this.encounter, this.notes, this.raisons, this.encounterToBeCompleted, this.encounterToBeRevised, this.lifeHabits, this.prevents, this.documents, this.rappels, this.immunizations, this.allergies, this.consultations, this.physicalExaminations, this.measurements, this.frequencies, this.bodyTemperatures, this.bloodPressures, this.prescriptions, this.diagnostics, this.interventions, this.patient);
    }

    public List<XCustomMeasure> getCustomMeasures() {
        return this.customMeasures;
    }

    @Override
    public Object cloneSetIdNull() {
        XEncounterModificationRequest c = this.clone();
        c.setId(null);
        return c;
    }
}

