/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.b2b;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.util.EnumWithValue;

public enum XDisabilityCode implements EnumWithValue<XDisabilityCode>
{
    C00(1, "0"),
    C01(2, "1"),
    C02(3, "2"),
    C03(4, "3"),
    C04(5, "4"),
    C05(7, "5"),
    C06(6, "6"),
    C07(8, "7"),
    C08(9, "8"),
    C09(12, "9"),
    C10(13, "10"),
    C11(14, "11"),
    C12(15, "12"),
    C13(16, "13"),
    C14(17, "14"),
    C15(19, "15"),
    C16(20, "16"),
    C17(21, "17"),
    C18(22, "18"),
    C19(23, "19"),
    C20(24, "20");

    public final int id;
    public final String code;

    private XDisabilityCode(int id, String code) {
        this.id = id;
        this.code = code;
    }

    public static XDisabilityCode from(Integer s) {
        if (s != null) {
            for (XDisabilityCode x : XDisabilityCode.values()) {
                if (x.id != s) continue;
                return x;
            }
        }
        return null;
    }

    public String getCode2chifres() {
        return this.getCode();
    }

    public static XDisabilityCode fromCode(String code) {
        if (code == null) {
            return null;
        }
        if (code.length() == 1) {
            code = "0" + code;
        }
        for (XDisabilityCode d : XDisabilityCode.values()) {
            String code2;
            String string = code2 = d.code.length() == 1 ? "0" + d.code : d.code;
            if (!code2.equals(code)) continue;
            return d;
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return Messages.getString("B2B.XDisabilityCode." + this.code + ".descLongue", new String[0]);
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public int getValue() {
        return this.id;
    }

    public static void main(String[] args) {
        for (XDisabilityCode d : XDisabilityCode.values()) {
            System.out.println(d.code + " " + d.getDescription());
        }
    }

    @Override
    public XDisabilityCode fromValue(Integer id) {
        return XDisabilityCode.from(id);
    }
}

