/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.util1.Pair;
import java.util.EnumSet;

public enum XUserRole implements EnumWithValue<XUserRole>
{
    INFODATA(1){

        public String toString() {
            return Messages.getString("INFODATA", new String[0]);
        }
    }
    ,
    ADMIN(2){

        public String toString() {
            return Messages.getString("ADMINISTRATEUR", new String[0]);
        }
    }
    ,
    SECRETARY(4){

        public String toString() {
            return Messages.getString("SECRETAIRE", new String[0]);
        }
    }
    ,
    HEALTHCARE_PROVIDER(8){

        public String toString() {
            return Messages.getString("CLINICIEN", new String[0]);
        }
    }
    ,
    MEDICAL_SECRETARY(16){

        public String toString() {
            return Messages.getString("SECRETAIRE_MEDICAL", new String[0]);
        }
    }
    ,
    CRISIS(32){

        public String toString() {
            return Messages.getString("CRISE", new String[0]);
        }
    }
    ,
    STAGIAIRE(64){

        public String toString() {
            return Messages.getString("STAGIAIRE", new String[0]);
        }
    }
    ,
    USER_MANAGEMENT(128){

        public String toString() {
            return Messages.getString("GESTION_DES_UTILISATEURS", new String[0]);
        }
    }
    ,
    BILLING(256){

        public String toString() {
            return Messages.getString("FACTURATION", new String[0]);
        }
    }
    ,
    SOFY(512){

        public String toString() {
            return Messages.getString("SOFY", new String[0]);
        }
    }
    ,
    ANONYMOUS(1024){

        public String toString() {
            return Messages.getString("ANONYMOUS", new String[0]);
        }
    }
    ,
    IMPORT(2048){

        public String toString() {
            return Messages.getString("IMPORT", new String[0]);
        }
    }
    ,
    HUB(4096){

        public String toString() {
            return Messages.getString("HUB", new String[0]);
        }
    }
    ,
    MIRTH(8192){

        public String toString() {
            return "MIRTH";
        }
    };

    public final int value;

    private XUserRole(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static XUserRole getMaxXUserRoleValueFromEnumSet(EnumSet<XUserRole> roles) {
        if (roles.contains(USER_MANAGEMENT)) {
            return USER_MANAGEMENT;
        }
        if (roles.contains(ADMIN)) {
            return ADMIN;
        }
        if (roles.contains(HEALTHCARE_PROVIDER)) {
            return HEALTHCARE_PROVIDER;
        }
        if (roles.contains(STAGIAIRE)) {
            return STAGIAIRE;
        }
        if (roles.contains(SECRETARY)) {
            return SECRETARY;
        }
        if (roles.contains(MEDICAL_SECRETARY)) {
            return MEDICAL_SECRETARY;
        }
        if (roles.contains(INFODATA)) {
            return INFODATA;
        }
        if (roles.contains(SOFY)) {
            return SOFY;
        }
        return null;
    }

    public static XUserRole ensureComplementaryRole(XUserRole role) {
        if (role == SECRETARY) {
            return MEDICAL_SECRETARY;
        }
        if (role == MEDICAL_SECRETARY) {
            return SECRETARY;
        }
        return role;
    }

    public static Pair<EnumSet<XUserRole>, EnumSet<XUserRole>> getRoleByRightsForRoles(EnumSet<XUserRole> roles, boolean maxed) {
        Pair pair = new Pair(EnumSet.noneOf(XUserRole.class), EnumSet.noneOf(XUserRole.class));
        if (roles.contains(INFODATA)) {
            ((EnumSet)pair.first).add(INFODATA);
        } else if (roles.contains(HEALTHCARE_PROVIDER) || roles.contains(STAGIAIRE)) {
            ((EnumSet)pair.first).add(HEALTHCARE_PROVIDER);
            if (!maxed) {
                ((EnumSet)pair.first).add(STAGIAIRE);
            }
        } else if (roles.contains(MEDICAL_SECRETARY) || roles.contains(SECRETARY)) {
            ((EnumSet)pair.first).add(MEDICAL_SECRETARY);
            if (!maxed) {
                ((EnumSet)pair.first).add(SECRETARY);
                ((EnumSet)pair.second).add(HEALTHCARE_PROVIDER);
                ((EnumSet)pair.second).add(STAGIAIRE);
            }
        }
        return pair;
    }

    public static XUserRole from(Integer value) {
        if (value != null) {
            for (XUserRole e : XUserRole.values()) {
                if (e.value != value) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public XUserRole fromValue(Integer id) {
        return XUserRole.from(id);
    }
}

