/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IEncounterAccessor;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounter;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.LocalDate;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EncounterAccessorClient
extends BaseAccessorClient {
    private static final Logger logger = Logger.getLogger(EncounterAccessorClient.class.getName());
    private static EncounterAccessorClient instance;
    private IEncounterAccessor accessor;

    public static EncounterAccessorClient getInstance() throws CannotConnectToServerException {
        return EncounterAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static EncounterAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new EncounterAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private EncounterAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getEncounterAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    protected IEncounterAccessor getAccessor() {
        return this.accessor;
    }

    public void findEncountersByPatient(XSession session, final ICallback callback, final XPatient patient) {
        final String function = "EncounterAccessorClient.findEncountersByPatient" + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findEncountersByPatient(patient.getId().intValue());
                            if (returnObject != null && returnObject.getObj() instanceof Collection) {
                                Collection list = (Collection)returnObject.getObj();
                                for (XEncounter xEncounter : list) {
                                    xEncounter.setPatient(patient);
                                    xEncounter.modificationStatus.plain_set((Object)ModificationStatus.STATUS_NEUTRAL);
                                }
                            }
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject getMostRecentEncounterByPatientSync(XSession session, XPatient patient) {
        if (this.isOkToCallFunction("EncounterAccessorClient.getMostRecentEncounterByPatient")) {
            try {
                ReturnObject returnObject = this.accessor.getMostRecentEncounterByPatient(patient.getId().intValue());
                if (returnObject != null && returnObject.getObj() instanceof XEncounter) {
                    XEncounter xEncounter = (XEncounter)returnObject.getObj();
                    xEncounter.setPatient(patient);
                    xEncounter.modificationStatus.plain_set((Object)ModificationStatus.STATUS_NEUTRAL);
                }
                ReturnObject returnObject2 = returnObject;
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.getMostRecentEncounterByPatient");
            }
        }
        return null;
    }

    public void getMostRecentEncounterByPatient(XSession session, final ICallback callback, final int patientId) {
        final String function = "EncounterAccessorClient.getMostRecentEncounterByPatient" + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.getMostRecentEncounterByPatient(patientId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findLifeHabitByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findLifeHabitByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findLifeHabitByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findLifeHabitByPatient");
            }
        }
        return null;
    }

    public void findLifeHabitByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findLifeHabitByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findLifeHabitByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findDocumentsByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findDocumentsByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findDocumentsByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findDocumentsByPatient");
            }
        }
        return null;
    }

    public void findDocumentsByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findDocumentsByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findDocumentsByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findRappelByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findRappelByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findRappelByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findRappelByPatient");
            }
        }
        return null;
    }

    public void findRappelByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findRappelByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findRappelByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findOverDueRappelByProf(XSession session, final ICallback callback, final int profId) {
        final String function = "EncounterAccessorClient.findOverDueRappelByProf " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findOverDueRappelByProf(profId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getNumberOverDueRappelByProf(XSession session, final ICallback callback, final int profId) {
        final String function = "EncounterAccessorClient.getNumberOverDueRappelByProf " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.getNumberOverDueRappelByProf(profId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findPlanByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findPlanByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findPlanByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findPlanByPatient");
            }
        }
        return null;
    }

    public void findPlanByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findPlanByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findPlanByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findRecentLaboResults(XSession session, final ICallback callback, final int patientId, final int nbMoisInThePast) {
        final String function = "EncounterAccessorClient.findRecentLaboreturnObjects " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findRecentLaboResults(patientId, nbMoisInThePast);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findPreventByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findPreventByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findPreventByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findPreventByPatient");
            }
        }
        return null;
    }

    public void findPreventByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findPreventByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findPreventByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findAllergyAndIntoleranceByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findDiagnosticByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findAllergyAndIntoleranceByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findDiagnosticByPatient");
            }
        }
        return null;
    }

    public void findAllergyAndIntoleranceByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findAllergyAndIntoleranceByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findAllergyAndIntoleranceByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findPreventionByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findDiagnosticByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findPreventionByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findDiagnosticByPatient");
            }
        }
        return null;
    }

    public void findPreventionByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findPreventionByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findPreventionByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findDiagnosticByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findDiagnosticByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findDiagnosticByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findDiagnosticByPatient");
            }
        }
        return null;
    }

    public void findDiagnosticByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findDiagnosticByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findDiagnosticByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findInterventionByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findInterventionByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findInterventionByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findInterventionByPatient");
            }
        }
        return null;
    }

    public void findInterventionByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findInterventionByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findInterventionByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findImmunizationByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findImmunizationByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findImmunizationByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findImmunizationByPatient");
            }
        }
        return null;
    }

    public void findImmunizationByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findImmunizationByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findImmunizationByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findConsultationsByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findConsultationsByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findConsultationsByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findConsultationsByPatient");
            }
        }
        return null;
    }

    public void findConsultationsByPatientNoThread(XSession session, ICallback callback, int patientId, boolean onlyActive) {
        String function = "EncounterAccessorClient.findConsultationsByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = this.accessor.findConsultationsByPatient(patientId, onlyActive);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void findConsultationsByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findConsultationsByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findConsultationsByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findPhysicalExaminationByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findPhysicalExaminationByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findPhysicalExaminationByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findPhysicalExaminationByPatient");
            }
        }
        return null;
    }

    public void findPhysicalExaminationByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findPhysicalExaminationByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findPhysicalExaminationByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findMeasurementByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findMeasurementByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findMeasurementByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findMeasurementByPatient");
            }
        }
        return null;
    }

    public void findMeasurementByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findMeasurementByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findMeasurementByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findFrequencyByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findFrequencyByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findFrequencyByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findFrequencyByPatient");
            }
        }
        return null;
    }

    public void findFrequencyByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findFrequencyByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findFrequencyByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findBodyTemperatureByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findBodyTemperatureByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findBodyTemperatureByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findBodyTemperatureByPatient");
            }
        }
        return null;
    }

    public void findBodyTemperatureByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findBodyTemperatureByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findBodyTemperatureByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findBloodPressureByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findBloodPressureByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findBloodPressureByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findBloodPressureByPatient");
            }
        }
        return null;
    }

    public void findBloodPressureByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findBloodPressureByPatient " + EncounterAccessorClient.getNextUniqueKey2();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findBloodPressureByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findCodeByCode(int uniqueKey, XSession session, final ICallback callback, final String text, final String classification) {
        final String function = "EncounterAccessorClient.findCodeBycode " + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findCodeByCode(text, classification);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findCode(int uniqueKey, XSession session, final ICallback callback, final String text, final String classification) {
        final String function = "EncounterAccessorClient.findCode " + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findCode(text, classification);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findCodeReasonVisit(int uniqueKey, XSession session, final ICallback callback, final String text) {
        final String function = "EncounterAccessorClient.findCodeReasonVisit " + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findCodeReasonVisit(text);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findCodeSync(XSession session, String text, String classification) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findCode")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = EncounterAccessorClient.instance.accessor.findCode(text, classification);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findCode");
            }
        }
        return null;
    }

    public ReturnObject findPrescriptionsByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findPrescriptionsByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findPrescriptionsByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findPrescriptionsByPatient");
            }
        }
        return null;
    }

    public void findPrescriptionsByPatient(XSession session, final ICallback callback, final int patientId, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findPrescriptionsByPatient " + patientId + EncounterAccessorClient.getNextUniqueKey();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findPrescriptionsByPatient(patientId, onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPrescriptionsByPatient(XSession session, final ICallback callback, final LocalDate start, final LocalDate end, final int patientId) {
        final String function = "EncounterAccessorClient.findPrescriptionsByPatient " + patientId + EncounterAccessorClient.getNextUniqueKey();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = EncounterAccessorClient.this.accessor.findPrescriptions2(start, end, patientId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findPrescriptionsByPatient(XSession session, LocalDate start, LocalDate end, int patientId) {
        String function = "EncounterAccessorClient.findPrescriptionsByPatient " + patientId;
        if (this.isOkToCallFunction(function, null)) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findPrescriptions2(start, end, patientId);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded(function, null);
            }
        }
        return null;
    }

    public void asyncFindLastUsedPrescription(XSession session, final ICallback callback, final String text) {
        final String function = "EncounterAccessorClient.findLastUsedPrescription " + text;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findLastUsedPrescriptionByDrug(text);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findLastUsedPrescription(XSession session, ICallback callback, String text) throws Exception {
        String function = "EncounterAccessorClient.findLastUsedPrescription " + text;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = EncounterAccessorClient.instance.accessor.findLastUsedPrescriptionByDrug(text);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void findFavPrescription(XSession session, ICallback callback, Integer idProf) throws Exception {
        String function = "EncounterAccessorClient.findFavPrescription " + idProf;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = EncounterAccessorClient.instance.accessor.findFavPrescription(idProf);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public Pair<IStatus, XPrescription> getNewDefaultPrescription(XSession session) {
        IStatus status;
        XPrescription object;
        block7: {
            object = null;
            status = Status.OK_STATUS;
            String function = "EncounterAccessorClient.getNewDefaultPrescription" + EncounterAccessorClient.getNextUniqueKey2();
            if (this.isOkToCallFunction(function)) {
                try {
                    try {
                        ReturnObject returnObject = this.accessor.getNewDefaultPrescription();
                        if (returnObject != null) {
                            object = (XPrescription)returnObject.getObj();
                            status = returnObject.getStatus();
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Erreur", e);
                        status = new Status(IStatus.Severity.BUG, (Throwable)e);
                        this.functionCallEnded(function);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.functionCallEnded(function);
                    throw throwable;
                }
                this.functionCallEnded(function);
            }
        }
        return Pair.newPair((Object)status, object);
    }

    public Pair<IStatus, XPrescription> represcribePrescription(XSession session, int prescriptionId) {
        IStatus status;
        XPrescription object;
        block7: {
            object = null;
            status = Status.OK_STATUS;
            String function = "EncounterAccessorClient.represcribePrescription" + EncounterAccessorClient.getNextUniqueKey2();
            if (this.isOkToCallFunction(function)) {
                try {
                    try {
                        ReturnObject returnObject = this.accessor.represcribePrescription(prescriptionId);
                        if (returnObject != null) {
                            object = (XPrescription)returnObject.getObj();
                            status = returnObject.getStatus();
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Erreur", e);
                        status = new Status(IStatus.Severity.BUG, (Throwable)e);
                        this.functionCallEnded(function);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.functionCallEnded(function);
                    throw throwable;
                }
                this.functionCallEnded(function);
            }
        }
        return Pair.newPair((Object)status, object);
    }

    public Pair<IStatus, XPrescription> stopPrescription(XSession session, int prescriptionId) {
        IStatus status;
        XPrescription object;
        block7: {
            object = null;
            status = Status.OK_STATUS;
            String function = "EncounterAccessorClient.stopPrescription" + EncounterAccessorClient.getNextUniqueKey2();
            if (this.isOkToCallFunction(function)) {
                try {
                    try {
                        ReturnObject returnObject = this.accessor.stopPrescription(prescriptionId);
                        if (returnObject != null) {
                            object = (XPrescription)returnObject.getObj();
                            status = returnObject.getStatus();
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Erreur", e);
                        status = new Status(IStatus.Severity.BUG, (Throwable)e);
                        this.functionCallEnded(function);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.functionCallEnded(function);
                    throw throwable;
                }
                this.functionCallEnded(function);
            }
        }
        return Pair.newPair((Object)status, object);
    }

    public XEncounter getEncounter(XSession session, int encounterId) throws Exception {
        XEncounter encounter;
        block8: {
            encounter = null;
            String function = "EncounterAccessorClient.getEncounter" + encounterId;
            if (session != null && this.isOkToCallFunction(function)) {
                try {
                    try {
                        ReturnObject returnObject = EncounterAccessorClient.instance.accessor.getEncounter(encounterId);
                        if (returnObject.getStatus().isOkToProceed()) {
                            encounter = (XEncounter)returnObject.getObj();
                            break block8;
                        }
                        throw new StatusException((IStatus)returnObject.getStatus());
                    }
                    catch (StatusException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Erreur", e);
                        throw e;
                    }
                }
                finally {
                    this.functionCallEnded(function);
                }
            }
        }
        return encounter;
    }

    public void findEncounter(int uniqueKey, XSession session, final ICallback callback, final String note, final LocalDate start, final LocalDate end, final Integer idPatient, final Integer idProfessionnal, final Integer idSupervisor, final Boolean toBeCompleted, final Boolean toBeRevised, final Boolean onlyMostRecentEncounterForEachPatient) {
        final String function = "EncounterAccessorClient.findEncounter" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findEncounter(note, start, end, idPatient, idProfessionnal, idSupervisor, toBeCompleted, toBeRevised, onlyMostRecentEncounterForEachPatient);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findReprescriptions(XSession session, final ICallback callback, final String drugName, final XBaseProfessionnal professionnal, final LocalDate startDate, final LocalDate endDate) throws Exception {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (this.isOkToCallFunction("EncounterAccessorClient.findReprescriptions", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject;
                            ReturnObject response = returnObject = instance.accessor.findReprescriptions(drugName, professionnal, startDate, endDate);
                            callback.response(response);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded("EncounterAccessorClient.findReprescriptions", callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded("EncounterAccessorClient.findReprescriptions", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPrescriptionsByPatient(final XSession session, final ICallback callback, final String patientNameOrRecordNumber, final String drugName, final boolean noLimit) throws Exception {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (this.isOkToCallFunction("EncounterAccessorClient.findPrescriptionsByPatient", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject;
                            ReturnObject response = returnObject = instance.accessor.findPrescriptions(patientNameOrRecordNumber, drugName, noLimit, session);
                            callback.response(response);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded("EncounterAccessorClient.findPrescriptionsByPatient", callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded("EncounterAccessorClient.findPrescriptionsByPatient", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findMedicationsByPatient(XSession session, ICallback callback, int patientId) throws Exception {
        if (session == null) {
            throw new NullPointerException("session");
        }
        String function = "EncounterAccessorClient.findMedicationsByPatient" + patientId;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject;
                    ReturnObject response = returnObject = EncounterAccessorClient.instance.accessor.findMedicationsByPatient(patientId);
                    callback.response(response);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void findPatientsByDrugName(final XSession session, final ICallback callback, final String patientNameOrRecordNumber, final String drugName, final boolean noLimit) throws Exception {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (this.isOkToCallFunction("EncounterAccessorClient.findPatientsByDrugName", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject;
                            ReturnObject response = returnObject = instance.accessor.findPatientsByDrugName(patientNameOrRecordNumber, drugName, noLimit, session);
                            callback.response(response);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            EncounterAccessorClient.this.functionCallEnded("EncounterAccessorClient.findPatientsByDrugName", callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded("EncounterAccessorClient.findPatientsByDrugName", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPrescriptionGroups(XSession session, ICallback callback) throws Exception {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (this.isOkToCallFunction("EncounterAccessorClient.findPatientsByDrugName", callback)) {
            try {
                try {
                    ReturnObject returnObject;
                    ReturnObject response = returnObject = EncounterAccessorClient.instance.accessor.findPrescriptionGroups();
                    callback.response(response);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("EncounterAccessorClient.findPatientsByDrugName", callback);
                }
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findPatientsByDrugName", callback);
            }
        }
    }

    public ReturnObject findCustomMeasureByPatientSync(XSession session, int patientId, boolean onlyActive) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findCustomMeasureByPatient")) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.findCustomMeasureByPatient(patientId, onlyActive);
                return returnObject2;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findCustomMeasureByPatient");
            }
        }
        return null;
    }

    public void findCustomMeasuresByPatient(final XSession session, final Callback callback, final Integer idPatient, final boolean onlyActive) {
        final String function = "EncounterAccessorClient.findCustomMeasuresByPatient" + idPatient;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findCustomMeasureByPatient(idPatient.intValue(), onlyActive);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, idPatient), e);
                            EncounterAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        EncounterAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findFollowUp(XSession session, Callback callback) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findFollowUp", callback)) {
            try {
                try {
                    ReturnObject returnObject;
                    ReturnObject ret = returnObject = EncounterAccessorClient.instance.accessor.findFollowUp();
                    callback.response(ret);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s}", "EncounterAccessorClient.findFollowUp", session, callback), e);
                    this.functionCallEnded("EncounterAccessorClient.findFollowUp", callback);
                }
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findFollowUp", callback);
            }
        }
    }

    public void findLabTypeNames(XSession session, Callback callback) {
        if (this.isOkToCallFunction("EncounterAccessorClient.findLabTypeNames", callback)) {
            try {
                try {
                    ReturnObject returnObject = EncounterAccessorClient.instance.accessor.findLabTypeNames();
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s}", "EncounterAccessorClient.findLabTypeNames", session, callback), e);
                    this.functionCallEnded("EncounterAccessorClient.findLabTypeNames", callback);
                }
            }
            finally {
                this.functionCallEnded("EncounterAccessorClient.findLabTypeNames", callback);
            }
        }
    }
}

