/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IB2BAccessor;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModif;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.library.log.Log;

public class B2BAccessorClient
extends BaseAccessorClient {
    private static B2BAccessorClient instance;
    private final IB2BAccessor accessor;

    public static B2BAccessorClient getInstance() throws CannotConnectToServerException {
        return B2BAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static B2BAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new B2BAccessorClient(serverConnectionInfo);
        }
        return instance;
    }

    private B2BAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getB2BAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void executeAsync(final XPatientB2bModif modif, XSession session, final ICallback callback) {
        final String function = "B2BAccessorClient.execute";
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.execute(modif));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            B2BAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        B2BAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject executeSync(XPatientB2bModif modif, XSession session) {
        String function = "B2BAccessorClient.execute";
        if (this.isOkToCallFunction(function, null)) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = B2BAccessorClient.instance.accessor.execute(modif);
                return returnObject2;
            }
            catch (Exception e) {
                Log.severe((String)"Erreur", (Exception)e);
                throw e;
            }
            finally {
                this.functionCallEnded(function, null);
            }
        }
        return null;
    }

    public ReturnObject verifySync(String nam, XSession session) {
        String function = "B2BAccessorClient.verify";
        if (this.isOkToCallFunction(function, null)) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = B2BAccessorClient.instance.accessor.verify(nam);
                return returnObject2;
            }
            catch (Exception e) {
                Log.severe((String)"Erreur", (Exception)e);
                throw e;
            }
            finally {
                this.functionCallEnded(function, null);
            }
        }
        return null;
    }

    public ReturnObject getInscriptionBasicInfosSync(String nam, XSession session) {
        String function = "B2BAccessorClient.getInscriptionBasicInfos";
        if (this.isOkToCallFunction(function, null)) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = B2BAccessorClient.instance.accessor.getInscriptionBasicInfos(nam);
                return returnObject2;
            }
            catch (Exception e) {
                Log.severe((String)"Erreur", (Exception)e);
                throw e;
            }
            finally {
                this.functionCallEnded(function, null);
            }
        }
        return null;
    }

    protected IB2BAccessor getAccessor() {
        return this.accessor;
    }
}

