/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.oe.OEC0302Svc;

import ca.infodata.dsq.domain.DosageInstruction;
import ca.infodata.dsq.domain.DosageLine;
import ca.infodata.dsq.domain.ICandidate;
import ca.infodata.dsq.domain.Ingredient;
import ca.infodata.dsq.domain.Medication;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.domain.SupplyRequestItem;
import ca.infodata.dsq.domain.TherapeuticIntent;
import ca.infodata.dsq.domain.ValueWithUnit;
import ca.infodata.dsq.service.oe.OEC0302Svc.DUPTHPYIssueManagement;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;

public final class CreateDrugPrescriptionCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ICandidate candidate;
    private final PrescriptionDrugDetails prescription;
    private DUPTHPYIssueManagement issueManagement;

    public CreateDrugPrescriptionCriteria(ICandidate candidate, PrescriptionDrugDetails prescription) {
        this.candidate = candidate;
        this.prescription = prescription;
    }

    public void setCandidate(ICandidate candidate) {
        this.candidate = candidate;
    }

    void valid() throws NullPointerException, IllegalArgumentException {
        if (this.candidate == null) {
            throw new NullPointerException("candidate");
        }
        if (this.candidate.getNiu() == null) {
            throw new NullPointerException("candidate.getNiu()");
        }
        if (this.candidate.getFirstName() == null) {
            throw new NullPointerException("candidate.getFirstName()");
        }
        if (this.candidate.getLastName() == null) {
            throw new NullPointerException("candidate.getLastName()");
        }
        if (this.prescription.prescriber == null) {
            throw new NullPointerException("prescription.prescriber");
        }
        if (this.prescription.prescriber.getFirstName() == null) {
            throw new NullPointerException("prescription.prescriber.getFirstName()");
        }
        if (this.prescription.prescriber.getLastName() == null) {
            throw new NullPointerException("prescription.prescriber.getLastName()");
        }
        if (this.prescription.medication == null) {
            throw new NullPointerException("prescription.medication");
        }
        this.valid("prescription.medication", this.prescription.medication);
        if (this.prescription.reasons != null) {
            for (TherapeuticIntent reason : this.prescription.reasons) {
                if (reason == null) {
                    throw new NullPointerException("reason");
                }
                if (!Helper.isBlank(reason.otherIndicationText)) continue;
                throw new IllegalArgumentException("reason.text is blank");
            }
        }
        if (this.prescription.dosageInstructions == null) {
            throw new NullPointerException("prescription.dosageInstructions");
        }
        if (this.prescription.dosageInstructions.isEmpty()) {
            throw new IllegalArgumentException("prescription.dosageInstructions must contains at least 1 item");
        }
        for (DosageInstruction dosageInstruction : this.prescription.dosageInstructions) {
            if (Helper.isBlank(dosageInstruction.text)) {
                throw new IllegalArgumentException("dosageInstruction.text is blank");
            }
            if (!(dosageInstruction.fromDate == null && dosageInstruction.toDate == null || dosageInstruction.fromDate != null && dosageInstruction.toDate != null)) {
                throw new NullPointerException("dosageInstruction.fromDate and dosageInstruction.toDate should both be null or both be not null");
            }
            if (dosageInstruction.maxDoseNumerators != null || dosageInstruction.maxDoseDenominators != null) {
                if (dosageInstruction.maxDoseNumerators == null) {
                    throw new NullPointerException("dosageInstruction.maxDoseNumerators");
                }
                if (dosageInstruction.maxDoseDenominators == null) {
                    throw new NullPointerException("dosageInstruction.maxDoseDenominators");
                }
                int size = dosageInstruction.maxDoseNumerators.size();
                if (dosageInstruction.maxDoseDenominators.size() != size) {
                    throw new IllegalArgumentException("dosageInstruction.maxDoseDenominatorUnits must have size " + size);
                }
                for (ValueWithUnit maxDoseNumerator : dosageInstruction.maxDoseNumerators) {
                    if (!Helper.isNonNullAndLowerOrEqualsZero(maxDoseNumerator)) continue;
                    throw new IllegalArgumentException("dosageInstruction.maxDoseNumerators.value is not > 0");
                }
                for (ValueWithUnit maxDoseDenominator : dosageInstruction.maxDoseDenominators) {
                    if (!Helper.isNonNullAndLowerOrEqualsZero(maxDoseDenominator)) continue;
                    throw new IllegalArgumentException("dosageInstruction.maxDoseDenominators.value is not > 0");
                }
            }
            if (dosageInstruction.consumable != null) {
                this.valid("dosageInstruction.consumable", dosageInstruction.consumable);
            }
            if (dosageInstruction.dosageLines == null) continue;
            for (DosageLine dosageLine : dosageInstruction.dosageLines) {
                if (dosageLine.sequenceNumber == null) {
                    throw new NullPointerException("dosageLine.sequenceNumber");
                }
                if (Helper.isNonNullAndLowerOrEqualsZero(dosageLine.sequenceNumber)) {
                    throw new IllegalArgumentException("dosageLine.sequenceNumber is not > 0");
                }
                if (Helper.isBlank(dosageLine.adhocInstruction)) {
                    if (dosageLine.dateLow == null) {
                        throw new NullPointerException("dosageLine.dateLow");
                    }
                    if (dosageLine.dateHigh == null) {
                        throw new NullPointerException("dosageLine.dateHigh");
                    }
                    if (dosageLine.quantityLow == null) {
                        throw new NullPointerException("dosageLine.quantityLow");
                    }
                    if (Helper.isNonNullAndLowerOrEqualsZero(dosageLine.quantityLow)) {
                        throw new IllegalArgumentException("dosageLine.quantityLow.value is not > 0");
                    }
                    if (dosageLine.quantityHigh == null) {
                        throw new NullPointerException("dosageLine.quantityHigh");
                    }
                    if (Helper.isNonNullAndLowerOrEqualsZero(dosageLine.quantityHigh)) {
                        throw new IllegalArgumentException("dosageLine.quantityHigh.value is not > 0");
                    }
                    if (dosageLine.numerator == null) {
                        throw new NullPointerException("dosageLine.numerator");
                    }
                    if (Helper.isNonNullAndLowerOrEqualsZero(dosageLine.numerator)) {
                        throw new IllegalArgumentException("dosageLine.numerator is not > 0");
                    }
                    if (dosageLine.denominator == null) {
                        throw new NullPointerException("dosageLine.denominator");
                    }
                    if (Helper.isNonNullAndLowerOrEqualsZero(dosageLine.denominator)) {
                        throw new IllegalArgumentException("dosageLine.denominator.value is not > 0");
                    }
                }
                if (dosageLine.rateQuantityLow == null && dosageLine.rateQuantityHigh == null) continue;
                if (dosageLine.rateQuantityLow == null) {
                    throw new NullPointerException("dosageLine.rateQuantityLow");
                }
                if (dosageLine.rateQuantityHigh == null) {
                    throw new NullPointerException("dosageLine.rateQuantityHigh");
                }
                if (Helper.isNonNullAndLowerOrEqualsZero(dosageLine.rateQuantityLow)) {
                    throw new IllegalArgumentException("dosageLine.rateQuantityLow.value is not > 0");
                }
                if (!Helper.isNonNullAndLowerOrEqualsZero(dosageLine.rateQuantityHigh)) continue;
                throw new IllegalArgumentException("dosageLine.rateQuantityHigh.value is not > 0");
            }
        }
        if (this.prescription.supplyRequestLocation != null) {
            if (this.prescription.supplyRequestLocation.getNIU() == null) {
                throw new NullPointerException("prescription.supplyRequestLocation.getNIU()");
            }
            if (this.prescription.supplyRequestLocation.getName() == null) {
                throw new NullPointerException("prescription.supplyRequestLocation.getName()");
            }
            if (this.prescription.supplyRequestLocation.getAddress() == null) {
                throw new NullPointerException("prescription.supplyRequestLocation.getAddress()");
            }
            if (this.prescription.supplyRequestLocation.getAddress().telecom == null) {
                throw new NullPointerException("prescription.supplyRequestLocation.getAddress().telecom");
            }
        }
        if (!(this.prescription.supplyRequestAllowedPeriodLowDate == null && this.prescription.supplyRequestAllowedPeriodHighDate == null || this.prescription.supplyRequestAllowedPeriodLowDate != null && this.prescription.supplyRequestAllowedPeriodHighDate != null)) {
            throw new NullPointerException("prescription.supplyRequestAllowedPeriodLowDate and prescription.supplyRequestAllowedPeriodHighDate should both be null or both be not null");
        }
        if (this.prescription.supplyRequestItems == null) {
            throw new NullPointerException("prescription.supplyRequestItems");
        }
        if (this.prescription.supplyRequestItems.isEmpty()) {
            throw new IllegalArgumentException("prescription.supplyRequestItems cant be empty");
        }
        for (SupplyRequestItem supplyRequestItem : this.prescription.supplyRequestItems) {
            if (supplyRequestItem.totalDaysSupply == null && supplyRequestItem.totalQuantity == null) {
                throw new IllegalArgumentException("prescription.supplyRequestItem.totalDaysSupply and prescription.supplyRequestItem.totalQuantity cant be both null");
            }
            if (Helper.isNonNullAndLowerThanZero(supplyRequestItem.totalDaysSupply)) {
                throw new IllegalArgumentException("prescription.supplyRequestItem.totalDaysSupply is not >= 0");
            }
            if (Helper.isNonNullAndLowerThanZero(supplyRequestItem.totalQuantity)) {
                throw new IllegalArgumentException("prescription.supplyRequestItem.totalQuantity.value is not >= 0");
            }
            if (Helper.isNonNullAndLowerOrEqualsZero(supplyRequestItem.numberOfFills)) {
                throw new IllegalArgumentException("prescription.supplyRequestItem.numberOfFills is not > 0");
            }
            if (Helper.isNonNullAndLowerOrEqualsZero(supplyRequestItem.dispenseInterval)) {
                throw new IllegalArgumentException("prescription.supplyRequestItem.dispenseInterval.value is not > 0");
            }
            if (Helper.isNonNullAndLowerOrEqualsZero(supplyRequestItem.fillExpectedUseTime)) {
                throw new IllegalArgumentException("prescription.supplyRequestItem.fillExpectedUseTime.value is not > 0");
            }
            if (Helper.isNonNullAndLowerOrEqualsZero(supplyRequestItem.fillQuantity)) {
                throw new IllegalArgumentException("prescription.supplyRequestItem.fillQuantity.value is not > 0");
            }
            if (Helper.isNonNullAndLowerOrEqualsZero(supplyRequestItem.firstFillExpectedUseTime)) {
                throw new IllegalArgumentException("prescription.supplyRequestItem.firstFillExpectedUseTime.value is not > 0");
            }
            if (!Helper.isNonNullAndLowerOrEqualsZero(supplyRequestItem.firstFillQuantity)) continue;
            throw new IllegalArgumentException("prescription.supplyRequestItem.firstFillQuantity.value is not > 0");
        }
    }

    void valid(String field, Medication medication) {
        if (Helper.isBlank(medication.name)) {
            throw new IllegalArgumentException(field + ".name is blank");
        }
        if ((medication.code == null || Helper.isBlank(medication.code.code)) && medication.formCode == null) {
            throw new IllegalArgumentException(field + ".code and " + field + ".formCode cant be both null");
        }
        if (medication.packageQuantity != null && Helper.isNonNullAndLowerOrEqualsZero(medication.packageQuantity)) {
            throw new IllegalArgumentException(field + ".packageQuantity.value is not > 0");
        }
        if (medication.ingredients != null) {
            for (Ingredient ingredient : medication.ingredients) {
                if ((ingredient.code == null || Helper.isBlank(ingredient.code.code)) && Helper.isBlank(ingredient.name)) {
                    throw new IllegalArgumentException(field + ".ingredients.code and " + field + ".ingredients.name cant be both blank");
                }
                if (!Helper.isNonNullAndLowerOrEqualsZero(ingredient.quantity)) continue;
                throw new IllegalArgumentException(field + ".ingredients.quantity is not > 0");
            }
        }
    }

    public ICandidate getCandidate() {
        return this.candidate;
    }

    public PrescriptionDrugDetails getPrescriptionDetails() {
        return this.prescription;
    }

    public DUPTHPYIssueManagement getIssueManagement() {
        return this.issueManagement;
    }

    public void setIssueManagement(DUPTHPYIssueManagement issueManagement) {
        this.issueManagement = issueManagement;
    }

    public String toString() {
        return "CreateDrugPrescriptionCriteria [candidate=" + this.candidate + ", prescription=" + this.prescription + ", issueManagement=" + this.issueManagement + "]";
    }
}

