/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;

public final class Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String id;
    public final String shortName;
    public final String name;
    public final String version;

    public Application(String id, String shortname, String name, String version) {
        if (Helper.isBlank(id)) {
            throw new IllegalArgumentException("id is blank");
        }
        if (Helper.isBlank(shortname)) {
            throw new IllegalArgumentException("shortname is blank");
        }
        if (shortname.length() > 20) {
            throw new IllegalArgumentException("shortName length is > 20");
        }
        if (Helper.isBlank(name)) {
            throw new IllegalArgumentException("name is blank");
        }
        this.id = id;
        this.shortName = shortname;
        this.name = name;
        if (version != null) {
            if (version.startsWith("0")) {
                throw new IllegalArgumentException("version should not start with 0");
            }
            if (version.contains(".")) {
                throw new IllegalArgumentException("version should not contains . (dots)");
            }
            if (!Helper.isNumeric(version)) {
                throw new IllegalArgumentException("version should be numeric positive");
            }
        }
        this.version = version;
    }

    public Application(String id, String shortname, String name) {
        this(id, shortname, name, null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    public String toString() {
        return String.format("Application [%s %s %s]", this.id, this.name, this.version);
    }
}

