/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.math;

import org.ddogleg.optimization.math.HessianSchurComplement_Base;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.factory.LinearSolverFactory_DSCC;
import org.ejml.sparse.csc.mult.MatrixVectorMult_DSCC;

public class HessianSchurComplement_DSCC
extends HessianSchurComplement_Base<DMatrixSparseCSC> {
    IGrowArray gw = new IGrowArray();
    DGrowArray gx = new DGrowArray();
    protected LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solverA;
    protected LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solverD;

    public HessianSchurComplement_DSCC() {
        this(LinearSolverFactory_DSCC.cholesky(FillReducing.NONE), LinearSolverFactory_DSCC.cholesky(FillReducing.NONE));
    }

    public HessianSchurComplement_DSCC(LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solverA, LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solverD) {
        super(solverA, solverD);
    }

    @Override
    public void computeHessian(DMatrixSparseCSC jacLeft, DMatrixSparseCSC jacRight) {
        ((DMatrixSparseCSC)this.A).reshape(jacLeft.numCols, jacLeft.numCols, 1);
        ((DMatrixSparseCSC)this.B).reshape(jacLeft.numCols, jacRight.numCols, 1);
        ((DMatrixSparseCSC)this.D).reshape(jacRight.numCols, jacRight.numCols, 1);
        CommonOps_DSCC.innerProductLower(jacLeft, (DMatrixSparseCSC)this.tmp0, this.gw, this.gx);
        CommonOps_DSCC.symmLowerToFull((DMatrixSparseCSC)this.tmp0, (DMatrixSparseCSC)this.A, this.gw);
        CommonOps_DSCC.multTransA(jacLeft, jacRight, (DMatrixSparseCSC)this.B, this.gw, this.gx);
        CommonOps_DSCC.innerProductLower(jacRight, (DMatrixSparseCSC)this.tmp0, this.gw, this.gx);
        CommonOps_DSCC.symmLowerToFull((DMatrixSparseCSC)this.tmp0, (DMatrixSparseCSC)this.D, this.gw);
    }

    @Override
    public DMatrixSparseCSC createMatrix() {
        return new DMatrixSparseCSC(1, 1);
    }

    @Override
    protected double innerProduct(double[] a, int offsetA, DMatrixSparseCSC B, double[] c, int offsetC) {
        return MatrixVectorMult_DSCC.innerProduct(a, offsetA, B, c, offsetC);
    }

    @Override
    protected void extractDiag(DMatrixSparseCSC input, DMatrixRMaj output) {
        CommonOps_DSCC.extractDiag(input, output);
    }

    @Override
    protected void divideRowsCols(double[] diagA, int offsetA, DMatrixSparseCSC B, double[] diagC, int offsetC) {
        CommonOps_DSCC.divideRowsCols(diagA, offsetA, B, diagC, offsetC);
    }

    @Override
    protected void multTransA(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C) {
        CommonOps_DSCC.multTransA(A, B, C, this.gw, this.gx);
    }

    @Override
    protected void multTransA(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj C) {
        CommonOps_DSCC.multTransA(A, B, C);
    }

    @Override
    protected void add(double alpha, DMatrixSparseCSC A, double beta, DMatrixSparseCSC B, DMatrixSparseCSC C) {
        CommonOps_DSCC.add(alpha, A, beta, B, C, this.gw, this.gx);
    }

    @Override
    protected void mult(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj C) {
        CommonOps_DSCC.mult(A, B, C);
    }
}

