/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.ExhaustiveNeighbor;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;

public class WrapExhaustiveNeighbor<P>
implements NearestNeighbor<P> {
    KdTreeDistance<P> distance;
    List<P> points;

    public WrapExhaustiveNeighbor(KdTreeDistance<P> distance) {
        this.distance = distance;
    }

    @Override
    public void setPoints(List<P> points, boolean trackIndicies) {
        this.points = points;
    }

    @Override
    public NearestNeighbor.Search<P> createSearch() {
        return new InternalSearch(this.distance);
    }

    private class InternalSearch
    implements NearestNeighbor.Search<P> {
        ExhaustiveNeighbor<P> alg;
        GrowQueue_I32 outputIndex = new GrowQueue_I32();
        GrowQueue_F64 outputDistance = new GrowQueue_F64();

        InternalSearch(KdTreeDistance<P> distance) {
            this.alg = new ExhaustiveNeighbor(distance);
            this.alg.setPoints(WrapExhaustiveNeighbor.this.points);
        }

        @Override
        public boolean findNearest(P point, double maxDistance, NnData<P> result) {
            if (maxDistance < 0.0) {
                maxDistance = Double.MAX_VALUE;
            }
            this.alg.setPoints(WrapExhaustiveNeighbor.this.points);
            int index = this.alg.findClosest(point, maxDistance);
            if (index >= 0) {
                result.point = WrapExhaustiveNeighbor.this.points.get(index);
                result.distance = this.alg.getBestDistance();
                result.index = index;
                return true;
            }
            return false;
        }

        @Override
        public void findNearest(P point, double maxDistance, int numNeighbors, FastQueue<NnData<P>> results) {
            results.reset();
            if (maxDistance < 0.0) {
                maxDistance = Double.MAX_VALUE;
            }
            this.alg.setPoints(WrapExhaustiveNeighbor.this.points);
            this.outputIndex.reset();
            this.outputDistance.reset();
            this.alg.findClosestN(point, maxDistance, numNeighbors, this.outputIndex, this.outputDistance);
            for (int i = 0; i < this.outputIndex.size; ++i) {
                int index = this.outputIndex.get(i);
                NnData r = results.grow();
                r.distance = this.outputDistance.get(i);
                r.point = WrapExhaustiveNeighbor.this.points.get(index);
                r.index = index;
            }
        }
    }
}

