/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.geometry.UtilPolygons2D_I32;
import georegression.struct.point.Point2D_I32;
import java.io.Serializable;
import org.ddogleg.struct.FastQueue;

public class Polygon2D_I32
implements Serializable,
Cloneable {
    public FastQueue<Point2D_I32> vertexes;

    public Polygon2D_I32(int numVertexes) {
        this.vertexes = new FastQueue<Point2D_I32>(Point2D_I32.class, true);
        this.vertexes.growArray(numVertexes);
        this.vertexes.size = numVertexes;
    }

    public Polygon2D_I32() {
        this.vertexes = new FastQueue<Point2D_I32>(Point2D_I32.class, true);
    }

    public Polygon2D_I32(Polygon2D_I32 original) {
        this.set(original);
    }

    public Polygon2D_I32(int ... points) {
        if (points.length % 2 == 1) {
            throw new IllegalArgumentException("Expected an even number");
        }
        this.vertexes = new FastQueue<Point2D_I32>(points.length / 2, Point2D_I32.class, true);
        this.vertexes.growArray(points.length / 2);
        this.vertexes.size = points.length / 2;
        int count = 0;
        for (int i = 0; i < points.length; i += 2) {
            ((Point2D_I32[])this.vertexes.data)[count++].set(points[i], points[i + 1]);
        }
    }

    public int size() {
        return this.vertexes.size();
    }

    public Point2D_I32 get(int index) {
        return ((Point2D_I32[])this.vertexes.data)[index];
    }

    public void flip() {
        UtilPolygons2D_I32.flip(this);
    }

    public boolean isCCW() {
        return UtilPolygons2D_I32.isCCW(this.vertexes.toList());
    }

    public boolean isConvex() {
        return UtilPolygons2D_I32.isConvex(this);
    }

    public boolean isIdentical(Polygon2D_I32 a) {
        return UtilPolygons2D_I32.isIdentical(this, a);
    }

    public boolean isEquivalent(Polygon2D_I32 a, double tol) {
        return UtilPolygons2D_I32.isEquivalent(this, a);
    }

    public void set(Polygon2D_I32 orig) {
        this.vertexes.resize(orig.size());
        for (int i = 0; i < orig.size(); ++i) {
            ((Point2D_I32[])this.vertexes.data)[i].set(((Point2D_I32[])orig.vertexes.data)[i]);
        }
    }

    public void set(int index, int x, int y) {
        ((Point2D_I32[])this.vertexes.data)[index].set(x, y);
    }

    public Polygon2D_I32 clone() {
        return new Polygon2D_I32(this);
    }
}

