/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Vector3D_F64;
import java.util.Random;
import org.ejml.data.DMatrixRMaj;

public class UtilVector3D_F64 {
    public static Vector3D_F64 createRandom(double min, double max, Random rand) {
        double range = max - min;
        Vector3D_F64 a = new Vector3D_F64();
        a.x = range * rand.nextDouble() + min;
        a.y = range * rand.nextDouble() + min;
        a.z = range * rand.nextDouble() + min;
        return a;
    }

    public static Vector3D_F64 perpendicularCanonical(Vector3D_F64 A, Vector3D_F64 output) {
        double scale;
        if (output == null) {
            output = new Vector3D_F64();
        }
        if ((scale = Math.abs(A.x) + Math.abs(A.y) + Math.abs(A.z)) == 0.0) {
            output.set(0.0, 0.0, 0.0);
        } else {
            double x = A.x / scale;
            double y = A.y / scale;
            double z = A.z / scale;
            if (Math.abs(x) > Math.abs(y)) {
                output.set(z, 0.0, -x);
            } else {
                output.set(0.0, z, -y);
            }
        }
        return output;
    }

    public static boolean isIdentical(Vector3D_F64 a, Vector3D_F64 b, double tol) {
        if (Math.abs(a.x - b.x) > tol) {
            return false;
        }
        if (Math.abs(a.y - b.y) > tol) {
            return false;
        }
        return Math.abs(a.z - b.z) <= tol;
    }

    public static void normalize(Vector3D_F64 v) {
        double a = v.norm();
        v.x /= a;
        v.y /= a;
        v.z /= a;
    }

    public static DMatrixRMaj createMatrix(DMatrixRMaj R, Vector3D_F64 ... v) {
        if (R == null) {
            R = new DMatrixRMaj(3, v.length);
        }
        for (int i = 0; i < v.length; ++i) {
            R.set(0, i, v[i].x);
            R.set(1, i, v[i].y);
            R.set(2, i, v[i].z);
        }
        return R;
    }

    public static Vector3D_F64 convert(DMatrixRMaj m) {
        Vector3D_F64 v = new Vector3D_F64();
        v.x = m.data[0];
        v.y = m.data[1];
        v.z = m.data[2];
        return v;
    }

    public static double acute(GeoTuple3D_F64 a, GeoTuple3D_F64 b) {
        double dot = a.x * b.x + a.y * b.y + a.z * b.z;
        double value = dot / (a.norm() * b.norm());
        if (value > 1.0) {
            value = 1.0;
        } else if (value < -1.0) {
            value = -1.0;
        }
        return Math.acos(value);
    }
}

