/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.fitting.curves.ClosestPointEllipseAngle_F32;
import georegression.misc.GrlConstants;
import georegression.struct.curve.EllipseRotated_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DMatrixRMaj;

public class RefineEllipseEuclideanLeastSquares_F32 {
    protected UnconstrainedLeastSquares optimizer;
    float ftol = GrlConstants.FCONV_TOL_B;
    float gtol = GrlConstants.FCONV_TOL_B;
    int maxIterations = 500;
    ClosestPointEllipseAngle_F32 closestPoint = new ClosestPointEllipseAngle_F32(GrlConstants.FCONV_TOL_B, 100);
    List<Point2D_F32> points;
    EllipseRotated_F32 found = new EllipseRotated_F32();
    double[] initialParam = new double[0];
    double initialError;

    public RefineEllipseEuclideanLeastSquares_F32(UnconstrainedLeastSquares optimizer) {
        this.optimizer = optimizer;
    }

    public RefineEllipseEuclideanLeastSquares_F32() {
        this(FactoryOptimization.levenbergMarquardt(null, true));
    }

    public void setFtol(float ftol) {
        this.ftol = ftol;
    }

    public void setGtol(float gtol) {
        this.gtol = gtol;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public UnconstrainedLeastSquares getOptimizer() {
        return this.optimizer;
    }

    public boolean refine(EllipseRotated_F32 initial, List<Point2D_F32> points) {
        int i;
        this.points = points;
        int numParam = 5 + points.size();
        if (numParam > this.initialParam.length) {
            this.initialParam = new double[numParam];
        }
        this.initialParam[0] = initial.center.x;
        this.initialParam[1] = initial.center.y;
        this.initialParam[2] = initial.a;
        this.initialParam[3] = initial.b;
        this.initialParam[4] = initial.phi;
        this.closestPoint.setEllipse(initial);
        for (i = 0; i < points.size(); ++i) {
            this.closestPoint.process(points.get(i));
            this.initialParam[5 + i] = this.closestPoint.getTheta();
        }
        this.optimizer.setFunction(new Error(), null);
        this.optimizer.initialize(this.initialParam, this.ftol, this.gtol);
        this.initialError = this.optimizer.getFunctionValue();
        for (i = 0; i < this.maxIterations && !this.optimizer.iterate(); ++i) {
        }
        double[] foundParam = this.optimizer.getParameters();
        this.found.center.x = (float)foundParam[0];
        this.found.center.y = (float)foundParam[1];
        this.found.a = (float)foundParam[2];
        this.found.b = (float)foundParam[3];
        this.found.phi = (float)foundParam[4];
        return true;
    }

    public EllipseRotated_F32 getFound() {
        return this.found;
    }

    public float getFitError() {
        return (float)this.optimizer.getFunctionValue();
    }

    protected Error createError() {
        return new Error();
    }

    protected Jacobian createJacobian() {
        return new Jacobian();
    }

    public class Jacobian
    implements FunctionNtoMxN<DMatrixRMaj> {
        @Override
        public int getNumOfInputsN() {
            return 5 + RefineEllipseEuclideanLeastSquares_F32.this.points.size();
        }

        @Override
        public int getNumOfOutputsM() {
            return 2 * RefineEllipseEuclideanLeastSquares_F32.this.points.size();
        }

        @Override
        public void process(double[] input, DMatrixRMaj output) {
            int i;
            double a = input[2];
            double b = input[3];
            double phi = input[4];
            double cp = Math.cos(phi);
            double sp = Math.sin(phi);
            int M = this.getNumOfOutputsM();
            int N = this.getNumOfInputsN();
            int total = M * N;
            for (i = 0; i < total; ++i) {
                output.data[i] = 0.0;
            }
            for (i = 0; i < RefineEllipseEuclideanLeastSquares_F32.this.points.size(); ++i) {
                double theta = input[5 + i];
                double ct = Math.cos(theta);
                double st = Math.sin(theta);
                int indexX = 2 * i * N;
                int indexY = indexX + N;
                output.data[indexX++] = -1.0;
                output.data[indexY++] = 0.0;
                output.data[indexX++] = 0.0;
                output.data[indexY++] = -1.0;
                output.data[indexX++] = -cp * ct;
                output.data[indexY++] = -sp * ct;
                output.data[indexX++] = sp * st;
                output.data[indexY++] = -cp * st;
                output.data[indexX++] = a * sp * ct + b * cp * st;
                output.data[indexY++] = -a * cp * ct + b * sp * st;
                output.data[indexX + i] = a * cp * st + b * sp * cp;
                output.data[indexY + i] = a * sp * st - b * cp * cp;
            }
        }

        @Override
        public DMatrixRMaj declareMatrixMxN() {
            return new DMatrixRMaj(this.getNumOfOutputsM(), this.getNumOfInputsN());
        }
    }

    public class Error
    implements FunctionNtoM {
        @Override
        public int getNumOfInputsN() {
            return 5 + RefineEllipseEuclideanLeastSquares_F32.this.points.size();
        }

        @Override
        public int getNumOfOutputsM() {
            return 2 * RefineEllipseEuclideanLeastSquares_F32.this.points.size();
        }

        @Override
        public void process(double[] input, double[] output) {
            double x0 = input[0];
            double y0 = input[1];
            double a = input[2];
            double b = input[3];
            double phi = input[4];
            double c = Math.cos(phi);
            double s = Math.sin(phi);
            int indexOut = 0;
            for (int i = 0; i < RefineEllipseEuclideanLeastSquares_F32.this.points.size(); ++i) {
                Point2D_F32 p = RefineEllipseEuclideanLeastSquares_F32.this.points.get(i);
                double theta = input[5 + i];
                double x = a * Math.cos(theta);
                double y = b * Math.sin(theta);
                double xx = x0 + c * x - s * y;
                double yy = y0 + s * x + c * y;
                output[indexOut++] = (double)p.x - xx;
                output[indexOut++] = (double)p.y - yy;
            }
        }
    }
}

