/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.curves;

import georegression.fitting.FitShapeToPoints_F32;
import georegression.struct.curve.ConicGeneral_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.ejml.data.FMatrix6x6;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_FDF6;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_FDRM;
import org.ejml.interfaces.SolveNullSpace;
import org.ejml.ops.ConvertFMatrixStruct;

public class FitConicAtA_F32
implements FitShapeToPoints_F32<Point2D_F32, ConicGeneral_F32> {
    private SolveNullSpace<FMatrixRMaj> solver = new SolveNullSpaceSvd_FDRM();
    private FMatrix6x6 ATA = new FMatrix6x6();
    private FMatrixRMaj tmp = new FMatrixRMaj(6, 6);
    private FMatrixRMaj nullspace = new FMatrixRMaj(6, 1);

    @Override
    public boolean process(List<Point2D_F32> points, ConicGeneral_F32 output) {
        int N = points.size();
        if (N < 3) {
            throw new IllegalArgumentException("At least 3 points required");
        }
        CommonOps_FDF6.fill(this.ATA, 0.0f);
        for (int i = 0; i < N; ++i) {
            Point2D_F32 p = points.get(i);
            float x = p.x;
            float y = p.y;
            float xx = x * x;
            float xxx = xx * x;
            float yy = y * y;
            float yyy = yy * y;
            this.ATA.a11 += xx * xx;
            this.ATA.a12 += xxx * y;
            this.ATA.a13 += xx * yy;
            this.ATA.a14 += xxx;
            this.ATA.a15 += xx * y;
            this.ATA.a16 += xx;
            this.ATA.a22 += xx * yy;
            this.ATA.a23 += x * yyy;
            this.ATA.a25 += x * yy;
            this.ATA.a26 += x * y;
            this.ATA.a33 += yyy * y;
            this.ATA.a35 += yyy;
            this.ATA.a36 += yy;
            this.ATA.a45 += x * y;
            this.ATA.a46 += x;
            this.ATA.a56 += y;
        }
        this.ATA.a21 = this.ATA.a12;
        this.ATA.a24 = this.ATA.a15;
        this.ATA.a31 = this.ATA.a13;
        this.ATA.a32 = this.ATA.a23;
        this.ATA.a34 = this.ATA.a25;
        this.ATA.a41 = this.ATA.a14;
        this.ATA.a42 = this.ATA.a24;
        this.ATA.a43 = this.ATA.a34;
        this.ATA.a44 = this.ATA.a16;
        this.ATA.a51 = this.ATA.a15;
        this.ATA.a52 = this.ATA.a25;
        this.ATA.a53 = this.ATA.a35;
        this.ATA.a54 = this.ATA.a45;
        this.ATA.a55 = this.ATA.a36;
        this.ATA.a61 = this.ATA.a16;
        this.ATA.a62 = this.ATA.a26;
        this.ATA.a63 = this.ATA.a36;
        this.ATA.a64 = this.ATA.a56;
        this.ATA.a65 = this.ATA.a56;
        this.ATA.a66 = N;
        ConvertFMatrixStruct.convert(this.ATA, this.tmp);
        if (!this.solver.process(this.tmp, 1, this.nullspace)) {
            return false;
        }
        output.A = this.nullspace.data[0];
        output.B = this.nullspace.data[1];
        output.C = this.nullspace.data[2];
        output.D = this.nullspace.data[3];
        output.E = this.nullspace.data[4];
        output.F = this.nullspace.data[5];
        return true;
    }

    @Override
    public boolean process(List<Point2D_F32> points, float[] weights, ConicGeneral_F32 output) {
        int N = points.size();
        if (N < 3) {
            throw new IllegalArgumentException("At least 3 points required");
        }
        CommonOps_FDF6.fill(this.ATA, 0.0f);
        for (int i = 0; i < N; ++i) {
            Point2D_F32 p = points.get(i);
            float w = weights[i];
            w *= w;
            float x = p.x;
            float y = p.y;
            float xx = x * x;
            float xxx = xx * x;
            float yy = y * y;
            float yyy = yy * y;
            this.ATA.a11 += w * xx * xx;
            this.ATA.a12 += w * xxx * y;
            this.ATA.a13 += w * xx * yy;
            this.ATA.a14 += w * xxx;
            this.ATA.a15 += w * xx * y;
            this.ATA.a16 += w * xx;
            this.ATA.a22 += w * xx * yy;
            this.ATA.a23 += w * x * yyy;
            this.ATA.a25 += w * x * yy;
            this.ATA.a26 += w * x * y;
            this.ATA.a33 += w * yyy * y;
            this.ATA.a35 += w * yyy;
            this.ATA.a36 += w * yy;
            this.ATA.a45 += w * x * y;
            this.ATA.a46 += w * x;
            this.ATA.a56 += w * y;
            this.ATA.a66 += w;
        }
        this.ATA.a21 = this.ATA.a12;
        this.ATA.a24 = this.ATA.a15;
        this.ATA.a31 = this.ATA.a13;
        this.ATA.a32 = this.ATA.a23;
        this.ATA.a34 = this.ATA.a25;
        this.ATA.a41 = this.ATA.a14;
        this.ATA.a42 = this.ATA.a24;
        this.ATA.a43 = this.ATA.a34;
        this.ATA.a44 = this.ATA.a16;
        this.ATA.a51 = this.ATA.a15;
        this.ATA.a52 = this.ATA.a25;
        this.ATA.a53 = this.ATA.a35;
        this.ATA.a54 = this.ATA.a45;
        this.ATA.a55 = this.ATA.a36;
        this.ATA.a61 = this.ATA.a16;
        this.ATA.a62 = this.ATA.a26;
        this.ATA.a63 = this.ATA.a36;
        this.ATA.a64 = this.ATA.a56;
        this.ATA.a65 = this.ATA.a56;
        ConvertFMatrixStruct.convert(this.ATA, this.tmp);
        if (!this.solver.process(this.tmp, 1, this.nullspace)) {
            return false;
        }
        output.A = this.nullspace.data[0];
        output.B = this.nullspace.data[1];
        output.C = this.nullspace.data[2];
        output.D = this.nullspace.data[3];
        output.E = this.nullspace.data[4];
        output.F = this.nullspace.data[5];
        return true;
    }

    public SolveNullSpace<FMatrixRMaj> getSolver() {
        return this.solver;
    }

    public void setSolver(SolveNullSpace<FMatrixRMaj> solver) {
        this.solver = solver;
    }
}

