/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.transform.pyramid.PyramidFloatGaussianScale;
import boofcv.alg.transform.pyramid.PyramidFloatScale;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidFloat;

public class UtilDenseOpticalFlow {
    public static <T extends ImageGray<T>> PyramidFloat<T> standardPyramid(int width, int height, double scale, double sigma, int minSize, int maxLayers, Class<T> imageType) {
        double desiredReduction;
        int numScales;
        if (scale > 1.0 || scale < 0.0) {
            throw new IllegalArgumentException("Scale must be 0 <= scale <= 1");
        }
        if (scale == 1.0 || maxLayers == 1) {
            numScales = 1;
        } else if (scale == 0.0) {
            numScales = maxLayers;
            desiredReduction = (double)minSize / (double)Math.min(width, height);
            scale = Math.pow(desiredReduction, 1.0 / (double)(numScales - 1));
        } else {
            desiredReduction = (double)minSize / (double)Math.min(width, height);
            numScales = (int)(Math.log(desiredReduction) / Math.log(scale) + 0.5);
            if (numScales > maxLayers) {
                numScales = maxLayers;
            }
            scale = Math.pow(desiredReduction, 1.0 / (double)numScales);
            ++numScales;
        }
        InterpolatePixelS<T> interp = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
        if (sigma > 0.0) {
            double layerSigma = sigma * Math.sqrt(Math.pow(scale, -2.0) - 1.0);
            double[] scaleFactors = new double[numScales];
            double[] scaleSigmas = new double[numScales];
            scaleFactors[0] = 1.0;
            scaleSigmas[0] = layerSigma;
            for (int i = 1; i < numScales; ++i) {
                scaleFactors[i] = scaleFactors[i - 1] / scale;
                scaleSigmas[i] = layerSigma;
            }
            return new PyramidFloatGaussianScale<T>(interp, scaleFactors, scaleSigmas, imageType);
        }
        double[] scaleFactors = new double[numScales];
        scaleFactors[0] = 1.0;
        for (int i = 1; i < numScales; ++i) {
            scaleFactors[i] = scaleFactors[i - 1] / scale;
        }
        return new PyramidFloatScale<T>(interp, scaleFactors, imageType);
    }
}

