/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.concurrency.BoofConcurrency;
import boofcv.concurrency.DWorkArrays;
import boofcv.concurrency.FWorkArrays;
import boofcv.concurrency.IWorkArrays;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ImplConvolveMean_MT {
    public static void horizontal(GrayU8 input, GrayI8 output, int offset, int length) {
        int divisor = length;
        int halfDivisor = divisor / 2;
        BoofConcurrency.loopFor(0, input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + offset;
            int total = 0;
            int indexEnd = indexIn + length;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut++] = (byte)((total + halfDivisor) / divisor);
            indexEnd = indexIn + input.width - length;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - length] & 0xFF;
                output.data[indexOut++] = (byte)(((total += input.data[indexIn] & 0xFF) + halfDivisor) / divisor);
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayU8 input, GrayI8 output, int offset, int length, IWorkArrays work) {
        if (work == null) {
            work = new IWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        IWorkArrays _work = work;
        int backStep = length * input.stride;
        int offsetEnd = length - offset - 1;
        int divisor = length;
        int halfDivisor = divisor / 2;
        BoofConcurrency.loopBlocks(offset, output.height - offsetEnd, length, (y0, y1) -> {
            int indexIn;
            int indexOut;
            int[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                int total = 0;
                int indexEnd = indexIn + input.stride * length;
                for (indexIn = input.startIndex + (y0 - offset) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn] & 0xFF;
                }
                totals[x] = total;
                output.data[indexOut] = (byte)((total + halfDivisor) / divisor);
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + offsetEnd) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    int total = totals[x] - (input.data[indexIn - backStep] & 0xFF);
                    totals[x] = total += input.data[indexIn] & 0xFF;
                    output.data[indexOut] = (byte)((total + halfDivisor) / divisor);
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
            _work.recycle(totals);
        });
    }

    public static void horizontal(GrayS16 input, GrayI16 output, int offset, int length) {
        int divisor = length;
        int halfDivisor = divisor / 2;
        BoofConcurrency.loopFor(0, input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + offset;
            int total = 0;
            int indexEnd = indexIn + length;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = (short)((total + halfDivisor) / divisor);
            indexEnd = indexIn + input.width - length;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - length];
                output.data[indexOut++] = (short)(((total += input.data[indexIn]) + halfDivisor) / divisor);
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayS16 input, GrayI16 output, int offset, int length, IWorkArrays work) {
        if (work == null) {
            work = new IWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        IWorkArrays _work = work;
        int backStep = length * input.stride;
        int offsetEnd = length - offset - 1;
        int divisor = length;
        int halfDivisor = divisor / 2;
        BoofConcurrency.loopBlocks(offset, output.height - offsetEnd, length, (y0, y1) -> {
            int indexIn;
            int indexOut;
            int[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                int total = 0;
                int indexEnd = indexIn + input.stride * length;
                for (indexIn = input.startIndex + (y0 - offset) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn];
                }
                totals[x] = total;
                output.data[indexOut] = (short)((total + halfDivisor) / divisor);
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + offsetEnd) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    int total = totals[x] - input.data[indexIn - backStep];
                    totals[x] = total += input.data[indexIn];
                    output.data[indexOut] = (short)((total + halfDivisor) / divisor);
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
            _work.recycle(totals);
        });
    }

    public static void horizontal(GrayU16 input, GrayI16 output, int offset, int length) {
        int divisor = length;
        int halfDivisor = divisor / 2;
        BoofConcurrency.loopFor(0, input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + offset;
            int total = 0;
            int indexEnd = indexIn + length;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFFFF;
            }
            output.data[indexOut++] = (short)((total + halfDivisor) / divisor);
            indexEnd = indexIn + input.width - length;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - length] & 0xFFFF;
                output.data[indexOut++] = (short)(((total += input.data[indexIn] & 0xFFFF) + halfDivisor) / divisor);
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayU16 input, GrayI16 output, int offset, int length, IWorkArrays work) {
        if (work == null) {
            work = new IWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        IWorkArrays _work = work;
        int backStep = length * input.stride;
        int offsetEnd = length - offset - 1;
        int divisor = length;
        int halfDivisor = divisor / 2;
        BoofConcurrency.loopBlocks(offset, output.height - offsetEnd, length, (y0, y1) -> {
            int indexIn;
            int indexOut;
            int[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                int total = 0;
                int indexEnd = indexIn + input.stride * length;
                for (indexIn = input.startIndex + (y0 - offset) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn] & 0xFFFF;
                }
                totals[x] = total;
                output.data[indexOut] = (short)((total + halfDivisor) / divisor);
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + offsetEnd) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    int total = totals[x] - (input.data[indexIn - backStep] & 0xFFFF);
                    totals[x] = total += input.data[indexIn] & 0xFFFF;
                    output.data[indexOut] = (short)((total + halfDivisor) / divisor);
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
            _work.recycle(totals);
        });
    }

    public static void horizontal(GrayF32 input, GrayF32 output, int offset, int length) {
        float divisor = length;
        BoofConcurrency.loopFor(0, input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + offset;
            float total = 0.0f;
            int indexEnd = indexIn + length;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total / divisor;
            indexEnd = indexIn + input.width - length;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - length];
                output.data[indexOut++] = (total += input.data[indexIn]) / divisor;
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayF32 input, GrayF32 output, int offset, int length, FWorkArrays work) {
        if (work == null) {
            work = new FWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        FWorkArrays _work = work;
        int backStep = length * input.stride;
        int offsetEnd = length - offset - 1;
        float divisor = length;
        BoofConcurrency.loopBlocks(offset, output.height - offsetEnd, length, (y0, y1) -> {
            int indexIn;
            int indexOut;
            float[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                float total = 0.0f;
                int indexEnd = indexIn + input.stride * length;
                for (indexIn = input.startIndex + (y0 - offset) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn];
                }
                totals[x] = total;
                output.data[indexOut] = total / divisor;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + offsetEnd) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float total = totals[x] - input.data[indexIn - backStep];
                    totals[x] = total += input.data[indexIn];
                    output.data[indexOut] = total / divisor;
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
            _work.recycle(totals);
        });
    }

    public static void horizontal(GrayF64 input, GrayF64 output, int offset, int length) {
        double divisor = length;
        BoofConcurrency.loopFor(0, input.height, y -> {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + offset;
            double total = 0.0;
            int indexEnd = indexIn + length;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total / divisor;
            indexEnd = indexIn + input.width - length;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - length];
                output.data[indexOut++] = (total += input.data[indexIn]) / divisor;
                ++indexIn;
            }
        });
    }

    public static void vertical(GrayF64 input, GrayF64 output, int offset, int length, DWorkArrays work) {
        if (work == null) {
            work = new DWorkArrays(input.width);
        } else {
            work.reset(input.width);
        }
        DWorkArrays _work = work;
        int backStep = length * input.stride;
        int offsetEnd = length - offset - 1;
        double divisor = length;
        BoofConcurrency.loopBlocks(offset, output.height - offsetEnd, length, (y0, y1) -> {
            int indexIn;
            int indexOut;
            double[] totals = _work.pop();
            for (int x = 0; x < input.width; ++x) {
                indexOut = output.startIndex + output.stride * y0 + x;
                double total = 0.0;
                int indexEnd = indexIn + input.stride * length;
                for (indexIn = input.startIndex + (y0 - offset) * input.stride + x; indexIn < indexEnd; indexIn += input.stride) {
                    total += input.data[indexIn];
                }
                totals[x] = total;
                output.data[indexOut] = total / divisor;
            }
            for (int y = y0 + 1; y < y1; ++y) {
                indexIn = input.startIndex + (y + offsetEnd) * input.stride;
                indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    double total = totals[x] - input.data[indexIn - backStep];
                    totals[x] = total += input.data[indexIn];
                    output.data[indexOut] = total / divisor;
                    ++x;
                    ++indexIn;
                    ++indexOut;
                }
            }
            _work.recycle(totals);
        });
    }
}

