/*
 * Decompiled with CFR 0.152.
 */
package org.mb.listeners;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Random;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Loader;
import javassist.LoaderClassPath;
import org.mb.listeners.CannotCreateListenerProxyException;
import org.mb.listeners.IListenerManager;

public class GenListenerManager<T>
implements IListenerManager<T> {
    private static int s_nCount = 0;
    private WeakReference<T>[] m_arrListeners;
    private boolean m_bAllowDuplicates;
    private Class<T> m_objClass;
    private T m_objProxy;

    public GenListenerManager(Class objClass) throws CannotCreateListenerProxyException {
        this(objClass, GenListenerManager.class.getClassLoader());
    }

    public GenListenerManager(Class objClass, boolean bAllowDuplicates) throws CannotCreateListenerProxyException {
        this(objClass, GenListenerManager.class.getClassLoader(), bAllowDuplicates);
    }

    public GenListenerManager(Class objClass, ClassLoader objLoader) throws CannotCreateListenerProxyException {
        this(objClass, objLoader, false);
    }

    public GenListenerManager(Class objClass, ClassLoader objLoader, boolean bAllowDuplicates) throws CannotCreateListenerProxyException {
        if (!objClass.isInterface()) {
            throw new IllegalArgumentException("The listener type " + this.m_objClass + " must be an interface");
        }
        this.m_objClass = objClass;
        this.m_bAllowDuplicates = bAllowDuplicates;
        this.m_arrListeners = new WeakReference[0];
        this.createProxy(objClass, objLoader);
    }

    @Override
    public synchronized void addListener(T objListener) throws IllegalArgumentException {
        if (!this.m_objClass.isInstance(objListener)) {
            throw new IllegalArgumentException("The listener must of type " + this.m_objClass);
        }
        this.cleanListenerArray();
        WeakReference<T>[] arrListeners = this.m_arrListeners;
        if (!this.m_bAllowDuplicates) {
            for (int i = 0; i < arrListeners.length; ++i) {
                Object objObject = arrListeners[i].get();
                if (!objListener.equals(objObject)) continue;
                return;
            }
        }
        int nPreviousSize = arrListeners.length;
        WeakReference[] arrNewListeners = new WeakReference[nPreviousSize + 1];
        System.arraycopy(arrListeners, 0, arrNewListeners, 0, nPreviousSize);
        arrNewListeners[nPreviousSize] = new WeakReference<T>(objListener);
        this.m_arrListeners = arrNewListeners;
    }

    private synchronized void cleanListenerArray() {
        int i;
        int[] indexes = new int[this.m_arrListeners.length];
        int j = 0;
        WeakReference<T>[] arrListeners = this.m_arrListeners;
        for (i = 0; i < arrListeners.length; ++i) {
            if (arrListeners[i].get() == null) continue;
            indexes[j++] = i;
        }
        if (j != arrListeners.length) {
            arrListeners = new WeakReference[j];
            for (i = 0; i < arrListeners.length; ++i) {
                arrListeners[i] = this.m_arrListeners[indexes[i]];
            }
        }
        this.m_arrListeners = arrListeners;
    }

    @Override
    public synchronized void removeListener(T objListener) throws IllegalArgumentException {
        if (!this.m_objClass.isInstance(objListener)) {
            throw new IllegalArgumentException("The listener must of type " + this.m_objClass);
        }
        this.cleanListenerArray();
        int nPos = this.findListenerIndex(objListener);
        if (nPos < 0) {
            return;
        }
        WeakReference<T>[] arrListeners = this.m_arrListeners;
        int nPreviousLength = arrListeners.length;
        WeakReference[] arrNewListeners = new WeakReference[nPreviousLength - 1];
        System.arraycopy(arrListeners, 0, arrNewListeners, 0, nPos);
        System.arraycopy(arrListeners, nPos + 1, arrNewListeners, nPos, nPreviousLength - nPos - 1);
        this.m_arrListeners = arrNewListeners;
    }

    @Override
    public synchronized boolean isListener(T objListener) {
        return this.findListenerIndex(objListener) >= 0;
    }

    protected int findListenerIndex(T objListener) {
        WeakReference<T>[] arrListeners = this.m_arrListeners;
        int nLength = arrListeners.length;
        for (int i = nLength - 1; i >= 0; --i) {
            Object objObject = arrListeners[i].get();
            if (!objListener.equals(objObject)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized T[] getListeners() {
        this.cleanListenerArray();
        Object[] arrListeners = (Object[])Array.newInstance(this.m_objClass, this.m_arrListeners.length);
        for (int i = 0; i < this.m_arrListeners.length; ++i) {
            arrListeners[i] = this.m_arrListeners[i].get();
        }
        return arrListeners;
    }

    @Override
    public T getProxy() {
        return this.m_objProxy;
    }

    private void createProxy(Class<T> objClass, ClassLoader objLoader) throws CannotCreateListenerProxyException {
        ClassPool objProxyClassPool;
        ClassPool objThisClassPool;
        ClassPool objInterfaceClassPool;
        ClassLoader objInterfaceLoader = objClass.getClassLoader();
        if (objInterfaceLoader == null) {
            objInterfaceClassPool = ClassPool.getDefault();
        } else {
            objInterfaceClassPool = new ClassPool(null);
            objInterfaceClassPool.insertClassPath((ClassPath)new LoaderClassPath(objInterfaceLoader));
        }
        ClassLoader objThisLoader = this.getClass().getClassLoader();
        if (objThisLoader == objInterfaceLoader) {
            objThisClassPool = objInterfaceClassPool;
        } else if (objThisLoader == null) {
            objThisClassPool = ClassPool.getDefault();
        } else {
            objThisClassPool = new ClassPool(null);
            objThisClassPool.insertClassPath((ClassPath)new LoaderClassPath(objThisLoader));
        }
        if (objLoader == objInterfaceLoader) {
            objProxyClassPool = objInterfaceClassPool;
        } else if (objLoader == null) {
            objProxyClassPool = ClassPool.getDefault();
        } else {
            objProxyClassPool = new ClassPool(null);
            objProxyClassPool.insertClassPath((ClassPath)new LoaderClassPath(objLoader));
        }
        String strInterfaceClass = objClass.getName();
        String strProxyClass = this.generateProxyName(strInterfaceClass);
        CtClass objProxyClass = objProxyClassPool.makeClass(strProxyClass);
        try {
            CtClass objInterfaceClass = objInterfaceClassPool.get(strInterfaceClass);
            objProxyClass.addInterface(objInterfaceClass);
            CtClass objThisClass = objThisClassPool.get(this.getClass().getName());
            CtField objField = new CtField(objThisClass, "_mgr", objProxyClass);
            objProxyClass.addField(objField);
            String strConstructorBody = "{\n  _mgr = $1;}\n";
            CtConstructor objConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{objThisClass}, null, (String)strConstructorBody, (CtClass)objProxyClass);
            objProxyClass.addConstructor(objConstructor);
            CtMethod[] arrMethods = objInterfaceClass.getDeclaredMethods();
            for (int i = 0; i < arrMethods.length; ++i) {
                CtMethod objMethod = arrMethods[i];
                CtMethod objNewMethod = CtNewMethod.copy((CtMethod)objMethod, (CtClass)objProxyClass, null);
                CtClass objReturnType = objNewMethod.getReturnType();
                String strBody = objReturnType == CtClass.voidType ? "{ \n  java.lang.Object[] listeners = _mgr.getListeners();  int size = listeners.length;\n  for (int i = 0; i < size; i++) {\n    " + strInterfaceClass + " listener = (" + strInterfaceClass + ") listeners[i];\n" + "    if (listener != null) { \n" + "      listener." + objNewMethod.getName() + "($$);\n" + "    }\n" + "  }\n" + "}" : "{ \n  java.lang.Object[] listeners = _mgr.getListeners();  int size = listeners.length;\n  for (int i = 0; i < size; i++) {\n    " + strInterfaceClass + " listener = (" + strInterfaceClass + ") listeners[i];\n" + "    if (listener != null) { \n" + "      " + objReturnType.getName() + " ret = listener." + objNewMethod.getName() + "($$);\n" + "      if (i+1 == size) return ret;\n" + "    }\n" + "  }\n" + "  throw new java.lang.IllegalStateException(\"Cannot return a value -- there are no listeners\");\n" + "}";
                objNewMethod.setBody(strBody);
                objProxyClass.addMethod(objNewMethod);
            }
            Loader objCtLoader = new Loader(objLoader, objProxyClassPool);
            objCtLoader.delegateLoadingOf(objInterfaceClass.getName());
            objCtLoader.delegateLoadingOf(this.getClass().getName());
            Class objRealProxyClass = objCtLoader.loadClass(strProxyClass);
            Constructor<?> objConstruct = objRealProxyClass.getConstructors()[0];
            Class<?> objMyClass = this.getClass();
            this.m_objProxy = objConstruct.newInstance(this);
        }
        catch (Exception e) {
            throw new CannotCreateListenerProxyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateProxyName(String strBase) {
        Class<GenListenerManager> clazz = GenListenerManager.class;
        synchronized (GenListenerManager.class) {
            int nCount = s_nCount++;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            String strName = strBase + "$listenerProxy" + nCount;
            if (strName.startsWith("java")) {
                strName = "listenerProxy." + strName;
            }
            return strName;
        }
    }

    @Override
    public synchronized void clear() {
        this.m_arrListeners = new WeakReference[0];
    }

    static {
        Random objRand = new Random();
        s_nCount = objRand.nextInt(0x3FFFFFFF);
    }
}

