/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import org.eclipse.swt.tools.internal.ASTClass;
import org.eclipse.swt.tools.internal.ASTItem;
import org.eclipse.swt.tools.internal.ASTMethod;
import org.eclipse.swt.tools.internal.ASTType;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.MetaData;

public class ASTParameter
extends ASTItem
implements JNIParameter {
    ASTMethod method;
    int parameter;
    String name;
    String data;

    public ASTParameter(ASTMethod method, int parameter, String name) {
        this.method = method;
        this.parameter = parameter;
        this.name = name;
    }

    @Override
    public String getCast() {
        String cast = ((String)this.getParam("cast")).trim();
        if (cast.length() > 0) {
            if (!cast.startsWith("(")) {
                cast = "(" + cast;
            }
            if (!cast.endsWith(")")) {
                cast = String.valueOf(cast) + ")";
            }
        }
        return cast;
    }

    @Override
    public String getMetaData() {
        if (this.data != null) {
            return this.data;
        }
        MetaData metaData = this.method.declaringClass.metaData;
        String className = this.method.getDeclaringClass().getSimpleName();
        String key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this.method) + "_" + this.parameter;
        String value = metaData.getMetaData(key, null);
        if (value == null) {
            key = String.valueOf(className) + "_" + this.method.getName() + "_" + this.parameter;
            value = metaData.getMetaData(key, null);
        }
        if (value == null && this.method.getName().startsWith("_") && (value = metaData.getMetaData(key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this.method).substring(2) + "_" + this.parameter, null)) == null) {
            key = String.valueOf(className) + "_" + this.method.getName().substring(1) + "_" + this.parameter;
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public JNIMethod getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public JNIClass getTypeClass() {
        ASTType type = (ASTType)this.getType();
        ASTClass declaringClass = this.method.declaringClass;
        String sourcePath = declaringClass.resolver.findPath(type.getSimpleName());
        return new ASTClass(sourcePath, declaringClass.metaData);
    }

    @Override
    public JNIType getType() {
        return this.method.getParameterTypes()[this.parameter];
    }

    @Override
    public JNIType getType64() {
        return this.method.getParameterTypes64()[this.parameter];
    }

    @Override
    public int getParameter() {
        return this.parameter;
    }

    @Override
    public void setCast(String str) {
        this.setParam("cast", str);
    }

    @Override
    public void setMetaData(String value) {
        this.data = value;
    }
}

