// Karma configuration
// Generated on Sat Nov 08 2014 19:20:47 GMT-0700 (MST)

module.exports = function (config) {
    config.set({

        // base path that will be used to resolve all patterns (eg. files, exclude)
        basePath: '../../',


        // frameworks to use
        // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
        frameworks: ['jasmine'],

        proxies: {
            '/dashboard/':'ca.infodata.ofys.ui.dashboard/dashboard/',
            '/tools/':'ca.infodata.ofys.data.middle.dataobjects_client/tools/'
        },
        // list of files / patterns to load in the browser
        files: [
            'ca.infodata.ofys.data.middle.dataobjects_client/tools/js/lib/angular.min.js',
            'ca.infodata.ofys.data.middle.dataobjects_client/tools/js/lib/jquery-3.2.1.min.js',
            'ca.infodata.ofys.data.middle.dataobjects_client/tools/js/lib/angular.min.js',
            'ca.infodata.ofys.data.middle.dataobjects_client/tools/moment.min.js',
            'ca.infodata.ofys.data.middle.dataobjects_client/tools/js/lib/fullcalendar.js',
            'ca.infodata.ofys.data.middle.dataobjects_client/tools/js/lib/*.js',
            'ca.infodata.ofys.data.middle.dataobjects_client/tools/js/infodata/*.js',
            'ca.infodata.ofys.data.middle.dataobjects_client/tools/autocomplete.js',
            'ca.infodata.ofys.ui.dashboard/dashboard/index.html',
            'ca.infodata.ofys.ui.dashboard/dashboard/resources/ofys/*/*.html',
            'ca.infodata.ofys.ui.dashboard/dashboard/resources/ofys/*/*/*.html',
            'ca.infodata.ofys.ui.dashboard/dashboard/resources/css/*.css',
            'ca.infodata.ofys.ui.dashboard/dashboard/resources/ofys/*/*.js',
            'ca.infodata.ofys.ui.dashboard/dashboard_test/src/spec/*.spec.js',
            // 'ca.infodata.ofys.ui.dashboard/dashboard_test/node_modules/angular-mocks/angular-mocks.js',
        ],

        ngHtml2JsPreprocessor: {
          stripPrefix: ['ca.infodata.ofys.ui.dashboard', 'ca.infodata.ofys.data.middle.dataobjects_client'],
          //stripSufix: '.ext',

          // setting this option will create only a single module that contains templates
          // from all the files, so you can load them all with module('foo')
          moduleName: 'myAppTemplates'
        },

        // list of files to exclude
        exclude: [],


        // preprocess matching files before serving them to the browser
        // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
        preprocessors: {
          'ca.infodata.ofys.ui.dashboard/dashboard/resources/ofys/*/*.html': ['ng-html2js']
        },


        // test results reporter to use
        // possible values: 'dots', 'progress'
        // available reporters: https://npmjs.org/browse/keyword/karma-reporter
        reporters: ['progress'],


        // web server port
        port: 9876,


        // enable / disable colors in the output (reporters and logs)
        colors: true,


        // level of logging
        // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
        logLevel: config.LOG_INFO,


        // enable / disable watching file and executing tests whenever any file changes
        autoWatch: true,


        // start these browsers
        // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
        browsers: ['Chrome'],


        // Continuous Integration mode
        // if true, Karma captures browsers, runs the tests and exits
        singleRun: false
    });
};
