(function () {
	var task = angular.module("task", ['ui.grid', 'ui.grid.selection', 'ui.grid.pagination', 'ui.bootstrap', 'patient']);

	task.run(function ($templateCache, $http) {
		$http.get('/dashboard/resources/ofys/user/user_dataItem.html?v=bf').then(
			function (res) {
				$templateCache.put('/dashboard/resources/ofys/user/user_dataItem.html?v=bf', res.data);
			}
		);
	});

	task.factory('TaskAccessor', ['DashAPI', 'MessageLink', 'model', '$state', '$filter', 'PatientAccessor', 'QuickEdit',
		function (DashAPI, MessageLink, model, $state, $filter, PatientAccessor, QuickEdit) {
			var accessor = {
				taskProgress: {
					SO: 0,
					RECU: 1,
					EN_COURS2: 2,
					EN_COURS20: 20,
					EN_COURS40: 40,
					EN_COURS60: 60,
					EN_COURS80: 80,
					EN_COURS100: 100,
				},
				patientlist: function (data, callback, error) {
					DashAPI.get('/dashboard/tasks/ws/list/bypat?id=' + data.id, callback, error);
				},
				find: function (query, callback, error) {
					return DashAPI.post('/dashboard/tasks/ws/find', query, callback, error);
				},
				findIds: function (query, callback, error) {
					return DashAPI.post('/dashboard/tasks/ws/findIds', query, callback, error);
				},
				byIds: function (data, callback, error) {
					return DashAPI.get('/dashboard/tasks/ws/byIds?ids=' + data.ids, callback, error);
				},
				openNew: function (data, callback, error) {
					var act = { className: "CTask" };
					var payload = { quickEditData: { qeActData: { className: "CTask" } }, templateUrl: "qe_task_editor_index.html", heading: $filter('translate')('NEW_TASK')};
					if(data){
						$.extend(act, data);
						payload.qe = { task: act, parseMessage: true };
					}
					return QuickEdit.open(payload);
				},
//				open: function (id, callback, error) {
//					return DashAPI.get('/dashboard/tasks/ws/openTask?id=' + id, callback, error);
//				},
				save: function (task, callback, error) {
					return DashAPI.post('/dashboard/tasks/ws/save', task, callback, error);
				},
				// Procédure pour el Reminder
				showReminderHtml: function () {
					var d = moment().add(1, 'weeks').isoWeekday(1)
					var html = $filter("translate")("TextReminderHelp", {
						nextMonday: d.format("D MMMM YYYY"), 
						nextTuesday:d.add(1, 'day').format("D MMMM YYYY")
					}).replaceAll('&lt;', '<').replaceAll('&gt;','>');
					return html;
				},
				// pour les cas où le nom attribué à la tâche est un employé ou un user
				getUserName: function (id) {
					if (!angular.isUndefined(id) && !angular.isUndefined(model.user().list[id])) {
						var user = model.user().list[id];
						if (!angular.isUndefined(user.personName)) {
							return user.personName;
						} else if (!angular.isUndefined(user.str)) {
							return user.str;
						}
					} else {
						return null;
					}
				},
				getFromUserName: function (task) {
					if (!angular.isUndefined(task.fromUserNMd)) {
						return task.fromUserNMd;
					} else if (!angular.isUndefined(task.fromUserNEmp)) {
						return task.fromUserNEmp;
					} else if (!angular.isUndefined(task.fromUserNClin)) {
						return task.fromUserNClin;
					} else {
						return null;
					}
				},
				initTask: function (task) {
					task.viewbag = {
						editMode: false
					};
					task.fromUserName = accessor.getFromUserName(task);
					if (!angular.isUndefined(task.toUser) && task.toUser>-1) {
						task.toUserName = accessor.getUserName(task.toUser);
					} else if (!angular.isUndefined(task.toGroup) && task.toGroup>-1) {
						task.toUserName = accessor.getUserName(task.toGroup);
					}
					//la tâche qui n'a pas de destinataire -> pas de rappel, ne peut pas avoir de reminder
					if (angular.isUndefined(task.toUser) && angular.isUndefined(task.toGroup)) {
						task.viewbag.disabledReminder = true;
					} else {
						task.viewbag.disabledReminder = false;
					}
//					if (angular.isDefined(task.idPatient) && angular.isUndefined(task.patient)) {
//						PatientAccessor.getPatient(task.idPatient, function (res) {
//							task.patient = res.data;
//						});
//					}
					// pour que le checkBox soit coché dans la page
					if (angular.isDefined(task.completionDatetime)) {
						task.viewbag.isComplete = true;
						//la checkbox Rappel est désactivée
						task.viewbag.disabledReminder = true;
					} else {
						task.viewbag.isComplete = false;
						task.viewbag.disabledReminder = false;
					}
				},
				msgLinkMap:{},//Used for message/task link of current document.
				updateMessageLink: function (patient,scope){
					accessor.messageLinkKey = MessageLink.setLinkType({
						patient: patient.id,
						linkType: MessageLink.linkTypes.patient,
						id: patient.id,
						pat: patient
					},scope);
					accessor.msgLinkMap[patient.uid] = accessor.messageLinkKey
				}
			};
			return accessor;
		}]);

	task.controller('TaskController', ['$scope', 'TaskAccessor', 'model', '$filter', '$stateParams','QValidation','UserAccessor',
		function ($scope, TaskAccessor, model, $filter, $stateParams, QValidation, UserAccessor) {
			model.task().tabLoaded = true;
			if(!$scope.userSearchable){
				UserAccessor.listUsersForSelection(function (res) {
					$scope.userSearchable = UserAccessor.cleanAndSortUsers(res.data);
					var grps = $filter('orderBy')(OfysUtils.ObjectValuesAsArray(model.user().groups), 'name');
					$scope.userSearchable = grps.concat($scope.userSearchable);
				});
			}
            $scope.taskSettings= {};
            model.addPrefSettings([
                 'st0','st1','st2', 'st20', 'st40','st60','st80', 'st100',
                 'stcol0','stcol1','stcol2', 'stcol20', 'stcol40','stcol60','stcol80', 'stcol100'
                ], $scope.taskSettings, 'task_settings_');
                
            $scope.getProgressColor = function (p) {
				return $scope.taskSettings['stcol' + TaskAccessor.taskProgress[p]]();
			};
			$scope.catEdit = {
				st20: {editMode:false, name: $scope.taskSettings.st20(), col: $scope.taskSettings.stcol20()},
				st40: {editMode:false, name: $scope.taskSettings.st40(), col: $scope.taskSettings.stcol40()},
				st60: {editMode:false, name: $scope.taskSettings.st60(), col: $scope.taskSettings.stcol60()},
				st80: {editMode:false, name: $scope.taskSettings.st80(), col: $scope.taskSettings.stcol80()}
			};

			$scope.editCat = function (c) {
				if($scope.catEdit[c].editMode!=true){
					$scope.catEdit[c].editName = $scope.catEdit[c].name;
					$scope.catEdit[c].editMode = true;
                    model.taskDataUpdate(true);
				}
			};
			$scope.editCatCol = function (c) {
				if($scope.catEdit[c].editMode!=true){
					$scope.catEdit[c].editCol = $scope.catEdit[c].col;
					$scope.catEdit[c].editMode = true;
				}
			};
			
			$scope.commitCat = function(c){
				if($scope.catEdit[c].editName!=undefined){
					var saveC = angular.copy($scope.catEdit[c]);
					saveC.name = $scope.catEdit[c].editName;
					if (saveC.name.trim()=='') {
						$scope.taskSettings[c](null);
					} else {
						$scope.taskSettings[c](saveC.name);
					}
					$scope.catEdit[c].editMode = false;
					$scope.catEdit[c].name = saveC.name;
					delete $scope.catEdit[c].editName;
                    model.taskDataUpdate(true);
				}else{
					$scope.catEdit[c].editMode = false;
					delete $scope.catEdit[c].editName;
				}
			}
			
			$scope.commitCatCol = function(c){
				if($scope.catEdit[c].editCol!==undefined){
					var saveC = angular.copy($scope.catEdit[c]);
					saveC.col = $scope.catEdit[c].editCol;
					$scope.taskSettings[c](saveC.col);
					$scope.catEdit[c].editMode = false;
					$scope.catEdit[c].col = saveC.col;
					delete $scope.catEdit[c].editCol;
                    model.taskDataUpdate(true);
				}else{
					$scope.catEdit[c].editMode = false;
					delete $scope.catEdit[c].editCol;
				}
			}
			
			$scope.showStringsFromObjArray = function(a, v, sep) {
				return _.pluck(a, v).join(sep);
			};
			
			$scope.getStatPref = function(v) {
				if (v>2 && v<100) {
					var fromTranslate = $filter('translate')('task_st' + v);
					var fromPref = model.prefSettings('task_settings_st'+v);
					var t;
					if (fromTranslate==fromPref || fromPref==null) {
						t = fromTranslate; 
					} else {
						t = fromTranslate + ': ' + fromPref;
					}
					return {pref: t};
				}				
				return {};
			};
			
			model.activeController('task');
			$scope.isModeWithIds = false;
			$scope.activeIds = null;
			$scope.isLoading = false;

			function currFilterShortcut(s){
				$scope.currFilterShorcut = s;
				model.task().currFilterShorcut = s;
				// console.log(model.task().currFilterShorcut);
			}
			currFilterShortcut(model.task().currFilterShorcut);
			$scope.taskOptions = model.task().currFilterShorcut;
			$scope.subMenuCount = function (sub) {
				var idProf = model.user().profil ? model.user().profil.id : undefined;
				if ($scope.currFilterShorcut === 'NB_TASK_ALL') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task();
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_group();
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_LATE') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_late;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_late_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_TODAY') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_tod;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_tod_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SEM') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_sem;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_sem_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SANS_ECHEANCE') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_sans;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_sans_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_URGENT') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_urg;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_urg_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_INPROGRESS') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_ecr;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_ecr_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_NOTED') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_note;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_note_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_STAT1') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_stat1;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_stat1_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_STAT2') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_stat2;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_stat2_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_STAT3') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_stat3;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_stat3_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_STAT4') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_stat4;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_stat4_group;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_OTHER') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_less();
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_group_less();
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SEARCH_SENT_UNCOMPLETED') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_sent_uncompleted;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_sent_uncompleted_others;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SEARCH_SENT_COMPLETED') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_sent_completed;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_sent_completed_others;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SEARCH_RECEIVED_COMPLETED') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_received_completed;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_received_completed_group;
					}
				}

				return 0;
			}

			$scope.subMenuIds = function (sub) {
				var idProf = model.user().profil ? model.user().profil.id : undefined;
				if ($scope.currFilterShorcut === 'NB_TASK_ALL') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_id();
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_group_id();
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_id_total();
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_LATE') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_late_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_late_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_late_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_TODAY') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_tod_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_tod_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_tod_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SEM') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_sem_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_sem_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_sem_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SANS_ECHEANCE') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_sans_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_sans_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_sans_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_URGENT') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_urg_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_urg_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_urg_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_INPROGRESS') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_ecr_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_ecr_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_ecr_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_STAT1') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_stat1_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_stat1_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_stat1_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_STAT2') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_stat2_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_stat2_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_stat2_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_STAT3') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_stat3_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_stat3_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_stat3_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_STAT4') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_stat4_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_stat4_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_stat4_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_NOTED') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_note_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_note_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_note_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_OTHER') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_id_less();
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_group_id_less();
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_id_total_less();
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SEARCH_SENT_UNCOMPLETED') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_sent_uncompleted_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_sent_uncompleted_others_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_sent_uncompleted_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SEARCH_SENT_COMPLETED') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_sent_completed_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_sent_completed_others_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_sent_completed_id_total;
					}
				} else if ($scope.currFilterShorcut === 'NB_TASK_SEARCH_RECEIVED_COMPLETED') {
					if (sub === 'P') {
						return model.dayData(idProf).cnts.task_received_completed_id;
					} else if (sub === 'G') {
						return model.dayData(idProf).cnts.task_received_completed_group_id;
					} else if (sub === 'A') {
						return model.dayData(idProf).cnts.task_received_completed_id_total;
					}
				}

				return [];
			}
			function setListSubMenu(val){
				$scope.listSubMenu = val;
				model.task().listSubMenu = $scope.listSubMenu;
			}
			$scope.isSubMenuActive = function (sub) {
				return $scope.listSubMenu === 'A' | $scope.listSubMenu === sub;
			}

			currFilterShortcut($scope.taskOptions)
			function updateTaskList() {
				initOptions($scope.currFilterShorcut + ':' + $scope.listSubMenu)
				updateDataSourceByIds($scope.subMenuIds($scope.listSubMenu));
			}

			$scope.forceReload = function () {
				$scope.isLoading = true;
				QValidation.closeContext($filter('translate')('taskInEdit')).then(function(){
					$scope.isModeWithIds = false;
					if (model.task().currIds) model.task().currIds.length = 0;
					model.task().todo = [];
					$scope.activeIds = [];
					$scope.taskListCount = 0;
					model.callDashBoardCount(updateTaskList, true); // reloadData called after the return of data from counts.
				});
			};

			var pagination = [];
			var activePage = 0;
			$scope.nextPage = function(dir){
				if ((activePage===0 && dir===-1) || pagination.length===0) {
					return;
				}
				if (pagination.length > activePage+dir) {
					//console.log("get next page"+ activePage + "dir:"+ dir);
					activePage += dir;
					getTaskList(pagination[activePage]);
				}
			}

			function updateDataSourceByIds(ids) {

				if (ids === undefined) {
	 				$scope.isLoading = false;
                    model.taskDataUpdate(true);
					return;
				}

				if (ids.length === 0) {
					model.task().todo.length = 0;
	 				$scope.isLoading = false;					
                    model.taskDataUpdate(true);
					return;
				}
				$scope.isLoading = true;
				model.task().currIds = ids;
				$scope.isModeWithIds = true;
				$scope.activeIds = ids;
				$scope.taskListCount = $scope.activeIds.length;
				var idsString = $scope.activeIds.toString();
				var lstCache = model.taskCached(idsString);
				model.task().todo.length = 0;
				if (lstCache!==undefined) {
					$.merge(model.task().todo, lstCache);
					$scope.isLoading = false;
	                model.taskDataUpdate(true);
				} else {
					pagination.length=0;
					if(ids.length > 50){
						var chuncks = Math.ceil(ids.length/ 25);
						for(var i = 0; i < chuncks; i++){
							var indexStart = i*25;
							pagination.push(ids.slice(indexStart, indexStart+25));
						}
						activePage = 0;
						getTaskList(pagination[activePage]);
					}else{
						getTaskList(ids);
					}
				}
			}

			$scope.filterTypes = model.task().filterTypes;
			$scope.filterQuery = function(q){
				if(q){
					var criteria = getCriteria(q);
					TaskAccessor.findIds(criteria,function(res){
						var resList = res.data && res.data.taskResults ? res.data.taskResults: [];
						if(criteria.toUser){
							if(!$scope.filterTypes.viewbag.recipient){
								var found = $scope.userSearchable.find(function(usr){
									return usr.userId === criteria.toUser;
								});
								if(found){
									$scope.filterTypes.viewbag.recipient = found;
								}
							}
						}
						updateDataSourceByIds(resList);
					});

				}
			}
			var defaultQuery = {
				default: {toUser: model.user().sessionUser.user.id},
				SENT: {fromUser: model.user().sessionUser.user.id},
				COMPLETED: {completed: true, toUser: model.user().sessionUser.user.id}
			};

			function getCriteria(q){
				var criteria = {};
				if($scope.filterTypes.SENT){
					criteria = angular.copy(defaultQuery.SENT);
				}else if($scope.filterTypes.COMPLETED){
					criteria = angular.copy(defaultQuery.COMPLETED);
				}else{
					criteria = angular.copy(defaultQuery.default);
				}

				if($scope.filterTypes.viewbag.recipient){
					if($scope.filterTypes.viewbag.recipient.className === "CUserForSelection"){
						delete criteria.toGroup;
						criteria.toUser = $scope.filterTypes.viewbag.recipient.userId;
					}else if($scope.filterTypes.viewbag.recipient.className === "CPersonGroup"){
						delete criteria.toUser;
						criteria.toGroup = $scope.filterTypes.viewbag.recipient.id;
					}
				}
				if($scope.filterTypes.viewbag.completed){
					criteria.completed = $scope.filterTypes.viewbag.completed === 1;
				}
				if($scope.filterTypes.viewbag.dueStart){
					criteria.dueStart = moment($scope.filterTypes.viewbag.dueStart, 'YYYY-MM-DD').valueOf();
				}
				if($scope.filterTypes.viewbag.dueEnd){
					criteria.dueEnd = moment($scope.filterTypes.viewbag.dueEnd, 'YYYY-MM-DD').valueOf();
				}
				return criteria;
			}

			var exclusiveFilters = ["SENT", "COMPLETED"];
			$scope.searchFilter = function(filterType){
				QValidation.closeContext($filter('translate')('taskInEdit')).then(function(){
					if(exclusiveFilters.indexOf(filterType) != -1){
						exclusiveFilters.forEach(function(filter){
							if(filter !== filterType){
								$scope.filterTypes[filter] = false;
							}
						});

						$scope.filterTypes.viewbag.completed = filterType === exclusiveFilters[1] ? 1: 0;
						$scope.filterTypes.viewbag.dueEnd = "";
						$scope.filterTypes.viewbag.dueStart = "";
						delete $scope.filterTypes.viewbag.recipient;
					}
					if($scope.filterTypes[filterType]){
						$scope.filterTypes[filterType] = false;
					}else{
						$scope.filterTypes[filterType] = true;
					}
					$scope.filterQuery(filterType);
				})
			}

			function getTaskList(pageIds){
				TaskAccessor.byIds({ ids: pageIds }, function success(response) {
					if (response.data && response.data && response.data.length > 0) {
						//var tasks = $filter('orderBy')(response.data, '-createDatetime');
						var tasks = response.data;
						angular.forEach(tasks, function (task) {
								TaskAccessor.initTask(task);
						});
						// model.taskCached(pageIds.toString(), tasks);
						$.merge(model.task().todo, tasks);
					}
					$scope.isLoading = false;
                    model.taskDataUpdate(true);
				}, function fail(res) {
					$scope.isLoading = false;
				});
			}

			function initOptions(str) {
				var opt = str.split(':');
				setListSubMenu(opt.length > 1 ? opt[1] : 'A');
				$scope.taskOptions = opt[0];
			}
			setListSubMenu(model.task().listSubMenu);
			// param possible: {ids_task_late:, ids_task_tod:, ids_task_sem:, ids_task_sans:
			if ($stateParams.ids_task_late != null && $stateParams.ids_task_tod != null
				&& $stateParams.ids_task_sem != null && $stateParams.ids_task_sans != null) {
				var mergedData = _.clone($stateParams.ids_task_late ? $stateParams.ids_task_late : []);
				if ($stateParams.ids_task_tod) {
					mergedData = $.merge(mergedData, $stateParams.ids_task_tod);
				}
				if ($stateParams.ids_task_sem) {
					mergedData = $.merge(mergedData, $stateParams.ids_task_sem);
				}
				if ($stateParams.ids_task_sans) {
					mergedData = $.merge(mergedData, $stateParams.ids_task_sans);
				}
				updateDataSourceByIds(mergedData, 1);
				$scope.taskOptions = 'NB_TASK_ALL';
			} else {
				if ($stateParams.ids_task_late != null) {
					updateDataSourceByIds($stateParams.ids_task_late, 1);
					initOptions($stateParams.type);
				} else if ($stateParams.ids_task_tod != null) {
					updateDataSourceByIds($stateParams.ids_task_tod, 1);
					initOptions($stateParams.type);
				} else if ($stateParams.ids_task_sem != null) {
					updateDataSourceByIds($stateParams.ids_task_sem, 1);
					initOptions($stateParams.type);
				} else if ($stateParams.ids_task_sans != null) {
					updateDataSourceByIds($stateParams.ids_task_sans, 1);
					initOptions($stateParams.type);
				} else {
					if (model.task().todo.length === 0) {
						// donc on affiche les nouveaux message si pas de liste active.
						model.callDashBoardCount(updateTaskList, false);// reloadData called after the return of data from counts.
					} else {
						$scope.isModeWithIds = true;
						$scope.activeIds = model.task().currIds;
						$scope.taskListCount = $scope.activeIds ? $scope.activeIds.length : 0;
					}
					// $scope.listSubMenu = 'P';

				}
			}

			$scope.filterShortcut = function (ids, options) {
				QValidation.closeContext($filter('translate')('taskInEdit')).then(function(){
					initOptions(options);
					if (!ids) {
						ids = []
					}
					currFilterShortcut($scope.taskOptions);
					updateDataSourceByIds(ids);
				})
			};

			$scope.toggleSubMenu = function (sub) {
				QValidation.closeContext($filter('translate')('taskInEdit')).then(function(){
					var opposite = { 'P': 'G', 'G': 'P' }
					var n = 'A';
					if ($scope.isSubMenuActive('A') || $scope.isSubMenuActive(sub)) {
						n = opposite[sub];
					} else if (!$scope.isSubMenuActive(opposite[sub])) {
						n = sub;
					}
					setListSubMenu(n);
					var ids = $scope.subMenuIds($scope.listSubMenu);
					updateDataSourceByIds(ids);
				});
			}

		}]);

		/**
		 * COMMENT: TASK VIEW DIRECTIVE
		 *
		 * View:
		 */
		task.directive('taskView', ['$q', 'model', '$filter', 'TaskAccessor', 'AppointmentAccessor', '$rootScope', 'PatientAccessor', 'UserAccessor','QuickView','Event','QConfirm','MessageLink',
		'utils', '$timeout', 'patientShowTitles', 'EncounterAccessor', 'FormAccessor', 'LabAccessor', 'DocAccessor', 'ModificationStatus','QValidation','Rights',
		function ($q, model, $filter, TaskAccessor, AppointmentAccessor, $rootScope, PatientAccessor, UserAccessor, QuickView, Event, QConfirm, MessageLink, utils,
			$timeout, patientShowTitles, EncounterAccessor, FormAccessor, LabAccessor, DocAccessor, ModificationStatus, QValidation, Rights) {
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/task/task_view.html',
				scope: true,
				link: function (scope, element, attrs) {
					scope.taskStates = [{val:0,name:'AllTaskState'},{val:1,name:'COMPLETED'},{val:2,name:'NotCOMPLETED'}];

					scope.model = model;
		            scope.taskSettings= {};
		            model.addPrefSettings([
		                 'st0','st1','st2', 'st20', 'st40','st60','st80', 'st100',
		                 'stcol0','stcol1','stcol2', 'stcol20', 'stcol40','stcol60','stcol80', 'stcol100'
		            ], scope.taskSettings, 'task_settings_');
		            scope.getProgressColor = function (p) {
						return scope.taskSettings['stcol' + TaskAccessor.taskProgress[p]]();
					};
					scope.getStatPref = function(v) {
						if (v>2 && v<100) {
							var fromTranslate = $filter('translate')('task_st' + v);
							var fromPref = model.prefSettings('task_settings_st'+v);
							var t;
							if (fromTranslate==fromPref || fromPref==null) {
								t = fromTranslate; 
							} else {
								t = fromTranslate + ': ' + fromPref;
							}
							return {pref: t};
						}				
						return {};
					};

					scope.showReminderHtml = TaskAccessor.showReminderHtml;
					function update() {
						var inputTasks = scope.$eval(attrs.inputTasks);
						model.safeCall(addEventsEvent);
						if (!Array.isArray(inputTasks)) {
							scope.tasks = [inputTasks];
						} else {
							scope.tasks = inputTasks;
						}
						angular.forEach(scope.tasks, function (task) {
							if(!task.viewbag){
								TaskAccessor.initTask(task);
							}
						});
						if (scope.quickViewData) {
							// TaskAccessor.updateMessageLink(scope.quickViewData.pat, scope);
							scope.linkManager = MessageLink.linkManager(TaskAccessor, scope.quickViewData.pat, scope.quickViewData.pat.uid, scope)
						}
						scope.viewOptions = scope.$eval(attrs.options);
					}

					scope.taskProgress = TaskAccessor.taskProgress;
					scope.$watch(attrs.options, function(){scope.viewOptions = scope.$eval(attrs.options);});
					scope.dueDynaDateOptions = {
						format: 'YYYY-MM-DD HH:mm',
						acceptFutureDate: true,
						onDateSelected: function (mDate, dAssist) {
							if (scope.currEditTask) {
								var m = mDate ? mDate.format(dAssist.format) : '';
								scope.currEditTask.viewbag.editTask.dueDT = m;
							}
						}
					};

					scope.searchdueStartDynaDateOptions = {
						format: 'YYYY-MM-DD',
						acceptFutureDate: true,
						onDateSelected: function (mDate, dAssist) {
							var m = mDate.format ? mDate.format(dAssist.format): moment(mDate).format(dAssist.format);
							scope.filterTypes.viewbag.dueStart = m;
						}
					};

					scope.searchdueEndDynaDateOptions = {
						format: 'YYYY-MM-DD',
						acceptFutureDate: true,
						onDateSelected: function (mDate, dAssist) {
							var m = mDate.format ? mDate.format(dAssist.format): moment(mDate).format(dAssist.format);
							scope.filterTypes.viewbag.dueEnd = m;
						}
					};

					scope.pageEndCount = 0
					scope.updatePageDisabled = false;
					scope.updatePage = function (directionId) {	// 1 pour down, -1 pour up
						scope.updatePageDisabled = true;
						if(scope.nextPage){
							scope.nextPage(directionId);
						}
						$timeout(function(){
							scope.updatePageDisabled = false;
						}, 1000);
					}

					var defaultTaskData = {};
					function isScrolledIntoView(elem)
					{
						var docViewTop = $(window).scrollTop();
						var docViewBottom = docViewTop + $(window).height();

						var elemTop = $(elem).offset().top;
						var elemBottom = elemTop + $(elem).height();

						return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
					}
					scope.NONEDITABLE_CONSENT = "Refus de consentement / Refusal of consent";
					function activateFinishFirstAnimation(task){

						task.viewbag.finishFirst = true;
						$timeout(function () {
							task.viewbag.finishFirst = false;
						}, 2100);
					}
					
					scope.edit = function (task) {
						if(task && task.note == scope.NONEDITABLE_CONSENT)
						{
							activateFinishFirstAnimation(task)
							return;
						}

						if (scope.currEditTask) {
							var domTask = $('#'+ scope.currEditTask.id);
							if(isScrolledIntoView(domTask)){
								activateFinishFirstAnimation(scope.currEditTask)
							}else{
								domTask[0].scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
								$timeout(function () {
									activateFinishFirstAnimation(scope.currEditTask)
								}, 200);
							}
						} else {
							scope.currEditTask = task;
							task.viewbag.editTask = $.extend(angular.copy(defaultTaskData), angular.copy(task));
							task.viewbag.editMode = true;
							setAssinged(findCurrentlyAssigned(task));
							registerDirty(scope.currEditTask);
						}
	                    model.taskDataUpdate(true);
					}
					var registeredDirtyId;
					function registerDirty(task){
						registeredDirtyId = "task_"+task.id;
						QValidation.registerDirty(registeredDirtyId, function(){
							return scope.save(task.viewbag.editTask, task);
						}, function(){
							return scope.cancel(task);
						});
					}

					function unregisterDirty(){
						if(registeredDirtyId){
							QValidation.unregisterDirty(registeredDirtyId);
							registeredDirtyId = undefined;
						}
					}

					if(scope.qv){
						scope.qv.isDirty = function(){
							return !!(registeredDirtyId);
						};
					}
					scope.cancel = function (task) {
						task.viewbag.editMode = false;
						unregisterDirty();
						scope.currEditTask = null;
	                    model.taskDataUpdate(true);
						return true;
					}

					function clearAssignData() {
						if (scope.currEditTask) {
							delete scope.currEditTask.viewbag.editTask.toGroup;
							delete scope.currEditTask.viewbag.editTask.toUser;
							delete scope.currEditTask.viewbag.toUser;
							delete scope.currEditTask.viewbag.toGroup;

						}
					}
					function isAssigned(task) {
						return !!(task.toUser || task.toGroup);
					}
					
					function removeTaskFromList(task){
						let index = scope.tasks.indexOf(task)
						if(index > -1){
							scope.tasks.splice(index, 1);
						}
					}

					function setAssinged(assignee, orig) {
						AppointmentAccessor.utils.isAbsentToday(assignee);
						if(!orig){
							if(scope.currEditTask && scope.currEditTask.viewbag){
								orig = scope.currEditTask.viewbag.editTask;
							}
						}else{
							orig.viewbag = orig.viewbag ? orig.viewbag: {};
						}
						if (orig && assignee) {
							if (assignee.className === 'CUserForSelection') {
								orig.toUser = assignee.userId;
								orig.viewbag.toUser = assignee;
							} else if (assignee.className === 'CPersonGroup') {
								orig.toGroup = assignee.id;
								orig.viewbag.toGroup = assignee;
							}
						}
					}

					scope.setAssingedTo = function (assignee) {
						clearAssignData();
						setAssinged(assignee);
					};

					function searchUsers(query) {
						var res = [];
						var elem;
						var initialList = filterUserSearchableByWorkSite()
						var q = query.toLowerCase().removeAccentsLc();
						for (var i = 0; i < initialList.length; i++) {
							elem = initialList[i];
							if ((elem.personNameLc && elem.personNameLc.indexOf(q) > -1) ||
								(elem.nameLc && elem.nameLc.indexOf(q) > -1)) {
								res.push(elem);
							}
						}
						return res;
					}

					function findCurrentlyAssigned(task) {
						var id = task.toUser ? task.toUser : task.toGroup;
						var type = task.toUser ? 'CUserForSelection' : 'CPersonGroup';
						if (id) {
							for (var i = 0; i < scope.userSearchable.length; i++) {
								elem = scope.userSearchable[i];
								if ((type === 'CPersonGroup' && id === elem.id) ||
									(type === 'CUserForSelection' && id === elem.userId)) {
									return elem;
								}
							}
						}
					}
					function filterUserSearchableByWorkSite(){
						var res = scope.userSearchable;
						if(model.prefSettings('user_settings_SiteTasks')){
							var workSiteId = model.user().session.workSite.id;
							res = res.filter(function(e){
								if(e && e.sessionSite && e.sessionSite.id){
									if(e.sessionSite.id === workSiteId){
										return true;
									}
									return false;
								}else{
									// if the user does not have a session site.. always display
									return true;
								}
							});
						}
						return res;
					}

					scope.assignedToSearchAssist = {
						assistId: "autocomplete_taskAssignedToQv",
						nextTabOnTab: true,
						nextTabOnEnter: true,
						hasDetails: false,
						hasHeader: false,
						minChar: 0,
						trigger: 'focus',
						updateDataSourceWithValues: function (assistObject) {
							if (scope.userSearchable) {
								assistObject.setData(filterUserSearchableByWorkSite());
							}
						},
						getAsyncData: function (query, assist) {
							return $q(function (resolve, reject) {
								resolve(searchUsers(query));
							});
						},
						getKey: function (recipient) {
							var newScope = $rootScope.$new();
							newScope.item = recipient;
							var res = utils.getTemplateAndCompileSync(newScope, '/dashboard/resources/ofys/user/user_dataItem.html?v=bf');
							$timeout(function () {
								if (!newScope.$$phase) {
									newScope.$digest();
								}
							}, 0);
							return res;
						},
						selection: function (recipient, assistObject) {
							scope.$apply(scope.setAssingedTo(recipient));
		                    model.taskDataUpdate(true);
							return "";
						},
					};

					scope.assignedToFilterSearchAssist = angular.copy(scope.assignedToSearchAssist);
					scope.assignedToFilterSearchAssist.assistId = "autocomplete_taskAssignedToFilter";
					scope.assignedToFilterSearchAssist.selection = function(recipient, assistObject){
						scope.$apply(function(){
							scope.filterTypes.viewbag.recipient = recipient;
						});
						return "";
					};
					if(!scope.userSearchable){
						UserAccessor.listUsersForSelection(function (res) {
							scope.userSearchable = UserAccessor.cleanAndSortUsers(res.data);
							var grps = $filter('orderBy')(OfysUtils.ObjectValuesAsArray(model.user().groups), 'name');
							scope.userSearchable = grps.concat(scope.userSearchable);
						});
					}

					scope.showPatientHtml = function(p, task) {
						if(p != null){
							p.viewbag = {};
							p.viewbag.limitations = Rights.getSessionUserConsent(p);
							return patientShowTitles.showPatientHtml(p);
						}
					};

					scope.isUserAdmin = function(){
						return model.user().isUserAdmin===true;
					}

					/**
					 * COMMENT: TASK VIEW @function
					 *				
					 * Description: Gère l'ouverture des quickview et des vues externes
					 *
					 * @param type: le type de l'object 
					 * @param task: la tâche selectionnée par l'utilisateur
					 */
					scope.openLink = function (type, id, task) {
						if (scope.currEditTask) {
							var domTask = $('#'+ scope.currEditTask.id);
							if(isScrolledIntoView(domTask)){
								activateFinishFirstAnimation(scope.currEditTask)
							}else{
								domTask[0].scrollIntoView({behavior: "smooth", block: "start", inline: "nearest"});
								$timeout(function () {
									activateFinishFirstAnimation(scope.currEditTask)
								}, 200);
							}
						} else {
							var idProf = model.user().profil ? model.user().profil.id : undefined;
//							if(model.summaryExternalViewer && model.summaryExternalViewer.quickViewData.qvActData.isDirty){
//								model.summaryExternalViewer.quickViewData.qvActData.save()
//							}
							if (type) {
								PatientAccessor.getPatient(task.idPatient, function (res) {
									var patient = res.data;
									scope.showPatientHtml(patient);
									var actOptions = { minimize: false, mode: 'n' };
									if (type === 'LABO') {
										LabAccessor.labView({ labProfId: task.idLink, idPatient: task.idPatient }, function (res) {
											var act = LabAccessor.utils.getBaseLab(res.data);
	//										act.prop = { readonly: true };
											patientShowTitles.openActivity(act, actOptions, patient);
										});
									} else if (type === 'SCAN') {
										DocAccessor.docView({id: task.idLink,idProf: idProf}, function (res) {
											var act = res.data;
											patientShowTitles.openActivity(act, actOptions, patient);
										});
									} else if (type === 'RENCONTRE') {
										EncounterAccessor.EncView(task.idLink, function (res) {
											var act = res.data;
											actOptions.openLastEncounter = true;
											patientShowTitles.openActivity(act, actOptions, patient);
										});
									} else if (type === 'FORM') {
										FormAccessor.data(task.idLink, function (res) {
											var act = res;
											patientShowTitles.openActivity(act, actOptions, patient);
										});
									} else if (type === 'PATIENT') {
										actOptions.openLastEncounter = true;
										patientShowTitles.openActivity(patient, actOptions, patient);
									}
								});
							}
						}
					}

					function copyForSave(task) {
						//Data conversion and validation
						if (task.viewbag.editTask) {
							dueDateTime = moment(task.viewbag.editTask.dueDT, scope.dueDynaDateOptions.format).valueOf();
						}
						if (task.viewbag.isComplete) {
							task.completionDatetime = moment().valueOf();
						} else {
							delete task.completionDatetime;
						}
						if (task.completionDatetime && task.toUser==undefined && task.toGroup==undefined) {
							task.toUser = model.user().sessionUser.user.id;
						}
						var res = JSON.parse(OfysUtils.safeStringify(_.omit(task, 'viewbag')));
						if(res.pat && res.pat.viewbag){
							delete res.pat.viewbag;
						}
						if(res.patient && res.patient.viewbag){
							delete res.patient.viewbag;
						}
						res.modificationStatus = ModificationStatus.STATUS_UPDATED;
	                    model.taskDataUpdate(true);
						return res;
					}

					scope.isOkToSend = function () {
						scope.qe.task.viewbag.okToSend = !!(scope.qe.task.note);
					};


					//This function should be normalized and put in quickview function as a helper function
					//It is useful for all quickview activities that need to listen to quickview events
					//especially ones that can have a dirty state
					// - forms, docs, laboratories and eventullly all other items that can be modified
					function addEventsEvent(){
						//Ne pas ajouter les événements si on est pas en mode quick view
						if(!scope.qv){
							return;
						}

						if(!QuickView.eventsActive(scope.qv)){
							return;// event have already been deleted (because of a close or one quickview that triggers another)
						}
						//Si c'est la première ouverture, créer la variable d'événements
						if(!scope.qv.ActiveEventsRef){
							scope.qv.ActiveEventsRef = {};
						}
						//Make sure previously created evens are not referred to
						//Very important to avoid leaks
						QuickView.removeAllEventHandlers(scope);

						function onMinimizeOrClose(event, fct) {
							var act = event.mObj.quickViewData.qvActData;
							if (registeredDirtyId) {
								event.stopPropagation();
								QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}).then(function(save){
									function continueAction(res){
										unregisterDirty();
										scope.ignoreChanges = true;
										//Makes sure the original action is called again in 'fct()'
										//- if changeActivity was the origianl action it should be recalled and
										//   the second time the validation message is not shown because scope.ignoreChanges === true
										if (fct) fct();
									}
									function saveFailedCanNotContinue(res){
										var errMsg = res.statusText ? res.statusText : "";
										model.notice().fail($filter('translate')('docFailedSaveErrMsg', {errMsg: errMsg}));
									}
									if(save){
										if(act && act.viewbag && act.viewbag.editTask){// de fois en prod dans le quickview le act.save n'est pas setter.
											scope.save(act.viewbag.editTask, act).then(continueAction, saveFailedCanNotContinue);
										}else{
											act.save().then(continueAction, saveFailedCanNotContinue);//should change the dirty state to make sure that the second time closing goes through
										}
									}else{
										continueAction();
									}
								});
								return true;
							}
							return false;
						}

						//L'événement existe donc il ne faut pas le recréer
						if(!scope.qv.ActiveEventsRef.onQvClose){
							//Ici elle est appeller ajouté aussi-tot que le viewer s'ouvre donc toujours active
							//Comme le scope n'est pas passé en parametre, le handler est seulement detruit quand le quickview est fermer
							scope.qv.ActiveEventsRef.onQvClose = Event.on(scope.qv.onQvClose,function(event){
								console.log("######Quick view is closing");
								onMinimizeOrClose(event, scope.qv.$$close);
							});
						}

						if(!scope.qv.ActiveEventsRef.onQvMinimize){
							scope.qv.ActiveEventsRef.onQvMinimize = Event.on(scope.qv.onQvMinimize, function(event){
								console.log("######Quick view is minimizing");
								onMinimizeOrClose(event, scope.qv.$$minimize);
								QuickView.removeAllEventHandlers(scope);
							}, scope);
						}

						//événement de changement d'activité
						if(!scope.qv.ActiveEventsRef.onQvActivityChange){
							scope.qv.ActiveEventsRef.onQvActivityChange = Event.on(scope.qv.onQvActivityChange,function(event){
								console.log("######Quick view is changing the activity");
								var newAct = event.newAct;
								onMinimizeOrClose(event, function(){
									if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (newAct)){
										model.actUpdated(true);
										scope.ignoreChanges = false;
										QuickView.removeAllEventHandlers(scope);
									}
								});
							}, scope);
						}

						if(!scope.qv.ActiveEventsRef.onQvExternalize){
							scope.qv.ActiveEventsRef.onQvExternalize = Event.on(scope.qv.onQvExternalize,function(event){
								console.log("######Quick view is externalizing");
								QuickView.removeAllEventHandlers(scope);
							}, scope);
						}
					}

					function sending(isSending) {
						if (isSending) {
							scope.sending = true;
						} else {
							$timeout(function () {
								scope.sending = false;
							}, 300);
						}
					}

					// call quand change le progress
					scope.saveTaskProgress = function(task) {
						if(task.progress === 'EN_COURS100'){
							task.viewbag.isComplete = true;
						} else {
							task.viewbag.isComplete = false;							
						}
	                    model.taskDataUpdate(true);
					};
					// call quand change le complete
					scope.saveTaskComplete = function(task) {
						if (task.viewbag.isComplete===true) {
							task.progress = 'EN_COURS100';
						} else if (task.progress === 'EN_COURS100') {
							task.progress = 'EN_COURS2';
						}
	                    model.taskDataUpdate(true);
					};
					
					function shouldRemoveTaskFromView(){
						return scope.viewOptions != "TASK_PAT" && scope.viewOptions != "NB_TASK_SEARCH"
								&& scope.viewOptions != "NB_TASK_SEARCH_SENT_UNCOMPLETED" && scope.viewOptions != "NB_TASK_SEARCH_SENT_COMPLETED"
					}

					scope.save = function (task, originalTask) {
						var wasComplete = task.completionDatetime!=undefined;
						var idProf = model.user().profil ? model.user().profil.id : undefined;
						
						if(task && task.note == scope.NONEDITABLE_CONSENT)
						{
							activateFinishFirstAnimation(task)
							return;
						}
						if (!scope.sending) {
							sending(true);
							var toSave = copyForSave(task);

							return TaskAccessor.save(toSave, function (res) {
								var savedTask ;
								if(res.className === "CTask"){
									savedTask = res;
								}
								if (savedTask) {
									//Message was sent successfully
									// model.notice().success($filter('translate')('QVTaskSavedSuccessfully'));
									TaskAccessor.initTask(savedTask);
									scope.currEditTask = null;
									
									if (originalTask) {
										OfysUtils.update(originalTask, savedTask, []);
									} else {
										OfysUtils.update(task, savedTask, []);
									}
									if(shouldRemoveTaskFromView() && deleteTaskFromList(task)){
										$timeout(function () {
											removeTaskFromList(originalTask);
										}, 200);
									}
									unregisterDirty();
									
									if (
										scope.currFilterShorcut=='NB_TASK_ALL'||
										scope.currFilterShorcut=='NB_TASK_LATE'||
										scope.currFilterShorcut=='NB_TASK_TODAY'||
										scope.currFilterShorcut=='NB_TASK_SEM'||
										scope.currFilterShorcut=='NB_TASK_SANS_ECHEANCE'||
										scope.currFilterShorcut=='NB_TASK_URGENT'||
										scope.currFilterShorcut=='NB_TASK_INPROGRESS'||
										scope.currFilterShorcut=='NB_TASK_NOTED'||
										scope.currFilterShorcut=='NB_TASK_STAT1'||
										scope.currFilterShorcut=='NB_TASK_STAT2'||
										scope.currFilterShorcut=='NB_TASK_STAT3'||
										scope.currFilterShorcut=='NB_TASK_STAT4'||
										scope.currFilterShorcut=='NB_TASK_OTHER'
										) {
										var taskType = getType(task);
											
										if (task.completionDatetime!=undefined) {
											if (wasComplete===false) {
												model.dayData(idProf).cnts[taskType] = model.dayData(idProf).cnts[taskType] - 1;
												if (taskType.indexOf('_group')>-1) {
													model.dayData(idProf).cnts[taskType.replace('_group','')+'_total'] = model.dayData(idProf).cnts[taskType.replace('_group','')+'_total'] - 1;
												} else {
													model.dayData(idProf).cnts[taskType+'_total'] = model.dayData(idProf).cnts[taskType+'_total'] - 1;
												}
											}
										} else {
											if (wasComplete==true) {
												// donc n'est plus complete!
												model.dayData(idProf).cnts[taskType] = model.dayData(idProf).cnts[taskType] + 1;
												if (taskType.indexOf('_group')>-1) {
													model.dayData(idProf).cnts[taskType.replace('_group','')+'_total'] = model.dayData(idProf).cnts[taskType.replace('_group','')+'_total'] + 1;								
												} else {
													model.dayData(idProf).cnts[taskType+'_total'] = model.dayData(idProf).cnts[taskType+'_total'] + 1;								
												}
											}
											
										}
										model.refreshCountsUpdated(true);
									}
								} else {
									model.notice().fail($filter('translate')('SaveError'));
								}

								//Prevent double sending when clicking too fast;
			                    model.taskDataUpdate(true);
								sending();
							}, function () {
								//Unlock sending on error
			                    model.taskDataUpdate(true);
								sending();
							});
						}
					}
					function getType(task){
						var typeStr = "task";
						if(task.dueDatetime){
							if(moment(task.dueDatetime).isBefore(moment(), "day")){
								typeStr = typeStr + "_late";
							} else if(moment(task.dueDatetime).isSame(moment(), "day")){
								typeStr = typeStr + "_tod";
							} else if(moment(task.dueDatetime).isBetween(moment(), moment().add(7, "days"))){
								typeStr = typeStr + "_sem";
							}
						}else{
							typeStr = typeStr +"_sans";
						}
			
						if(typeStr !== "task"){
							if(task.toGroup){
								typeStr = typeStr + "_group";
							}
							return typeStr;
						}else{
							return "";
						}
					}
					function deleteTaskFromList(task){
						let userId = 0;
						if(task.toGroup && task.viewbag.toGroup){
							let user = task.viewbag.toGroup.persons.find((person) => person.id === model.user().sessionUser.user.id);
							if(user)userId = user.id
							
						}else{
							userId = task.toUser;
						}
						return userId != model.user().sessionUser.user.id;
					}
					
					scope.$watch(attrs.inputTasks, update);
				}
			};
		}]);

	task.directive('taskEdit', ['PrefAccessor', '$timeout', 'model', '$q', 'TaskAccessor', 'UserAccessor', 'AppointmentAccessor', 'MessageLink', '$filter', '$rootScope', 'utils',
		function (PrefAccessor, $timeout, model, $q, TaskAccessor, UserAccessor, AppointmentAccessor, MessageLink, $filter, $rootScope, utils) {
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/task/task_edit.html?v=bf',
				link: function (scope, element, attrs) {
					scope.model = model;
					scope.focusMessageFn = function (header) {
						$timeout(function () {
							if (header || !isAssigned()) {
								scope.focusAssignTask();
							} else {
								scope.focusWriteTask();
							}
						}, 0);
					};

					scope.isOkToSend = function () {
						scope.qe.task.viewbag.okToSend = ((!!scope.qe.task.note) && !(scope.qe.task.toUser == undefined && scope.qe.task.toGroup == undefined));
					};
					
					scope.isUserAdmin = function(){
						return model.user().isUserAdmin===true;
					}

					function addLink() {
						scope.qe.task.viewbag.messageLink = MessageLink.getMessageLink();
						applyLink(scope.qe.task.viewbag.messageLink)
					}

					function applyLink(link){
						if (link) {
							scope.qe.task.viewbag.idLinkType = MessageLink.linkTypesArray.indexOf(link.linkType);
							scope.qe.task.linkType = link.linkType;
							scope.qe.task.idLink = link.id;
							scope.qe.task.idPatient = link.patient;

							scope.focusMessageFn();
						} else {
							scope.qe.task.viewbag.idLinkType = 0;
						}
					}

					var DEFAULTLINKTYPE = 'S_O';
					function def(){
						return {
							priority: "NORMAL",
							viewbag: {},
							linkType: DEFAULTLINKTYPE,
							modificationStatus: "STATUS_NEW"
						}
					}

					function init(){
						if (!scope.qe.task) {
							scope.qe.task = def();
							addLink();
							scope.isOkToSend();
							getListUsersForSelection();
						}else if(scope.qe.parseMessage){
							delete scope.qe.parseMessage;
							scope.qe.task = $.extend(def(), scope.qe.task);
							scope.qe.task.idLinkType = scope.qe.task.linkType;
							if(scope.qe.task.idLinkType !== undefined){
								delete scope.qe.task.viewbag.messageLink;
								scope.qe.task.viewbag.messageLink = {
									id: scope.qe.task.idLink,
									linkType: scope.qe.task.linkType,
									patient: scope.qe.task.idPatient,
									pat: scope.qe.task.presetPat,
									doc: scope.qe.task.patientImage,
									lab: scope.qe.task.laboFile,
									form: scope.qe.task.formData,
								}
								applyLink(scope.qe.task.viewbag.messageLink)
							}
							scope.isOkToSend();
							getListUsersForSelection();
						};
					}
//					init();
					scope.$watch('qe.task', init);
//					scope.isOkToSend();

					scope.actOptions = { verbose: true };
					scope.dueDynaDateOptions = {
						format: 'YYYY-MM-DD HH:mm',
						acceptFutureDate: true,
					};
					
					function assignToSelf() {
						var userId = model.user().sessionUser.user.id;
					}

					scope.showReminderHtml = TaskAccessor.showReminderHtml;

					scope.isPriority = function (type) {
						if (scope.qe.task) {
							return scope.qe.task.priority === type;
						}
					};

					scope.setPriority = function (type) {
						scope.qe.task.priority = type;
					};

					function filterUserSearchableByWorkSite(){
						var res = scope.userSearchable;
						if(model.prefSettings('user_settings_SiteTasks')){
							var workSiteId = model.user().session.workSite.id;
							res = res.filter(function(e){
								if(e && e.sessionSite && e.sessionSite.id){
									if(e.sessionSite.id === workSiteId){
										return true;
									}
									return false;
								}else{
									// if the user does not have a session site.. always display
									return true;
								}
							});
						}
						return res;
					}
					var initialList;
					function searchUsers(query) {
						var res = [];
						var elem;
						var q = query.toLowerCase().removeAccentsLc();
						if (initialList==undefined) {
							initialList = filterUserSearchableByWorkSite()
						}
						if (scope.userSearchable) {
							for (var i = 0; i < initialList.length; i++) {
								elem = initialList[i];
								if ((elem.personNameLc && elem.personNameLc.indexOf(q) > -1) ||
										(elem.nameLc && elem.nameLc.indexOf(q) > -1)) {
									res.push(elem);
								}
							}
						}
						return res;
					}

					scope.removeLink = function () {
						scope.qe.task.linkType = DEFAULTLINKTYPE;
						scope.qe.task.viewbag.idLinkType = 0;
						delete scope.qe.task.idLink;
						delete scope.qe.task.idPatient;
						scope.focusMessageFn();
					};

					scope.setMessageLink = function () {
						addLink();
					};

					function clearAssignData() {
						delete scope.qe.task.toGroup;
						delete scope.qe.task.toUser;
						delete scope.qe.task.viewbag.toUser;
						delete scope.qe.task.viewbag.toGroup;
					}
					function isAssigned() {
						return !!(scope.qe.task.toUser || scope.qe.task.toGroup);
					}

					function setAssinged(assignee) {
						if (assignee) {
							AppointmentAccessor.utils.isAbsentToday(assignee);
							if (assignee.className === 'CUserForSelection') {
								scope.qe.task.toUser = assignee.userId;
								scope.qe.task.viewbag.toUser = assignee;
							} else if (assignee.className === 'CPersonGroup') {
								scope.qe.task.toGroup = assignee.id;
								scope.qe.task.viewbag.toGroup = assignee;
							}
						}
					}

					scope.setAssingedTo = function (assignee) {
						clearAssignData();
						setAssinged(assignee);
						scope.isOkToSend();
					};

					scope.assignedToSearchAssist = {
						assistId: "autocomplete_taskAssignedTo",
						nextTabOnTab: true,
						nextTabOnEnter: true,
						hasDetails: false,
						hasHeader: false,
						minChar: 0,
						trigger: 'focus',
						updateDataSourceWithValues: function (assistObject) {
							if (scope.userSearchable) {
								assistObject.setData(filterUserSearchableByWorkSite());
							}
						},
						getAsyncData: function (query, assist) {
							return $q(function (resolve, reject) {
								resolve(searchUsers(query));
							});
						},
						getKey: function (recipient) {
							var newScope = $rootScope.$new();
							newScope.item = recipient;
							var res = utils.getTemplateAndCompileSync(newScope, '/dashboard/resources/ofys/user/user_dataItem.html?v=bf');
							$timeout(function () {
								if (!newScope.$$phase) {
									newScope.$digest();
								}
							}, 0);
							return res;
						},
						selection: function (recipient, assistObject) {
							scope.$apply(scope.setAssingedTo(recipient));
							initialList = undefined;
							return "";
						},
					};
					function isPositiveInteger(n) {
						return n >>> 0 === OfysUtils.parseFloat(n);
					}
					function getListUsersForSelection(){
						UserAccessor.listUsersForSelection(function (selectionUserList) {
							scope.userSearchable = UserAccessor.cleanAndSortUsers(selectionUserList.data);
							var grps = $filter('orderBy')(OfysUtils.ObjectValuesAsArray(model.user().groups), 'name');
							scope.userSearchable = grps.concat(scope.userSearchable);
							if ((!isAssigned() && scope.qe.task.viewbag.pristine !== false)) {
								var selfId = -1;
								var type = "user";
								if (model.prefSettings('task.toUserId') && isPositiveInteger(model.prefSettings('task.toUserId'))) {
									selfId = model.prefSettings('task.toUserId');
								} else if (model.prefSettings('task.toGroupId') && isPositiveInteger(model.prefSettings('task.toGroupId'))) {
									selfId = model.prefSettings('task.toGroupId');
									type = "group";
								} else {
									selfId = model.user().sessionUser.user.id;
								}
								scope.setAssingedTo(findAssignee(scope.userSearchable, selfId, type));
							}
							scope.qe.task.viewbag.pristine = false;
							scope.focusMessageFn();
						});
					}


					function findAssignee(selectionUserList, selfId, type) {
						for (var i = 0; i < selectionUserList.length; i++) {
							if ((type === "user" && selectionUserList[i].userId == selfId) ||
								(type === "group" && selectionUserList[i].id == selfId)) {
								return selectionUserList[i];
							}
						}
					}

					function copyForSave(task) {
						//Data conversion and validation
						if (task.viewbag.newDueDT) {
							task.dueDateTime = moment(task.viewbag.newDueDT, scope.dueDynaDateOptions.format).valueOf();
						}
						if (task.viewbag.isComplete) {
							task.completionDatetime = moment().valueOf();
						} else {
							delete task.completionDatetime;
						}
						if (task.completionDatetime && task.toUser==undefined && task.toGroup==undefined) {
							task.toUser = model.user().sessionUser.user.id;
						}
						
						var res = JSON.parse(OfysUtils.safeStringify(_.omit(task, 'viewbag')));
						if(res.pat && res.pat.viewbag){
							delete res.pat.viewbag;
						}
						if(res.patient && res.patient.viewbag){
							delete res.patient.viewbag;
						}
						return res;
					}

					function sending(isSending) {
						if (isSending) {
							scope.sending = true;
						} else {
							$timeout(function () {
								scope.sending = false;
							}, 500);
						}
					}

					scope.save = function () {
						// console.log(scope.qe.task);
						// return;
						if (!scope.sending) {
							sending(true);
							var toSave = copyForSave(scope.qe.task);
							// console.log(toSave);

							TaskAccessor.save(toSave, function (res) {
								var savedTask ;
								if(res.className === "CTask"){
									savedTask = res;
								}
								if (savedTask) {
									//Message was sent successfully
									model.notice().success($filter('translate')('TaskSavedSuccessfully'));
									if (savedTask.toUser!==undefined) {
										if (model.prefSettings('task.toUserId')!==savedTask.toUser) {
											model.prefSettings('task.toUserId', savedTask.toUser);
										}
										if (model.prefSettings('task.toGroupId')!==-1) {
											model.prefSettings('task.toGroupId', -1);
										}
									} else if (savedTask.toGroup!==undefined) {
										if (model.prefSettings('task.toGroupId')!==savedTask.toGroup) {
											model.prefSettings('task.toGroupId', savedTask.toGroup);
										}
										if (model.prefSettings('task.toUserId')!==-1) {
											model.prefSettings('task.toUserId', -1);
										}
									}
									if (scope.closeQe) {
										scope.closeQe(scope.activeEditor);
									}
								} else {
									model.notice().fail($filter('translate')('SaveError'));
								}
								//Prevent double sending when clicking too fast;
								sending();
							}, function () {
								//Unlock sending on error
								sending();
							});
						}
					};

				}
			};
		}]);
		
})();