(function(){
	var quickedit = angular.module('quickedit', []);
	

	//QuickEditController is used by the external quickview window.
	//This is the main controller in the external quickview window mode.
	quickedit.controller('QuickEditController', ['$scope','$timeout','$filter','model',
	                                   function($scope, $timeout, $filter, model){
		model.activeMenu('qeiewer');
		var co = 0;
		var mO = {};
		
		function init(){
			if(window.ofysPayload){
				mO = window.ofysPayload();
				$.extend($scope, mO);
				model = mO.model;
//				model.patient().currPatient = mO.quickEditData.pat;
			}else{
				if(co < 100){
					$timeout(init, 0);
				}else{
					$scope.failedToLoad = true;
					$scope.title = $filter('translate')("error");
					$scope.qe = {noList: true};
					$scope.templateUrl = "error_view.html";
				}
				co += 1;
			}
		}
		
		init();
		
		model.qe().isExternal = true;
		
		$scope.popBack = function(){
			//console.log(model.activeMenu());
			if($scope.failedToLoad){
				window.close();
			}else{
				window.ofysBackToParent(mO);
			}
		}
	}]);

	//Directive for the activity bar. Displays the active quickview patient activities
	//and manages all activity bar options
	quickedit.directive('quickEditBar', ['model','QuickEdit', function(model, QuickEdit) {
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/quickview/qe_bar.html?v=bf',
			scope: {},
			controller: ['$scope', '$element', function($scope, $element, $attrs) {
				$scope.model = model;
				//internal flag to show if an activity contains other items (group item)
				$scope.showGroupMenu = false;
				
				$scope.getQVItems = function(){
					return OfysUtils.ObjectValuesAsArray(model.qe().items);
				}
				
				//Set the current group items
				//Resolves group items reference by id
				function extractItems(itemsIds){
					var res = [];
					for(var i = 0; i < itemsIds.length; i++){
						res.push(model.qe().items[itemsIds[i]]);
					}
					return res;
				}
				
				//Centers the grouped items bar relative to the active group
				function positionMenu(ev){
					if(ev){
						var pos = $(ev.currentTarget).position();
						var menuWidth = $("#quickEditGroupItems").outerWidth();
						var itemWidth = $(ev.currentTarget).outerWidth();
						var menuStart = pos.left - ((menuWidth /2)-(itemWidth /2)); 
						menuStart = menuStart < 0 ? 0: menuStart;
						$("#quickEditGroupItems").css("left", menuStart+'px');
					}
					
				}
				
				//called when a quickview item is hovered
				$scope.itemHasHover = function(qeItem, ev){
//					clearGroup();
					qeItem.quickEditData.icon.amHovered = true;
					qeItem.quickEditData.icon.active = true;
					$scope.mEdit = qeItem; 
					$scope.showGroupMenu = true;
				}
				
				//called when a quickview item looses hover
				$scope.itemLostHover = function(qeItem){
					qeItem.quickEditData.icon.amHovered = false;
					qeItem.quickEditData.icon.active = false;
				}
				
				//called when the quickview is hovered
				$scope.barHasHover = function(qeItem){
				}
				
//				function clearGroup(){
//					if($scope.activeEditor){
//						$scope.activeEditor.quickEditData.icon.active  = false;
//					}
//				}
				
				function clear(){
					if($scope.activeEditor && $scope.activeEditor.qe){
						delete $scope.activeEditor.qe.modal;
					}
				}
				//called when the quickview looses hover
				$scope.barLostHover = function(){
//					$scope.groupMenuItems = [];
//					$scope.showGroupMenu = false;
//					clearGroup();
				}
				
				$scope.openQe = function(mObj){
					if(mObj === $scope.activeEditor){
						$scope.minimizeQe();
					}else{
						QuickEdit.open(mObj);
					}
				}
				
				$scope.externalQV = function(mObj){
					QuickEdit.external(mObj);
				}
				
				$scope.closeQe = function(mObj){
					if(QuickEdit.close(mObj)){
						if(mObj === $scope.activeEditor){
							delete $scope.activeEditor;
						}
					}
				}
				
				$scope.minimizeQe = function(){
					clear();
					delete $scope.activeEditor;
				}
				
				QuickEdit.api = this;
				
				this.setActiveEditor = function(mObj){
					clear();
					$scope.activeEditor = mObj;
					$scope.qe = $scope.activeEditor.qe;
//					$scope.activeEditor.quickEditData.icon.active = true;
					if($scope.activeEditor && $scope.activeEditor.qe){
						var modal ={
							$$close: QuickEdit.api.close,
							$$minimize: QuickEdit.api.minimizeQe
						}
						return modal;
					}
				}
				
				this.close = function(mObj){
					if($scope.activeEditor && $scope.activeEditor.$$_qe_id === mObj.$$_qe_id){
						delete $scope.activeEditor;
					}
				}
				
					
			}]
		}
	}]);
	
	
	quickedit.directive('quickEditDir', ['$timeout', '$filter', 'model', function($timeout, $filter, model) {
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/quickview/qe_modal.html?v=bf',
			scope: {
				model: '=',
				quickEditData: '=',
				qe: "=",
				listUrl: "=",
				templateTitleUrl: "=",
				templateUrl: "=",
				title: "=title"
			},
			link: function(scope, element, attrs) {
				// scope.qeActPat = scope.quickEditData.pat;
				// scope.qeActData = scope.quickEditData.qeActData;
				$timeout(function(){
					var sections = 'PatientData';
					if (model.patientQeAllDataTabs().activeTab!=sections) {
						// reselect au cas ou il y a eu error d'initialisatin (erreur ... on ...)
						model.patientQeAllDataTabs().activeTab = sections;						
					}
					$timeout(function(){
						var o = $('.selected')[0];
						if (o) {
							o.scrollIntoView(false);
						}
					}, 800);
//					var p = $(window)[0];	// ne fonctionne pas car != window mais une div avec flow.
//					var elem_position = o.offsetTop;
//				    var window_height = p.innerHeight;
//				    var y = elem_position - window_height/2;
//				    p.scrollTo(0,y);					
					},100);
			}
		}
	}]);
	
	quickedit.factory('QuickEdit', ['$uibModal','$filter', 'model','$timeout','Event', 
	                                function($uibModal, $filter, model, $timeout, Event) {
		var iNextQeId = 0;
		function getNextQeId(){
			var prefix = 'qe_';
			iNextQeId++;
			//TODO use atomic integer for value of i. if not could cause problems with external view.
			while(model.qe().items[prefix+iNextQeId] !== undefined)iNextQeId++;
			return prefix+iNextQeId;
		}
		
		function getActivityHash(input){
			if(input.quickEditData && input.quickEditData.qeActData &&
					input.quickEditData.qeActData.uid){
				return input.quickEditData.qeActData.uid
			}
		}
		
		function getQVbyHash(hash){
			if(service.qeByHash[hash]){
				return model.qe().items[service.qeByHash[hash]];
			}
		}
		
		//Update hash object references for look up
		//called when new item is added and when the activity of an existing quickview is changed.
		function updateQVHash(input, reason){
			var hash = getActivityHash(input);
			if(hash){
				if(reason && reason.searchAndDelete){
					searchAndDeleteOldHash(input);
				}
				if(reason && reason.deleteOnly)return;
				
				service.qeByHash[hash] = input.$$_qe_id;
			}
		}
		
		function searchAndDeleteOldHash(input){
			if(input.$$_qe_id){
				//Since the hash of a quickview could change (e.g if another activity is selected)
				//to find old hash, the qeByHash Object must be searched to make sure that id does not exist more than once
				var param = OfysUtils.findParameterWithValue(service.qeByHash, input.$$_qe_id);
				if(param){
					delete service.qeByHash[param];
				}
			}
		}
		
		/*
		 * Application can define callback functions in the qe object.
		 * onQeSuccess : called when the modal is closed with a return object. when opened for results.
		 * onQeClose : called when the modal is closed without a user defined return object. (modal object mObj is returned)
		 * onQeMinimize : called when the modal is minimized.
		 * onQeExternalize : called when the modal is externalized(pop up window).
		 * 
		 * to listen to the events define the handler. e.g :  
		 * 	
		 * 		Event.on(qe.onQeSuccess, function(modalObject){});
		 * 
		 * to remove the handler. e.g :
		 * 
		 * 		Event.off(qe.onQeSuccess);
		 */
		var qeEvent = ["onQeSuccess", "onQeClose", "onQeMinimize", "onQeExternalize", "onQeActivityChange"];
		
		//Unit function adds a modal event
		function addModalEvent(mObj, eventType){
			if(!mObj.qe[eventType]){
				mObj.qe[eventType] = eventType+ mObj.$$_qe_id;
				Event.addEvent(mObj.qe[eventType], {});
			}
		}
		
		//Unit function removes a modal event
		function removeModalEvent(mObj, eventType){
			Event.removeEvent(mObj.qe[eventType]);
			delete mObj.qe[eventType];
		}
		
		//List function adds a modal events
		function addEvents(mObj){
			if(!mObj.qe.$$eventsReady){
				for(var i = 0; i< qeEvent.length; i++){
					addModalEvent(mObj, qeEvent[i]);
				}
				mObj.qe.$$eventsReady = true;
			}
		}
		
		//List function removes a modal events
		function removeEvents(mObj){
			for(var i = 0; i< qeEvent.length; i++){
				removeModalEvent(mObj, qeEvent[i]);
			}
			delete mObj.qe.$$eventsReady;
		}
		
		function cleanUp(mObj){
			delete mObj.qe.modal;
			if(model.qe().group[mObj.quickEditData.pat.id]){
				delete model.qe().group[mObj.quickEditData.pat.id].isOpen;
			}
			
			service.currentModal = null;
		}
		
		function addNewQuickEditIfPossible(input){
			var mObj, openType;
			
			//hackish variable that skips adding the options
			//'$$'prefixed variables are internal variables that are deleted DO NOT Use this variable outside the QuickEdit factory
			var skippOptionsSet = input.$$skippOptionsSet?true: false;
			var isPopingBack = input.$$popingBack?true: false;
			delete input.$$skippOptionsSet;
			delete input.$$popingBack;
			
			var isNewEntry = false;
			
			//if the input has the $$_qe_id property then it has already been added and only the modal needs to be opened. 
			if(input.$$_qe_id){
				openType = 'qeBar';
				mObj = input;
			}else{
				//Check if qe is open to make sure the same activity is not added more than once.
				var qeHash = getActivityHash(input);
				if(qeHash){
					mObj = getQVbyHash(qeHash);
					openType = 'reOpen';
				}
			}
			
			// if mObj is still undefined at this point, then no quickview exist with the same hash  and
			// it is a new activity that should be added to quickview list.
			if(!mObj ){
				openType = 'firstOpen';
				
				if(!input.$$_qe_id){
					isNewEntry = true;
					input.$$_qe_id = getNextQeId();
					if(input.quickEditData && input.quickEditData.pat ){
						var pt = input.quickEditData.pat;
						model.patientsInQe(''+pt.id, pt);
					}
					mObj = {
							title: "",
							templateUrl:"placeHolder_index.html",
							quickEditData: {
								icon: {
									title: "Document",
									cssClasses :"fa-folder" 
								}
							},
							qe: {},
							model: model
					};
					
					$.extend(mObj, input);
					updateQVHash(mObj);
					
				}else{
					mObj = input;
				}
				
				
				//Adds icons and other quickview specific options
				//useful when adding an element to quickview without opening the quickview modal. (open later use cases).
				if(!skippOptionsSet){
					if(mObj.quickEditData){
						service.addQuickEditOptions(mObj.quickEditData, mObj);
					}
				}
			}
			
			if(isNewEntry || isPopingBack){
				if(!service.isGroup(mObj)){
					model.qe().items[mObj.$$_qe_id] = mObj;
				}
			}
			
			//Add events if necessary if event already exists it is not added again.
			addEvents(mObj);
			
			return mObj;
		}
		
		//Closes a quickview activity
		//The reason parameter used in the removeFromGroup function could be:
		//- external : the activity is being poped to an external view (loose reference is kept by the containing group for closing later on) 
		//- kill : the activity viewing is terminated and all resources should be free
		function closeQuickEditItem(input, reason){
			if(!input.$$_qe_id){
				
			}else if(model.qe().items[input.$$_qe_id] !== undefined){
				delete model.qe().items[input.$$_qe_id];
			}
			if(service.api){
				service.api.close(input);
			}
			return true;
		}
		
		//Closes all group elements (activities, external views and modals that are open)
		function closeQuickEditGroup(input, reason){
			//Close all open external windows of this group
    		while(input.groupExternals.length > 0){
    			input.groupExternals[0].externalViewer.close();
    			input.groupExternals.splice(0, 1);
    		}
    		//Close all activities of the group
    		while(input.groupContent.length > 0){
    			closeQuickEditItem(model.qe().items[input.groupContent[0]]);
    		}
    		
    		//Close the group modal if it is open
    		if(input.qe && input.qe.modal){
    			input.qe.modal.dismiss('cancel');
    		}
    		return true;
		}
		
		//Closes the quickview this is the destruction method.
		//if the modal is opened it is closed
		//The reference in the quickview list is removed.
		function closeQuickEdit(input, reason){
			var closeSuccess = false;
			closeSuccess = closeQuickEditItem(input, reason)
			removeEvents(input);
			return closeSuccess;
		}
		
		//Pop out the quickview modal to an external view window.
		function externaliseQuickEdit(mObj){
			var closeReason = {id:mObj.$$_qe_id, type: "external", externalViewer: externalViewer};
			
			service.close(mObj, closeReason);
			
			cleanUp(mObj);
			
			mObj.qe.isExternal = true;
			
			if (!window.location.origin) {
			  window.location.origin = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port: '');
			}
			var url = window.location.origin +"/dashboard#/qeiewer";
			var externalViewer = window.open(url, '_blank', 
					'location=no,height='+Math.floor(screen.height*0.9)+',width='+Math.floor(screen.width*0.8)+',scrollbars=yes,resizable=1, status=yes');
			
			if(externalViewer.addEventListener){
				externalViewer.addEventListener('load',setWindowData,false);
				externalViewer.addEventListener('beforeunload', beforeWindowClose);
		    }else{
		    	externalViewer.attachEvent('onload',setWindowData);
		    	externalViewer.attachEvent('beforeunload', beforeWindowClose);
		    }
			
			function getRootScope(){
				var $body = angular.element(document.body);            
				var $rootScope = $body.injector().get('$rootScope');   
				return $rootScope;
			}
			
			function setWindowData(event){
				externalViewer.ofysPayload = function(){
					return mObj;
				}
				externalViewer.ofysBackToParent = function(mObj){
					externalViewer.isPopingBack = true;
					getRootScope().$apply(function () {
						mObj.$$popingBack = true;
						delete mObj.qe.isExternal;
						service.add(mObj);
					});
					externalViewer.close();
				}
			}
			
			function beforeWindowClose(event){
				if (!(externalViewer.isPopingBack===true)) {
					if (false && 'data.isDirty()') {	// TODO check if edited data. Un compare d'objet? Mais si popBack, pas besoin.
						event.returnValue = "Veuillez sauvegarder ou annuler les modifications avant de fermer la fenêtre.";
					} else {
						if (mObj.quickEditData!== undefined && mObj.quickEditData.pat!== undefined) {
							model.patientsInQe(''+mObj.quickEditData.pat.id, null);
						}
					}
				}
			}
		}

		var service = {
			//stores all the open quickview according to a hash that should 
			//uniquely identify the content. if the content is changed the has is updated too.
			qeByHash: {},
			updateQVHashById: function(qeId){
				if(qeId){
					updateQVHash(model.qe().items[qeId], {searchAndDelete: true});
				}
			},
			updateQVHashOldNew: function(oldAct, newAct){
				if(newAct.uid &&oldAct.uid){
					service.qeByHash[newAct.uid] = service.qeByHash[oldAct.uid];
					delete service.qeByHash[oldAct.uid];
				}
			},
			isGroup: function (qeItem){
				return qeItem.quickEditData.icon && qeItem.quickEditData.icon.type === 'group';
			},
			isExternal: function (reason){
				return reason && reason.type === "external";
			},
			//Add an item to a group corresponding to the right group. Called when oppeing a new activity. added to the right patient.
		    addToGroup: function(obj, isPopingBack){
		    	
		    	if(model.qe().group[obj.quickEditData.pat.id] === undefined){
		    		model.qe().group[obj.quickEditData.pat.id] = angular.copy(obj);
		    		
		    		model.qe().group[obj.quickEditData.pat.id].$$_qe_id = getNextQeId();
					
					model.qe().group[obj.quickEditData.pat.id].groupContent = [], //refrence to group items are stored. only the id
					model.qe().group[obj.quickEditData.pat.id].groupExternals = [], // if a group items is externalized then a reference to the window is kept in this array
					model.qe().group[obj.quickEditData.pat.id].quickEditData = {icon:{}}// view data of the group;
					
					model.qe().group[obj.quickEditData.pat.id].quickEditData.pat = obj.quickEditData.pat ;
					model.qe().group[obj.quickEditData.pat.id].quickEditData.icon.cssClasses = service.getGenderIcon(obj.quickEditData.pat.gender);
					model.qe().group[obj.quickEditData.pat.id].quickEditData.icon.type = "group";
					model.qe().group[obj.quickEditData.pat.id].quickEditData.icon.title = model.getPatIdTitle(obj.quickEditData.pat);
					
					model.qe().itemsGroupCount = model.qe().itemsGroupCount + 1;
				}
				model.qe().group[obj.quickEditData.pat.id].groupContent.push(obj.$$_qe_id);
				//console.log(model.qe().group);
		    	
				if(isPopingBack){
					var i = 0;
					while(i < model.qe().group[obj.quickEditData.pat.id].groupExternals.length && 
							model.qe().group[obj.quickEditData.pat.id].groupExternals[i].id !== obj.$$_qe_id){
						i++;
		    		}
					if(model.qe().group[obj.quickEditData.pat.id].groupExternals[i] && 
							model.qe().group[obj.quickEditData.pat.id].groupExternals[i].id === obj.$$_qe_id){
						model.qe().group[obj.quickEditData.pat.id].groupExternals.splice(i, 1);
					}
				}
		    },
		    //Pop out the quickview modal to and external view.
			external: function(mObj){
				if(mObj.qe.onQeExternalize){
					Event.emit(mObj.qe.onQeExternalize, {mObj: mObj}, function(){
						externaliseQuickEdit(mObj);
					});
				}else{
					externaliseQuickEdit(mObj)
				}
			},
			add: function(input){
				return addNewQuickEditIfPossible(input);
			},
			
			//returns a class that represents the gender passed in parameter
			getGenderIcon: function (gender){
				if(gender === 'M'){
					return "fa-mars"; 
				}else if(gender === 'F'){
					return "fa-venus";
				}else{
					return "fa-transgender";
				}
			},
			addQuickEditOptions: function(quickEditData, input){
				
				function setDefault(hasPatient){
					if(hasPatient){
						quickEditData.icon.cssClasses = service.getGenderIcon(quickEditData.pat.gender);
						quickEditData.icon.title=model.getPatIdTitle(quickEditData.pat);
						quickEditData.viewerType = "pat";
					}else{
						quickEditData.icon.cssClasses="fa-info-circle";
						quickEditData.icon.title="";
						quickEditData.viewerType = "unknown";
					}
				}
				
				
				var actData = quickEditData.qeActData;
				var patIdTitle = "";
				var hasPatient = quickEditData.pat && quickEditData.pat.id; 
				if (hasPatient) {
					patIdTitle = model.getPatIdTitle(quickEditData.pat) + "\n";
				}
				if (!quickEditData.icon) {
					quickEditData.icon = {};
				}
				
				if (!angular.isDefined(actData)){
					quickEditData.icon.headerCssClasses="badge-default";
				}
				if(input && input.heading){
					quickEditData.title = input.heading;
				}
				
				if (angular.isUndefined(actData)) {
					setDefault(hasPatient);
				}else if(actData.className === "CLaboFile" || actData.className === "CLaboResultsProfessionnal"){
					quickEditData.icon.cssClasses="fa-flask labo-cr";
//					quickEditData.icon.title= patIdTitle + $filter('translate')('Laboratory') + ": "+ actData.req;
					quickEditData.viewerType = "lab";
				}else if(actData.className === "CBasePatientImage" || actData.className === "CPatientImage"){
					quickEditData.icon.cssClasses="fa-file-text-o doc-cr";
//					quickEditData.icon.title= patIdTitle + $filter('translate')('Scan') + ": " + actData.str.replace('~ListScaned.SCANNED_BY~', $filter('translate')('ScannedBy'));
					quickEditData.viewerType =  "doc";
				}else if((actData.className === "CCourrielTexte")){
					quickEditData.icon.cssClasses="fa-envelope-o msg-cr";
					quickEditData.icon.headerCssClasses="badge-msg";
//					quickEditData.icon.title= patIdTitle + $filter('translate')('Message') + ": " + actData.dataText;
					quickEditData.viewerType = "courriel";
				}else if((actData.className === "CChatMessage" || actData.className === "CBaseChatMessage")){
					quickEditData.icon.cssClasses="fa-envelope-o msg-cr";
					quickEditData.icon.headerCssClasses="badge-msg";
//					quickEditData.icon.title= patIdTitle + $filter('translate')('Message') + ": " + actData.dataText;
					quickEditData.viewerType = "msg";
				}else if(actData.className === "CAppointment"){
					quickEditData.icon.cssClasses="fa-calendar appoint-cr";
//					quickEditData.icon.title= patIdTitle + $filter('translate')('Appointment') + ": " + actData.date;
					quickEditData.viewerType = "app";
				}else if(actData.className === "CTask"){
					quickEditData.icon.cssClasses="fa-check-circle task-cr";
					quickEditData.icon.headerCssClasses="badge-task";
//					quickEditData.icon.title= patIdTitle + $filter('translate')('Task') + ": " + actData.patientText;
					quickEditData.viewerType = "task";
				}else if(actData.className === "CPatientRecall"){
					quickEditData.icon.cssClasses="fa-bell-o rem-cr";
//					quickEditData.icon.title= patIdTitle + $filter('translate')('RemindersNotClin') + ": " + actData.date;
					quickEditData.viewerType = "reminder";
				}else if(actData.className === "CEncounter"){
					quickEditData.icon.cssClasses="fa-folder cons-cr";
//					quickEditData.icon.title= patIdTitle + $filter('translate')('ENCOUNTER') + ": " + actData.date;
					quickEditData.viewerType = "encounter";
				}else if(actData.className === "CFormData"){
					var edited = "";
					if (actData.prop && actData.prop.readonly===false) {
						edited = " red";
					}
					quickEditData.icon.cssClasses="fa-list-alt form-cr" + edited;
//					quickEditData.icon.title= patIdTitle + $filter('translate')('Form') + ": " + actData.form.name;
					quickEditData.viewerType = "form";
				}else{
					setDefault(hasPatient);
				}
				return quickEditData;
			},
			close: function(input, reason){
				if(input.qe.onQeClose){
					Event.emit(input.qe.onQeClose, {mObj: input}, function(){
						closeQuickEdit(input, reason);
					});
				}else{
					closeQuickEdit(input, reason);
				}
			},
			
			open : function (input){
				var mObj = service.add(input);
				if(service.api){
					mObj.qe.modal = service.api.setActiveEditor(mObj);
				}
			}
		}
		
		return service;
	}]);
	
})();