(function(){
    angular.module('home')
	.factory('omnisearchAccessor', [function(){
		function registerSearchable(searchableOptions){
			
		}
		
		function setActiveState(stateOptions){
			
		}
		
		return {registerSearchable: registerSearchable, setActiveState: setActiveState};
    }])
    .directive('omnisearch', ['$q','$filter', '$sce', 'omnisearchAccessor','utils',
	                                function($q, $filter, $sce, omnisearchAccessor, utils){
		return {
			restrict: 'AE',
			templateUrl: '/dashboard/resources/ofys/widgets/omnisearch.html?v=bf',
			scope:true,
			link:{
				pre: function(scope, element, attrs){
					scope.searchablesList = [
				                      {
				                    	  displayName: $filter('translate')('Laboratory'),
				                    	  activeClasses: 'badge-labo',
				                    	  classes: 'inactive',
				                    	  status: 'active'
				                      },
				                      {
				                    	  displayName:$filter("translate")("Patients"),
				                    	  activeClasses: "badge-doc",
				                    	  classes: "inactive",
				                    	  onSelect: function(omniSearchId, searchAssist){
				                    		  	utils.getTemplate('/dashboard/resources/ofys/widgets/searchClientForm.html?v=bf', function(html){
													newConfig = {};
													newConfig.hasHeader = true;
													newConfig.helpHtml = html;
													newConfig.trigger = 'res';
													newConfig.hasResultList = false;
													newConfig.onClose = function(query, assistObject) {
													return true;
													};
													searchAssist.setOptions(newConfig);
													searchAssist.buildBase();
													searchAssist.open();
												});
				                    	  },
				                    	  status: "active"
				                      },
				                      {
				                    	  displayName:$filter("translate")("Scan"),
				                    	  activeClasses: "badge-doc",
				                    	  classes: "inactive",
				                    	  status: "active"
				                      },
				                      {
				                    	  displayName:$filter("translate")("Appointments"),
				                    	  activeClasses: "badge-appoint",
				                    	  classes: "inactive",
				                    	  status: "active"
				                      },
				                      {
				                    	  displayName: $filter("translate")("Messages"),
				                    	  activeClasses: "badge-msg",
				                    	  classes: "inactive",
				                    	  status: "active"
				                      },
				                      {
				                    	  displayName:$filter("translate")("Task"),
				                    	  classes: "inactive",
				                      },
				                     ];
					
					scope.activeFilters = [];
					scope.omniSearchId = 1;
					scope.remove = function(searchable){
						scope.activeFilters.splice(scope.activeFilters.indexOf(searchable), 1);
					}
					
					function onSearchSelected(searchable, dxA){
						if(angular.isDefined(searchable.activeClasses)){
							searchable.classes = searchable.activeClasses;
						}
						
						scope.activeFilters.push(searchable);
						if(angular.isDefined(searchable.onSelect)){
							searchable.onSelect(scope.omniSearchId, dxA);
						}
					}
					
					scope.omniSearchAssistApi = {};
					
					//OmniSearch assist input
					scope.omniSearchAssist = {
							assistId: "autocomplete_omnisearch",
							nextTabOnTab: true,
							nextTabOnEnter: true,
							hasDetails: false,
							hasHeader: false,
							trigger: 'res',
							updateDataSourceWithValues: function(assistObject){
								assistObject.setData(scope.searchablesList);
							},
							onRegisterApi: function(api){
								scope.omniSearchAssistApi = api;
							},
							getAsyncData: function(query){
								  return $q(function(resolve, reject) { onSearchSelected(scope.searchablesList); });
							},
							getKey: function(searchable) {
								return searchable.displayName;
							},
							selection: function(searchable, assistObject) {
								scope.$apply(onSearchSelected(searchable, assistObject));
								return "";
							},
					};
				},
				post:angular.noop
			}
		}
	}]);
	
})();