(function() {
	var ia = angular.module('iaFct', []);

	ia.factory('IaAccessor', ['DashAPI', function(DashAPI) {
		var accessor = {
			// inclue STT - donc data = byte[] dans Form
			sendChunk: function(data, d2, callback, error) {
				var config = { headers: { 'Content-Type': undefined }, 'transformRequest': angular.identity };
				return DashAPI.post('/dashboard/ia/ws/sendChunk?idAudio=' + d2.idAudio + "&chunkNo=" + d2.chunkNo + '&isFinalChunk=' + d2.isFinalChunk, data, callback, error, config);
			},
			consentPatient: function(data, d2, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/consentPatient?' + (d2.idPatient ? 'id=' + d2.idPatient + '&' : '') + (d2.sexPat ? 'sexPat=' + d2.sexPat : ''), data, callback, error);
			},
			dictation: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/dictation', data, callback, error);
			},
			improveDictation: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/improveDictation', data, callback, error);
			},
			interviewDictation: function(data, d2, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/interviewDictation?noteType=' + d2.noteType + '&sexPat=' + d2.sexPat, data, callback, error);
			},
			medNoteFromInterview: function(data, d2, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/medNoteFromInterview?noteType=' + d2.noteType + '&sexPat=' + d2.sexPat, data, callback, error);
			},
			medNoteFromNote: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/medNoteFromNote', data, callback, error);
			},
			// fonction de traitement de texte uniquement. data = text:'TEXTE A ANALYSER'
			improveText: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/improveText', data, callback, error);
			},
			noteInfoClin4Form: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/noteInfoClin4Form', data, callback, error);
			},
			summaryEnc4Prof: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryEnc4Prof', data, callback, error);
			},
			summaryEnc4Pat: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryEnc4Pat', data, callback, error);
			},
			encInfoClin4Form: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/encInfoClin4Form', data, callback, error);
			},
			summaryOfDoc4Prof: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryOfDoc4Prof', data, callback, error);
			},
			summaryOfDoc4Pat: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryOfDoc4Pat', data, callback, error);
			},
			summaryOfLab4Pat: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryOfLab4Pat', data, callback, error);
			},
			summaryFile4Prof: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryFile4Prof', data, callback, error);
			},
			getLastEnc3y: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/getLastEnc3y', data, callback, error);
			},
			lastEnc3y: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/lastEnc3y', data, callback, error);
			},
			generatePatientSummary: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/generatePatientSummary', data, callback, error);
			},
			toFrench: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/toFrench', data, callback, error);
			},
			toEnglish: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/toEnglish', data, callback, error);
			}
		};
		return accessor;
	}]);

	ia.factory('iaService', ['$timeout', '$compile', '$translate', function($timeout, $compile, $translate) {
		var iaScope;
		return {
			setIaScope: function(scope) {
				iaScope = scope;
			},
			startRecording: function(textareaElement, inputText, choice, sexPat, patient, enc) {
				if (iaScope && iaScope.startRecordingViaApi) {
					return iaScope.startRecordingViaApi(textareaElement, inputText, choice, sexPat, patient, enc);
				}
				return null; // Handle case where directive is not yet initialized
			},
			endRecording: function() {
				if (iaScope && iaScope.endRecordingViaApi) {
					return iaScope.endRecordingViaApi();
				}
				return null; // Handle case where directive is not yet initialized
			},
			openTextWindow: function(text) {
				openTextWindow(decodeURIComponent(text));
			},
			insertTextAtCursor: function(textareaElement, text) {
				if (!isInDOM(textareaElement)) {
					openTextWindow(decodeURIComponent(text));
					return;
				}
				if (textareaElement.setSelectionRange) {
					$timeout(function() {
						var start = textareaElement.selectionStart;
						var end = textareaElement.selectionEnd;
						textareaElement.value = textareaElement.value.substring(0, start) + (start == 0 ? '' : ' ') + text + textareaElement.value.substring(end);
						var newEnd = start + (start == 0 ? '' : ' ') + text.length;
						textareaElement.selectionStart = newEnd;
						textareaElement.selectionEnd = newEnd;
						// Trigger a change event
						var event = new Event('input', { bubbles: true });
						textareaElement.dispatchEvent(event);
						// textareaElement.focus();
					}, 0);
				} else if (textareaElement.createTextRange) {
					var range = document.selection.createRange();
					range.collapse(true);
					range.text = text;
					range.select();
					var event = new Event('input', { bubbles: true });
					textareaElement.dispatchEvent(event);
				}
			},
			replaceText: function(textareaElement, text) {
				if (!isInDOM(textareaElement)) {
					openTextWindow(decodeURIComponent(text));
					return;
				}
				$timeout(function() {
					textareaElement.value = text.replaceAll('\\*', '*').replaceAll('\\#', '#').replaceAll('\\[', '[').replaceAll('\\]', ']').replaceAll('\\_', '_');
					// Trigger a change event
					var event = new Event('input', { bubbles: true });
					textareaElement.dispatchEvent(event);
					textareaElement.focus();
				}, 0);
			},
			showModal: function(text) {
				iaScope.text = text;
				var modal = angular.element(`
			        <div class="ia-modal">
			            <div class="ia-modal-content">
			                <div class="draggable-handle-not-used"></div>
			                <div class="textarea-container" ng-class="{ 'locked': readOnly }">
			                <i ng-show="readOnly" class="fa fa-lock lock-icon"></i>
			                <textarea class="ia-texte" ng-readonly="readOnly">{{text}}</textarea>
			                <span class="ia-resp-valid">{{'VOTRE_RESP_DE_VALIDER'|translate}}</span>
			                <div class="button-group">
			                    <button ng-click="copyToClipboard()">{{'copy_app'|translate}}</button>
			                    <button ng-click="closeModal()">{{'Close'|translate}}</button>
			                </div>
			            </div>
			            </div>
			        </div>
			    `);
				var compiledContent = $compile(modal)(iaScope);
				document.body.appendChild(compiledContent[0]);

				iaScope.hasParentText = function() {
					return element[0].nodeName.toLowerCase() !== 'div';	 // les div n'ont pas de texte.
				};

				iaScope.closeModal = function() {
					modal.remove();
				};

				// Copier dans le presse-papier
				iaScope.copyToClipboard = function() {
					var textarea = compiledContent.find('textarea')[0];
					textarea.select();
					document.execCommand('copy');
					modal.remove();
				};
			}

		}

		function isInDOM(element) {
			return document.body.contains(element);
		}

		function openTextWindow(text) {
			OfysUtils.openTextWindow(text);
		}

	}]);

	ia.directive('iaTools', ['model', 'IaAccessor', 'iaService', '$translate', '$timeout', function(model, IaAccessor, iaService, $translate, $timeout) {
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ia/ia_tools.html?v=bf',
			scope: true,
			link: function(scope, element, attrs) {
				if (scope.model.clientPreferences() == undefined || scope.model.clientPreferences().aiEnabled !== true) return;

				var noteType = function() {
					return scope.model.prefSettings('user_settings_medNoteType');
				};
				
				model.isRecording = false;
				scope.isPaused = false;
				scope.isProcessing = false;
				var reprendre = $translate.instant('CONTINUE');
				var pause = $translate.instant('PAUSE');
				var terminer = $translate.instant('TERMINER');

				scope.idAudio;	// = model.getSession().idAudio;
				scope.chunkNo = 0;
				let microphone;
				let mediaRecorder;
				const shortSilenceDuration = 300; // ms
				const longSilenceDuration = 3000; // ms
				let lastNonSilenceTime = 0;
				let pauseTime = 0;
				let chunkRecordingDuration = 0;
				const minRecordingDuration = 30000;
				let isRecordingSpeech = false;
				
				scope.pause = function() {
					return scope.isPaused ? reprendre : pause;
				};
				scope.terminer = function() {
					return terminer;
				};
				
				const silenceThreshold = -51; // dB
				function getSilenceThreshold() {
					return silenceThreshold;
				}
				let decibels = 0;
				function setDecibels(d) {
					decibels = d;
				}
				function getDecibels() {
					return decibels;
				}
				
				// Function to start recording via API
				scope.startRecordingViaApi = function(textareaElement, inputText, choice, sexPat, patient, enc) {
					if (model.isRecording == true || scope.isPaused == true || scope.isProcessing == true) {
						model.notice().warn($translate.instant('recordingAlreadyInProgress'));
						return;
					}
					if (mediaRecorder && mediaRecorder.state=='recording') {
						// ne devrait pas arriver!
						console.error("Ne deverait pas passer ici car on commence une session d'enregistrement et mediaRecorder.state=='recording'! ");
						
						try {
							mediaRecorder.stop();
							mediaRecorder = null;
						} catch (error) {
							console.error('Erreur arret mediaRecorder:', error);
						}
					} 
					const audioContextRec = new (window.AudioContext || window.webkitAudioContext)({
					    sampleRate: 16000,
					    latencyHint: 'interactive'
					});
					let analyserRec = audioContextRec.createAnalyser();
					analyserRec.fftSize = 8192; 
					analyserRec.smoothingTimeConstant = 0.2; // Lower value for quicker response to changes
					
					scope.encounter = enc;
					scope.idAudio = undefined;
					scope.chunkNo = 0;
					scope.textCaller = inputText || '';
					//scope.postConsent = postConsent;	// method that should be called if consent is ok - called from interview recording
					scope.choice = choice;
					scope.sexPat = sexPat;
					scope.recordingPatient = patient;
					scope.textareaElement = textareaElement;
					navigator.mediaDevices.getUserMedia({ audio: true })
						.then(stream => {
					        microphone = audioContextRec.createMediaStreamSource(stream);
					        microphone.connect(analyserRec);
							lastNonSilenceTime = Date.now();
							chunkRecordingDuration = 0;
							
							isRecordingSpeech = false;
							let mustSendNextChunk = true;
					        
							// Helper function to create a new MediaRecorder
							function createNewMediaRecorder(stream) {
							    const options = {
							        mimeType: 'audio/webm;codecs=opus',
							        audioBitsPerSecond: 16000,
							        channelCount: 1,
							        sampleRate: 16000
							    };
								if (!mediaRecorder) {
								    mediaRecorder = new MediaRecorder(stream, options);
								    mediaRecorder.onstart = () => {
								        //console.log("New MediaRecorder started");
										model.isRecording = true;
										scope.isPaused = false;
										scope.isProcessing = false;
										scope.$apply();
//										if (!isMediaRecorderRestart) {
//											isMediaRecorderRestart = true;
									        checkAudioLevel();
		        					        drawWaveform(stream, {});
//										}
								    };
								    
								    mediaRecorder.ondataavailable = event => {
							            console.log(`ondataavailable! mustSendNextChunk=${mustSendNextChunk}, isRecordingSpeech=${isRecordingSpeech}, chunkRecordingDuration=${chunkRecordingDuration} ms, data.size=${event.data.size} bytes` );
										if (mustSendNextChunk===false && chunkRecordingDuration==0 && !isDone()) {
											console.log('mustSendNextChunk===false and !isDone(). We ignore the chunk.');
											return;
										}
							            const formData = new FormData();
							            formData.append('audio', event.data, 'audio.webm');
							            var d2 = { 
							                'idAudio': scope.idAudio, 
							                'chunkNo': ++scope.chunkNo,
							                'isFinalChunk': isDone()
							            };
							            sendChunkWithRetry(formData, d2);
								    };
							   	}
							    
							    // Start the new recorder
							    mediaRecorder.start();
							}					        
					        					
					        function checkAudioLevel() {
								if (model.isRecording  && !scope.isPaused) {
								    let dataArray = new Float32Array(analyserRec.fftSize);
								    analyserRec.getFloatTimeDomainData(dataArray);
								    
								    // Calculate RMS (Root Mean Square) value
								    let rms = Math.sqrt(dataArray.reduce((sum, val) => sum + val * val, 0) / dataArray.length);
								    
								    // Convert RMS to dB, with a noise floor
								    let dB = 20 * Math.log10(Math.max(rms, 1e-10));
									// console.log("dB volume = " + dB);
						            // console.log("Silence:" + getIntegerPart(dB));
						            let currentTime = Date.now();
						            setDecibels(dB);
						            if (dB >= silenceThreshold) {
										//console.log("dB > silence threshold -> isRecordingSpeech = true, db = " + getIntegerPart(dB));
										isRecordingSpeech = true;
										chunkRecordingDuration += currentTime - lastNonSilenceTime;
						                lastNonSilenceTime = currentTime;
						            } else {
						                let silenceDuration = currentTime - lastNonSilenceTime;
										//console.log("dB < silence threshold (" + (10 * getIntegerPart(dB)) + "db) isRecordingSpeech=" + isRecordingSpeech);
						                if (isRecordingSpeech) {
							                if (chunkRecordingDuration>minRecordingDuration && silenceDuration>shortSilenceDuration) {
												//console.log("restart recording to create a chunk. chunkRecordingDuration=" + chunkRecordingDuration);
												mustSendNextChunk = true;
							                    restartMediaRecorder();
							                } else if (silenceDuration > longSilenceDuration) {
												// ici la pause est > 3s mais la durée est < 30s. si on a un enreg. > 1 sec mais de moins de 30 sec, on restart pour générer un chunk
												//console.log("silenceDuration > longSilenceDuration. chunkRecordingDuration=" + chunkRecordingDuration);
												mustSendNextChunk = true;
												lastNonSilenceTime = currentTime;
							                    restartMediaRecorder(true);							
											}
										} else if (silenceDuration > longSilenceDuration) {
											// chuck de 2 sec qu'on ignore si silence continue
											//console.log("On ignore ce segment: silenceDuration=" + silenceDuration);
											mustSendNextChunk = false;
											lastNonSilenceTime = currentTime;
							                restartMediaRecorder();
										}
						            }
								} else {
									//console.log("*** model.isRecording == false OU scope.isPaused");									
								}
					            if (isDone()) {
									//console.log("*** isDone() is true");									
								} else {
						            requestAnimationFrame(checkAudioLevel);									
								}
								function restartMediaRecorder(stopRecordingSpeech) {
									chunkRecordingDuration = 0; 
									if (mediaRecorder) {
										if (stopRecordingSpeech===true) {
											isRecordingSpeech = false;												
										}
										mediaRecorder.stop();
										setTimeout(() => {
											if (!isDone() && mediaRecorder.state!='recording') {
												mediaRecorder.start();
											}
										}, 120);		
									}
								}
					        }
					        createNewMediaRecorder(stream);
						})
						.catch(error => console.error('Error accessing media devices.', error));
						
				};

				function getIntegerPart(value) {
				    // Divide the value by 10 and use Math.floor to get the integer part
				    return Math.floor(value / 10);
				}
				
				scope.endRecordingViaApi = function() {
					stopRecording();
				}
				
				function togglePause() {
					if (model.isRecording) {
					    pauseRecordingWithDelay().then(() => {
						  pauseTime = Date.now();
					      model.isRecording = false;
					      scope.isPaused = true;
					      ctx.clearRect(0, 0, canvas.width, canvas.height); // Clear the waveform canvas
					      hideSilenceWarning();
					      //scope.$apply();
					    });						
					} else if (scope.isPaused) {
						var pauseDuration = pauseTime - lastNonSilenceTime;
						lastNonSilenceTime += pauseDuration ;
						mediaRecorder.resume();
						model.isRecording = true;
						scope.isPaused = false;
						drawWaveform(mediaRecorder.stream, {}); // Restart the waveform drawing
						//scope.$apply();
					}
				}

				function stopRecording() {
					model.isRecording = false;
					scope.isPaused = false;
					scope.isProcessing = true;
					ctx.clearRect(0, 0, canvas.width, canvas.height); // Clear the waveform canvas
					hideSilenceWarning();
					try {
						mediaRecorder.stop();
					} catch (error) {
						console.error('Erreur arret mediaRecorder:', error);
					}
				}

				function isDone() {
					return model.isRecording===false && scope.isPaused===false;
				}
				
				function waitForRecordingState() {
				  return new Promise((resolve) => {
				    const maxAttempts = 10; // Approximately 100ms with 10ms interval
				    let attempts = 0;
				    
				    function checkState() {
				      if (attempts >= maxAttempts) {
				        resolve(false); // Timeout, did not enter 'recording' state
				      } else {
				        attempts++;
				        
				        if (mediaRecorder.state === 'recording') {
				          resolve(true); // Entered 'recording' state
				        } else {
				          setTimeout(checkState, 10); // Check again after 10ms
				        }
				      }
				    }
				    
				    checkState();
				  });
				}
				
				async function pauseRecordingWithDelay() {
				  if (await waitForRecordingState()) {
				    try {
				      mediaRecorder.pause();
				    } catch (error) {
				      console.error('Error pausing MediaRecorder:', error);
				    }
				  } else {
				    console.log('Timeout: MediaRecorder did not enter "recording" state within the expected timeframe.');
				  }
				}				
				// Update sendChunk function to accept formData directly
				function sendChunk(formData, d2) {
					return new Promise((resolve, reject) => {
						IaAccessor.sendChunk(formData, d2,
							function onSuccess(response) {
								resolve(response);
							},
							function onFailure(error) {
								reject(error);
							}
						);
					});
				}

				
				// Add a queue to track pending chunk requests
				scope.pendingChunks = [];
				scope.processingChunk = false;
				
				// function to use a queue
				async function sendChunkWithRetry(formData, d2, maxRetries = 3) {
				    // Add this chunk request to the queue
				    const chunkRequest = { formData, d2, maxRetries };
				    scope.pendingChunks.push(chunkRequest);
				    
					function doProcessNextChunk() {
						// console.log('doSendAndGetTextResul.  scope.processingChunk=' + scope.processingChunk);
						if (scope.processingChunk===false) {
					        processNextChunk();
						} else {
							$timeout(doProcessNextChunk, 200);													
						}
			        }
					doProcessNextChunk();
				}
				
				// Function to process chunks sequentially
				async function processNextChunk() {
				    const logPrefix = '[processNextChunk]'; // Consistent prefix for logs
				
				    try {
				        if (scope.pendingChunks.length === 0) {
				            console.log(`${logPrefix} No more chunks to process. Setting processingChunk to false.`);
				            scope.processingChunk = false;
				
				            // If recording is done and we have an idAudio, get the text result
				            if (scope.idAudio && isDone()) {
				                console.log(`${logPrefix} Recording is done. Fetching text result for idAudio: ${scope.idAudio}`);
				                getTextResult(scope.idAudio);
				                scope.idAudio = undefined;
				            }
				            return;
				        }
				
				        console.log(`${logPrefix} Processing next chunk. Pending chunks left: ${scope.pendingChunks.length}`);
				        scope.processingChunk = true;
				        const { formData, d2, maxRetries } = scope.pendingChunks.shift();
						d2.idAudio = scope.idAudio;	// car possible que le premier idAudio n'était pas dispo quand objet ajoute ds array
						
				        for (let i = 0; i < maxRetries; i++) {
				            try {
				                console.log(`${logPrefix} Attempt ${i + 1}/${maxRetries} to send chunk ${d2.chunkNo}`);
				                const response = await sendChunk(formData, d2);
				
				                if (response.data && response.data.success === false) {
				                    console.error(`${logPrefix} ERR: Chunk ${d2.chunkNo} failed with message: ${response.data.ms}`);
				                } else {
				                    console.log(`${logPrefix} Success: response.idAudio=${response.data}, chunkNo=${d2.chunkNo}`);
				                    scope.idAudio = response.data === -1 ? undefined : response.data;
				                }
				
				                // Process the next chunk in the queue
				                processNextChunk();
				                return;
				            } catch (error) {
				                console.error(`${logPrefix} Attempt ${i + 1}/${maxRetries} failed for chunk ${d2.chunkNo}:`, error);
				
				                if (i === maxRetries - 1) {
				                    console.error(`${logPrefix} All retries exhausted for chunk ${d2.chunkNo}. Moving to next chunk.`);
				                    scope.processingChunk = false;
				                    processNextChunk(); // Move to the next chunk even if this one failed
				                    return;
				                }
				
				                // Exponential backoff before retrying
				                const delay = 1000 * Math.pow(2, i);
				                console.log(`${logPrefix} Retrying in ${delay}ms for chunk ${d2.chunkNo}`);
				                await new Promise(resolve => setTimeout(resolve, delay));
				            }
				        }
				    } catch (unexpectedError) {
				        console.error(`${logPrefix} Unexpected error occurred:`, unexpectedError);
				        scope.processingChunk = false; // Ensure processing is marked as done in case of unexpected errors
				    }
				}
				
				function getGranularEncData(encounter) {
					var extraData = "";
						try {
							if (encounter) {
								var l = encounter;
								var lBp = "";
								if (l.lstBloodPres && l.lstBloodPres.length && l.lstBloodPres.length>0) {
									for (i2 = 0; i2 < l.lstBloodPres.length; i2++) {
										var bp = l.lstBloodPres[i2];
										lBp += 'TA/BP: ' + OfysUtils.default(bp.systolic, '-') + '/' + OfysUtils.default(bp.diastolic, '-')  + ', FC/HR:' + OfysUtils.default(bp.pulse, '-') + ', saturation:' + OfysUtils.default(bp.saturation,'-') + '\n';
									}
								}
								var lTemp = "";
								if (l.lstBodyTemp && l.lstBodyTemp.length && l.lstBodyTemp.length>0) {
									for (i2 = 0; i2 < l.lstBodyTemp.length; i2++) {
										lTemp += 'Temperature:' + OfysUtils.default(l.lstBodyTemp[i2].bodyTemperature, '-') + '\n';
									}
								}
								var lFreq = "";
								if (l.lstFreq && l.lstFreq.length && l.lstFreq.length>0) {
									for (i2 = 0; i2 < l.lstFreq.length; i2++) {
										lFreq += 'frequence respiratoire (FR)/breathing frequency (BF): ' + OfysUtils.default(l.lstFreq[i2].respiration,'-') + '\n';
									}
								}
								//var lMeas = "";
								//if (l.lstMeasurement && l.lstMeasurement.length && l.lstMeasurement.length>0) {
								//	for (i2 = 0; i2 < l.lstMeasurement.length; i2++) {
								//		var m = l.lstMeasurement[i2];
								//		lMeas += 'poids/weight:' + m.descr[1] + ', taille/height:' + m.descr[2] + ', tour de taille/waist measurement:' + m.m.descr[3] + '\n';
								//	}
								//}
								extraData = lBp + lTemp + lFreq;
							}
						} catch (err) {
							console.error('Erreur: ' + err);
						}
					return extraData;
				}
				
				// bon pour splitter le résultat d'une note médicale pour généric et conclusion.
				function splitMedicalReport(report) {
				    const regex = /^(Analyse|Assessment|IMPRESSIONS)\b/i; // Case-insensitive match for the keywords
				    const lines = report.split('\n');
				    let splitIndex = -1;
				
				    // Find the first line that matches the criteria
				    for (let i = 0; i < lines.length; i++) {
				        if (regex.test(lines[i])) {
				            splitIndex = i;
				            break;
				        }
				    }
				
				    if (splitIndex === -1) {
				        return [report, '']; // No matching line found, return the original report and an empty string
				    }
				
				    const firstPart = lines.slice(0, splitIndex).join('\n').trim();
				    const secondPart = lines.slice(splitIndex).join('\n').trim();
				
				    return [firstPart, secondPart];
				}
				
				// bon pour mettre note gén et conclusion dans note. Mais ne fonctionne pas avec toast si note ouverte.
				function updateNotes(enc, stringArray) {
				    const noteTypeToIndex = {};
				
				    // Helper function to get or create the index for a noteType
				    function getNoteIndex(noteType, lstNote) {
				        if (!noteTypeToIndex[noteType]) {
				            const notesOfType = lstNote.filter(note => note.noteType === noteType);
				            if (notesOfType.length > 0) {
				                // Find the note with the greatest id
				                const maxIdNote = notesOfType.reduce((max, note) => note.id > max.id ? note : max);
				                noteTypeToIndex[noteType] = lstNote.indexOf(maxIdNote);
				            } else {
				                noteTypeToIndex[noteType] = -1; // No note found for this type
				            }
				        }
				        return noteTypeToIndex[noteType];
				    }
				
				    const lstNote = enc.lstNote;
				
			        const index10 = getNoteIndex(10, lstNote);
				    if (stringArray.length === 1) {
				        // Update the note with noteType 10
				        if (index10 !== -1) {
							var item = lstNote[index10].viewbag.item;
				            item.note = (item.note ? item.note +" " : "") + stringArray[0];
				        }
				    } else if (stringArray.length > 1) {
				        // Update the notes with noteType 10 and 100
				        const index100 = getNoteIndex(100, lstNote);
				
				        if (index10 !== -1) {
							var item = lstNote[index10].viewbag.item;
				            item.note = (item.note ? item.note +" " : "") + stringArray[0] + (index100==-1 ? "\n\n" + stringArray[1] : "");
				        }
				        if (index100 !== -1 ) {
							var item = lstNote[index100].viewbag.item;
				            item.note = (item.note ? item.note +" " : "") + stringArray[1];
				        }
				    }
				}				
				scope.gettingTextResult = false;
				
				function getTextResult(idAudio) {
				    // Prevent duplicate calls
				    if (scope.gettingTextResult==true || idAudio==undefined) return;
				    
				    scope.isProcessing = true;
				    
				    scope.gettingTextResult = true;
				    
					if (scope.choice === 'D') {
						IaAccessor.dictation({'idAudio': idAudio},
							function onSuccess(response) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								let text;
								if (response.data && response.data.success === false) {
									text = response.data.ms;
								} else {
									text = response.data;
								}
								iaService.insertTextAtCursor(scope.textareaElement, text);
							},
							function onFailure(res) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								console.error('Error:', res);
							}
						);
					} else if (scope.choice === 'D+') {
						IaAccessor.improveDictation({'idAudio': idAudio},
							function onSuccess(response) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								let text;
								if (response.data && response.data.success === false) {
									text = response.data.ms;
								} else {
									text = response.data;
								}
								iaService.insertTextAtCursor(scope.textareaElement, text);
							},
							function onFailure(res) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								console.error('Error:', res);
							}
						);
					} else if (scope.choice === 'DG') {
						var extraData = getGranularEncData(scope.encounter);
						IaAccessor.interviewDictation({'idAudio': idAudio, 'text': (extraData.length==0 ? "" : extraData)}, { 'noteType': noteType(), 'sexPat': scope.sexPat },
							function onSuccess(response) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								let text;
								if (response.data && response.data.success === false) {
									text = response.data.ms;
								} else {
									text = response.data;
								}
								try {
									var texts = splitMedicalReport(text);
									updateNotes(scope.encounter, texts);									
								} catch (err) {
									iaService.insertTextAtCursor(scope.textareaElement, text);
								}
							},
							function onFailure(res) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								console.error('Error:', res);
							}
						);
					} else {
						// console.log("Oups.... pas de choice detected.");
						IaAccessor.dictation({'idAudio': idAudio},
							function onSuccess(response) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								const text = response.data;
								iaService.insertTextAtCursor(scope.textareaElement, text);
							},
							function onFailure(res) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								console.error('Error:', res);
							}
						);
					}
				}

				scope.togglePause = togglePause;
				scope.stopRecording = stopRecording;

				const canvas = document.getElementById('waveformCanvas');
				const ctx = canvas.getContext('2d');
				warningVisible = false;

				function drawWaveform(stream, options = {}) {
					const {
						amplification = 4,
						verticalOffset = 0,
						lineWidth = 3,
						strokeStyle = '#00ff00',
						silenceThreshold = getSilenceThreshold(),
						silenceTimeout = 3000
					} = options;

					const audioContext = new (window.AudioContext || window.webkitAudioContext)();
					const source = audioContext.createMediaStreamSource(stream);
					const analyser = audioContext.createAnalyser();
					analyser.fftSize = 2048;
					const bufferLength = analyser.frequencyBinCount;
					const dataArray = new Uint8Array(bufferLength);
					source.connect(analyser);

					let silenceTimer = null;

					function renderFrame() {
						if (model.isRecording && !scope.isPaused) {
							requestAnimationFrame(renderFrame);
							
							analyser.getByteTimeDomainData(dataArray);
							// getDecibels est setté dans le checkAudioLevel

							ctx.clearRect(0, 0, canvas.width, canvas.height);

							if (getDecibels() < silenceThreshold && model.isRecording) {
								if (!silenceTimer) {
									silenceTimer = setTimeout(() => {
										if (model.isRecording) {
											showSilenceWarning();
										}
									}, silenceTimeout);
								}
								
							} else {
								
								if (silenceTimer) {
									clearTimeout(silenceTimer);
									silenceTimer = null;
								}
								if (warningVisible) {
									hideSilenceWarning();
								}
								
								ctx.lineWidth = lineWidth;
								ctx.strokeStyle = strokeStyle;
	
								ctx.beginPath();
								const sliceWidth = canvas.width * 1.0 / bufferLength;
								let x = 0;
								for (let i = 0; i < bufferLength; i++) {
									const v = dataArray[i] / 128.0;
	
									// Amplify the waveform
									const y = (canvas.height / 2) + ((v - 1) * (canvas.height / 2) * amplification) - verticalOffset;
	
									if (i === 0) {
										ctx.moveTo(x, y);
									} else {
										ctx.lineTo(x, y);
									}
									x += sliceWidth;
								}
								ctx.stroke();
							}
						}
					}
					renderFrame();
				}

				function showSilenceWarning() {
					document.getElementById('silence-warning').style.display = 'flex';
					warningVisible = true;
				}

				function hideSilenceWarning() {
					document.getElementById('silence-warning').style.display = 'none';
					warningVisible = false;
				}

				iaService.setIaScope(scope);

				scope.$watch('textareaElement', function(newVal) {
					if (newVal) {
						scope.textareaElement = newVal;
					}
				});

				// Add a "working" animation element
				const workingAnimationElement = document.createElement('div');
				workingAnimationElement.className = 'working-animation';
				workingAnimationElement.innerHTML = '<i class="fa fa-spinner fa-pulse"></i>';
				element.find('.floating-icon-container').append(workingAnimationElement);

				scope.$watch('isProcessing', function(newVal) {
					if (newVal) {
						workingAnimationElement.style.display = 'block';
					} else {
						workingAnimationElement.style.display = 'none';
					}
				});
				
			}
		};
	}]);

	ia.directive('addRecordingButton', ['model', 'iaService', 'QConfirm', '$compile', '$timeout', 'IaAccessor', '$translate',
		function(model, iaService, QConfirm, $compile, $timeout, IaAccessor, $translate) {
			return {
				restrict: 'A',
				link: function(scope, element, attrs) {
					scope.model = model;
					if (scope.model.clientPreferences() == undefined || scope.model.clientPreferences().aiEnabled !== true) return;

					function currentPatient() {
						if (scope.model.patient() && scope.model.patient().currPatient) {
							return scope.model.patient().currPatient;
						} else if (scope.patient) {
							return scope.patient;
						}
					}

					scope.model.iaIsWorking = false;
					var iaIsWorkingLocally = false;
					scope.iaIsWorkingLocally = function(arg) {
						if (arguments.length === 1) {
							scope.model.iaIsWorking = arg;
							iaIsWorkingLocally = arg;
						} else {
							return iaIsWorkingLocally;
						}
					}

					scope.getConsentRecPat = function() {
						return 11;	// consent = true
//						if (scope.model.patient() && scope.model.patient().currPatient) {
//							return scope.model.patient().currPatient.consentRecording;
//						}
//						return undefined;
					}

					function getSexPat() {
						if (scope.model.patient() && scope.model.patient().currPatient) {
							return scope.model.patient().currPatient.gender; // val I, M, F
						}
						return 'I';
					}

					scope.medNoteType = function(b) {
						if (b != undefined) {
							scope.model.prefSettings('user_settings_medNoteType', b);
						} else {
							return scope.model.prefSettings('user_settings_medNoteType');
						}
					}

					scope.contextData = attrs.contextData;

					var isToast = 'toast' == attrs.contextEditor;
					//scope.encounter = scope.$eval(attrs.encounter);

					var textNode;	// la directive est dans la directive toast-editor
					if (isToast) {
						textNode = element[0].children.note;
					} else {
						textNode = element[0];
						element[0].style.marginTop = "25px";// pour éviter que les destinataires soit caché dans la tâche et le sujet des messages soit caché.
					}

					//var contextAlways = ['Plan','Task','Message'];
					//scope.showMicBtn = function() {
					//	return contextAlways.indexOf(scope.contextData)!=-1 || (scope.encounter && scope.encounter.editMode == true);
					//};

					// Main container
					var div = document.createElement('div');
					div.className = 'ia-divButtons';
					
					var selectMenuType;
			
					var isInSommaire = 'Encounter' == scope.contextData && scope.def && scope.def.hideNoteTypes === true;
					if ('Encounter' == scope.contextData && !isInSommaire) {
						var div1 = document.createElement('div');
						div1.style.cssText = "padding: 0px 6px 0px 4px;";
						div1.setAttribute('ng-click', 'interviewDictation()');
						div1.setAttribute('title', $translate.instant('RECORD_INTERVIEW'));
						
						var dictationBtn = document.createElement('i');
						dictationBtn.className = 'fa fa-microphone ia-color fa-lg';
						div1.appendChild(dictationBtn);
						div.appendChild(div1);
						
						var div2 = document.createElement('div');
						
						selectMenuType = document.createElement('select');
						selectMenuType.style.cssText = 'width:100%';
						selectMenuType.setAttribute('data-ng-model', 'medNoteType');
						selectMenuType.setAttribute('data-ng-model-options', '{ getterSetter: true }');

						var options = [
							{ value: '102', text: $translate.instant('UserSetting_medNoteType102') },
							{ value: '104', text: $translate.instant('UserSetting_medNoteType104') },
							{ value: '115', text: $translate.instant('UserSetting_medNoteType115') },
							{ value: '116', text: $translate.instant('UserSetting_medNoteType116') }
						];

						options.forEach(function(option) {
							var optionElement = document.createElement('option');
							optionElement.value = option.value;
							optionElement.textContent = option.text;
							selectMenuType.appendChild(optionElement);
						});
						div2.appendChild(selectMenuType);

						div.appendChild(div2);
					}

					var div3 = document.createElement('div');

					// Toggle Dropdown Button
					var toggleBtn = document.createElement('div');
					toggleBtn.setAttribute('ng-click', 'toggleDropdown($event)');
					toggleBtn.className = 'ia-toggle-btn';
					toggleBtn.setAttribute('data-ng-class', "{'disabled':model.iaIsWorking}");

					// Superpowers icon
					var superpowersIcon = document.createElement('i');
					superpowersIcon.className = 'fa fa-superpowers ia-color';
					superpowersIcon.setAttribute('data-ng-class', "{'fa-spin': iaIsWorkingLocally()}");
					superpowersIcon.setAttribute('title', $translate.instant('SOFIA_IA'));

					// Caret icon
					var caretIcon = document.createElement('i');
					caretIcon.className = 'fa';
					caretIcon.setAttribute('ng-class', "{'fa-caret-down': !isDropdownOpen, 'fa-caret-up': isDropdownOpen}");

					toggleBtn.appendChild(superpowersIcon);
					toggleBtn.appendChild(caretIcon);

					// Dropdown Items
					var items = [
						{ context: ['all'], click: 'dictation()', text: $translate.instant('DICTATION'),  iconStart: 'fa fa-microphone' },
						{ context: ['all'], click: 'improvedDictation()', text: $translate.instant('IMPROVED_DICTATION'),  iconStart: 'fa fa-microphone' },
						{ context: ['all'], click: 'improve()', text: $translate.instant('IMPROVE') },
						{ context: ['all'], click: 'translateToFrench()', text: $translate.instant('TRANSLATE_FR') },
						{ context: ['all'], click: 'translateToEnglish()', text: $translate.instant('TRANSLATE_EN') },
						{ context: ['Encounter'], click: 'generateMedicalNote("-")', text: $translate.instant('GENERATE_MEDICAL_NOTE'),  iconEnd: 'fa fa-magic' },
						{ context: ['Encounter'], click: 'noteInfoClin4Form("-")', text: $translate.instant('GENERATE_ENC_CLIN_INFO_4FORM') },
					];

					var filteredItems = items.filter((item, index) =>
						(item.context.indexOf(scope.contextData) != -1 && !(scope.def && scope.def.hideNoteTypes === true)) || item.context.indexOf('all') != -1
					);
					
					// Dropdown Menu
					var dropdown = document.createElement('ul');
					dropdown.className = 'ia-dropdown-menu';
					dropdown.style.cssText="width:250px;";
					
					filteredItems.forEach(function(item) {
						var li = document.createElement('li');
						li.setAttribute('ng-click', item.click);
						if (item.iconStart) {
							var sp1 = document.createElement('span');
							var icon = document.createElement('i');
							icon.className = item.iconStart;
							icon.style.cssText='padding-right: 5px;';
							sp1.appendChild(icon);
							li.appendChild(sp1);
						}
						var a = document.createElement('a');
						a.innerHTML = '{{ "' + item.text + '" | translate }}';
						li.appendChild(a);
						if (item.iconEnd) {
							var sp2 = document.createElement('span');
							var icon = document.createElement('i');
							icon.className = item.iconEnd;
							icon.style.cssText='padding-left: 5px;';
							sp2.appendChild(icon);
							li.appendChild(sp2);
						}
						dropdown.appendChild(li);
					});
					toggleBtn.appendChild(dropdown);

					// Compile all elements
					div3.appendChild(toggleBtn);
					div.appendChild(div3);
					
					const dropDownPos = "width: 200px;left: -150px;";
					if (scope.def && scope.def.hideNoteTypes === true) {
						// dans une toast editor de l'edition du commaire
						div.style.cssText = "right: 0px;top: -30px;";
						dropdown.style.cssText = dropDownPos;
					} else if ('Plan' == scope.contextData) {	// est aussi toast... 
						div.style.cssText = "right: 4px;top: 0px;";
						dropdown.style.cssText = dropDownPos;
					} else if (isToast) {
						div.style.cssText = "left: 196px;top: -38px;right: unset;";
					} else if ('Task' == scope.contextData || 'Message' == scope.contextData) {
						dropdown.style.cssText = dropDownPos;
					} else if ('MessageTab' == scope.contextData) {
						dropdown.style.cssText = "right:0px; left:unset;width: 200px;";
						div.style.cssText = "position: relative;top: -205px !important;right:-550px;width:50px";
					}
					// Compile the template
					var compiled = $compile(div)(scope);
					element.parent().append(compiled);

					// Utiliser $timeout pour s'assurer que le DOM est mis à jour
					$timeout(function() {
						// Définir la valeur du select
						if (selectMenuType) selectMenuType.value = scope.medNoteType();
						// Déclencher un événement de changement pour s'assurer que Angular met à jour le modèle
						// selectMenu.dispatchEvent(new Event('change'));
					});

					scope.isDropdownOpen = false;

					function isClickOutside(event) {
						return !div.contains(event.target) && !toggleBtn.contains(event.target);
					}

					function closeDropdown(event) {
						if (isClickOutside(event) && scope.isDropdownOpen) {
							scope.isDropdownOpen = false;
							dropdown.parentElement.classList.remove('ia-is-open');
							if (scope.$root && !scope.$root.$$phase) {
								scope.$apply();
							}
						}
					}

					// Listen for the broadcast event
					scope.$on('closeDropdown', function(event, originalEvent) {
						closeDropdown(originalEvent);
					});

					// Also set up a document click listener as a fallback
					angular.element(document).on('click', function(event) {
						closeDropdown(event);
					});

					scope.toggleDropdown = function(event) {
						event.stopPropagation();
						scope.isDropdownOpen = !scope.isDropdownOpen;
						dropdown.parentElement.classList.toggle('ia-is-open', scope.isDropdownOpen);
					};

					// Clean up the document click listener when the directive is destroyed
					scope.$on('$destroy', function() {
						angular.element(document).off('click', closeDropdown);
					});

					scope.improve = function() {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.improveText({ text: textNode.value, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.generateMedicalNote = function(l) {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.medNoteFromNote({ text: textNode.value, noteType: scope.medNoteType(), lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									if (response.data && response.data.success === false) {
										console.error('Error:', response);
										scope.iaIsWorkingLocally(false);
									} else {
										try {
											// see encounter.js, ligne 5328 et 5488 'structured'
											scope.iaIsWorkingLocally(false);
											showModal(response.data, true);
											//const mednote = OfysUtils.parseJson(response.data);
											//if (mednote==null) {
											//	showModal(response.data, true);
											//} else {
											//	showModal(mednote.note, true);
											// ici il faudrait afficher aussi les valeurs structurées 
											// et permettre de désélectionner ceux qu'on ne veut pas intégrer structurés dans la rencontre.
											//}

										} catch (error) {
											console.error('Erreur de parsing:', error);
										}


									}
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					// TODO ouvrier nouveau chat pour send to patient.
					scope.generatePatientSummary = function(l) {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.generatePatientSummary({ text: textNode.value, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};
					scope.noteInfoClin4Form = function(l) {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.noteInfoClin4Form({ text: textNode.value, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.translateToFrench = function() {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.toFrench({ text: textNode.value, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.translateToEnglish = function() {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.toEnglish({ text: textNode.value, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.dictation = function() {
						iaService.startRecording(textNode, textNode.value, 'D', getSexPat(), currentPatient());
					};

					scope.improvedDictation = function() {
						iaService.startRecording(textNode, textNode.value, 'D+', getSexPat(), currentPatient());
					};

					//scope.interviewDictation = function() {
					//	iaService.startRecording(textNode, textNode.value, 'DG', getSexPat(), currentPatient(), scope.enc);
					//};

					scope.interviewDictation = function() {
						if (scope.getConsentRecPat() !== 11) {
							//showModalConsent();
							model.notice().warn($translate.instant('PATIENT_DID_NOT_CONSENT_TO_RECORDING')+$translate.instant('PATIENT_DID_NOT_CONSENT_TO_RECORDING_INFO'));
						} else {
							if (model.isRecording == true || scope.isProcessing == true) {
								model.notice().warn($translate.instant('recordingAlreadyInProgress'));
								return;
							}
							askForConsentGiven();
						}
					};
					function askForConsentGiven(){
						var qconfirmOptions = {title: $translate.instant('consentementObtenu')};
	
						QConfirm.open(qconfirmOptions).then(proceedWithEditCancel);
						function proceedWithEditCancel(proceed){
							if(proceed){
								iaService.startRecording(textNode, textNode.value, 'DG', getSexPat(), currentPatient(), scope.enc);								
							}
						}
					}

					function showModal(text, showReplaceButton) {
						scope.text = text;
						scope.showReplaceButton = showReplaceButton;
						scope.readOnly = false;
						var modal = angular.element(`
					        <div class="ia-modal">
					            <div class="ia-modal-content">
					                <div class="draggable-handle-not-used"></div>
					                <div class="textarea-container" ng-class="{ 'locked': readOnly }">
					                <i ng-show="readOnly" class="fa fa-lock lock-icon"></i>
					                <textarea class="ia-texte" ng-readonly="readOnly">{{text}}</textarea>
					                <span class="ia-resp-valid">{{'VOTRE_RESP_DE_VALIDER'|translate}}</span>
					                <div class="button-group">
					                    <button ng-click="copyToClipboard()">{{'copy_app'|translate}}</button>
					                    <button ng-if="showReplaceButton" ng-click="copyToTextarea()">{{'REPLACE_TEXT'|translate}}</button>
					                    <button ng-click="closeModal()">{{'Close'|translate}}</button>
					                </div>
					            </div>
					            </div>
					        </div>
					    `);
						var compiledContent = $compile(modal)(scope);
						document.body.appendChild(compiledContent[0]);

						// Add draggable functionality
						var modalContent = compiledContent.find('.ia-modal-content')[0];
						var dragHandle = modalContent.querySelector('.draggable-handle');

						if (dragHandle) {
							var isDragging = false;
							var startX, startY, initialLeft, initialTop;

							dragHandle.addEventListener('mousedown', function(event) {
								event.preventDefault();
								isDragging = true;

								var rect = modalContent.getBoundingClientRect();
								startX = event.clientX;
								startY = event.clientY;
								initialLeft = rect.left;
								initialTop = rect.top;

								document.addEventListener('mousemove', handleMouseMove);
								document.addEventListener('mouseup', handleMouseUp);
							});

							function handleMouseMove(event) {
								if (!isDragging) return;

								var deltaX = event.clientX - startX;
								var deltaY = event.clientY - startY;

								var newLeft = initialLeft + deltaX;
								var newTop = initialTop + deltaY;

								var maxX = window.innerWidth - modalContent.offsetWidth;
								var maxY = window.innerHeight - modalContent.offsetHeight;

								newLeft = Math.min(Math.max(newLeft, 0), maxX);
								newTop = Math.min(Math.max(newTop, 0), maxY);

								modalContent.style.left = newLeft + 'px';
								modalContent.style.top = newTop + 'px';
								modalContent.style.transform = 'none'; // Remove the centering transform
							}

							function handleMouseUp() {
								isDragging = false;
								document.removeEventListener('mousemove', handleMouseMove);
								document.removeEventListener('mouseup', handleMouseUp);
							}
						}

						scope.copyToTextarea = function() {
							iaService.replaceText(textNode, text);
							modal.remove();
						};

						// dans la méthode de retour, assigner une nouvelle methode selon ce qu'on veut avoir ou non le bouton "remplacer le texte"
						scope.hasParentText = function() { return true; };

						scope.closeModal = function() {
							modal.remove();
						};

						// Copier dans le presse-papier
						scope.copyToClipboard = function() {
							var textarea = compiledContent.find('textarea')[0];
							textarea.select();
							document.execCommand('copy');
							modal.remove();
						};
					};

				}
			};
		}
	]);

	ia.directive('addAiButton', ['iaService', '$compile', 'IaAccessor', '$translate', '$filter',
		function(iaService, $compile, IaAccessor, $translate, $filter) {
			return {
				restrict: 'A',
				link: function(scope, element, attrs) {
					if (scope.model.clientPreferences() == undefined || scope.model.clientPreferences().aiEnabled !== true) return;

					scope.encounter = scope.$eval(attrs.encounter);

					function currentPatient() {
						if (typeof scope.patient === 'function' && scope.model.patient() && scope.model.patient().currPatient) {
							return scope.model.patient().currPatient;
						} else if (scope.patient && typeof scope.patient !== 'function') {
							return scope.patient;
						} else if (typeof scope.getPatient === 'function' && scope.getPatient()) {
							return scope.getPatient();
						} else if (scope.doc && typeof scope.doc !== 'function' && scope.doc.patient) {
							return scope.doc.patient;
						} else if (scope.quickViewData && scope.quickViewData.pat) {
							return scope.quickViewData.pat;
						}
					}

					const CONSENT_UNKNOW = $translate.instant('RECORD_PATIENT_CONSENT_TO_RECORDING');
					const CONSENTED = $translate.instant('PATIENT_CONSENTED_TO_RECORDING');
					const DID_NOT_CONSENT = $translate.instant('PATIENT_DID_NOT_CONSENT_TO_RECORDING');
					const CONSENT_UNCLEAR = $translate.instant('PATIENT_CONSENT_UNCLEAR');
					const IN_FRENCH = $filter('translate')('IN_FRENCH');
					const IN_ENGLISH = $filter('translate')('IN_ENGLISH');
					const LANG = { 'fr': IN_FRENCH, 'en': IN_ENGLISH, '-': '' };
					scope.contextData = attrs.contextData;

					scope.isProf = function() {
						return scope.model.user().isClinician();
					};
					scope.isMedSecretary = function() {
						return scope.model.user().isClinician() !== true && scope.model.user().hasClinicalRights;
					};

					scope.iaEncData = function() {
						var pt = currentPatient();
						if (pt) {
							return pt.iaEncData;
						}
					}

					scope.model.iaIsWorking = false;
					var iaIsWorkingLocally = false;
					scope.iaIsWorkingLocally = function(arg) {
						if (arguments.length === 1) {
							scope.model.iaIsWorking = arg;
							iaIsWorkingLocally = arg;
						} else {
							return iaIsWorkingLocally;
						}
					}

					function getSexPat() {
						var pt = currentPatient();
						if (pt) {
							return pt.gender; // val I, M, F
						}
						return 'I';
					}

					scope.getConsentRecPat = function() {
						var pt = currentPatient();
						if (pt) {
							return 11;
							// return pt.consentRecording;
						}
						return undefined;
					}

					scope.getConsentRecPatDate = function() {
						var pt = currentPatient();
						if (pt) {
							return "\n" + pt.consentRecordingDate;
						}
						return undefined;
					}

					scope.getTitle4ConsentRecPat = function() {
						var pt = currentPatient();
						if (pt) {
							var consentRec = pt.consentRecording;
							if (consentRec == undefined || consentRec === 0) {
								return CONSENT_UNKNOW;
							} else if (consentRec === 11) {
								return CONSENTED + scope.getConsentRecPatDate();
							} else if (consentRec === 12) {
								return DID_NOT_CONSENT + scope.getConsentRecPatDate();
							} else if (consentRec === 13) {
								return CONSENT_UNCLEAR + scope.getConsentRecPatDate();
							}
						}
					}


					function getIdsForDoc() {
						var idPatient;
						var qvId;
						const currentPatientData = scope.docNote || scope.doc ? null : (currentPatient() || null);
						if (scope.docNote) {
							idPatient = scope.docNote.idPatient;
							qvId = scope.docNote.id;
						} else if (scope.doc) {
							idPatient = scope.doc.idPatient;
							qvId = scope.doc.id;
						} else if (currentPatientData) {
							idPatient = currentPatientData.idPatient;
							if (scope.quickViewData && scope.quickViewData.qvActData) {
								qvId = scope.quickViewData.qvActData.id;
							}
						}
						return { idPatient: idPatient, idObj: qvId };
					}

					function getIdsForLab() {
						var idPatient;
						var qvId;
						if (scope.labNote) {
							idPatient = scope.labNote.idPatient;
							qvId = scope.labNote.id;
						} else if (scope.model.patient().currPatient) {
							idPatient = scope.model.patient().currPatient.idPatient;
							if (scope.quickViewData && scope.quickViewData.qvActData) {
								qvId = scope.quickViewData.qvActData.id;
							}
						}
						return { idPatient: idPatient, idObj: qvId };
					}

					scope.hasDocId = function() {
						if (scope.contextData === "Doc") {
							var ids = getIdsForDoc();
							return ids.idObj !== undefined;
						}
						return false;
					}

					// Main container
					var div = document.createElement('div');
					div.className = 'ia-divButtons';

					// Toggle Dropdown Button
					var toggleBtn = document.createElement('div');
					toggleBtn.setAttribute('ng-click', 'toggleDropdown($event)');
					toggleBtn.className = 'ia-toggle-btn';
					toggleBtn.setAttribute('ng-class', "{'disabled':model.iaIsWorking}");

					// Superpowers icon
					var superpowersIcon = document.createElement('i');
					superpowersIcon.className = 'fa fa-superpowers ia-color';
					superpowersIcon.setAttribute('ng-class', "{'fa-spin': iaIsWorkingLocally()}");
					superpowersIcon.setAttribute('title', $translate.instant('SOFIA_IA'));

					// Caret icon
					var caretIcon = document.createElement('i');
					caretIcon.className = 'fa';
					caretIcon.setAttribute('ng-class', "{'fa-caret-down': !isDropdownOpen, 'fa-caret-up': isDropdownOpen}");

					toggleBtn.appendChild(superpowersIcon);
					toggleBtn.appendChild(caretIcon);

					// Dropdown Menu
					var dropdown = document.createElement('ul');
					dropdown.className = 'ia-dropdown-menu';

					scope.getLastEnc3yText = function() {
						return $filter('translate')('LAST_ENC_3Y') + ' (' + scope.iaEncData().dateCreated + ')';
					}
					scope.getTranslatedText = function(ttt, l, iaDate) {
						return $filter('translate')(ttt) + LANG[l] + (iaDate && scope.iaEncData() ? ' (' + scope.iaEncData().dateCreated + ')' : '');
					}
					// Dropdown Items   
					var items = [	// $filter('translate')(
						{ context: ['Encounter'], ngif: "isProf()", click: 'summaryEnc4Prof("fr")', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PROF', 'fr')" },
						{ context: ['Encounter'], ngif: "isProf()", click: 'summaryEnc4Prof("en")', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PROF', 'en')" },
						{ context: ['Encounter'], ngif: "isProf()||isMedSecretary()", click: 'summaryEnc4Pat("fr")', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PAT', 'fr')" },
						{ context: ['Encounter'], ngif: "isProf()||isMedSecretary()", click: 'summaryEnc4Pat("en")', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PAT', 'en')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'summaryEnc4Prof("fr", true)', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PROF', 'fr')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'summaryEnc4Prof("en", true)', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PROF', 'en')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'summaryEnc4Pat("fr", true)', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PAT', 'fr')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'summaryEnc4Pat("en", true)', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PAT', 'en')" },
						{ context: ['Patient', 'QvPatient'], ngif: "isProf()", click: 'summaryFile4Prof("fr")', text: "getTranslatedText('GENERATE_SUMMARY_FILE_4PROF', 'fr')" },
						{ context: ['Patient', 'QvPatient'], ngif: "isProf()", click: 'summaryFile4Prof("en")', text: "getTranslatedText('GENERATE_SUMMARY_FILE_4PROF', 'en')" },
						{ context: ['Patient', 'QvPatient'], ngif: "(isProf()) && iaEncData()!=undefined", click: 'getLastEnc3y("-")', text: "getTranslatedText('LAST_ENC_3Y','-',true)" },
						{ context: ['Patient', 'QvPatient'], ngif: "isProf()", click: 'lastEnc3y("fr")', text: "getTranslatedText('LAST_ENC_3Y','fr')" },
						{ context: ['Patient', 'QvPatient'], ngif: "isProf()", click: 'lastEnc3y("en")', text: "getTranslatedText('LAST_ENC_3Y','en')" },
						{ context: ['Encounter'], ngif: "isProf()", click: 'encInfoClin4Form("-")', text: "getTranslatedText('GENERATE_ENC_CLIN_INFO_4FORM','-')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'encInfoClin4Form("-", true)', text: "getTranslatedText('GENERATE_ENC_CLIN_INFO_4FORM','-')" },
						{ context: ['Doc'], ngif: "isProf()", click: 'summaryOfDoc4Prof("fr")', text: "getTranslatedText('GENERATE_SUMMARY_DOC_4PROF','fr')" },
						{ context: ['Doc'], ngif: "isProf()", click: 'summaryOfDoc4Prof("en")', text: "getTranslatedText('GENERATE_SUMMARY_DOC_4PROF','en')" },
						{ context: ['Doc'], ngif: "isProf()", click: 'summaryOfDoc4Pat("fr")', text: "getTranslatedText('GENERATE_SUMMARY_DOC_4PAT', 'fr')" },
						{ context: ['Doc'], ngif: "isProf()", click: 'summaryOfDoc4Pat("en")', text: "getTranslatedText('GENERATE_SUMMARY_DOC_4PAT', 'en')" },
						//{ context:['Lab'], ngif:"isProf()||isMedSecretary()", click: 'summaryOfLab4Pat("fr")', text: "getTranslatedText('GENERATE_SUMMARY_LAB_4PAT', 'fr')" },
						//{ context:['Lab'], ngif:"isProf()||isMedSecretary()", click: 'summaryOfLab4Pat("en")', text: "getTranslatedText('GENERATE_SUMMARY_LAB_4PAT', 'en')" },
					];
					var filteredItems = items.filter((item, index) => item.context.indexOf(scope.contextData) != -1);

					filteredItems.forEach(function(item) {
						var li = document.createElement('li');
						li.addEventListener('click', function() {
							scope.$apply(function() {
								scope.isDropdownOpen = false;
								dropdown.parentElement.classList.remove('ia-is-open');
							});
						});
						li.setAttribute('ng-show', item.ngif);
						li.setAttribute('ng-click', item.click);

						var a = document.createElement('a');
						a.setAttribute('ng-bind-html', item.text);

						li.appendChild(a);
						dropdown.appendChild(li);
					});
					var isPatient = scope.contextData === "Patient" || scope.contextData == 'QvPatient';
					if (false && isPatient) {
						var consentBtn = document.createElement('button');
						consentBtn.setAttribute('ng-click', 'consent()');
						consentBtn.className = 'ia-dictation-btn';
						consentBtn.setAttribute('title', '{{getTitle4ConsentRecPat()}}');
						consentBtn.setAttribute('data-ng-class', "{'ia-consented-recording': getConsentRecPat()===11, 'ia-not-consented-recording': getConsentRecPat()===12, 'ia-unclear-consented-recording': getConsentRecPat()===13}");

						var micIcon = document.createElement('i');
						micIcon.className = 'fa fa-microphone';
						consentBtn.appendChild(micIcon.cloneNode(true));

						var cSpan = document.createElement('span');
						cSpan.style.fontSize = '10px';
						cSpan.textContent = 'c';
						consentBtn.appendChild(cSpan);
					}

					// Compile all elements
					div.appendChild(toggleBtn);
					//if (isPatient) {
						//div.appendChild(consentyBtn);
					//}
					div.appendChild(dropdown);

					if (scope.contextData === 'Patient') {
						div.style.cssText = "top:48px;" + (scope.model.isWeb() ? "right:260px;" : "right:280px;");
						dropdown.style.cssText = "right:0px;";
					} else if (scope.contextData === "Doc") {
						if (scope.hasDocId()) {
							div.style.cssText = "top: unset; margin-top: 4px;right: 48px;";
							dropdown.style.cssText = "right: 0px;";
						} else {
							div.classList.add('hidden');
						}
					} else if (scope.contextData === "Lab") {
						div.style.cssText = "top: unset; margin-top: 10px;right: 16px;";
						dropdown.style.cssText = "right: 0px;";
					} else if (scope.contextData === "QvPatient") {
						div.style.cssText = "top: 2px;height: 20px;left: 312px;width: 49px;";
						//consentBtn.style.cssText = "height: 15px;padding: 0px 4px;margin-left: 4px;";
						dropdown.style.cssText = "right: unset;";
					} else if (scope.contextData === "EncounterNote") {
						div.style.cssText = "top: -5px;left: 140px;right: unset;";
						dropdown.style.cssText = "right: unset;";
					} else if (scope.contextData === "Encounter") {
						div.style.cssText = "top: 1px;right: unset; left: 80px;";
						dropdown.style.cssText = "right: unset;";
						//					} else if (element[0].classList.contains('is-doc')) {
						//						div.style.cssText = "right: -360px;top: -35px;";
					}
					// Compile the template
					var compiled = $compile(div)(scope);

					element.parent().append(compiled);
					scope.isDropdownOpen = false;


					function isClickOutside(event) {
						return !div.contains(event.target) && !toggleBtn.contains(event.target);
					}

					function closeDropdown(event) {
						if (isClickOutside(event) && scope.isDropdownOpen) {
							scope.isDropdownOpen = false;
							dropdown.parentElement.classList.remove('ia-is-open');
							if (!scope.$root.$$phase) {
								scope.$apply();
							}
						}
					}

					// Listen for the broadcast event
					scope.$on('closeDropdown', function(event, originalEvent) {
						closeDropdown(originalEvent);
					});

					// Also set up a document click listener as a fallback
					angular.element(document).on('click', function(event) {
						closeDropdown(event);
					});

					scope.toggleDropdown = function(event) {
						event.stopPropagation();
						scope.isDropdownOpen = !scope.isDropdownOpen;
						dropdown.parentElement.classList.toggle('ia-is-open', scope.isDropdownOpen);
					};

					// Clean up the document click listener when the directive is destroyed
					scope.$on('$destroy', function() {
						angular.element(document).off('click', closeDropdown);
					});


					scope.summaryFile4Prof = function(l) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryFile4Prof({ id: idPatient, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.getLastEnc3y = function(l) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							scope.iaIsWorkingLocally(true);
							IaAccessor.getLastEnc3y({ idPatient: idPatient, idLink: idPatient, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.lastEnc3y = function(l) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							scope.iaIsWorkingLocally(true);
							IaAccessor.lastEnc3y({ idPatient: idPatient, idLink: idPatient, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									pt.iaEncData = { note: text, dateCreated: moment().format('YYYY-MM-DD') };
									scope.iaIsWorkingLocally(false);
									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.summaryEnc4Prof = function(l, useText) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							var idEnc = scope.editEnc.idAnchor;
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryEnc4Prof({ idPatient: idPatient, idLink: idEnc, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.summaryEnc4Pat = function(l, useText) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							var idEnc = scope.editEnc.idAnchor;
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryEnc4Pat({ idPatient: idPatient, idLink: idEnc, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.encInfoClin4Form = function(l, useText) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							var idEnc = scope.editEnc.idAnchor;
							scope.iaIsWorkingLocally(true);
							IaAccessor.encInfoClin4Form({ idPatient: idPatient, idLink: idEnc, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.summaryOfDoc4Prof = function(l) {
						var ids = getIdsForDoc();
						if (ids.idPatient && ids.idObj) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryOfDoc4Prof({ idPatient: ids.idPatient, idLink: ids.idObj, lang: l },
								function onSuccess(response) {
									const text = response.data;
									if (scope.docNote.aiData) {
										scope.docNote.aiData.note = text;
									} else {
										scope.docNote.aiData = { 'note': text };
									}
									scope.iaIsWorkingLocally(false);
									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}

					};

					scope.summaryOfDoc4Pat = function(l) {
						var ids = getIdsForDoc();
						var pt = currentPatient();
						if (pt && ids.idPatient && ids.idObj) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryOfDoc4Pat({ idPatient: ids.idPatient, idLink: ids.idObj, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.summaryOfLab4Pat = function(l) {
						var ids = getIdsForLab();
						var pt = currentPatient();
						if (pt && ids.idPatient && ids.idObj) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryOfLab4Pat({ idPatient: ids.idPatient, idLink: ids.idObj, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					//scope.consent = function() {
					//	iaService.startRecording(undefined, undefined, 'C', getSexPat(), currentPatient());
					//};

					function showModal(text, showReplaceButton, readOnly) {
						scope.text = text;
						scope.readOnly = readOnly;
						scope.showReplaceButton = showReplaceButton;
						var modal = angular.element(`
					        <div class="ia-modal">
					            <div class="ia-modal-content">
					                <div class="draggable-handle-not-used"></div>
					                <div class="textarea-container" ng-class="{ 'locked': readOnly }">
					                <i ng-show="readOnly" class="fa fa-lock lock-icon"></i>
					                <textarea class="ia-texte" ng-readonly="readOnly">{{text}}</textarea>
					                <span class="ia-resp-valid">{{'VOTRE_RESP_DE_VALIDER'|translate}}</span>
					                <div class="button-group">
					                    <button ng-click="copyToClipboard()">{{'copy_app'|translate}}</button>
					                    <button ng-if="showReplaceButton" ng-click="copyToMessage()">{{'REPLACE_TEXT'|translate}}</button>
					                    <button ng-click="closeModal()">{{'Close'|translate}}</button>
					                </div>
					            </div>
					            </div>
					        </div>
					    `);
						var compiledContent = $compile(modal)(scope);
						document.body.appendChild(compiledContent[0]);

						// Add draggable functionality
						var modalContent = compiledContent.find('.ia-modal-content')[0];
						var dragHandle = modalContent.querySelector('.draggable-handle');

						if (dragHandle) {
							var isDragging = false;
							var startX, startY, initialLeft, initialTop;

							dragHandle.addEventListener('mousedown', function(event) {
								event.preventDefault();
								isDragging = true;

								var rect = modalContent.getBoundingClientRect();
								startX = event.clientX;
								startY = event.clientY;
								initialLeft = rect.left;
								initialTop = rect.top;

								document.addEventListener('mousemove', handleMouseMove);
								document.addEventListener('mouseup', handleMouseUp);
							});

							function handleMouseMove(event) {
								if (!isDragging) return;

								var deltaX = event.clientX - startX;
								var deltaY = event.clientY - startY;

								var newLeft = initialLeft + deltaX;
								var newTop = initialTop + deltaY;

								var maxX = window.innerWidth - modalContent.offsetWidth;
								var maxY = window.innerHeight - modalContent.offsetHeight;

								newLeft = Math.min(Math.max(newLeft, 0), maxX);
								newTop = Math.min(Math.max(newTop, 0), maxY);

								modalContent.style.left = newLeft + 'px';
								modalContent.style.top = newTop + 'px';
								modalContent.style.transform = 'none'; // Remove the centering transform
							}

							function handleMouseUp() {
								isDragging = false;
								document.removeEventListener('mousemove', handleMouseMove);
								document.removeEventListener('mouseup', handleMouseUp);
							}
						}

						scope.copyToTextarea = function() {
							iaService.replaceText(element[0], text);
							modal.remove();
						};

						scope.closeModal = function() {
							modal.remove();
						};

						// Copier dans le presse-papier
						scope.copyToClipboard = function() {
							var textarea = compiledContent.find('textarea')[0];
							textarea.select();
							document.execCommand('copy');
							modal.remove();
						};
					};

				}
			};
		}
	]);

})();