(function(){
    var fax = angular.module("fax", []);

	fax.factory('FaxAccessor', ['DashAPI', 'model', '$filter', 'PatientAccessor', 'QuickEdit', 'MessageLink',
		function (DashAPI, model, $filter, PatientAccessor, QuickEdit, MessageLink) {
			var accessor = {
					patientlist: function (data, callback, error) {
						DashAPI.get('/dashboard/fax/ws/bypat?id=' + data.id, callback, error);
					},
					find: function (query, callback, error) {
						return DashAPI.post('/dashboard/fax/ws/find', query, callback, error);
					},
					findIds: function (query, callback, error) {
						return DashAPI.post('/dashboard/fax/ws/findIds', query, callback, error);
					},
					listOnDate: function (data, callback, error) {
						return DashAPI.get('/dashboard/fax/ws/listOnDate?d=' + data.date + '&idUser=' + model.user().sessionUser.user.id, callback, error);
					},
					byIds: function (data, callback, error) {
						return DashAPI.post('/dashboard/fax/ws/byIds', data, callback, error);
					},
					save: function (fax, callback, error) {
						return DashAPI.post('/dashboard/fax/ws/save', fax, callback, error);
					},
					utils:{
						faxView : function (data, callback, error){
							var param = '?id=' + data.id;
							if (data.faxId && data.faxId>-1) {
								param +='&faxId=' + data.faxId;
							}
							DashAPI.get('/dashboard/fax/ws/faxView' + param, callback, error);
						},
					},
					msgLinkMap:{},//Used for message/task link of current document.
					updateMessageLink: function (patient,scope){
						accessor.messageLinkKey = MessageLink.setLinkType({
							patient: patient.id,
							linkType: MessageLink.linkTypes.patient,
							id: patient.id,
							pat: patient
						},scope);
						accessor.msgLinkMap[patient.uid] = accessor.messageLinkKey
					}
			};
			return accessor;
		}]);

    fax.directive('faxData', ['model','PatientAccessor','FaxAccessor','$filter',
        function (model, PatientAccessor, FaxAccessor, $filter) {
       return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/fax/faxData.html?v=bf',
			link: function(scope, element, attrs){
				scope.listSize = function() {
					return model.listPatSize();
				};
	    		function updateDataSourceByIds(ids){

	    			if (ids===undefined || ids.length===0) {
	    				scope.currList = [];
	    				scope.currIds = [];
	    				return;
	    			}
	    			scope.isLoading = true;

	    			scope.currIds = ids;
	    			scope.totalItems = ids.length;

					FaxAccessor.byIds({ids:scope.currIds},function success(response){
						if (response.data && response.data && response.data.length>0) {
							var faxs = $filter('orderBy')(response.data, '-stamp');
							scope.currList = faxs;
						}
						scope.isLoading = false;
					}, function fail(res) {
						//$log.log("ChatAccessor.byIds FAIL : " +res);
						scope.isLoading = false;
					});
	    		}
				if(!scope.user){
					scope.user = model.user().sessionUser.user;
				}
        		updateDataSourceByIds(scope.quickViewData.fax.ids);
           }
       }
	}]);

    fax.controller('FaxController', ['$scope', 'model','$filter','$timeout','PrefAccessor',
        function($scope, model, $filter, $timeout, PrefAccessor){
    		if (model.currentFaxPatient && ($scope.patient===undefined ||$scope.patient.id!=model.currentFaxPatient.id)) {
    			$scope.patient = model.currentFaxPatient;
    		}
    		var ptIdent;
    		if ($scope.patient) {
	    		ptIdent = "Patient: " +  model.getPatIdTitle($scope.patient) + ($scope.patient.healthInsuranceNumber ? ", " + $scope.patient.healthInsuranceNumber : "") +"\n";
			}
    		if ($scope.faxData) {
    			if ($scope.faxData.withCoverPage==undefined) $scope.faxData.withCoverPage=false;
    			if ($scope.faxData.coverPageLangue == undefined) $scope.faxData.coverPageLangue='FR';
    			if ($scope.faxData.idPatient == undefined) $scope.faxData.idPatient=$scope.patient ? $scope.patient.id : undefined;
    			if ($scope.faxData.coverPageNote == undefined) $scope.faxData.coverPageNote = ptIdent;
    		} else {
    			$scope.faxData = {withCoverPage: false, coverPageLangue:'FR', coverPageNote:ptIdent, idPatient:$scope.patient ? $scope.patient.id : undefined};	// il faut l'id (correspond à l'id_patient_anchor)    			
    		}
			$scope.allsites = model.user().sites;
            $scope.patientPharmacies = [];


            function updatePatientList(){
            	if ($scope.patient) {
            		var pharma = $filter('filter')($scope.patient.lstSites, {addedAs:"DRUG_STORE"});
            		if(pharma){
						$scope.patientPharmacies = [];
						var sitesadded = {};
            			pharma.forEach(function(pi){
							if(!sitesadded[pi.idSite]){// some cases dupes are present
								sitesadded[pi.idSite] = true;
								$scope.patientPharmacies.push($scope.allsites[pi.idSite]);
							}
            			});
            		}
            	}
			}
			
            PrefAccessor.contextSite(function (res) {
                var cs = res.data;
                if(cs.faxAccount && cs.faxUser && cs.faxNumber){
                    cs.canUseFax = true;
                }else{
                    cs.canUseFax = false;
                }
                $scope.userSite = cs;
            });

            $scope.$watch($scope.patient, updatePatientList)
            $scope.setFaxNo = function (fax) {
                $scope.faxData.faxNo = fax
                $scope.faxData.faxNoConfirm = fax
            }
            $scope.selectSite = function(site){
                if(site && site.phonenumber2){
                    $scope.setFaxNo(site.phonenumber2)
                }else{
                    $scope.setFaxNo("")
                }
            }

            $scope.selectFaxProfOptions = {searchType: 'server', minChar: 3};
			function profName(prof){
				return prof.lastName + ', '+ prof.firstName;
			}
            $scope.selectFaxProf = function(prof) {
                if(prof && prof.fax){
                    $scope.setFaxNo(prof.fax)
                }else{
                    $scope.setFaxNo("")
                }
				return profName(prof);
            }

            $scope.dest =  $scope.patient ? 'pharmaPat' : 'prof';

			$scope.updateDest = function(dest){
				$scope.dest = dest;
			}
            $scope.close = function () {
                $scope.fl.cancel();
            }
            $scope.editPatientPopoverOptions = {
                showExit: true,
                exit:function(){
                    updatePatientList()
                    $timeout(function() {
                        angular.element('#fax-btn-edit-patient').triggerHandler('click');
                        $scope.popoverEdit = false;
                    });
                }
            }

            function faxNumberValid (n){
                return n && n.length > 9 && n.length <12 && /^\d+$/.test(n)
            }
            function cleanNo(no){
                if(no){
                    no = no.trim();
                }
            }
            $scope.sendFax = function () {
                cleanNo($scope.faxData.faxNo);
                cleanNo($scope.faxData.faxNoConfirm);
                if($scope.encFaxForm.$valid &&
                    $scope.faxData.faxNo === $scope.faxData.faxNoConfirm &&
                    faxNumberValid($scope.faxData.faxNo)){
                    $scope.fl.ok($scope.faxData);
                }else if(!faxNumberValid($scope.faxData.faxNo)){
                    model.notice().fail($filter("translate")("InvalidFaxNo"))
                }else if($scope.faxData.faxNo !== $scope.faxData.faxNoConfirm){
                    model.notice().fail($filter("translate")("InvalidFaxNoCofirm"))
                }else{
                    model.notice().fail($filter("translate")("InvalidFaxForm"))
                }
            }
    }]);

	fax.directive('faxView', ['FaxAccessor','MessageLink', 'model', 'ModificationStatus', 'FlView', '$filter',
	function(FaxAccessor, MessageLink, model, ModificationStatus, FlView, $filter){

		function getData(scope, fax) {
			if (!fax) return;
			if (fax.id != undefined) {
				if (fax.statusId===0 || fax.statusId===1 || fax.statusId===4) {
					scope.ready = 3;
					scope.faxMsg = $filter("translate")("FAX_IN_PROG_CANNOT_SHOW_DOC");
				} else {
					if (scope.faxMsg) delete scope.faxMsg;
					// pour obtenir principalement la colonne picture (byte arr du doc).
					FaxAccessor.utils.faxView(fax, function success(response){
						fax.viewerUrl = response.data.viewerUrl;
						if(fax.viewerUrl){
							fax.t = 'urlframe';
						}
						model.currentFaxPatient = fax.patient;
						scope.ready=1;
						model.editModeUpdated(true);
					});
				}
			}
		}

		return {
		restrict: 'E',
		templateUrl: '/dashboard/resources/ofys/fax/fax_view.html?v=bf',
		scope: true,
		link: function(scope, element, attrs){
			scope.ready = 2;
			var defaultOptions = {
				hasHeader: false
			};
			scope.resend = function(fax) {
				var payload = {};
				FlView.open({templateUrl: "/dashboard/resources/ofys/fax/fax.html?v=bf", patient: scope.quickViewData.pat, showCoverPageOptions: (fax.faxId === undefined || fax.faxId===-1) }, {
					backdrop: 'static',windowClass: "faxmodal"}).then(function(faxdata){
					if (fax.resend%2==0) fax.resend++;
					fax.destination = faxdata.faxNo;
					fax.idPatient = faxdata.idPatient;
					// en fait, on update slm le resend. Les autres données sont pour le new faxSend qui sera créé lors du send à SRFax
					fax.modificationStatus = ModificationStatus.STATUS_UPDATED;
					FaxAccessor.save(fax, function success(response){
						model.notice().success($filter('translate')('FAX_SERVER_SUCCESS'));
					});
				});
			};

			function setViewOptions(options){
				scope.viewOptions = angular.copy(defaultOptions);
				if(options){
					$.extend(scope.viewOptions, options);
				}
			}

			function update(n, o){
				scope.ready=2;
				scope.fax = n;
				if (model.currentFaxPatient) delete model.currentFaxPatient;
				scope.quickViewData = scope.$eval(attrs.quickViewData);
				if(!scope.fax) return;
				setViewOptions(scope.$eval(attrs.options));
				getData(scope, scope.fax);
				var pat = scope.quickViewData.pat ? scope.quickViewData.pat : scope.quickViewData.qvActData.patient;
				scope.linkManager = MessageLink.linkManager(FaxAccessor, pat, (pat ? pat.uid : undefined), scope);
			}

			scope.$watch(attrs.faxs, update);

			scope.$on("$destroy", function callbck() {
				if (model.currentFaxPatient) delete model.currentFaxPatient;
		    });

			scope.setupIframe = function(elem){
				// scope.iframeWindow = elem[0].contentWindow;
				adjustIFrame(elem);
			}

			function adjustIFrame(elem){
				//Resize iframe to parents height
				var parentSection = $(elem[0]).parents("section")[0];
				var headerheight = $(parentSection).find(".popSide").outerHeight();
				if(headerheight === undefined)headerheight = 0;
				var height = $(parentSection).outerHeight() - headerheight;
				elem[0].style.height = (height - 28 ) + "px";
			};

		}
	}
}]);


})()