(function(){
	var form = angular.module('form', ['ngSanitize']);

	form.factory('FormAccessor', ['DashAPI','MessageLink','model', function(DashAPI, MessageLink, model) {
		var isFetchingForms = false;		
		var accessor = {
			ANCHOR_STYLET: 1428,
		    getFormHtmlForCrds : function (formId, formDataId, callback, error){
				return DashAPI.get('/dashboard/forms/ws/getFormHtmlForCrds?formId=' + formId+'&formDataId=' + formDataId, callback, error);
			},
			data : function (id, callback, error){
				return DashAPI.get('/dashboard/forms/ws/get?id=' + id, callback, error);
			},
			getPlainForm : function (id, callback, error){
				return DashAPI.get('/dashboard/forms/ws/getPlain?id=' + id, callback, error);
			},
			byIdAnchors : function (ids, callback, error){
				return DashAPI.get('/dashboard/forms/ws/byIdAnchors?ids=' + ids, callback, error);
			},
			byIdAnchorsWithRevision : function (ids, callback, error){
				return DashAPI.get('/dashboard/forms/ws/byIdAnchors?revision=true&ids=' + ids, callback, error);
			},
			addToFavorites : function (data, callback, error){
				return DashAPI.get('/dashboard/forms/ws/addToFavorites?formId=' + data.formId + '&userId='+data.userId , callback, error);
			},
			removeFavorites : function (data, callback, error){
				return DashAPI.get('/dashboard/forms/ws/removeFavorite?formId=' + data.formId + '&userId='+data.userId , callback, error);
			},
			addToAvailables : function (data, callback, error){
				return DashAPI.get('/dashboard/forms/ws/addToAvailables?formId=' + data.formId + '&userId='+data.userId , callback, error);
			},
			removeAvailables : function (data, callback, error){
				return DashAPI.get('/dashboard/forms/ws/removeAvailables?formId=' + data.formId + '&userId='+data.userId , callback, error);
			},
			newData : function (data, callback, error){
				return DashAPI.get('/dashboard/forms/ws/new?formId=' + data.formId + '&patientId='+data.patientId , callback, error);
			},
			copyData : function (data, callback, error){
				return DashAPI.get('/dashboard/forms/ws/copy?formDataId=' + data.formDataId + '&patientId='+data.patientId, callback, error);
			},
			//templates
			getAssistText : function (data, callback, error){
				return DashAPI.get('/dashboard/template/ws/getAssistText?idType=' + data.idType + '&txt='+data.txt, callback, error);
			},
			assistantSelectedCount : function (data, callback, error){
				return DashAPI.get('/dashboard/template/ws/assistantSelectedCount?idTemplate=' + data.idTemplate, callback, error);
			},
			utils: {
				getLastVersions: function(patientFormData){
					var res = {};
					for(var i = 0; i < patientFormData.length; i++){
						//Add version if new or previous version is older (datetime)
						if(res[patientFormData[i].idAnchor] === undefined ||
								res[patientFormData[i].idAnchor].datetime < patientFormData[i].datetime){
							res[patientFormData[i].idAnchor] = patientFormData[i];
						}
					}
					return OfysUtils.ObjectValuesAsArray(res);
				},
				availableFormAsyncSearchIn : function (query, resolve, reject){
					accessor.availablesList(function(availables){
						resolve(accessor.utils.filterNonCnesst(availables.filter(function(a){return OfysUtils.matchInRegExpArray(OfysUtils.searchRegExpArray(query, 2), a.nameLc);})));
					}, reject);
				},
				findFormByIdAnchor: function(idAnchor, resolve, reject){
					accessor.availablesList(function(availables){
						resolve(availables.find(e=>e.idAnchor === idAnchor));
					}, reject);
				},

				/**
				 * Clears all the form list (available, favorite).
				 */
				clearList: function(){
					model.forms().favoritesFetched = false;
					model.forms().favorites = [];
					model.forms().availablesFetched = false;
					model.forms().availables = [];
				},

				favoritesFormAsyncSearchIn :function (query, resolve, reject){
					accessor.favoritesList(function(availables){
						var searchTextRegExp = OfysUtils.searchRegExpArray(query);
						resolve(accessor.utils.filterNonCnesst(availables.filter(function(a){return OfysUtils.matchInRegExpArray(searchTextRegExp, a.nameLc);})));
					}, reject);
				},
				filterNonCnesst: function (list){
					var res = [];
					for(var i=0;i < list.length; i++){
						if(list[i].type !== 3){
							res.push(list[i]);
						}
					}
					return res.sort(function(a, b) {return a.name.localeCompare(b.name);});
				},

				removeFromFavorites: function (form){
					accessor.favoritesList(function(data){
						var i = accessor.utils.findInList(form.id, data);
						data.splice(i, 1);
					});
				},
				addToFavorites: function (form){
					model.forms().favorites.push(form);
				},
				removeFromAvailables: function (form){
					accessor.availablesList(function(data){
						var i = accessor.utils.findInList(form.id, data);
						data.splice(i, 1);
					});
				},
				addToAvailables: function (form){
					model.forms().availables.push(form);
				},

				/**
				 * Filters a list of forms and returns forms that have a name that contain the query string
				 * @param query : Filter string that should be contained in form name.
				 * @param formList : A list of forms to filter down.
				 */
				filterList: function (query, formList){
					var res = [];
					var q = query.toLowerCase().removeAccentsLc();
					for(var i = 0; i< formList.length; i++){
						if(formList[i].nameLc.indexOf(q) > -1){
							res.push(formList[i]);
						}
					}
					return res.sort(function(a, b) {return a.name.localeCompare(b.name);});
				},

				/**
				 * Finds a form in a list with the id given as parameter.
				 * If a form is found it's index in the list is returned.
				 * If no form is found in the list -1 is returned.
				 * @param id : the id of the form to be searched in the form list.
				 * @param formList : the list in which to find the form with the id.
				 */
				findInList: function (id, formList){
					var res = null;
					var i = 0;
					while(i < formList.length && res === null){
						if(formList[i] && formList[i]!=null && formList[i].id === id){
							return i;
						}
						i += 1;
					}
					return -1;
				},

				availablesFormAsyncList: function (resolve, reject){
					accessor.availablesList(function(availables){
						resolve(availables);
					}, reject);
				},
				favoriteFormAsyncList: function (resolve, reject){
					accessor.favoritesList(function(favorites){
						resolve(favorites);
					}, reject);
				}
			},
			patientFormData : function (patientId, callback, error){
				var url = '/dashboard/forms/ws/patientFormData?patientId=' + patientId;
				return DashAPI.get(url, callback, error);
			},
			userFormData : function (userid, callback, error){
				var url = '/dashboard/forms/ws/userFormData?idPerson=' + userid;
				return DashAPI.get(url, callback, error);
			},
			favoritesList : function (callback, error){
				if(model.forms().favoritesFetched){
					callback(model.forms().favorites);
				}else{
					DashAPI.get('/dashboard/forms/ws/favoritesList', function(resData){
						model.forms().favoritesFetched = true;
						for(var i=0;i<resData.length;i++) {
							if (resData[i].name) {
								resData[i].nameLc = resData[i].name.toLowerCase().removeAccentsLc();
							}
						}
						model.forms().favorites = resData;
						callback(model.forms().favorites);
					}, error);
				}
			},
			availablesList : function (callback, error){
				if(model.forms().availablesFetched){
					callback(model.forms().availables);
				}else{
					console.log("will call availablesList...");
					DashAPI.get('/dashboard/forms/ws/availablesList', function(resData){
						model.forms().availablesFetched = true;
						OfysUtils.fuzzyListSearch(resData, "name");
						// for(var i=0;i<resData.length;i++) {
						// 	if (resData[i].name) {
						// 		resData[i].nameLc = resData[i].name.toLowerCase().removeAccentsLc();
						// 	}
						// }
						model.forms().availables = resData;
						callback(model.forms().availables);
						isFetchingForms = false;
					}, error);
				}
			},
			crdsList : function (callback, error){
				console.log("will call crdsList...");
				DashAPI.get('/dashboard/crds/ws/listForm', function(resData){
					OfysUtils.fuzzyListSearch(resData, "name");
					for(var i=0;i<resData.length;i++) {
						if (resData[i].name) {
							resData[i].nameLc = resData[i].name.toLowerCase().removeAccentsLc();
						}
					}
					callback(resData);					
				}, error);
			},
			adminList : function(callback, error){
				if(model.forms().adminFetched){
					callback(model.forms().admin);
				}else{
					console.log("will call adminList...");
					DashAPI.get('/dashboard/forms/ws/adminList', function(resData){
						model.forms().adminFetched = true;
						for(var i=0;i<resData.length;i++) {
							if (resData[i].name) {
								resData[i].nameLc = resData[i].name.toLowerCase().removeAccentsLc();
							}
						}
						model.forms().admin = resData;
						callback(model.forms().admin);
//						isFetchingForms = false;
					}, error);
				}
//				return DashAPI.get('/dashboard/forms/ws/adminList', callback, error);
			},
			loadPreSaved : function (saveForm, callback, error){
				DashAPI.post('/dashboard/forms/ws/loadPreSaved', saveForm, callback, error,  'json');
			},
			save : function (saveForm, callback, error){
				return DashAPI.post('/dashboard/forms/ws/save', saveForm, callback, error, 'json');
			},
			delAttenteResultats : function (saveObj, callback, error){
				return DashAPI.post('/dashboard/forms/ws/delAttenteResultats', {id:saveObj.id}, callback, error, 'json');
			},
			saveAttenteResultats : function (saveObj, callback, error){
				return DashAPI.post('/dashboard/forms/ws/saveAttenteResultats', saveObj, callback, error, 'json');
			},
			sendToCnesst : function (data, callback, error){
				return DashAPI.get('/dashboard/forms/ws/toCnesst?eformDataId=' + data.eformDataId, callback, error);
			},
			deleteFormData : function (deleteForm, callback, error){
				return DashAPI.post('/dashboard/forms/ws/delete', deleteForm, callback, error, 'json');
			},
			unDeleteFormData : function (deleteForm, callback, error){
				return DashAPI.post('/dashboard/forms/ws/undelete', deleteForm, callback, error, 'json');
			},
			cancel : function (tag, callback, error){	// pour retirer de la cache le formData au besoin.
				return DashAPI.post('/dashboard/forms/ws/cancel', {preSavedTag: tag}, callback, error, 'json');
			},
			print : function (formData, callback, error){
				return DashAPI.get('/dashboard/forms/ws/print?formDataId='+formData.id+"&idPatient=" + formData.idPatient, model.handlePrint(callback), error);
			},
			printWithLinks : function (formData, callback, error){
				return DashAPI.get('/dashboard/forms/ws/printWithLinks?formDataId='+formData.id+"&idPatient=" + formData.idPatient, model.handlePrint(callback), error);
			},
			fax : function (faxdata, callback, error){
				return DashAPI.post('/dashboard/forms/ws/fax',faxdata, callback, error);
			},
			faxWithLinks : function (faxdata, callback, error){
				return DashAPI.post('/dashboard/forms/ws/faxWithLinks',faxdata, callback, error);
			},
			msgLinkMap: {},
			updateMessageLink: function (formData, scope){
				var formDataId ;
				if(formData!=undefined) {
					if (parseInt(formData.id, 10) == formData.id){
						formDataId = formData.id;
						accessor.messageLinkKey = MessageLink.setLinkType({
							patient: formData.idPatient,
							linkType: MessageLink.linkTypes.form,
							id: formDataId,
							form: formData,
							pat: formData.patient
						}, scope);
					} else {
						accessor.messageLinkKey = MessageLink.setLinkType({
							patient: formData.idPatient,
							linkType: MessageLink.linkTypes.patient,
							id: formData.idPatient,
							pat: formData.patient
						}, scope);
					}
				} else {
					// MessageLink.setLinkType({});
				}
				accessor.msgLinkMap[formData.uid] = accessor.messageLinkKey
			}
		};

		return accessor;
	}]);

	form.directive('formSearch',
		['model', 'FormAccessor', 'patientShowTitles','$timeout', '$q','DashWebSocket','QuickView',
		function(model,  FormAccessor, patientShowTitles, $timeout, $q, DashWebSocket, QuickView){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				var formType = scope.$eval(attrs.formType);
				var currPatient = scope.patient;
				var isFetchingCrdsForms = false;

				if(!currPatient && scope.def && scope.def.patient){
					currPatient = scope.def.patient;
				}

				scope.openUrl = function(v) {
					if(model.isWeb()){
						var win = window.open(v, '_blank');
						win.focus();
					}else{
						DashWebSocket.send({url: "/dashboard", data:{url:v}});
					}
				};

				function type1FormsOnly(a){
					return a.type === 1;
					// && a.type == 2 && a.type !== 3;
				}

				/**
				 * Search form list (available and favorites) and returns a filtered list
				 */
				function formAsyncSearch(query, resolve, reject){
					query = query.toLowerCase().removeAccentsLc();
					var wildChar = getWildCard(query);
					var searchTextRegExp;
					function filterOtherTypes(filterfn){
						return function(frmsLst){
							resolve(frmsLst.filter(filterfn));
						}
					}
					if (formType<=1) {
						if(wildChar === "*"){
							FormAccessor.utils.favoritesFormAsyncSearchIn(query.substring(1), filterOtherTypes(type1FormsOnly) , reject);
						}else if(wildChar === " "){
							FormAccessor.utils.availableFormAsyncSearchIn(query.substring(1), filterOtherTypes(type1FormsOnly), reject);
						}else if(query === ""){
							FormAccessor.utils.favoriteFormAsyncList(function(favs){
								favs = filterFormFavs(favs);
								if(favs.length > 0){
									FormAccessor.utils.favoritesFormAsyncSearchIn(query.substring(1), filterOtherTypes(type1FormsOnly) , reject);
								}else{
									FormAccessor.utils.availableFormAsyncSearchIn(query.substring(1), filterOtherTypes(type1FormsOnly) , reject);
								}
							});
							
						}else{
							FormAccessor.utils.availableFormAsyncSearchIn(query, filterOtherTypes(type1FormsOnly), reject);
						}
					} else if (formType == 2 && allCrds.list) {
						if (query === "") {
							//show crds favorite list
							FormAccessor.utils.favoriteFormAsyncList(function(favs){
								favs = filterCrdsFavs(favs);
								if(favs.length > 0){
									FormAccessor.utils.favoritesFormAsyncSearchIn(query.substring(1), filterOtherTypes(filterCrds) , reject);
								}else{
									searchTextRegExp = OfysUtils.searchRegExpArray(query, 2);	// 2 lettres suffisent ici
									resolve(allCrds.list.filter(function(a){return OfysUtils.matchInRegExpArray(searchTextRegExp, a.nameLc);}).sort(function(a, b) {return a.name.localeCompare(b.name);}));
								}
							});
						} else {
							//search in all crds list
							searchTextRegExp = OfysUtils.searchRegExpArray(query, 2);	// 2 lettres suffisent ici
							resolve(allCrds.list.filter(function(a){return OfysUtils.matchInRegExpArray(searchTextRegExp, a.nameLc);}).sort(function(a, b) {return a.name.localeCompare(b.name);}));
						}
					} else if (formType == 3 && allCnesst) {
						searchTextRegExp = OfysUtils.searchRegExpArray(query, 2);
						var currContext = makeContext();
						resolve(allCnesst.filter(function(a){
							return validCnesstContext(a, currContext) &&
								OfysUtils.matchInRegExpArray(searchTextRegExp, a.nameLc)}).sort(function(a, b) {return a.name.localeCompare(b.name);}));
					} else if ((formType== 4 || formType ==5) && allPatientsForm ) {// Mofidier ou copie un formulaire du patient en cours
						searchTextRegExp = OfysUtils.searchRegExpArray(query, 2);
						resolve(allPatientsForm.filter(function(a){
							var descr = a.description && a.form.name!=a.description ? " (" + a.description + ")" : "";
							return OfysUtils.matchInRegExpArray(searchTextRegExp, a.date+a.form.name+descr);
						}));
					}else if(formType === 10){
						searchTextRegExp = OfysUtils.searchRegExpArray(query, 2);
						var res = allUserForms === undefined ? []: allUserForms.filter(function(a){
							return OfysUtils.matchInRegExpArray(searchTextRegExp, a.nameLc);
						})
						resolve(res);
					}else {
						reject();
					}
				}

				scope.pref = {
					form_cnesst_lang : function(val) {
						if (arguments.length) {
							model.prefSettings('form_cnesst_lang', val);
						} else {
							return model.prefSettings('form_cnesst_lang');
						}
					}
				};

				var codeCtxt = {
					ctx1: [0,1],
					ctx2: [2,3,4,5,6,7,8,9],
					ctx3: [2,3,4,5,6,7]
				};
	
				var codes = [
					"cnesst-adhoc-CertificatRetraitPreventif-fr",
					"cnesst-adhoc-CertificatRetraitPreventif-en",
					"cnesst-AttestationMedicale-en",
					"cnesst-AttestationMedicale-fr",
					"cnesst-RapportMedical-en",
					"cnesst-RapportMedical-fr",
					"cnesst-RapportFinal-en",
					"cnesst-RapportFinal-fr",
					//"cnesst-adhoc-AssignationTemporaireTravail-en",
					//"cnesst-adhoc-AssignationTemporaireTravail-fr",
					//"cnesst-adhoc-InformationMedicaleComplementaireEcrite-en",
					//"cnesst-adhoc-InformationMedicaleComplementaireEcrite-fr",
					"cnesst-RapportEvaluationMedicale-en",
					"cnesst-RapportEvaluationMedicale-fr",
					//"cnesst-adhoc-RapportExpertise-en",
					//"cnesst-adhoc-RapportExpertise-fr",
					//"cnesst-adhoc-RapportComplementaire-en",
					//"cnesst-adhoc-RapportComplementaire-fr",
					// "cnesst-adhoc-RapportEnvoiDeFichier" 
				];
				
				function filterProf(form){
					return form.type === 10;
				}
							
				function filterNonCnesst(list){
					var res = [];
					for(var i=0;i < list.length; i++){
						if(list[i].type !== 3){
							res.push(list[i]);
						}
					}
					return res;
				}
				
				function filterCrdsFavs(list){
					var res = [];
					for(var i=0;i < list.length; i++){
						if(list[i].type === 2){
							res.push(list[i]);
						}
					}
					return res
				}
				function filterFormFavs(list){
					var res = [];
					for(var i=0;i < list.length; i++){
						if(list[i].type === 1){
							res.push(list[i]);
						}
					}
					return res
				}
				function filterCnesstQuestions(list){
					var res = [];
					if(scope.cnesstprefillFrm){
						var currContext = makeContext();
						for(var i=0;i < list.length; i++){
							if(validCnesstContext(list[i], currContext)){
								res.push(list[i]);
							}
						}
					}
					return res;
				}

				function validCnesstContext(form, currContext){
					var valid = true, cdIndex;
//					if(scope.pref.form_cnesst_lang !== 'all' &&
//						form.language && form.language !== scope.pref.form_cnesst_lang){
//						return false;
//					}
					if(form.code && (cdIndex = codes.indexOf(form.code)) >= 0 ){
						for(var i = 0; i < currContext.length && valid; i++){
							valid = codeCtxt[currContext[i]].indexOf(cdIndex) >= 0;
						}
					}
					return valid;
				}

				function makeContext(){
					var context = [];
					if(scope.cnesstprefillFrm.retrait === 'oui'){
						context.push('ctx1');
					}
					if(scope.cnesstprefillFrm.lesion === 'oui'){
						context.push('ctx2');
					}
					if(
						scope.cnesstprefillFrm.civisme === 'oui' ||
						scope.cnesstprefillFrm.criminel === 'oui'
					){
						context.push('ctx3');
					}
					return context;
				}

				function getWildCard(query){
					if(query.indexOf(" ") === 0 || query.indexOf("*") === 0){
						return query.substring(0, 1);
					}
					return "";
				}

				var allUserForms;
				
				let allCrds = model.forms().crds;

				var allCnesst;
				var allPatientsForm;

				// pour setter les form cdrs et cnesst selon le type
				scope.dataSourceWithValues = function(a) {
					if (a==0) {	// tous
						return function(assistObject){
							//Display favorite form list on default
							//if no favorites display all form.
							FormAccessor.utils.favoriteFormAsyncList(function(favs){
								if(favs.length > 0){
									assistObject.setData(filterNonCnesst(favs));
								}else{
									FormAccessor.utils.availablesFormAsyncList(function(all){
											assistObject.setData(filterNonCnesst(all));
									}, function(){});
								}
							}, function(){});
						};
					} else if (a==1) {
						return function(assistObject){
							//Display favorite form list on default
							//if no favorites display all form.
							FormAccessor.utils.favoriteFormAsyncList(function(favs){
								if(favs.length > 0){
									assistObject.setData(filterNonCnesst(favs));
								}else{
									FormAccessor.utils.availablesFormAsyncList(function(all){
										assistObject.setData(filterNonCnesst(all.filter(filterCommon)));
									}, function(){});
								}
							}, function(){});
						};
					} else if (a==2) {
						return function(assistObject){	
							//Display favorite crds form list on default
							//if no favorites display all crds form.
							FormAccessor.utils.favoriteFormAsyncList(function(favs){
								if(favs.length > 0) {
									loadAllCrdsAsync(function() {
										var list = favs.filter(filterCrds);
										if (list.length > 0) {
											assistObject.setData(list);	
										} else {
											assistObject.setData(allCrds.list);
										}										
									});									
								}else{
									loadAllCrdsAsync(function() {
										assistObject.setData(allCrds.list);
									});										
								}
							});
						};
					} else if (a==3) {
						return function(assistObject){
							FormAccessor.utils.availablesFormAsyncList(function(all){
								if (!allCnesst) {
									allCnesst = all.filter(filterCnesst);
								}
								assistObject.setData(filterCnesstQuestions(allCnesst));
							});
						};
					} else if(a === 4 || a === 5){
						return function(assistObject){
							allPatientsForm = [];
							if(currPatient && currPatient.viewbag && currPatient.viewbag.patData && currPatient.viewbag.patData.form){
								var allFormsInEnc = {};
								if (currPatient.viewbag.patData.enc && currPatient.viewbag.patData.enc.length>0) {
									for(var i = 0; i < currPatient.viewbag.patData.enc.length; i++) {
										if (currPatient.viewbag.patData.enc[i].lstDoc && currPatient.viewbag.patData.enc[i].lstDoc.length>0) {
											for(var j = 0; j <  currPatient.viewbag.patData.enc[i].lstDoc.length; j++) {
												var fDoc = currPatient.viewbag.patData.enc[i].lstDoc[j];
												if (fDoc.atype===2) {
													allFormsInEnc[fDoc.idDocument] = fDoc;
												}
											}
										}
									}
								}
								allPatientsForm = currPatient.viewbag.patData.form.filter(function (f) {
									return !f.deleted
								});
								for(var i = 0; i < allPatientsForm.length; i++){
									if (allFormsInEnc[allPatientsForm[i].id]) {
										allPatientsForm[i].description = allFormsInEnc[allPatientsForm[i].id].description;
									}
								}
							}
							assistObject.setData(allPatientsForm);
						};
					}else if(a === 10){
						return function(assistObject){
							FormAccessor.utils.availablesFormAsyncList(function(all){
								// allUserForms = [];
								if (!allUserForms) {
									allUserForms = all.filter(filterProf);

								}
								assistObject.setData(allUserForms);
							});
							assistObject.setData(allUserForms);
						};
					}
				};

				//load crds list and codes
				function loadAllCrdsAsync(callback) {
					if (isFetchingCrdsForms) {
						//already in a call, ignore
					} else {						
						if (allCrds.list !== undefined) {
							//already loaded, just return								
							callback();								
						} else {
							isFetchingCrdsForms = true;
							FormAccessor.crdsList(function(all) {
								//on success
								isFetchingCrdsForms = false;

								allCrds.list = all;
								allCrds.codes = all.map(x => x.code);
								
								callback();							
							}, function() {
								//on error
								isFetchingCrdsForms = false										
							});
						}
					}
				}				
				function filterCrds(value, index, arr){				
					//retain only crds type
					return value.type === 2 
						//retain only crds form than have a valid code.
						//this is needed because some favorite may link a crds form not valid anymore
						&& value.code !== undefined
						&& allCrds.codes.indexOf(value.code) >= 0;				
				}
				function filterCommon(a) {
					return a.type===1;
				}				
				function filterCnesst(a) {
					var ret = a.type===3;
					if (ret===true) {
						var lang = model.prefSettings('form_cnesst_lang');
						ret = lang==="all"?true:a.language===lang;
					}
					return ret;
				}
				function ifDefined(str){
					return str?str: "";
				}
				function getKey(form){
					if(form.className === 'CFormData'){
						var descr = form.description && form.form.name!=form.description ? " (" + form.description + ")" : "";
						return form.date + ' ' +form.form.name + descr;
					}else{
						return form.name
					}
				}

				//form assist input
				scope.formViewformSearchAssist = {
					assistId: "autocomplete_form_select_add",
					nextTabOnTab: true, continuePropagationOnEsc:true,	// fonctionne bien sauf ds qv -> ferme aussi le qv.
					nextTabOnEnter: true,
					minChar: 0,
					// dynaType: 'popover',
					hasDetails: false,hasHeader: false,
					trigger: 'focus', listWidth: 450,
					updateDataSourceWithValues: scope.dataSourceWithValues(formType),
//						headerHtml: '<i class="fa fa-star" style="color: #92BF28" ng-click="getFavoriteForms()" aria-hidden="true"></i>',
					getAsyncData: function(query){
							return $q(function(resolve, reject) { formAsyncSearch(query, resolve, reject); });
					},
					getKey: function(form) {
						if (model.debug().dev) {
							return ifDefined(form.code) + " " + ifDefined(form.id) + " " +  getKey(form);
						} else {
							return getKey(form);
						}
					},
					selection: function(form, assistApi) {
						assistApi.lockEntry();

						if (scope.patient) {	// donc de la page patientData
							if (form.type===2) {
								model.loadingOverlay().show('LOADING_CRDS_FORM', true);
							}
							FormAccessor.newData({formId: form.id, patientId:scope.patient.id }, function(resData){
								var newOptions = angular.copy(scope.actOptions);
								newOptions.newAct = true;
								// il faut mettre le new CFormdata dans la liste form et frm9 (type du form).
								if (resData.patient === undefined) {
									resData.patient = _.omit(scope.patient, 'viewbag');	// resData est un CFormData. J'ai besoin du patient pour les autofill qui se font au chargement du form.
									if (scope.patient.viewbag!== undefined) {
										scope.patient.viewbag.patData.form.unshift(resData);
										scope.patient.viewbag.patData['frm' + resData.form.type].unshift(resData);
										scope.resetLimits();
									}
								}
								if (form.type===2) {
									model.loadingOverlay().hide();
								}
								if (form.type===3 && scope.cnesstprefillFrm) {
									resData.prefillForm = scope.cnesstprefillFrm;
								}
								patientShowTitles.openActivity(resData, newOptions, scope.patient);
							}, function(){
								model.loadingOverlay().hide();
							});
						}else if(scope.user && form.type===10){
							// TODO: FIX THIS
							FormAccessor.newData({formId: form.id }, function(resData){
								scope.user.viewbag.userData.allForms.unshift(resData);
								scope.user.viewbag.userData.forms.unshift(resData);
								if(scope.quickViewData.qvActData && scope.quickViewData.qvActData.className === 'CUser'){
									scope.quickViewData.qvActData = resData;
									model.actUpdated(true);
									model.userDataUpdated(true);
								}else{
									QuickView.openCurrentUserQV(resData, {});
								}
								closeFrmPopover();
							}, function(){
							});
						} else { // donc de form_view
							scope.addForm(form, formType);
						}
					}
				};

				function closeFrmPopover(){
					$timeout(function() {
						angular.element('.frmSelectPopover').triggerHandler('click');
					});
				}

				function keyUpFunc(e) {
					if (e.keyCode == 27) {
						e.stopPropagation();
						$('#btn-add-new-form'+formType).popover('hide');
					}
				}


				scope.onPopupShow = function() {
					scope.invalidPrefill = false;
					scope.showSection = "search";
					if (formType==3) {
						scope.cnesstprefillFrm = {};
						scope.showSection = "cnesstForm";
					}else{
						scope.activateSearchInput();
					}
				};

				scope.activateSearchInput = function(cnesst){
					$timeout(function() {
						$(document).keyup(keyUpFunc);
						$('#focusOnSearchForm').focus();
						if (scope.formViewformSearchAssist.elem) scope.formViewformSearchAssist.elem.dxA.focusIn();
					}, 50);
				};

				var cnesstQ = ['retrait', 'lesion', 'criminel','civisme'];
				scope.previousAnswers = function(){
					var answsers = model.prefSettings("cnesstQuestions").split(",");
					if(answsers.length === cnesstQ.length){
						for(var i = 0; i < answsers.length; i++){
							scope.cnesstprefillFrm[cnesstQ[i]] = answsers[i];
						}
					}
				}

				scope.cnesstNext = function(){
					if(
						scope.cnesstprefillFrm.retrait &&
						scope.cnesstprefillFrm.lesion &&
						scope.cnesstprefillFrm.criminel &&
						scope.cnesstprefillFrm.civisme
					){
						scope.showSection = "search";
						scope.activateSearchInput(true);
						var str = cnesstQ.map(function(elem){
							return scope.cnesstprefillFrm[elem];
						}).join();
						if(model.prefSettings("cnesstQuestions") !== str ){
							model.prefSettings("cnesstQuestions", str);
						}

					}else{
						scope.invalidPrefill = true;
					}
				};
				scope.onPopupHide = function() {
					$(document).unbind("keyup", keyUpFunc);
				};
			}
		};
	}]);

	form.directive('formView', ['model', '$filter','FormAccessor','$timeout', '$log', 'FlView', 'Event','QuickView','$q', 'CourrielAccessor', 'TaskAccessor',
								'QConfirm','patientShowTitles','TempAssistAccessor', 'CrdsAccessor','DashWebSocket','MessageLink', 'ModificationStatus',
								function(model, $filter, FormAccessor, $timeout, $log,  FlView, Event, QuickView, $q, CourrielAccessor, TaskAccessor,
									QConfirm, patientShowTitles, TempAssistAccessor, CrdsAccessor, DashWebSocket, MessageLink, ModificationStatus){

		var today = OfysUtils.localDateFrom1970();
		var calcDay = {j:1, s:7, m:30, a:365};
		function setLimitDate(scope) {
			if (scope.formData.attenteTemp.no) {
				scope.formData.attenteTemp.limitDate = today+(scope.formData.attenteTemp.no * calcDay[scope.formData.attenteTemp.unit]);
				scope.formData.attenteTemp.limitDateStr = OfysUtils.daysFrom1970ToStr(scope.formData.attenteTemp.limitDate);						
			}
		}

		function setInitData(formData, scope) {
			if (!formData.addedLinks) formData.addedLinks = [];
			if (!formData.objAddedLinks) formData.objAddedLinks = [];
			if (!formData.addedLinksUid) formData.addedLinksUid = [];
			if (!formData.prop) formData.prop = {readonly:true};
			if (!formData.dashEdit) formData.dashEdit = getDashEdit(formData);
			if(formData.viewbag)formData.viewbag.ready = true;
			if (formData && formData.idAnchor) getRevsionDataByIdAnchor(formData, scope);
			updateMethods(formData, scope)
			if (formData.attente==undefined) {
				formData.attenteTemp = getAttenteTemp(scope);
				setLimitDate(scope);
			} else {
				formData.attenteTemp = angular.copy(formData.attente);
				formData.attenteTemp.unit = 's';
			}
			
		}

		function getDataByIdAnchor(scope, formData){	// formData === scope.formData === scope.quickViewData.qvActData
			model.loadingOverlay().show('LOADING_DATA', true);
			FormAccessor.byIdAnchors(formData.idAnchor, function(resData){
				delete resData.uid;	// je ne veux pas écraser le uid actuel
				angular.extend(formData, resData);	// copier les properties - garde donc la ref du l'obj.
				if (formData.patient===undefined && scope.patient) {
					formData.patient = _.omit(scope.patient,'viewbag');
				}
				scope.form = formData.form;	// en ai besoin pour les fav.
				scope.form.html = scope.form.html.replace('$(".button-div").remove();', '$(".button-div").hide();');
				setInitData(formData, scope);
				formData.origVersion = formData.origVersion ? angular.copy(formData.origVersion) : angular.copy(formData);	// pour permettre cancel
				formData.preSaveDone = false;	// mis true dans le preSave
				setDataToAddedLinks(scope.quickViewData, formData, scope);
				setFavoriteState(scope.form);
				$timeout(function(){
					formReady(scope.formWindow);
					model.loadingOverlay().hide();
					model.editModeUpdated(true);
					model.formDataUpdated(true);
				}, 1000);

			}, function(){
				model.loadingOverlay().hide();
			});
		}
		function getRevsionDataByIdAnchor(formData, scope){	// formData === scope.formData === scope.quickViewData.qvActData
			model.loadingOverlay().show('LOADING_DATA', true);
			scope.revisions.length = 0;
			FormAccessor.byIdAnchorsWithRevision(formData.idAnchor, function(resData){
				for(var i=0;i<resData.length;i++) {
					if (resData[i].id!=formData.id) {
						scope.revisions.push(resData[i]);
					}
				}
				$timeout(function(){
					model.loadingOverlay().hide();
				}, 1000);
			}, function(){
				model.loadingOverlay().hide();
			});
		}
		function updateMethods(formData, scope){
			formData.save = scope.saveForm;	// ai besoin de ces méthodes dans les event close
			formData.cancel = scope.cancel;
			formData.presave = scope.preSaveForm;
			formData.closeContext = scope.closeContext;
		}
		function getAttenteTemp(scope) {
			return {id: scope.formData.id, status:1, idPatient:scope.formData.idPatient, idProf: model.user().profil.id, unit:'s', no:3};
		}
		
		function getData(scope, formData){	// formData === scope.formData === scope.quickViewData.qvActData
			model.loadingOverlay().show('LOADING_DATA', true);
			if (formData.savedForm && formData.savedForm.preSavedTag) {
				scope.form = formData.form;
				FormAccessor.loadPreSaved({preSavedTag: formData.savedForm.preSavedTag}, function(resData){
					console.log("saved succesfully");
					// je ne garde pas le form retourné car incomplet.
					delete resData.form;
					delete resData.uid;
					delete resData.date;
					delete formData.savedForm.preSavedTag;
					angular.extend(formData, resData);	// extend car je veux conserver le uid mais écraser les valeurs différentes
					if (formData.patient===undefined && scope.patient) {
						formData.patient = _.omit(scope.patient,'viewbag');
					}
					setInitData(formData, scope);
					formData.origVersion =  formData.origVersion ? angular.copy(formData.origVersion) : angular.copy(formData);	// pour permettre cancel
					formData.preSaveDone = false;	// mis true dans le preSave
					setDataToAddedLinks(scope.quickViewData, formData, scope);
					setFavoriteState(scope.form);
					editProp(scope, formData);
					model.loadingOverlay().hide();
					scope.setPrerequisInLists();
					model.editModeUpdated(true);
					model.formDataUpdated(true);
				}, function(){
					model.loadingOverlay().hide();
				});
			} else if(formData.id != undefined){
				FormAccessor.data(formData.id, function(resData){
					delete resData.uid;	// je ne veux pas écraser le uid actuel
					angular.extend(formData, resData);	// copier les properties - garde donc la ref du l'obj.
					if (formData.patient===undefined && scope.patient) {
						formData.patient = _.omit(scope.patient,'viewbag');
					}else if(formData.patient && formData.patient.viewbag){
						formData.patient = _.omit(formData.patient,'viewbag');
					}
					scope.form = formData.form;	// en ai besoin pour les fav.
					scope.form.html = scope.form.html.replace('$(".button-div").remove();', '$(".button-div").hide();');
					setInitData(formData, scope);
					if(formData.origVersion){
						// formData.origVersion = angular.copy(formData.origVersion);
					}else{
						formData.origVersion = angular.copy(formData);	// pour permettre cancel
					}
					formData.preSaveDone = false;	// mis true dans le preSave
					setDataToAddedLinks(scope.quickViewData, formData, scope);
					setFavoriteState(scope.form);
					
					if (formData.crdsRequestId) {
						//loading crds request info
					    CrdsAccessor.getRequest(formData.crdsRequestId, function(res) {
					    	if(res && res.infoRequete){
					    		formData.crdsRequest = res;
					    		formData.crdsRequest.infoRequete = JSON.parse(res.infoRequete);
					    		scope.setPrerequisInLists();
					    		model.editModeUpdated(true);
					    		model.formDataUpdated(true);
					    	}
			                 model.loadingOverlay().hide();
					    }, function(res) {
					    	model.loadingOverlay().hide();
					    });
					} else {
						scope.setPrerequisInLists();
						model.loadingOverlay().hide();
						model.editModeUpdated(true);
						model.formDataUpdated(true);
					}
					
				}, function(){
					model.loadingOverlay().hide();
				});
			} else { //If the formdata id is undefined, this is a new entry to be edited.
				scope.form = formData.form;
				scope.formData.origVersion={};	// si cancel, on n'a pas de version précédente.
				if (formData.patient===undefined) {
					if (scope.patient) {
						formData.patient = _.omit(scope.patient,'viewbag');
					} else if(model.patient()){
						formData.patient = _.omit(model.patient().currPatient,'viewbag');
					}
				}
				formData.preSaveDone = false;	// mis true dans le preSave
				setInitData(formData, scope);
				setDataToAddedLinks(scope.quickViewData, formData, scope);
				setFavoriteState(scope.form);
				editProp(scope, formData);
				scope.setPrerequisInLists();

				if(scope.quickViewData.patData){// si le patient n'est pas encore loadé le patData n'existera pas encore.
					// l'ajouter dans la liste des form - mais il faut vérfier avant que n'a pas déjà été ajouté
					// car a peut être été fermé et réouvert
					if ($.inArray(formData, scope.quickViewData.patData.form)==-1) {
						scope.quickViewData.patData.form.unshift(formData);	// on le push au début du array
					}
					if ($.inArray(formData, scope.quickViewData.patData['frm' + scope.form.type])==-1) {
						scope.quickViewData.patData['frm' + scope.form.type].unshift(formData);
					}
				}
				formData.attenteTemp = getAttenteTemp(scope)
				setLimitDate(scope);

//				formData.attenteTemp = {id: scope.formData.id, status:1, idPatient:scope.formData.idPatient, idProf: model.user().profil.id, unit:'s', no:3};

				model.loadingOverlay().hide();
				model.editModeUpdated(true);
				model.formDataUpdated(true);
			}
		}
		function sleep(ms) {
			return new Promise(resolve => setTimeout(resolve, ms));
		}

		async function setDataToAddedLinks(qv, formData, scope) {
			var keys, k, actKey;
			if (qv && formData.addedLinks && formData.addedLinks.length>0) {
				// il faut trouver les doc/lab/form/enc correspondant et les ajouter dans objAddedLinks.
				// puis prendre leur uid et les ajouter dans addedLinksUid;
				if (qv.patData == undefined || qv.patData.loaded == undefined || qv.patData.loaded.doc!=1  || qv.patData.loaded.lab!=1  || qv.patData.loaded.form!=1  || qv.patData.loaded.sum!=1 ) {
					await sleep(1000);
				}

				formData.objAddedLinks = [];
				formData.sumAddedLinks = [];
				formData.addedLinksUid = [];
				formData.addedLinksItem = [];	// idem à addedinks mais sans le 3e item (les liens avec key crds).
				formData.addedKeys = [];
				formData.addedCrdsKey = {};
				formData.selectedDV = {};
				scope.prerequis = {};

				for(var i = 0;i<formData.addedLinks.length;i++) {
					var links = formData.addedLinks[i].split('ı');
					if (links[0]=='sum') {	// un array de 4 items (0-3), en 3, array de string key_crds.
						var sumArr = links[1].split('˜');
						for(k = 0;k<sumArr.length;k++) {
							var sumStr = sumArr[k];
							if (sumStr.trim().length>0) {
								formData.addedLinksUid.push(sumStr);
								var sum = sumStr.split('Į');
								var iObj = {t:sum[0], d:sum[2], addedLink:formData.addedLinks[i]};
								if (sum[1]!='') {
									iObj.i = sum[1]*1;
								}
								formData.sumAddedLinks.push(iObj);
							}
						}

						actKey = 'sum';
						// pour les crds Keys
						if (formData.addedCrdsKey[actKey] === undefined) {
							formData.addedCrdsKey[actKey] = [];
						}
						if (formData.form.type===2) {
							// on a crds key
							keys = links.length==3 && links[2]!='' ? links[2].split('|'):[];
							for(k = 0; k<keys.length; k++) {
								formData.addedKeys.push(keys[k]);
								formData.addedCrdsKey[actKey].push(keys[k]);
								if (scope.prerequis[keys[k]] === undefined) {
									scope.prerequis[keys[k]] = {};
								}
								scope.prerequis[keys[k]][actKey]=true;
							}
							formData.addedKeys = formData.addedKeys.sort(function(o1,o2) {
								return o1.localeCompare(o2);
							});

						} else if (formData.form.type===3) {	// cnesst
							// cette valeur ici est sum
							var key = links.length==3 && links[2] != '' ? links[2] : '';
							formData.selectedDV['sum'] = {key:key};
						}

					} else {
						// links = array de 3 items (0-2 -> type, id, key_crds), en 2, array de key_crds
						//PATCHING CODE Load from SAFIR-CRDS tab and not pt data begin ************
						var arr = [];
						if(qv.patData){
							arr = qv.patData[links[0]];	// qv.patData[links[0]]; -> qv.patData[enc]; = liste des rencontres.
						}else if(qv.pat && qv.pat.viewbag && qv.pat.viewbag.patData){
							arr = qv.pat.viewbag.patData[links[0]];	// ex
						}
						if(arr){
							//PATCHING CODE Load from SAFIR-CRDS tab and not pt data end ************
							for(k = 0;k<arr.length;k++) {
								if (arr[k].id==links[1]) {	// est-ce que l'id de l'item == id du lien? Si oui, on est sur le bon
									arr[k].addedLink = formData.addedLinks[i];
									formData.objAddedLinks.push(arr[k]);
									formData.addedLinksUid.push(arr[k].uid);
									break;
								}
							}
							actKey = links[0]+'ı'+links[1];
							formData.addedLinksItem.push(actKey);	// car je dois séparer cette valeure des crdsKey
							// pour les crds keys
								if (formData.addedCrdsKey[actKey] === undefined) {
									formData.addedCrdsKey[actKey] = [];
								}
							if (formData.form.type===2) {
								// on a crds key
								keys = links.length==3 && links[2]!='' ? links[2].split('|'):[];
								for(k = 0; k<keys.length; k++) {
									formData.addedKeys.push(keys[k]);
									formData.addedCrdsKey[actKey].push(keys[k]);
									if (scope.prerequis[keys[k]] === undefined) {
										scope.prerequis[keys[k]] = {};
									}
									// j'Ai besoin de l'uid de actData - je l'ai récupéré dans le for précédent
									for(var l=0, c=formData.objAddedLinks.length; l < c; l++) {
										if (formData.objAddedLinks[l].id==links[1]) {
											scope.prerequis[keys[k]][formData.objAddedLinks[l].uid] =true;
										}
									}
								}
								formData.addedKeys = formData.addedKeys.sort(function(o1,o2) {
									return o1.localeCompare(o2);
								});
							} else if (formData.form.type===3) {
								// cnesst
								// scope.cnesstLinks est un object donc key = uid et val = index du type de doc.
								// cette valeur ici est le uid de l'objet. Donc pas dispo ici.
								var key = links.length==3 && links[2]!='' ? links[2] : '';
								// j'Ai besoin de l'uid de actData - je l'ai récupéré dans le for précédent
								for(var l=0, c=formData.objAddedLinks.length; l < c; l++) {
									if (formData.objAddedLinks[l].id==links[1]) {
										formData.addedCrdsKey[actKey].push(key);
										formData.selectedDV[formData.objAddedLinks[l].uid] = {key: key};	// pour le ng-model
									}
								}
							}
						}
					}
				}
			}
			formData.hasPrerequisManquant = function() {
				if(this.crdsRequest){	//  && scope.needsPrerequis===true
//					var prerequisManquant = this.crdsRequest.infoRequete.prerequisManquant;
//					if (prerequisManquant && prerequisManquant[0] === "vrai") {
//						return true;
//					}
					return true;
				}
				return false;
			};
			formData.disableSelectFormLinks = function() {
//				return this.crdsRequest && this.crdsRequest.infoRequete && (this.crdsRequest.infoRequete.lstPrerequisManquant == undefined || this.crdsRequest.infoRequete.lstPrerequisManquant.length===0);
//				if(scope.formData.crdsRequest && scope.formData.crdsRequest.infoRequete && scope.formData.crdsRequest.infoRequete.lstPrerequisManquant && scope.formData.crdsRequest.infoRequete.lstPrerequisManquant.length==0){
//					return scope.evalPrerequisManquant().length==0
//				}
				return false;
			};
		}

		function editProp(scope, formData){
			formData.prop.readonly = false;
			scope.quickViewData.editMode = true;
			model.editModeUpdated(true);
			model.formDataUpdated(true);
		}

		/**
		 * Returns formdata dashEdit object, this object is dashboard specific and is not sent to backend.
		 * @param formData : and formdata object with a form.html property
		 */
		function getDashEdit(formData){
			if(formData.form.html != undefined){
				return {datePickers: extractDatePicker(formData.form.html)};
			}
		}

		function extractDatePicker(html) {
			var rx = /\"(.*)\"\)\.datepicker/g;
			var arr;
			var allPickers = [];
			while ((arr = rx.exec(html)) !== null){
				allPickers.push(arr[1]);
			}
			return allPickers;
		}

		/**
		 * Async sets the form favorite state (true or false).
		 */
		function setFavoriteState(form){
			FormAccessor.favoritesList(function(data){
				form.isFavorite = FormAccessor.utils.findInList(form.id, data) !== -1;
			});
		}

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/eform/form_view.html?v=bf',
			scope: true,
			link: function(scope, element, attrs){
				scope.formWindow = {};
				scope.revisions = [];
				scope.formData = {origVersion:{}};	// origVersion - permet le cancel au besoin.
				scope.model = model;
				scope.linkModeOn = 0;
				scope.reloadTryIeFix = true;
				scope.attenteDefault = {
					
				};
				var ieFormLoadFixLoadCount = 0;
				var ieFormLoadDocWritten = false;
				//Default viewbag attributes added for every formData load.
				var viewbag = {ready: false};

				function setViewbag(formData){
					formData.viewbag = _.omit(formData);
					return formData;
				}
				var defaultOptions = {
					hasHeader: true,
					hasTitle: true,
					addEvents: true
				}
				function setViewOptions(options){
					scope.viewOptions = angular.copy(defaultOptions)
					if(options){
						$.extend(scope.viewOptions, options)
					}
				}
				function addMessageLink(){
					scope.linkManager = MessageLink.linkManager(FormAccessor, scope.formData, scope.formData.uid, scope)
				}

				// method called at the end of the link via le watch
				function update(n, o, scope){
					setViewOptions(scope.$eval(attrs.options));
					if(scope.addEventsEvent && scope.viewOptions.addEvents){
						model.safeCall(scope.addEventsEvent);
					}
					scope.formData = setViewbag(n);
					getData(scope, scope.formData);
					if (scope.formData.patient == undefined) {
						scope.formData.patient = model.patientsInQv(''+scope.formData.idPatient);
					}
					addMessageLink();
					ieFormLoadFixLoadCount = 0;
					ieFormLoadDocWritten = false;
					if(scope.qv){
						scope.qv.isDirty = function(){return scope.isDirtyOrCrds() !== 0 && scope.isDirtyOrCrds() !== 4};
					}
					// if(model.isIE && scope.formWindow.open){
					// 	ieUpdate();
					// }
					// $log.log("Updating form idForm : " + n.idForm+ " idAnchor: "+ n.idAnchor+" :: "+ n.form.name );
				}

				function dirty(act){
					return (!scope.ignoreChanges) && (scope.isDirtyOrCrds() === 1)
				}
				function sendToCrds(act){
					return (scope.isDirtyOrCrds() == 3 && model.user().isMd()  && !scope.isChecked)
				}
				
				scope.setLimitNo = function(u) {
					scope.formData.attenteTemp.no = u;		
					setLimitDate(scope);			
				}
				scope.setLimitUnit = function(u) {
					scope.formData.attenteTemp.unit = u;					
					setLimitDate(scope);			
				}
				scope.setAttente = function(s) {
					scope.formData.attenteTemp.status = s;
				};
				scope.cannotSaveAttente = function(){
					var att = scope.formData.attenteTemp;
					return !(att.status && ( (att.unit && att.no) || (att.limitDate && att.limitDate>today-1)));
				}
				scope.saveAttente = function() {
					scope.formData.attenteTemp.modificationStatus = ModificationStatus.STATUS_NEW;
					if (scope.formData.attenteTemp.id) {
						FormAccessor.saveAttenteResultats(scope.formData.attenteTemp, function(data){
							scope.formData.attente = angular.copy(data);
							scope.formData.attenteTemp = angular.copy(data);
							model.notice().success($filter('translate')('RESULT_ATTENDUS_SAVED'));
						}, function(err) {
							model.notice().warn($filter('translate')('error') + ": " + err);										
						});
					}
				}
				scope.cancelAttente = function() {
					scope.formData.attenteTemp = scope.formData.attente ? angular.copy(scope.formData.attente) : getAttenteTemp(scope);
					scope.formData.attenteTemp.unit='s';
				}
				/*Close the editor context if possible
					Returns true if the context can be closed and false if not.
				*/
				scope.closeContext = function(act, onContextClosed){
					var pristine = true;
					function closeSuccessful(){
						onContextClosed && onContextClosed(pristine);
					}
					if (dirty(act)) {
						pristine = false;
						QConfirm.open({title: $filter('translate')(scope.isCrdsFormType()?'formCRDSUnsavedChanges':'formUnsavedChanges', act.form)})
						.then(function(save){
							if(save && scope.isCrdsFormType()){
								return;
							}
							if(save ){
								act.save().then(closeSuccessful);//should change the dirty state to make sure that the second time closing goes through
							}else{
								scope.ignoreChanges = true;
								act.cancel();
								closeSuccessful();
							}
						});
						return false;
					} else if(sendToCrds(act)){
						scope.isChecked = true;
						pristine = false;
						QConfirm.open({title: $filter('translate')('crdsNotSend', act.form)})
						.then(function(save){
							if(save){
								scope.sendFormToCrds().then(closeSuccessful);
							}else{
								scope.ignoreChanges = true;
								act.cancel();
								closeSuccessful();
							}
						});
						return false;
					}
					closeSuccessful();
					return true;
				}
				function closeIfPrestine(pristine){
					if(!pristine){
						if(scope.formData.closeActivity){
							scope.formData.closeActivity();
						}else{
							scope.qv.$$close();
						}
					}
				}
				
				scope.openOldVersion = function openOldVersion(version){
					FormAccessor.data(version.id, function(res){
						var act = res && res.length ? res[0] : res;
						if(scope.viewOptions.previousForm){// Formulaire dans la rencontre.
							scope.viewOptions.updateDoc(act, scope.viewOptions.previousForm)
						}else{
							if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (act)){
								model.actUpdated(true);
							}else{
								patientShowTitles.open(act, scope);
							}
						}
					});
				}

				scope.addEventsEvent = function (){
					//Ne pas ajouter les événements si on est pas en mode quick view
					if(!scope.qv){
						return;
					}

					if(!QuickView.eventsActive(scope.qv)){
						return;// event have already been deleted (because of a close or one quickview that triggers another)
					}
					//Si c'est la première ouverture, créer la variable d'événements
					if(!scope.qv.ActiveEventsRef){
						scope.qv.ActiveEventsRef = {};
					}

					//Make sure previously created evens are not referred to
					//Very important to avoid leaks
					QuickView.removeAllEventHandlers(scope);

					//L'événement existe donc il ne faut pas le recréer
					if(!scope.qv.ActiveEventsRef.onQvClose){
						//Ici elle est appeller ajouté aussi-tot que le viewer s'ouvre donc toujours active
						//Comme le scope n'est pas passé en parametre, le handler est seulement detruit quand le quickview est fermer
						scope.qv.ActiveEventsRef.onQvClose = Event.on(scope.qv.onQvClose,function(event){
							var act = event.mObj.quickViewData.qvActData;

							if(!scope.closeContext(act, closeIfPrestine)){
								event.stopPropagation();
							}
						});
					}

					if(!scope.qv.ActiveEventsRef.onQvMinimize){
						scope.qv.ActiveEventsRef.onQvMinimize = Event.on(scope.qv.onQvMinimize,function(event){
							return preSaveForm(true);
						});
					}


					//événement de changement d'activité
					if(!scope.qv.ActiveEventsRef.onQvActivityChange){
						scope.qv.ActiveEventsRef.onQvActivityChange = Event.on(scope.qv.onQvActivityChange,function(event){
							//Ici l'objet 'event' passé en paramètre contient l'objet
							//mObj=objet modal contenat qv, quickviewData,
							//le oldAct=activité courant qui a le controle du quickview
							//newAct=activité qui veut prendre contrôle du quickview.

							console.log('oldAct:' + event.oldAct.uid + ', newAct:'+event.newAct.uid);
							var oldAct;
							if (angular.isDefined(event.oldAct.prop) && event.oldAct.prop.readonly===false) {
								oldAct = event.oldAct;
							}
							if (oldAct) {
								event.stopPropagation();
								if(scope.qv.isExternal){
									model.notice().warn($filter("translate")('InExternalEditRestrictionForm'))
									return;
								}
								// il ne faut pas fermer le old. Il faut le minimiser - je le ferai après le changement.
								$timeout(function() {
									// peut ouvrir 2 x le meme. il faut prévenir cela.
									if(event.mObj.quickViewData.pat){
										patientShowTitles.openActivity(event.newAct, {mode: 'n', minimize: false}, event.mObj.quickViewData.pat);
									}else if(event.mObj.quickViewData.user){
										QuickView.openCurrentUserQV(event.newAct, {});
										model.formDataUpdated(true);
									}
								}, 1000);
							}else{
								QuickView.removeAllEventHandlers(scope);
							}
							preSaveForm(true);
						});
					}

					if(!scope.qv.ActiveEventsRef.onQvExternalize){
						scope.qv.ActiveEventsRef.onQvExternalize = Event.on(scope.qv.onQvExternalize,function(event){
							preSaveForm(true);
							QuickView.removeAllEventHandlers(scope);
						});
					}
				}

				scope.formType = "";
				scope.FORM_TYPES = {Ofys: "Ofys", IEOfys: "ieOfys", CrdsLocal: "CrdsLocal", IECrdsLocal: "ieCrdsLocal", Crds:"Crds"};

				scope.getFormType = function (){
					scope.formType = "";
					if(!model.isIE && (scope.notFormCrds(scope.formData) || scope.formCrdsIsOnlySaved(scope.formData))){
						scope.formType = scope.FORM_TYPES.Ofys;
					}else if(model.isIE && scope.notFormCrds(scope.formData) && scope.reloadTryIeFix){
						scope.formType = scope.FORM_TYPES.IEOfys;
					}else if(model.isIE && scope.formCrdsIsOnlySaved(scope.formData) && scope.reloadTryIeFix){
						scope.formType = scope.FORM_TYPES.IECrdsLocal;
					}else if(!model.isIE && scope.formCrdsIsOnlySaved(scope.formData)){
						scope.formType = scope.FORM_TYPES.CrdsLocal;
					}else if(scope.formData.crdsRequestId){
						scope.formType = scope.FORM_TYPES.Crds;
					}
					// console.log("The form type is :: = "+ scope.formType);
					return scope.formType;
				};

				function ieUpdate(){
					scope.reloadTryIeFix = false;
					$timeout(function(){
						scope.reloadTryIeFix = true;
					}, 30);
				}

				scope.reloadCrdsForm = function() {
					delete scope.formData.savedForm;
					delete scope.formData.isResponseFromCrds;	// car on ne devrait cliquer qu'une fois ici.
					getData(scope, scope.formData);
				};

		        scope.wasSentToCrds = function (formData, addedLink) {
		            if (!formData.addedLinks || formData.addedLinks.length == 0) {
		                return false;
		            }
		            if (!formData.crdsRequest || !formData.crdsRequest.sentAddedLinks || formData.crdsRequest.sentAddedLinks.length == 0) {
		                return false;
		            }
		            var sentAddedLinks = formData.crdsRequest.sentAddedLinks;
		            var r = sentAddedLinks.indexOf(addedLink) > -1;
		            return r;
		        };

				scope.printFormDataWithLinks = function(){
					FormAccessor.printWithLinks(scope.formData, function(res){
						model.notice().success($filter('translate')('PRINT_SERVER_SUCCESS'));
						// if (res.data && res.data.status) {
						// 	if (res.data.status.severity==='OK') {
						// 	} else {
						// 		model.notice().fail($filter('translate:{msg:' + res.data.status.message + '}')('PRINT_SERVER_FAIL'));
						// 	}
						// }
					});
				};

				scope.printFormData = OfysUtils.throttle(function(){
					FormAccessor.print(scope.formData, function(res){
						model.notice().success($filter('translate')('PRINT_SERVER_SUCCESS'));
						// if (res.data && res.data.status) {
						// 	if (res.data.status.severity==='OK') {
						// 	} else {
						// 		model.notice().fail($filter('translate:{msg:' + res.data.status.message + '}')('PRINT_SERVER_FAIL'));
						// 	}
						// }
					});
				});

				function faxDataFaxTo (formData) {
					var fax = {}
					if (formData && formData.dataJsonb) {
						var jsonNo = JSON.parse(formData.dataJsonb);
						var autoFaxTo;
						if (jsonNo.auto_fax_to) {
							autoFaxTo = jsonNo.auto_fax_to;
						} else if (jsonNo.autoFaxTo) {
							autoFaxTo = jsonNo.autoFaxTo;
						}
						if (autoFaxTo) {
							var cleanNumber = autoFaxTo.replaceAll(/[^0-9.]/, "");// remove all non number characters
							fax.faxNo = cleanNumber;
							fax.faxNoConfirm = cleanNumber;
						}
					}
					return fax;
				}
				scope.faxFormData = OfysUtils.throttle(function(formData){
					if (formData==undefined) formData = scope.formData;
					if (formData && formData.form) {
						var formName = formData.form.name + " (" + formData.date + ")";
					}
					var fax = faxDataFaxTo(formData);
					FlView.open({templateUrl: "/dashboard/resources/ofys/fax/fax.html?v=bf", patient: scope.quickViewData.pat, showCoverPageOptions: true, faxData: fax }, {
						backdrop: 'static',windowClass: "faxmodal"
					}).then(function(faxdata){
						if (formName) {
							faxdata.docName = formName;
						}
						FormAccessor.fax({id: scope.formData.id, faxdata: faxdata}, function(res){
							model.notice().success($filter('translate')('FAX_SERVER_SUCCESS'));
						});
					});
				});

				scope.faxFormDataWithLinks = OfysUtils.throttle(function(formData){
					if (formData==undefined) formData = scope.formData;
					if (formData) {
						var formName = formData.form.name + " (" + formData.date + ")";
					}
					var fax = faxDataFaxTo(formData);
					FlView.open({templateUrl: "/dashboard/resources/ofys/fax/fax.html?v=bf", patient: scope.quickViewData.pat, showCoverPageOptions: true, faxData: fax }, {
						backdrop: 'static',windowClass: "faxmodal"}).then(function(faxdata){
						if (formName) {
							faxdata.docName = formName;
						}
						FormAccessor.faxWithLinks({id: scope.formData.id, faxdata: faxdata}, function(res){
							model.notice().success($filter('translate')('FAX_SERVER_SUCCESS'));
						});
					});
				});

				scope.addFavForm = function(form){
					var usr = model.user();
					var data  = {formId: form.id, userId: usr.sessionUser.user.id};
					FormAccessor.addToFavorites(data, function(resData){
						if(resData){
							form.isFavorite = resData;
							FormAccessor.utils.addToFavorites(form);
						}
					});
				};
				scope.delFavForm = function(form){
					var usr = model.user();
					var data  = {formId: form.id, userId: usr.sessionUser.user.id};
					FormAccessor.removeFavorites(data, function(resData){
						if(resData==true){
							form.isFavorite = false;
							FormAccessor.utils.removeFromFavorites(form);
						}
					});
				};

				// 0 si non modifié, 1 si modifié, 2 si crds.3 si crds  .4 si crds non modifié 9 si pas un formulaire (une réponse success.html, p.ex.)
				scope.isDirtyOrCrds = function() {
					if (scope.formData.isModifiable===false) return 6;
					if (scope.formData.isResponseFromCrds === true) {	// une réponse non un formulaire - ex success.html
						return 9;
					}
					if (scope.formData.crdsRequestId) {
						// on affiche slm si prerequis manquant ou si addedlinks non vide.
						if ((scope.formData.hasPrerequisManquant && scope.formData.hasPrerequisManquant()) || (scope.formData.addedLinks && scope.formData.addedLinks.length>0)) {
							return 2;
						}
						return 9;
					}
					// rendu ici, si crds (type 2), ça signifie que pas envoyé - si non envoyé, on ne peut pas imprimer
					var res = angular.isDefined(scope.formData.prop) && scope.formData.prop.readonly===false ? 1 : 0;
					if(scope.formData.form) {
						if (res===0) {
							if (scope.formData.form.type===2){
								res = 3;
							} else if (scope.formData.form.type===3) {
								if (scope.formData.cnesstRefNo) {
									res = 5		// cnesst sent
								} else {
									res = 4;	// cnesst
								}
							}
						}
					}
					return res;
				};

				scope.isCrdsFormType = function() {
					return scope.formData.form.type===2;
				};

				scope.edit = function() {
					editProp(scope, scope.formData);
					changeFormEditState(scope.formData.prop.readonly);
				};

				scope.openLatestVersion = function() {
					var patient = scope.quickViewData.pat;
					var actOptions = { minimize: false, mode: 'n' };
					FormAccessor.byIdAnchors(scope.formData.idAnchor, function (res) {
						var act = res && res.length ? res[0] : res;
						if(scope.viewOptions.previousForm){// Formulaire dans la rencontre.
							if(!scope.viewOptions.previousForm){
								scope
							}
							scope.viewOptions.updateDoc(act, scope.viewOptions.previousForm)
						}else{
							if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (act)){
								model.actUpdated(true);
							}else{
								patientShowTitles.openActivity(act, actOptions, patient);
							}	
						}
					});
				};

				scope.deleteForm = function() {
					QConfirm.open({title: $filter('translate')('CONFIRM_DELETE')}).then(function(ok){
						if(ok){
							FormAccessor.deleteFormData({formDataId:scope.formData.id}, function(res) {
								// console.log(res);
								scope.formData.deleted = true;
								scope.qv.$$close();
								model.actUpdated(true);
							});
						}
					});
				};

				scope.unDeleteForm = function() {
					FormAccessor.unDeleteFormData({formDataId:scope.formData.id}, function(res) {
						// console.log(res);
//						if (res.statusText=='OK') {
						scope.formData.deleted = false;
						model.actUpdated(true);
//						} else {
//							model.notice().fail(res.data.status.messsage);
//						}
					});
				};

				scope.addForm = function(form){
					var idPat;
					if (scope.quickViewData && scope.quickViewData.pat) {
						idPat = scope.quickViewData.pat.id;
					} else if (scope.formData && scope.formData.idPatient) {
						idPat = scope.formData.idPatient;
					}
					if (form.type===2) {
						model.loadingOverlay().show('LOADING_CRDS_FORM', true);
					}
					FormAccessor.newData({formId:form.id, patientId: idPat}, function(resData){
						scope.formData = resData;	// coupe le lien avec , scope.quickViewData.qvActData - n'est plus le même objet.
						// angular.copy(res.data, scope.formData);	// src, dest
						if (scope.formData.patient===undefined && scope.patient) {
							scope.formData.patient = _.omit(scope.patient,'viewbag');
						}
						setInitData(scope.formData, scope);
						scope.reloadIframeSource(scope.form);

						scope.quickViewData.qvActData = scope.formData;	// un add = il faut réassigner le qvActData
						scope.quickViewData.patData.form.unshift(scope.formData);	// est aussi scope.formData.patient.viewbag
						scope.quickViewData.patData['frm' + scope.form.type].unshift(scope.formData);
						editProp(scope, scope.formData);
						changeFormEditState(scope.formData.prop.readonly);
						model.actUpdated(true);
						addMessageLink()
						if (form.type===2) {
							model.loadingOverlay().hide();
						}
					}, function(){
						model.loadingOverlay().hide();
					});
				};

				scope.copyForm = function(){
					FormAccessor.copyData({formDataId:scope.formData.id, patientId:scope.formData.idPatient}, function(resData){
						console.log("copyForm succesfully");
						scope.formData = resData;	// coupe le lien avec , scope.quickViewData.qvActData - n'est plus le même objet.
						if (scope.patient) {	// undefined si deja dans section appointments ou patients
							// si pas dans un de ces sections, j'ai besoin du patient pour afficher les données dans le patientData_
							scope.formData.patient = _.omit(scope.patient,'viewbag');
						} else if (scope.formData.idPatient) {
							scope.formData.patient = model.patientsInQv(''+scope.formData.idPatient);
						}
						scope.formData.form = scope.form;
						setInitData(scope.formData,scope);
						if (scope.formWindow.fillFormWithData) {
							scope.formWindow.fillFormWithData(cleanFormData(scope.formData));
						}
						if(scope.viewOptions.previousForm){// Formulaire dans la rencontre.
							scope.viewOptions.updateDoc(scope.formData, scope.viewOptions.previousForm)
						}else{
							scope.quickViewData.qvActData = scope.formData;	// un add = il faut réassigner le qvActData
						}

						scope.quickViewData.patData.form.unshift(scope.formData);
						scope.quickViewData.patData['frm' + scope.form.type].unshift(scope.formData);
						editProp(scope, scope.formData);
						changeFormEditState(scope.formData.prop.readonly);
						model.actUpdated(true);
						addMessageLink()
					});
				};
				function getActivity(){
					if(scope.quickViewData.qvActData.delegateActivity){
						return scope.quickViewData.qvActData.delegateActivity();
					}else{
						return scope.quickViewData.qvActData;
					}
				}
				scope.cancel = function(){
					if (scope.linkModeOn>0) {
						scope.toggleLinkMode();
					}
					if (angular.isUndefined(scope.formData.id)) {
						// était un ajout de form.
						var idx = -1;
						if(scope.quickViewData.patData && scope.quickViewData.patData.form){
							for(var k=0;k<scope.quickViewData.patData.form.length;k++) {
								if (scope.quickViewData.patData.form[k].uid===scope.formData.uid) {
									idx = k;
									break;
								}
							}
							if (idx!=-1) {
								scope.quickViewData.patData.form.splice(idx, 1);
							}
							idx = -1;
							for(var j=0;j<scope.quickViewData.patData['frm'+scope.form.type].length;j++) {
								if (scope.quickViewData.patData['frm'+scope.form.type][j].uid===scope.formData.uid) {
									idx = j;
									break;
								}
							}
							if (idx!=-1) {
								scope.quickViewData.patData['frm' + scope.form.type].splice(idx, 1);
							}
							changeFormEditState(scope.formData.prop.readonly);
	//						// il me faut un id 'tag' pour ces forms.
							FormAccessor.cancel(scope.formData.tag, function(resData){
	//							$log.log('cancel done, status = ' +  resData.status);
							});
							model.editModeUpdated(true);
							model.formDataUpdated(true);	// car il faut mettre à jour le resumedValue au besoin.
							scope.ignoreChanges = true;
	//						scope.qv.$$close();
						}else if(scope.quickViewData.userData){
							var spliceIndex = scope.quickViewData.userData.forms.indexOf(scope.formData);
							var spliceIndexAll = scope.quickViewData.userData.allForms.indexOf(scope.formData);
							if(spliceIndex > -1){
								scope.quickViewData.userData.forms.splice(spliceIndex, 1);
							}
							if(spliceIndexAll > -1){
								scope.quickViewData.userData.allForms.splice(spliceIndexAll, 1);
							}

						}
					} else {
						OfysUtils.deleteAllProps(scope.formData, ['origVersion']);
						angular.extend(scope.formData, scope.formData.origVersion);	// scope.formData == dvActData, donc objet remis
						scope.formData.prop.readonly = true;
						scope.formData.editMode = false;
						setInitData(scope.formData, scope);
						setDataToAddedLinks(scope.quickViewData, getActivity(), scope);
						setFavoriteState(scope.form);
						if (scope.formWindow.fillFormWithData) {
							scope.formWindow.fillFormWithData(cleanFormData(scope.formData));
						}
						changeFormEditState(scope.formData.prop.readonly);
						FormAccessor.cancel(scope.formData.id, function(resData){
//							$log.log('cancel done' + resData);
						});
						model.editModeUpdated(true);
						model.formDataUpdated(true);	// car il faut mettre à jour ds ui les valeurs modifiées.
					}
					addMessageLink()
					model.actUpdated(true);
				};

				function cleanFormData(formData) {
					formData =  _.omit(formData, ['origVersion', 'patient', 'viewbag', 'savedForm', 'objAddedLinks']);
					formData.form = _.omit(formData.form, ['html']);

					//omit functions from formData
					formData = _.omit(formData, function(value, key, object) {
						return typeof value === 'function';
					});
					return formData;
				}

				function preSaveForm(p) {	// p = true si only presave

				    if (scope.formData.preSaveDone!==true) {
				        if (scope.isDirtyOrCrds()===1) {
							// $log.log('actUid dans preSaveForm:' + scope.formData.uid);
				        	if (scope.formData.form.type===3) {
				        		// cnesst - il faut mettre les key pour chacun des fichiers joints.
			                	setAddedLinksFromCrdsKeyField(scope.formData);
							}

							var cformdata = {
								mustCheckMetaData: true,
								preSaveOnly:p
							};

							scope.formData.savedForm = cformdata;
							scope.formWindow.SubmitImage();
							scope.formData.date = moment().format('YYYY-MM-DD HH:mm');
							scope.formData.idAuthor = model.user().sessionUser.user.idPerson;
							scope.formData.savedForm.metas = scope.formWindow.ofys_get_metadata();
							var rv = scope.formWindow.getResumeValueInfodataCall();
							if (rv && rv!='""') {
								scope.formData.savedForm.resumeValue = JSON.stringify(rv);
								scope.formData.resumeValue = JSON.stringify(rv);
							} else {
								delete scope.formData.savedForm.resumeValue;
								delete scope.formData.resumeValue;
							}

							var jsondata = scope.formWindow.getJsonDataInfodataCall();
							if(jsondata && jsondata != '""'){
								scope.formData.savedForm.dataJsonb = jsondata;
								scope.formData.dataJsonb = jsondata;
							} else {
								delete scope.formData.savedForm.dataJsonb;
								delete scope.formData.dataJsonb;
							}

							scope.formData.savedForm.formData = cleanFormData(scope.formData);
							var inputs = scope.formWindow.listFormInputs();

							scope.formData.savedForm.inputs = inputs;

							if (scope.formData.savedForm.preSaveOnly) {
								return FormAccessor.save(scope.formData.savedForm, function(data){
									scope.formData.savedForm = {preSavedTag: data};	// le savedForm en XBase est dans une cache dans le backend.
									model.formDataUpdated(true);	// car il faut mettre à jour le resumedValue au besoin.
								});
							}else{
								model.formDataUpdated(true);	// car il faut mettre à jour le resumedValue au besoin.
							}
							// y mettre les valeurs du form actif - si ne save pas, le cancel remettra les valeurs
							// angular.extend(scope.quickViewData.qvActData, scope.formData);
	                    } else if (scope.isDirtyOrCrds()===2) {
//                            scope.formData.savedForm = {mustCheckMetaData: true, preSaveOnly:p};
//                            var savedForm = angular.copy(scope.formData);
//                            delete savedForm.form.html;
//                            scope.formData.savedForm.formData = JSON.stringify(scope.formData);
//                            var inputs = scope.formWindow.listFormInputs();
//                            scope.formData.savedForm.inputs = JSON.stringify(inputs);
//                            if (scope.formData.savedForm.preSaveOnly) {
//                                FormAccessor.save(scope.formData.savedForm, function(data){
//                                    if (data.status && data.status.severity==='OK') {
//                                        console.log("saved succesfully");
//                                        scope.formData.savedForm = {preSavedTag: data.obj}; // le savedForm en XBase est dans une cache dans le backend.
//                                    }
//                                });
//					}
							if(scope.formWindow.modifButtonStatus) scope.formWindow.modifButtonStatus(false);	// activer les boutons
                            model.formDataUpdated(true);    // car il faut mettre à jour le resumedValue au besoin.
                            // y mettre les valeurs du form actif - si ne save pas, le cancel remettra les valeurs
                            // angular.extend(scope.quickViewData.qvActData, scope.formData);

	                    }
				    }
					// il faut remettre cette valeur defaut car on a fermé ou minimiser la fenêtre.
					if (scope.linkModeOn>0) {
						scope.toggleLinkMode();
					}
					return $q(function(resolve, reject){resolve()});
				}

				scope.preSaveForm = preSaveForm;
				
				scope.savePrintForm = function(){
					return scope.saveForm().then(function(){scope.printFormDataWithLinks()});
				}
				scope.saveFaxForm = function(){
					return scope.saveForm().then(function(){scope.faxFormDataWithLinks()});
				}
				scope.saveTaskForm = function(){
					return scope.saveForm().then(function(){
						FormAccessor.updateMessageLink(scope.formData, scope);
						payload = {
								presetPat: scope.formData.patient,
								idPatient: (scope.formData.patient ? scope.formData.patient.id : undefined),
								idLink:scope.formData.id ,
								linkType: MessageLink.linkTypes.form,
								formData: scope.formData,
								patientdata: {}
						};
						payload.patientdata['form_'+scope.formData.uid] = scope.formData;
						return TaskAccessor.openNew(payload);
					});
				}
				scope.saveSofyForm = function(){
					return scope.saveForm().then(function(){ 
						FormAccessor.updateMessageLink(scope.formData, scope);
						payload = {
								presetPat: scope.formData.patient,
								idLink:scope.formData.id ,
								linkType: MessageLink.linkTypes.form,
								patientdata: {}
						};
						payload.patientdata['form_'+scope.formData.uid] = scope.formData;
						return CourrielAccessor.openNew(payload, scope.formData.patient); 
					});
				}
				
				scope.saveForm = function(){
					if(scope.formWindow.formValidator && !scope.formWindow.formValidator.validate()){
						var errorMsg = $filter('translate')('InvalidForm');
						model.notice().fail(errorMsg);
						return $q.reject(errorMsg);
					}
					var defer = $q.defer();
					function saveFailed(){
						model.loadingOverlay().hide();
						defer.reject(arguments);
					};
					model.loadingOverlay().show('SAVING_DATA', true);
					//if form is crds type we need to reload the whole data
				    if (scope.formData.form.type===2) {
						preSaveForm(false);
						if(scope.formData.savedForm === undefined){
							defer.resolve();//Nothing to save.. go through
						}else{
							FormAccessor.save(scope.formData.savedForm, function(resData){
								console.log("crds form locally-saved succesfully");
								// le eformdata.save sauve aussi le attente au backend = appelant un delete avant au besoin.
								if (scope.formData.attenteTemp && scope.formData.attenteTemp.modificationStatus != undefined && scope.formData.attenteTemp.id==undefined) {
									scope.formData.attenteTemp.id = resData.id;
									FormAccessor.saveAttenteResultats(scope.formData.attenteTemp, function(data){
										scope.formData.attente = angular.copy(data);
										scope.formData.attenteTemp = angular.copy(data);
										model.notice().success($filter('translate')('RESULT_ATTENDUS_SAVED'));
									}, function(err) {
										model.notice().warn($filter('translate')('error') + ": " + err);										
									});
								}
								FormAccessor.getFormHtmlForCrds(resData.form.id, resData.id, function(html) {
									// scope.formData.form.html = html;
									scope.postSaveForm(resData);
									//Internet explorer does not allow srcdoc in iframe
									//form html is injected with form_proxy.html
									if(model.isIE){
										ieUpdate();
										ieFormLoadDocWritten = false;
									}
								}).then(defer.resolve, defer.reject);
							}, saveFailed);
						}
				    } else {
						preSaveForm(false);
	                    FormAccessor.save(scope.formData.savedForm, function(resData){
	                        console.log("locally-saved succesfully");
							if (scope.formData.attenteTemp && scope.formData.attenteTemp.modificationStatus != undefined && scope.formData.attenteTemp.id==undefined) {
								scope.formData.attenteTemp.id = resData.id;
								FormAccessor.saveAttenteResultats(scope.formData.attenteTemp, function(data){
									scope.formData.attente = angular.copy(data);
									scope.formData.attenteTemp = angular.copy(data);
			                        scope.postSaveForm(resData);
									model.notice().success($filter('translate')('RESULT_ATTENDUS_SAVED'));
								}, function(err) {
									model.notice().warn($filter('translate')('error') + ": " + err);										
								});
							} else {
		                        scope.postSaveForm(resData);								
							}
	                     // DCI OFF
						//	TaskAccessor.openNew();
	                    }, saveFailed).then(defer.resolve, defer.reject);
					}
					return defer.promise;
				};

				//inner function called from saveForm && saveAndSendAddedFilesToCrds
				scope.postSaveForm = function(resData) {
					// je ne garde pas le form retourné car incomplet.
					delete resData.form;
					delete resData.uid;
					delete resData.date;
					delete scope.formData.id;
					delete scope.formData.prefillForm;//utilisé pour le questionnaire cnesst
					angular.extend(scope.formData, resData);	// extend car je veux conserver le uid mais écraser les valeurs différentes
					setInitData(scope.formData,scope);
					scope.formData.prop.readonly=true;
					scope.formData.editMode = false;
					scope.formData.origVersion = _.omit(scope.formData, ['origVersion']);

					//Hook for Enconter or any other directive that has set an on save success listener.
					if(scope.viewOptions && scope.viewOptions.onSaveSuccess){
						scope.viewOptions.onSaveSuccess(scope.formData, scope.viewOptions);
					}

					//should not be done for crds because is cause eof exception
					//crds form type already do autofill, dont do it twice
					if (scope.isCrdsFormType() === false) {
						scope.formWindow.fillFormWithData(cleanFormData(scope.formData));
					}

					model.loadingOverlay().hide();
					model.editModeUpdated(true);
					model.formDataUpdated(true);	// car il faut mettre à jour le resumedValue au besoin.
					changeFormEditState(scope.formData.prop.readonly);
					model.actUpdated(true);
					addMessageLink()
				};

				function validLinkFromCrds(fd){
					var keys = [];
					if(fd.addedLinks && fd.addedLinks.length > 0 && !fd.addedCrdsKey){
						return false;
					}
					if (fd.addedCrdsKey) {
                		keys = fd.addedLinks.map(function(e){
							var arr = e.split('ı')
							if(fd.addedCrdsKey[arr[0]] !== undefined){
								return arr = arr[0];
							}
							return arr.splice(0, 2).join('ı');
						});
                		for (var i=0, j=keys.length; i<j;i++) {
                			var crdsKey = fd.addedCrdsKey[keys[i]]; 	// un [] sans duplicate
                			if (!crdsKey || crdsKey.length === 0) {
								return false;
							}
						}
					}
					return true;
				}

				function setAddedLinksFromCrdsKeyField(fd) {
                	var keys = [];
                	if (fd.addedCrdsKey) {
                		keys = _.keys(fd.addedCrdsKey);
                		for (var i=0, j=keys.length; i<j;i++) {
                			var crdsKey = fd.addedCrdsKey[keys[i]]; 	// un [] sans duplicate
                			if (crdsKey && crdsKey.length>0) {
                				var idx = -1;
            					for (var index = 0; index < fd.addedLinks.length; index++) {
	           					     var link = fd.addedLinks[index];
	           					     if (link.startsWith(keys[i])) {
	           					         idx = index; break;
	           					     }
            					}
                				if (idx>-1) {
                					if (keys[i]==='sum') {// ı106
                						fd.addedLinks[idx] = keys[i] + 'ı' + fd.addedLinks[idx].split('ı')[1] + 'ı' + crdsKey.join('|');
                    				} else {
                    					fd.addedLinks[idx] = keys[i] + "ı" + crdsKey.join('|');
                    				}
                				} else if (keys[i]==='sum') {
                					for (var n=0; n<fd.addedLinks.length;n++) {
                						if (fd.addedLinks[n].startsWith('sum')) {
                    						fd.addedLinks[n] = keys[i] + 'ı' + fd.addedLinks[n].split('ı')[1] + 'ı' + crdsKey.join('|');
                						}
                					}
                				}
            				}
            			}
            		}
            	}

                scope.saveAndSendAddedFilesToCrds = function() {
					if(!validLinkFromCrds(scope.formData)){
						model.notice().fail($filter("translate")("crds.prerequisiteMissingType"))
						console.log("Invalid CRDS: Document linked without selecting prerequisite.");
						return;
					}
                	setAddedLinksFromCrdsKeyField(scope.formData);
                    if(scope.formData.addedLinks.length === 0){
                    	model.notice().fail($filter('translate')('NoFilesToSendCRDS'));
                    	return;
                    }
                    model.loadingOverlay().show('ENVOI_CRDS_EN_COURS', true);
                    CrdsAccessor.saveAddedFiles(scope.formData, function(savedFormData) {

                        CrdsAccessor.sendAddedFilesToCrds(scope.formData, function() {
                        	delete savedFormData.uid;	// pour garder le lien
                        	delete scope.formData.id;
                        	if (scope.formData.attente) delete scope.formData.attente;
                            angular.extend(scope.formData, scope.postSaveForm(savedFormData));	// pour garder meme obj, on transfert les valeurs
                            model.notice().success($filter('translate')('crds.prerequisitesWereSent'));
            			    CrdsAccessor.getRequest(scope.formData.crdsRequestId, function(res) {
								scope.closeView();
								scope.formData.crdsRequest = res;
								scope.formData.crdsRequest.infoRequete = JSON.parse(res.infoRequete);

								scope.formData.prop.readonly = true;
								var isReadOnly = true;
								changeFormEditState(isReadOnly)
								model.loadingOverlay().hide();
								scope.closeContext(getActivity(), function(dirty){
									closeIfPrestine(!dirty)
								});
								// succes. On devrait fermer le formulaire ou le recharger auto.
								// getData(scope, scope.formData); ne ferme pas les popover...
	                        });
                        },
                        function() {
                            scope.formData = savedFormData;
                            getData(scope, scope.formData);
                            model.loadingOverlay().hide();
                    });
                    }, function(){model.loadingOverlay().hide();});
                };

				scope.sendACompleterFormToCrds = function() {
					scope.formWindow.setMetaDataId(scope.formData);
					scope.formWindow.Requete_nouvelle_ACompleterMedCaller();
					ieCrdFormStatusPatch();
				};

				scope.sendFormToCrds = function() {
					scope.formWindow.setMetaDataId(scope.formData);
					scope.formWindow.Requete_nouvelle_EnvoyerMedCaller();
					ieCrdFormStatusPatch();
				};

				scope.sendFormToCnesst = function() {
					scope.formData.submittingToCnesst = true;
					FormAccessor.sendToCnesst({eformDataId:scope.formData.id}, function(resData){
                    	scope.formData.submittingToCnesst = false;
                    	var updatedFormData = resData;
        				delete updatedFormData.uid;	// je ne veux pas écraser le uid actuel
        				angular.extend(scope.formData, updatedFormData);	// copier les properties - garde donc la ref du l'obj.
        				if (scope.formData.patient===undefined && scope.patient) {
        					scope.formData.patient = _.omit(scope.patient,'viewbag');
        				}
        				scope.form = scope.formData.form;	// en ai besoin pour les fav.
        				scope.form.html = scope.form.html.replace('$(".button-div").remove();', '$(".button-div").hide();');
        				setInitData(scope.formData, scope);
        				scope.formData.origVersion = scope.formData.origVersion ? angular.copy(scope.formData.origVersion) : angular.copy(scope.formData);	// pour permettre cancel
        				scope.formData.preSaveDone = false;	// mis true dans le preSave
        				setDataToAddedLinks(scope.quickViewData, scope.formData, scope);
						setFavoriteState(scope.form);
						//Hook for Enconter or any other directive that has set an on save success listener.
						if (scope.viewOptions && scope.viewOptions.onSaveSuccess) {
							scope.viewOptions.onSaveSuccess(scope.formData, scope.viewOptions);
						}
						addMessageLink();// pour mettre à jour et avoir last formdata id.
        				$timeout(function(){
        					formReady(scope.formWindow);
        					model.loadingOverlay().hide();
        					model.editModeUpdated(true);
        					model.formDataUpdated(true);
							model.notice().success($filter('translate')('SUCCESS_SENT_CNESST'));
        				}, 1000);
                    },
                    function() {
                    	scope.formData.submittingToCnesst = false;
                    });
				};

				// 0 si non crds, 1 si crds sans pre-req. 2 si avec prerequis. Facilite l'assignatino de data-ng-class dans patientDataFormLinks
				scope.crdsAndPreRequis = function(i) {
					var r = scope.formData.crdsRequest ? 1 : 0;
					if (r===1) {
						r += scope.hasPrerequis() ? 1 : 0;
					}
					return r===i;
				};
				scope.hasPrerequis = function() {
					if(scope.formData.crdsRequest && scope.formData.crdsRequest.infoRequete && scope.formData.crdsRequest.infoRequete.lstPrerequis && scope.formData.crdsRequest.infoRequete.lstPrerequis.length>0){
						return true;
					}
					return false;
				};

				scope.changePrerequisAssignment = function(act, key) {
					console.log('key: ' + key + ", assigned to: " + act.id + ", value:" + scope.prerequis[key][act.uid]);
					var uid = act.uid ? act.uid : 'sum';	// car si pas de uid, c'est forcément pour le sommaire.
					var action = scope.prerequis[key][uid];
					// il faut maitenant ajouter key à addedlinks - ligne 3300 dans patient.js (dir patientDataItem, scope.addItemsToLinks)
					// pour l'organisation de cet objet qui sera modifié ici.
					var t = "";
					if(act.className === "CLaboFile" || act.className === "CLaboResultsProfessionnal"){
						t="lab";
					}else if(act.className === "CBasePatientImage" || act.className === "CPatientImage"){
						t="doc";
					}else if(act.className === "CEncounter"){
						t="enc";
					}else if(act.className === "CFormData"){
						t="form";
					} else {
						t='sum';
					}
					var actKey = t==='sum' ? t : t+'ı'+act.id;

					var idx = -1;
					for (var index = 0; index < scope.formData.addedLinks.length; index++) {
					     var link = scope.formData.addedLinks[index];
					     if (link.startsWith(actKey)) {
					         idx = index; break;
					     }
					}

					// devrait TJRS être là, sauf si sum
					if (idx>-1) {
						if (scope.formData.addedKeys===undefined) {
							scope.formData.addedKeys = [];	// juste pour savoir lesquelles ont été ajoutées.
						}
						if (scope.formData.addedCrdsKey===undefined) {
							scope.formData.addedCrdsKey = {};
						}
						if (scope.formData.addedCrdsKey[actKey]===undefined) {
							scope.formData.addedCrdsKey[actKey] = [];
						}
						if (scope.formData.selectedDV===undefined) {
							scope.formData.selectedDV = {};
						}
						if (action) {	// true, donc a sélectionné une case
							scope.formData.addedCrdsKey[actKey].push(key);
							scope.formData.addedKeys.push(key);
						} else {	// donc déselection d'un pré requis
							scope.formData.addedCrdsKey[actKey] = _.without(scope.formData.addedCrdsKey[actKey], key);
							scope.formData.addedKeys = _.without(scope.formData.addedKeys, key);
						}
						scope.formData.addedKeys = scope.formData.addedKeys.sort(function(o1,o2) {
							return o1.localeCompare(o2);
						});
					}
				};

				// called after les 'getData'
				scope.setPrerequisInLists = function() {
					scope.prerequis = {};	// ng-model pour status select ou non.
					scope.lstPrerequisText = undefined;
					scope.lstPrerequis = [];
					scope.lstPrerequisManquant = [];
					scope.needsPrerequis = false;
					if (scope.formData.crdsRequest && scope.formData.crdsRequest.infoRequete) {
						if (scope.formData.crdsRequest.infoRequete.cnDiscussionhistorique) {
							// conseil numérique
							if (scope.formData.crdsRequest.infoRequete.lstPrerequis == undefined) {
								scope.formData.crdsRequest.infoRequete.lstPrerequis = ["demandeurDocument|Autres rapports"];
						//		scope.formData.crdsRequest.infoRequete.lstPrerequis = ["rprt_AUTRES|Autres rapports"];
							}
						}
						if (scope.formData.crdsRequest.infoRequete.lstPrerequis) {
							var lstPR = scope.formData.crdsRequest.infoRequete.lstPrerequis;
							if (lstPR && lstPR.length>0) {
								var listTexteOnly = [];
								for (var index = 0; index < lstPR.length; index++) {
									var value = lstPR[index];
									if (value) {
										var vals = value.split("|");
										var pr = {};
										pr.key = vals[0];
										pr.text = vals[1];
										scope.prerequis[pr.key]={};
										scope.lstPrerequis.push(pr);
										// n'est pas un pre-requis mais pour avoir le menu ici, on fait comme si
										if (vals[0]=='rprt_AUTRES' || vals[0]=='demandeurDocument') {
											var prOpt = {key:vals[0], text:vals[1] + ' (' + $filter('translate')('optionnel') + ')'};
											scope.lstPrerequisManquant.push(prOpt);
										} else {
											listTexteOnly.push(pr.text);
										}
									}
								}
								scope.lstPrerequisText = listTexteOnly.toString();
							}
						}
						if (scope.formData.crdsRequest.infoRequete.lstPrerequisManquant) {
							var lstPRM = scope.formData.crdsRequest.infoRequete.lstPrerequisManquant;
							if (lstPRM && lstPRM.length>0) {
								for (var indexj = 0, cnt = lstPRM.length; indexj < cnt; indexj++) {
									value = lstPRM[indexj];
									if (value) {
										var vals = value.split("|");
										var pr = {};	// il faut créer un nouvel objet ici
										pr.key = vals[0];
										pr.text = vals[1];
										scope.lstPrerequisManquant.push(pr);
										scope.needsPrerequis = true;
									}
								}
							}
						}
					}
				};
				scope.evalPrerequisManquant =  function() {
					var stillManquant = [];
					for (var i=0, l=scope.lstPrerequisManquant.length; i<l; i++) {
						var km = scope.lstPrerequisManquant[i];
						if (_.indexOf(scope.formData.addedKeys, km.key, true)==-1 && 'rprt_AUTRES'!=km.key) {
							stillManquant.push(km.text);
						}
					}
					return stillManquant;
				};

				scope.closeView = function(){
					$timeout(function() {
						angular.element('#btn-toggle-link-mode').triggerHandler('click');
					});
				};

 				scope.changeLinkedDocsAssignment = function(act) {
					var uid = act.uid ? act.uid : 'sum';	// car si pas de uid, c'est forcément pour le sommaire.
					console.log('key: ' + scope.formData.selectedDV[uid].key + ", assigned to: " + act.id);
					var action = scope.formData.selectedDV[uid].key;
					// il faut maitenant ajouter key à addedlinks - ligne 3300 dans patient.js (dir patientDataItem, scope.addItemsToLinks)
					// pour l'organisation de cet objet qui sera modifié ici.
					var t = "";
					if(act.className === "CLaboFile" || act.className === "CLaboResultsProfessionnal"){
						t="lab";
					}else if(act.className === "CBasePatientImage" || act.className === "CPatientImage"){
						t="doc";
					}else if(act.className === "CEncounter"){
						t="enc";
					}else if(act.className === "CFormData"){
						t="form";
					} else {
						t='sum';
					}
					var actKey = t==='sum' ? t : t+'ı'+act.id;

					var idx = -1;
					for (var index = 0; index < scope.formData.addedLinks.length; index++) {
					     var link = scope.formData.addedLinks[index];
					     if (link.startsWith(actKey)) {
					         idx = index; break;
					     }
					}

					// devrait TJRS être là, sauf si sum
					if (idx>-1) {
						if (scope.formData.addedCrdsKey===undefined) {
							scope.formData.addedCrdsKey = {};
						}
						if (scope.formData.addedCrdsKey[actKey]===undefined) {
							scope.formData.addedCrdsKey[actKey] = [];
						}
						if (scope.formData.selectedDV===undefined) {
							scope.formData.selectedDV = {};
						}
						if (action) {	// true, donc a sélectionné un item
							scope.formData.addedCrdsKey[actKey] = [];
							scope.formData.addedCrdsKey[actKey].push(scope.formData.selectedDV[uid].key);
						} else {	// donc retrait - on devrait n'Avoir qu'un select ici car pas de select multiple avec cnesst
							scope.formData.addedCrdsKey[actKey] = _.without(scope.formData.addedCrdsKey[actKey], scope.formData.selectedDV[uid].key);
						}
					}
				};

				scope.ignoreChanges = false;

				scope.toggleLinkMode = function(){
					//PATCHING CODE Load from SAFIR-CRDS tab and not pt data begin**************
					if (scope.formData.form.type===2) {
						setDataToAddedLinks(scope.quickViewData, scope.formData, scope);
					}
					//PATCHING CODE Load from SAFIR-CRDS tab and not pt data end****************

					scope.linkModeOn = scope.linkModeOn>0?0:1;
					if (scope.quickViewData) {
						scope.quickViewData.linkModeOn = scope.linkModeOn?1:0;
					}
					model.formLinkUpdated(true);
					model.editModeUpdated(true);	// il faut réévaluer quand la val de linkMode change
				};

				function filterNotInArray(a) {
					var b = true;
					if (scope.quickViewData.qvActData.addedLinksUid) {
						b = $.inArray(a.uid, scope.quickViewData.qvActData.addedLinksUid)>-1;
					}
					return b;
				}

				scope.addedLinksCount = function() {
					return scope.formData.addedLinks ? scope.formData.addedLinks.length : 0;
				};

				var changeFormEditState = function(isReadOnly){
				    if (scope.formWindow.setReadonly) {
				    	scope.formWindow.setReadonly(isReadOnly);
					}
				    if (scope.formWindow._onReady) {
				    	scope.formWindow._onReady();
					}
					if(scope.formData && scope.formData.prop){
						scope.formData.editMode = !scope.formData.prop.readonly;
					}
					if (isReadOnly) {
						// il faut remettre cette valeur defaut
						scope.quickViewData.linkModeOn = 0;
					}
				};

				scope.formFlag= "";
				scope.setupIframe = function(elem){
					scope.formWindow = elem[0].contentWindow;
					scope.adjustIFrame(elem);
					// appelé à la fin du load data
					scope.formWindow.setFormProperties = function(prop){
						$.extend(scope.formData.prop, prop);
						if(scope.formData.viewbag){
							scope.formData.viewbag.iframeIsLoading = false;
						}
					};
					scope.postSetUpIframe(elem);
				};

				scope.isCrds = function(){
					return scope.formType === scope.FORM_TYPES.CrdsLocal ||
							scope.formType === scope.FORM_TYPES.IECrdsLocal ||
							scope.formType === scope.FORM_TYPES.Crds ;
				};
				scope.postSetUpIframe = function(elem){
					$log.log("Setting up form idForm : " + scope.formData.idForm + " idAnchor: "+ scope.formData.idAnchor + " :: " + scope.formData.form.name );
					var crdsDirect = scope.formType === scope.FORM_TYPES.Crds;//Form directly linked to crds and not modified by ofys
					var isCrds = scope.isCrds();

					if(isCrds){
						scope.formData.submittingToCrds = false;
					}
					//Internet explorer does not allow srcdoc in iframe
					//form html is injected with form_proxy.html
					if(!crdsDirect && model.isIE){
						ieFormLoadFix(scope.formWindow, crdsDirect);
					}else if(!crdsDirect){
						formReady(scope.formWindow);
					}else if(crdsDirect){
						setCRDSFormAPI(scope.formWindow);
					}

					// if(isCrds && !model.user().isMd()&&!model.user().isIPS()){
					// 	// code qui, je pense, concerne les crds.
					// 	try{
					// 		scope.formWindow.document.getElementById('Requete_nouvelle_EnvoyerMed').style.display = "none";
					// 	}catch(e){
					// 		console.error(e);
					// 	}
					// }

					if(isCrds && !crdsDirect){
						scope.$digest();
						var readonly = false;
						changeFormEditState(readonly);
					}
				};

				scope.notFormCrds = function(fd) {
					return fd && (fd.id===undefined || (fd.form && fd.form.type!==2));
				};

				scope.formCrdsIsOnlySaved = function(fd) {
					return fd && fd.id !== undefined && fd.form && fd.form.type===2 && fd.crdsRequestId === undefined;
				};

				//In IE saving the form does not change the status of the quickview editor.
				//ieCrdFormStatusPatch function ensures that the status is updated when change occurs
				function ieCrdFormStatusPatch(){
					if(model.isIE && scope.isCrds()){
						$timeout(function(){
							formReady(scope.formWindow);
						}, 5000);
					}
				}

				var reloadAfter = 1;
				function ieFormLoadFix(iframe, crdsDirect){
					if(scope.form && !ieFormLoadDocWritten && scope.formData.prop){
						ieFormLoadDocWritten = true;
						//Internet explorer hack since srcdoc in iframe does not work
						//Inject html. this method 'setFormHtml' is created in form_proxy.html
						//when eform is loaded the frame containing this function is loaded, calling this method rewrites the frame content.
						var iframedoc = iframe.document;
						iframedoc.open();
				        iframedoc.write(scope.form.html);
						iframedoc.close();

						//Crds peut avoir des navigations de sauvegarde ceci
						//assure que angular est mis au courant du changement pour
						//la mise a jours des états de rafraichisement
						iframe.onbeforeunload = function(event) {
							ieCrdFormStatusPatch();
						};

						//set the formReady callback that is called by the
						//form when it has been loaded in this case by the $(document).ready() function of - eformInject.js
						// scope.formWindow.formReady = formReady;
						scope.formWindow.formReady = formReady;
						// formReady(scope.formWindow);
						ieFormLoadFixLoadCount = 0;
						reloadAfter = 1;
					}else if(ieFormLoadFixLoadCount < 10 && !ieFormLoadDocWritten){
						ieFormLoadFixLoadCount += 1;
						if(ieFormLoadFixLoadCount > 5) {
							reloadAfter = ieFormLoadFixLoadCount * 10;
						}
						$timeout(function(){
							ieFormLoadFix(iframe, crdsDirect);
						}, reloadAfter);
					}else if(ieFormLoadFixLoadCount >= 10){
						model.notice().fail($filter('translate')('FailedIELoadingForm'));
					}
				}

				scope.adjustIFrame = function(elem){
					//Resize the iframe to fit parent remaining space
					var parentSection = $(elem[0]).parents("section")[0];
					var headerHeight = $(parentSection).find(".header").outerHeight();
					if(headerHeight === undefined){
						headerHeight = 0;
					}
					var height = $(parentSection).outerHeight() - headerHeight;
					elem[0].style.height = 0;
					elem[0].style.height = (height-5) + "px";//the magic no. 5 is due to required extra padding.
				};

				// function clearMessageLink() {
				// 	if(angular.isDefined(FormAccessor.messageLinkKey) &&
				// 		FormAccessor.messageLinkKey !== "" &&
				// 		FormAccessor.msgLinkMap[scope.formData.id] !== undefined){
				// 		MessageLink.removeLinkType(FormAccessor.messageLinkKey);
				// 		delete FormAccessor.msgLinkMap[scope.formData.id];
				// 	}
				// }
				// function addMessageLink(){
				// 	if (scope.formData) {
				// 		clearMessageLink()
				// 		FormAccessor.updateMessageLink(scope.formData);
				// 		scope.$on('$destroy',  clearMessageLink);
				// 	}
				// }


				scope.reloadIframeSource = function(form) {
					var myEl = angular.element(document.querySelector('#formFrame'));
					myEl.attr('srcdoc',$filter("toTrusted")(form.html));
					scope.formWindow.setFormProperties(form.prop);
				};

				/**
				 * Called on iframe form ready window
				 * Fill's form with autocomplete data or already saved data
				 * @param wx : iframe window. allows for overriding functions and gives access to form window.
				 * @returns undefined
				 */
				function formReady(wx){
					if (wx.fillFormWithData) {	// sinon, est un html crds
						if (wx.isAForm && wx.isAForm()) {
							scope.formData.viewbag.iframeIsLoading = true;
							wx.fillFormWithData(cleanFormData(scope.formData));
							if(scope.isCrdsFormType()){
								setCRDSFormAPI(wx)
							}else{
								setFormApi(wx);
							}
							changeFormEditState(scope.formData.prop.readonly);
							scope.formData.viewbag.iframeIsLoading = false;// des fois que n'a pas été désetté.
						} else {
							// pas une form. Donc une réponse crds ou un message d'erreur;
							scope.formData.submittingToCrds = false;
							scope.formData.submittingToCnesst = false;
							scope.formData.isResponseFromCrds = true;
							delete scope.formData.prop;
							model.formDataUpdated(true);
							scope.$digest();
						}
					} else {
						scope.formData.submittingToCrds = false;
						scope.formData.submittingToCnesst = false;
						delete scope.formData.prop;
						if (wx.document && wx.document.URL.indexOf('succes.html')>-1) {
							scope.formData.isResponseFromCrds = true;
						}
						model.formDataUpdated(true);	// car il faut mettre à jour le resumedValue au besoin.
						scope.$digest();
					}
				}

				function setCRDSFormAPI(wx){
					wx.InfodataOfys = {
						isCRDS: true,
						getFormId: function(){
							return scope.formData.id;
						},
						getCRDSId: function(){
							return scope.formData.crdsRequestId;
						},
						saveFormIfNew: function(submitCRDS){
							if(scope.formData.id == undefined){
								scope.saveForm().then(function(){
									console.log("Saved success");
									submitCRDS(scope.formData);
								});
							}else{
								submitCRDS(scope.formData);
							}
						}
					}
				}

				function setFormApi(wx){
					wx.allDatePickers = scope.formData.dashEdit.datePickers;

					wx.searchProf = function(id, name, code,adress,tel, fax){
						return FlView.open({templateUrl: "/dashboard/resources/ofys/prof/search_prof.html?v=bf"}).then(function(prof){
							if(id) wx.setVariable(id, safeStr(prof.id));
							if(name) wx.setVariable(name, safeStr(prof.lastName) + ", "+ safeStr(prof.firstName));
							if(code) wx.setVariable(code, safeStr(prof.code));
							if(adress) wx.setVariable(adress, safeStr(prof.street) + " "+ safeStr(prof.cityName));
							if(tel) wx.setVariable(tel, safeStr(prof.tel));
							if(fax) wx.setVariable(fax, safeStr(prof.fax));
							return prof
						});
					};

					function safeStr(str){
						if(str !== undefined){
							return str;
						}else{
							return "";
						}
					}

					wx.envOpenUrl = function(v) {
						DashWebSocket.send({url: "/dashboard", data:{url:v}});
					};

					if(model.debug().isActive){
						wx.right_clic = function(){
							return true;
						};
					}
					wx.searchPatient = function(){
						console.log("searchPatient not yet implemented!!");
					};

					wx.assistText = function(){
						//Since no use case was found this function should never be called.
						//If it is then an implementation is required. Here because it exist in legacy BrowserFunction code.
						console.log("$$Should be implemented$$ Pending implementation no use case found :: assistText not yet implemented!!");
					};

					wx.createNewAssistant = function(){
						console.log("createNewAssistant not yet implemented!!");
					};
					var profsArr = $filter('orderBy')(model.store.profs.list(), ['lastName', 'firstName']);
					var empsArr = $filter('orderBy')(OfysUtils.ObjectValuesAsArray(model.user().employees), ['lastName', 'firstName']);

					//All subsequent ofys api's should start with "o_" to avoid name collisions.
					wx.o_getProfList = function(criteria){
						return $q(function(resolve, reject){
							try{
								var profarr = profsArr;
								if(criteria){
									profarr = profarr.filter(criteriaFilter(criteria));
								}
								resolve(profarr);
							}catch(e){
								console.error(e);
								reject(e);
							}
						});
					}

					//All subsequent ofys api's should start with "o_" to avoid name collisions.
					wx.o_getEmployeeList = function(criteria){
						return $q(function(resolve, reject){
							try{
								resolve(empsArr);
							}catch(e){
								console.error(e);
								reject(e);
							}
						});
					}

					function criteriaFilter(criteria){
						if(typeof criteria === "function"){
							return criteria;
						}else if (typeof criteria === "object") {
							var keys = Object.keys(criteria);
							return function (item) {
								for (let i = 0; i < keys.length; i++) {
									if(criteria[keys[i]] === item[keys[i]]){
										return true;
									}
								}
								return false;
							}
						}
					}

					if(wx.AutoComplete){
						wx.AutoComplete.isWebVersion = true;
						wx.AutoComplete.api = TempAssistAccessor.api;
					}
				}

				scope.$watch(attrs.forms, update);
			}
		};
	}]);
	
	form.controller('FormManagerController', ['$scope', 'model', '$filter', 'FormAccessor', 'QConfirm',
       			 function($scope, model, $filter, formAccessor, QConfirm){
			
			var isLoading = false;
			function init(){
				if(!isLoading){
					isLoading = true
					const promiseAdmin = new Promise((resolve) =>
						formAccessor.adminList(function(res){
							$scope.adminForms = res.filter(e =>e.type != 2);
							resolve(true);
						}, function(error){
							model.notice().fail($filter('translate')(error.msg));
							resolve(false);
						})
					)
					const promiseFavorite = new Promise((resolve) =>
						formAccessor.favoritesList(function(res){
							$scope.favoritesForms = res.filter(e =>e.type != 2);
							resolve(true);
						}, function(error){
							model.notice().fail($filter('translate')(error.msg));
							resolve(false);
						})
					)
					const promiseAvail = new Promise((resolve) =>
						formAccessor.availablesList(function(res){
							$scope.availablesForms = res.filter(e =>e.type != 2);
							$scope.currList = res.filter(e =>e.type != 2);
							nbrOfStep = Math.ceil(res.length/step)-1;
							$scope.lstDisplayedForms = [];
							$scope.lstDisplayedForms.push(...$scope.currList.slice(offset, offset+step-1))
							offset += step;
							currStep +=1;
							resolve(true);
						}, function(error){
							model.notice().fail($filter('translate')(error.msg));
							resolve(false);
						})
					)
					Promise.all([promiseAdmin, promiseFavorite, promiseAvail]).then((e) => $scope.ready = true, model.actUpdated(true))
				}
			}
			
			$scope.getFormLst = function(){
				if(listUpd){
					offset = 0;
					currStep = 0
					$scope.lstDisplayedForms = []
					if($scope.formFiltervalue.value.code == "admin"){
						$scope.currList = $scope.adminForms;
					}else if($scope.formFiltervalue.value.code == "fav"){
						$scope.currList = $scope.favoritesForms;
					}else if($scope.formFiltervalue.value.code == "avail"){
						$scope.currList = $scope.availablesForms;
					}
					nbrOfStep = Math.ceil($scope.currList.length/step)-1
					$scope.lstDisplayedForms.push(...$scope.currList.slice(offset, offset+step-1));
					offset += step;
					currStep +=1;
					listUpd = false;
				}
				return $scope.lstDisplayedForms;
			}
			
			var listUpd = false;
			$scope.updateList = function(){
				listUpd = true;
				$scope.searchQuery = "";
				model.forms().adminEdit = false;
				model.actUpdated(true);
			}
			
			var offset = 0;
			var step = 50;
			var nbrOfStep = 0;
			var currStep = 0
			$scope.getNextForms = function(){
				if(currStep<nbrOfStep){
					$scope.lstDisplayedForms.push(...$scope.currList.slice(offset, offset+step-1))
					offset += step;
					currStep +=1;
				}else if(currStep==nbrOfStep){
					$scope.lstDisplayedForms.push(...$scope.currList.slice(offset, $scope.currList.length-1))
					offset += step;
					currStep +=1;
				}
				model.actUpdated(true);
			}
			
			$scope.getForm = function(form){
				delete $scope.selectedForm;
				$scope.selectedForm = {};
				formAccessor.getPlainForm(form.id, function(res){
					$scope.form = res;
					$scope.selectedForm = res;
					$scope.selectedForm.ready = true;
					model.actUpdated(true);
				}, function(error){
					model.notice().fail($filter('translate')(error.msg));
					model.actUpdated(true);
				})
			}
			
			$scope.isActive = function(form){
				return $scope.form && form.id == $scope.form.id;
			}
			
			$scope.setupIframe = function(elem){
				$scope.formWindow = elem[0].contentWindow;
				$scope.adjustIFrame(elem);
				// appelé à la fin du load data
				$scope.formWindow.setFormProperties = function(prop){
					$.extend($scope.selectedForm.prop, prop);
				};
				if($scope.formWindow.setReadonly) {
			    	$scope.formWindow.setReadonly(true);
				}
			    if($scope.formWindow._onReady) {
			    	$scope.formWindow._onReady();
				}
			};
			
			$scope.adjustIFrame = function(elem){
				//Resize the iframe to fit parent remaining space
				var parentSection = $(elem[0]).parents("section")[0];
				var headerHeight = $(parentSection).find(".header").outerHeight();
				if(headerHeight === undefined){
					headerHeight = 0;
				}
				var height = $(parentSection).outerHeight() - headerHeight;
				elem[0].style.height = 0;
				elem[0].style.height = (height-5) + "px";//the magic no. 5 is due to required extra padding.
			};
			
			$scope.editAlert = function(){
				if(!model.forms().adminAlert){
					model.forms().adminAlert = true;
					var qconfirmOptions = {
						title: $filter('translate')('admin_form_alert') + "<br>" + $filter('translate')('admin_form_alert_2'),
						qconfirm: {
							hideCancel: true,
							yesTitle: "DoIt",
							noTitle: "Cancel",
						}
					};
					QConfirm.open(qconfirmOptions).then(function(proceed){
						if(!proceed){
							model.forms().adminEdit = false;
						}else{
							model.forms().adminEdit = true;
						}
						model.actUpdated(true);
					});
				}else{
					model.forms().adminEdit = !model.forms().adminEdit;
					model.actUpdated(true);
				}
			}
			
			$scope.formFilter = {
				admin: {name:'All', code: "admin"},
				favorite: {name:'favorites', code: "fav"},
				available: {name:'available', code: "avail"},
			};
			
			$scope.formFiltervalue = {value : $scope.formFilter["available"]};
			
			$scope.modifyFormFavorite = function(form){
				if($scope.isFavorite(form)){
					delFavForm(form);
				}else{
					addFavForm(form);
				}
			}
			
			$scope.isFavorite = function(form){
				return $scope.favoritesForms.some(e => e.id == form.id);
			}
			
			function addFavForm(form){
				var usr = model.user();
				var data  = {formId: form.id, userId: usr.sessionUser.user.id};
				formAccessor.addToFavorites(data, function(resData){
					if(resData){
						formAccessor.utils.addToFavorites(form);
						$scope.favoritesForms.push(form);
					}
					model.actUpdated(true);
				});
			};
			function delFavForm(form){
				var usr = model.user();
				var data  = {formId: form.id, userId: usr.sessionUser.user.id};
				formAccessor.removeFavorites(data, function(resData){
					if(resData==true){
						formAccessor.utils.removeFromFavorites(form);
						var i = formAccessor.utils.findInList(form.id, $scope.favoritesForms);
						$scope.favoritesForms.splice(i, 1);
					}
					model.actUpdated(true);
				});
			};
			
			$scope.modifyFormAvailable = function(form){
				if($scope.isAvailable(form)){
					delAvailForm(form);
				}else{
					addAvailForm(form);
				}
			}
			
			function addAvailForm(form){
				var usr = model.user();
				var data  = {formId: form.id, userId: usr.sessionUser.user.id};
				formAccessor.addToAvailables(data, function(resData){
					if(resData){
						formAccessor.utils.addToAvailables(form);
						$scope.availablesForms.push(form);
					}
					model.actUpdated(true);
				});
			};
			function delAvailForm(form){
				var usr = model.user();
				var data  = {formId: form.id, userId: usr.sessionUser.user.id};
				formAccessor.removeAvailables(data, function(resData){
					if(resData==true){
						formAccessor.utils.removeFromAvailables(form);
						var i = formAccessor.utils.findInList(form.id, $scope.availablesForms);
						$scope.availablesForms.splice(i, 1);
					}
					model.actUpdated(true);
				});
			};
			
			$scope.isAvailable = function(form){
				return $scope.availablesForms.some(e => e.id == form.id);
			}
			
			$scope.searchForm = function(query){
				if(query.length > 0){
					$scope.lstDisplayedForms = $scope.currList.filter((a) => OfysUtils.matchInRegExpArray(OfysUtils.searchRegExpArray(query, 1), a.nameLc));
				}else{
					$scope.lstDisplayedForms = $scope.currList;
				}
				
//				$scope.lstDisplayedForms = formAccessor.utils.filterList(query, $scope.currList)
				model.actUpdated(true);
			}
			
			init()
    }]);

})();