(function(){
	var scan = angular.module('scan', ['ngSanitize']);
	
	scan.controller('ScanningController', ['$scope', 'DocAccessor', 'model', '$filter', 'ModificationStatus', 'QConfirm',
					'PatientFormService', 'patientShowTitles', 'PatientAccessor', '$timeout',
        	        function($scope, DocAccessor, model, $filter, ModificationStatus, QConfirm, PatientFormService,
								patientShowTitles, PatientAccessor, $timeout){


		model.activeController('scan');
		model.activeMenu('scan');
		
		$scope.criteriaPreset = {
			simple: function () {
				var res = getDefaultCriteria();
				return res;
			}
		}
		
		$scope.onCallProf = model.clientPreferences().onCallProfessionnal;
		if($scope.onCallProf){
			$scope.onCallProf.isOnCall = true;
		}
		
		DocAccessor.labels(function(res){
			$scope.listDocLabels = res.filter(label => !label.isDeleted);
		})
		
		$scope.docFunction = {};
		
		const html5QrCode = new Html5Qrcode("qr-input-file", "reader", { verbose: true, formatsToSupport: [ Html5QrcodeSupportedFormats.QR_CODE ] }); //, Html5QrcodeSupportedFormats.CODE_128
		
		$scope.pdfjs = { get: true, lib: undefined, onCallProf: $scope.onCallProf};
		$scope.qrCodeReady = false;
		
		$scope.docSearchDynaDateOptions = {acceptFutureDate: false};
		
		$scope.compassnav = function(direction){
			var d = moment(model.scan().currSearchDate, OfysUtils.DATEFORMAT);
			if(!model.scan().currSearchDate){
				model.scan().currSearchDate = moment().format(OfysUtils.DATEFORMAT);
				d = moment(model.scan().currSearchDate, OfysUtils.DATEFORMAT);
			}
			if(direction === 'N'){
				model.scan().currSearchDate = d.add(1, 'days').format(OfysUtils.DATEFORMAT);
			}else if(direction === 'C'){
				model.scan().currSearchDate = moment().format(OfysUtils.DATEFORMAT);
			}else if(direction === 'S'){
				model.scan().currSearchDate = d.subtract(1, 'days').format(OfysUtils.DATEFORMAT);
			}
		};
		$scope.isSearching = false;
		
		function getDefaultCriteria(){
			var res = {
				professionnals: []
			};
			res.professionnals.push(model.user().profil.id);
			var profSelect = $scope.groupCriteria.find(function (e) {
				return e.name === 'scanProfSelector';
			})
			if (profSelect && typeof profSelect.select === 'function') {
				var prof = model.store.profs.get(model.user().profil.id, function(prof){
					profSelect.select(prof);
				})
			}
			
			updateFromDate(res);
			return res;
		}
		
		$scope.refreshDirectory = async function(){
			isFileToEditDirty(populateDirectory);
		}
		
		async function populateDirectory(){
			if(model.scan().directoryHandler){
				populateList(model.scan().directoryHandler);
			}else{
				model.scan().viewType = 'fileToAdd';
				model.actUpdated(true);
			}
		}
		
		$scope.selectFolder = async function(){
			isFileToEditDirty(getDirectory);
		}
		
		async function getDirectory(){
			if(!window.showDirectoryPicker){
			    alert('Unsupported Browser Notice');
			    return;
			}
			model.scan().directoryHandler = await window.showDirectoryPicker({ mode: 'readwrite' });
//			getAccessResult();
			populateList(model.scan().directoryHandler);
		};
		
//		async function getAccessResult(){
//			let result = await model.scan().directoryHandler.queryPermission({ mode: 'readwrite' });
//			if(result != "granted"){
//				let request = await model.scan().directoryHandler.requestPermission({ mode: 'readwrite' });
//				console.log(request);
//			}
//		};
		
		async function populateList(directoryHandle){
			model.scan().viewType = 'fileToAdd';
			var files = [];
			var filesRemaining = [];
			for await(let handle of directoryHandle.entries()){
				let doExist = model.scan().files.list.filter(e => e.origName == handle[0])
				let extention = handle[0].toLowerCase()
				if(extention.match(/\.pdf$/) || extention.match(/\.png$/) || extention.match(/\.jpeg$/) || extention.match(/\.jpg$/)){
					file = await handle[1].getFile();
					if(file.size/1024 < 5120){
						if(doExist.length == 0){
							files.push(file);
						}
						else if(doExist.length > 0){
							filesRemaining.push(doExist[0])
						}
					}else{
						$scope.fileTooBig = true;
					}
				}
			}
			Array.prototype.push.apply(filesRemaining,model.scan().files.list.filter(e=> e.fromNewFile)); 
			model.scan().files.list = [...new Set(filesRemaining)];
			if(files && files.length > 0){
				Object.keys(files).forEach((val, key, arr) => {
					const file = files[key]
					var reader = new FileReader();				
					reader.onload = function (readerEvent) {
						if(file.type == 'application/pdf'){
							convertPdfFile(readerEvent, file)
						}
						if(arr.length - 1 == key){
							updateAndSortList();
						}else if(file.type == 'image/png' || file.type == 'image/jpeg'){
							var image = new Image();
							image.onload = function (imageEvent) {
								convertImgFile(readerEvent, image, file)
								if(arr.length - 1 == key){
									updateAndSortList();
								}
							}
							image.src = readerEvent.target.result;
						}
					}
					reader.readAsDataURL(file);
				})
			} else{
				model.scan().files.list.sort((a,b) => (a.origName.toLowerCase().localeCompare(b.origName.toLowerCase())));
				model.actUpdated(true);
			}
			
		}
		
		/**
		 * COMMENT: SCAN QRCODE @function
		 *
		 * Permet de trier tout les documents et de décrypter les codes QR
		 * Les trois fonctions(qrCodeScan, getPdfAsImage, getDecodedText) sont utiliser dans la même boucle
		 * 	
		 */
		$scope.qrCodeScan = async function(){
			$scope.qrCodeReady = false
			var files = [];
			var canvasdiv = document.getElementById('qrCanvas_div');
			while(!$scope.pdfjs.lib){
				await new Promise( resolve => setTimeout(resolve, 200))
			}
			for(var i = 0; i < model.scan().files.list.length; i++){
				if(!model.scan().files.list[i].isDecoded && model.scan().files.list[i].t != "imgviewer"){
					var pdf = $scope.pdfjs.lib.getDocument(convertDataURIToBinary(model.scan().files.list[i].sanitizedImage))
					let file = await getPdfAsImage(pdf, canvasdiv)
					file.$$hashKey = model.scan().files.list[i].$$hashKey
					files.push(file)
					pdf.destroy();
				} else {
					files.push(model.scan().files.list[i])
				}
			}
			canvasdiv.replaceChildren();
			for(var i = 0; i < files.length; i++){
				if(!files[i].isDecoded && files[i].t != "imgviewer"){
					let qrText = await getDecodedText(files[i])
					model.scan().files.list[i].decodedCode = qrText;
					model.scan().files.list[i].isDecoded = true;
				}
			}
			$scope.qrCodeReady = true
		}
		
		async function getPdfAsImage(pdf, canvasdiv){
			return pdf.promise.then(function(pdf){
				var page = pdf.getPage(1)
				return page.then(function(page){
					var scale = 1.5;
             		var viewport = page.getViewport({scale});
					var canvas = document.createElement('canvas');
 					canvasdiv.appendChild(canvas);
        			var context = canvas.getContext('2d');
					canvas.height = viewport.height;
		            canvas.width = viewport.width;
		            var task = page.render({canvasContext: context, viewport: viewport})
		            return task.promise.then(function(){
						return new File([convertDataURIToBinary(canvas.toDataURL('image/jpeg'))],  "qr.jpeg");
		            });
				});
			});
		}
		
		function getDecodedText(file){
			return html5QrCode.scanFile(file, false)
			.then(decodedText => {
		   		return decodedText;
			})
			.catch(err => {
		    	console.log(`Error scanning file. Reason: ${err}`)
			});
		}
		
		$scope.saveQrCodeFile = async function(){
			isSaving = true;
			var docList = [];
			for(i=0; model.scan().files.list.length > i; i++){
				if(model.scan().files.list[i].decodedCode){
					var splitQrText = model.scan().files.list[i].decodedCode.split(":")
					var res = undefined;
					var name = undefined;
					var profId = undefined;
					if(splitQrText[0] == "VIS"){
						name = $filter('translate')('ENCOUNTER') + " (" + splitQrText[3] + ")";
						res = await getPatient(splitQrText[1]);
						model.scan().files.list[i].qrEncounter = {
							isSeen: splitQrText[2] == model.user().profil.id,
							date: splitQrText[3]
						}
					} else if(splitQrText[0] == "SOM"){
						name = $filter('translate')('PatientMedSummary')
						res = await getPatient(splitQrText[1]);
					} else if(splitQrText[0] == "ARC"){
						name = $filter('translate')('ARCHIVER')
						res = await getPatient(splitQrText[1]);
					}else {
						name = "-"
						res = await getPatient(splitQrText[0]);
					}
					if(res){
						model.scan().files.list[i].name = model.scan().files.selected.name ? model.scan().files.selected.name : name;
						profId = splitQrText[2] ? splitQrText[2] : res.treatingProfessionnal
						model.scan().files.list[i].profs = [];
						model.scan().files.list[i].profs.push(model.store.profs.list().find(function(prof){
							return prof.id == profId;
						}))
						model.scan().files.list[i].patient = res;
						model.scan().files.list[i].idPatient = res.id;
						if(splitQrText[0] == "VIS"){
							model.scan().files.list[i].encounterProfessional = model.scan().files.list[i].profs[0];
						}
						if(model.scan().files.list[i].profs[0]){
							docList.push($scope.prepareDocForSave(model.scan().files.list[i], false));
						}						
					}else{
						model.notice().warn($filter('translate')('scan_pat_not_found', {name : model.scan().files.selected.origName}));
					}
				}
			}
			DocAccessor.saveQRCode(docList, function(res){
				model.notice().success($filter('translate')('qrcode_sort_success'));
				var isSelected = false;
				for(i=0; docList.length > i; i++){
					const index = model.scan().files.list.findIndex(e => e.origName == docList[i].origName);
					if(!isSelected){
						isSelected = model.scan().files.list[index] == model.scan().files.selected;
					}
					if(model.scan().directoryHandler){
						model.scan().directoryHandler.removeEntry(model.scan().files.list[index].origName).then(function(){
						}, function(error){
							console.log(error)
						})
					}
					$scope.deleteFromList(model.scan().files.list[index]);
				}
				if(isSelected){
					switchOrReset()
				}
				isSaving = false;
				model.actUpdated(true);
			})
		}
		
		function getPatient(recNumber){
			return PatientAccessor.findPatientExactNoDossier(b64EncodeUnicode(recNumber.trim())).then(resolvePatient);
		}
		
		function resolvePatient(res){
			if(res && res.data && res.data.success!==false){
				return res.data;
			}else{
				return undefined;
			}
		}
		
		$scope.deleteFromList = function(file){
			const index = model.scan().files.list.findIndex((e) => e.$$hashKey == file.$$hashKey);
			if (index > -1){
				model.scan().files.list.splice(index, 1)
			}
			model.scan().createTask = false;
		}
		
		$scope.getScannedDoc = function(){
			
			$scope.noFileFound = false;
			model.actUpdated(true);
			var data = {
				idUser: model.user().session.user.id,
				startCreateDate: moment(model.scan().currSearchDate).startOf('day').valueOf(),
				endCreateDate: moment(model.scan().currSearchDate).startOf('day').valueOf(),
				getFuturAppts: false,	
			}
			$scope.isSearching = true;
			DocAccessor.searchDoc(data,function(res){
				$scope.isSearching = false;
				if (res.data.success===false) {
					model.notice().warn(res.data.ms);
				} else {
					model.scan().viewType = "fileToEdit";
					if(res.data &&  res.data.length > 0){
						isFileToEditDirty(loadNewEditList, res.data)
					}else{
						$scope.noFileFound = true;
					}
				}
			}, function(err) {
				console.log(err);
				model.notice().warn($filter('translate')('error') + ": " + err);										
				scope.isSearching = false;			
			});
		}
		
		function loadNewEditList(data){
			model.scan().filesToEdit.list = [];
			model.scan().filesToEdit.selected = undefined;
			model.scan().filesToEdit.list = data;
//			$scope.switchFile(data[0]);
		}
		
		$scope.selectFile = function() {
			addFile = function(){
				setTimeout(function() {
			        document.getElementById('fileElem').click();
			    }, 0);
			} 
			isFileToEditDirty(addFile)
		};
		
		$scope.addNewFile = function(file){
			if(file){
				model.scan().viewType = 'fileToAdd';
				var kb = Math.round(file.size/1024);
				$scope.fileTooBig = false;
				$scope.fileNotSupported = false;
				if(kb > 5120){
					$scope.fileTooBig = true;
					return;
				}
				// Ensure it's an image
				// if(file.type.match(/image.*|application.*/)) 
				if(file.type == 'application/pdf'|| file.type == 'image/png' || file.type == 'image/jpeg') {
					// Load the image
					var reader = new FileReader();				
					reader.onload = function (readerEvent) {
						var reader = new FileReader();				
						reader.onload = function (readerEvent) {
							if(file.type == 'application/pdf'){
								convertPdfFile(readerEvent, file, true)
								updateAndSortList()
							}else if(file.type == 'image/png' || file.type == 'image/jpeg'){
								var image = new Image();
								image.onload = function (imageEvent) {
									convertImgFile(readerEvent, image, file, true)
									updateAndSortList()
								}
								image.src = readerEvent.target.result;
							}
						}
						reader.readAsDataURL(file);
					}
					reader.readAsDataURL(file);
				}else{
					$scope.fileNotSupported = true;
					return
				}
			}
		}
		
		$scope.switchFile = function(file){
			if(model.scan().viewType == 'fileToAdd'){
				delete model.scan().files.selected;
				model.scan().files.selected = file;
				$scope.docFunction.getDocProf(file);
				$timeout(function(){
                    if($scope.docFunction.focus){
                        $scope.docFunction.focus();
                    }
                }, 50)
			}else if(model.scan().viewType == 'fileToEdit'){
				if ($scope.quickViewData==undefined){
					// si on veut que le scope.$watch fonctionne dans le doc.js, il faut réutiliser scope.quickViewData si existe deja. 
					$scope.quickViewData = {};
				}
				isFileToEditDirty(selectEditFile, file)	
			}
			model.actUpdated(true);
		}
		
		function selectEditFile(file){
			$scope.quickViewData.qvActData = file;
			file.fromSearch = false;
			model.scan().filesToEdit.selected = file
			model.actUpdated(true);
		}
		
		function isFileToEditDirty(fct, file){
			if ($scope.quickViewData && $scope.quickViewData.qvActData && $scope.quickViewData.qvActData.hasModification()){
				QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}, {windowClass:'top-modal'}).then(function(save){
					if(save){
						$scope.quickViewData.qvActData.save().then(function(data){
							if(fct){
								fct(file);
							}
						});
					}else if(fct){
						fct(file);
					}
				});
			}else if(fct){
				fct(file);
			}
		}
		
		$scope.actOptions = {verbose: false, fct:$scope.switchFile, showSendToProf: true};
		
		function defaultImage (input, origDoc){
			var act = {
				rawImage: input.rawImage,
				modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
				sanitizedImage: input.sanitizedImage,
				picture: Array.from(convertDataURIToBinary(input.sanitizedImage)),
				className: "CBasePatientImage",
				date: moment().format("YYYY-MM-DD"),
				isNew: true,
				profs:[],
				idPatient: undefined,
				patient: undefined,
				pictureUpload: true,
				origName: origDoc.name,
				origFile: input.file,
				size: Math.round(origDoc.size/1024) + "kb"
			}
			if(input.file.type=="image/png" || input.file.type=="image/jpeg"){
				act.t = 'imgviewer'
			}else{
				act.t = 'pdfviewer'
			}
			return act;
		}
		
		function dataURLToBlob(dataURL) {
			var BASE64_MARKER = ';base64,';
			if (dataURL.indexOf(BASE64_MARKER) == -1) {
				var parts = dataURL.split(',');
				var contentType = parts[0].split(':')[1];
				var raw = parts[1];

				return new Blob([raw], {type: contentType});
			}

			var parts = dataURL.split(BASE64_MARKER);
			var contentType = parts[0].split(':')[1];
			var raw = window.atob(parts[1]);
			var rawLength = raw.length;

			var uInt8Array = new Uint8Array(rawLength);

			for (var i = 0; i < rawLength; ++i) {
				uInt8Array[i] = raw.charCodeAt(i);
			}

			return new Blob([uInt8Array], {type: contentType});
		}
		
		function convertDataURIToBinary(dataURI) {
			var BASE64_MARKER = ';base64,';
			var base64Index = dataURI.indexOf(BASE64_MARKER) + BASE64_MARKER.length;
			var base64 = dataURI.substring(base64Index);
			var raw = window.atob(base64);
			var rawLength = raw.length;
			var array = new Uint8Array(new ArrayBuffer(rawLength));

			for(var i = 0; i < rawLength; i++) {
				array[i] = raw.charCodeAt(i);
			}
			return array;
		}
		
		function updateAndSortList(){
			model.scan().files.list.sort((a,b) => (a.origName.toLowerCase().localeCompare(b.origName.toLowerCase())));
			$scope.qrCodeScan();
			model.actUpdated(true);
		}
		
		function convertPdfFile(readerEvent, file, fromNewFile){
			var input = {
				rawImage: readerEvent.target.result,
				sanitizedImage: readerEvent.target.result,
				file: file,
				fromNewFile: fromNewFile,
			};
			file = defaultImage(input, file);
			model.scan().files.list.push(file);
			if(!model.scan().files.selected){
				model.scan().files.selected = file
			}
		}
		
		function convertImgFile(readerEvent, image, file, fromNewFile){
			var canvas = document.createElement('canvas'),
				max_size = 900,
				width = image.width,
				height = image.height;
			if (width > height) {
				if (width > max_size) {
					height *= max_size / width;
					width = max_size;
				}
			} else {
				if (height > max_size) {
					width *= max_size / height;
					height = max_size;
				}
			}
			canvas.width = width;
			canvas.height = height;
			canvas.getContext('2d').drawImage(image, 0, 0, width, height);
			var dataUrl = canvas.toDataURL('image/jpeg');
			var resizedImage = dataURLToBlob(dataUrl);
			$.event.trigger({
				type: "imageResized",
				blob: resizedImage,
				url: dataUrl
			});
			var input = {
				rawImage: readerEvent.target.result,
				sanitizedImage: dataUrl,
				file: file,
				fromNewFile: fromNewFile,
			};
			file = defaultImage(input, file);
			if(model.clientPreferences().onCallProfessionnal){
				file.profs[0] = model.clientPreferences().onCallProfessionnal ;
			}
			model.scan().files.list.push(file);
			if(!model.scan().files.selected){
				model.scan().files.selected = file
			}
		}

		$scope.prepareDocForSave = function(file, createTask){
			var toSave = angular.copy(file);
			toSave.result = model.scan().state;
			toSave.labels = model.scan().selectedLabels;
			let profs = [];
			if(toSave.labels.some((obj) => obj.id == -2)){
				toSave.encounterProfessional = model.scan().chosenProfLabel;
				if(!file.profs || file.profs.length == 0 || (file.profs.length == 1 && file.profs[0].isOnCall)){
					file.profs = []
					profs.push(doGetDocProf(model.scan().chosenProfLabel));
				}
			}
			if(file.profs){
				file.profs.forEach(function(prof){
					profs.push(doGetDocProf(prof, file.qrEncounter));
				})
			}
			toSave.profs = profs
			if(toSave.encounterProfessional){
				const i = toSave.profs.findIndex(element => element.idProf == toSave.encounterProfessional.id);
  				if (i > -1) toSave.profs[i].st = ['SEEN'];
			}
			toSave.doCreateTaskOnSave = createTask;
			if(file.qrEncounter && file.qrEncounter.date){
				toSave.labels = $scope.listDocLabels.filter(label => label.id == -2)
				toSave.date = moment(file.qrEncounter.date).startOf('day').format("YYYY-MM-DD");
				toSave.datetimeScanned = moment().valueOf();
			}else{
				date = angular.copy(model.scan().currDate);
				toSave.date = moment(date).startOf('day').format("YYYY-MM-DD");
				toSave.datetimeScanned = moment().valueOf();
			}
			return toSave;
		}

		function doGetDocProf(prof, qrEncounter){
			var res = {
				idProf:prof.id,
				profName:prof.lastName + ", "+ prof.firstName,
				dateAssigned: moment().valueOf(),
				modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
				st: [],
				activeSt: []
			};
			
			if(model.scan().seenByProf || (qrEncounter && qrEncounter.isSeen)){
//				res.seenDatetime = time;
				res.st.push('SEEN');
				res.activeSt.push('SEEN');
			} else {
				res.st.push('UNSEEN');
				res.activeSt.push('UNSEEN');
			}
			return res;
		}
		
		$scope.deleteFile = async function(){
			var qconfirmOptions = {
				title: $filter('translate')('delete_num_file'),
				descriptions: [$filter('translate')('delete_num_file_folder')]
			};
			QConfirm.open(qconfirmOptions).then(function(proceed){
				if(proceed){
					if(model.scan().directoryHandler){
						model.scan().directoryHandler.removeEntry(model.scan().files.selected.origName).then(function(){
							$scope.deleteFromList(model.scan().files.selected);
							switchOrReset();
						}, function(error){
							$scope.deleteFromList(model.scan().files.selected);
							switchOrReset();
							console.log(error.name)
						})
					} else {
						$scope.deleteFromList(model.scan().files.selected);
						switchOrReset();
					}
				}
			});
		}
		
		function switchOrReset(){
			if(model.scan().files.list.length > 0){
				$scope.switchFile(model.scan().files.list[0]);
			} else {
				$scope.pdfjs.lib = undefined;
				$scope.docFunction.resetDoc();
				delete model.scan().files.selected
			}
			model.actUpdated(true);
		}
		
		model.callDashBoardCount();
		
	}]);
	
	/**
	 * COMMENT: SCAN ADDFILE @directive
	 *
	 * La directive sert seulement à afficher la section research pour le moment.
	 *
	 */
	scan.directive('scanAddDoc', ['DocAccessor', 'model', '$filter', 'QConfirm', '$timeout',
					'PatientFormService', '$q', 'FlView', 'patientShowTitles', 'Rights',
        	        function(DocAccessor, model, $filter, QConfirm, $timeout,
        	         PatientFormService, $q, FlView, patientShowTitles, Rights){

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/doc/scan_add_doc.html?v=bf',
			//scope: true,
			link: function(scope){
				
				scope.resultatItems = [{n:$filter('translate')('SO'), id:'SO'},
				                       {n:$filter('translate')('NORMAL'), id:'NORMAL'},
				                       {n:$filter('translate')('ANORMAL'), id:'ANORMAL'},
				                       {n:$filter('translate')('VERY_ANORMAL'), id: 'VERY_ANORMAL'}];
				
				scope.docDynaDateOptions = {
					acceptFutureDate: false,
					onDateSelected: function (mDate, dAssist) {
						if(mDate){
							var m = mDate.format('YYYY-MM-DD');
							model.scan().currDate = m;
						}
					}
				};
				
				/**
				 * COMMENT: SCAN DOC FUNCTION @function
				 *
				 * Groupe de fonction à utiliser par le parent lors du changement de document/fichier
				 * Permet de mettre à jour la section "view" selon le contexte
				 * 	
				 */
				scope.docFunction.resetDoc = function(){
					if(model.scan().files.selected){
						delete model.scan().files.selected.patient;
						delete model.scan().files.selected.idPatient;
						delete model.scan().files.selected.profs;
						delete model.scan().files.selected.name;
					}
					model.scan().state = "SO";
					scope.groupCriteria[0].selectedList = []
					angular.forEach(scope.listDocLabels, function(item){
						item.selected = false;
					})
					model.scan().seenByProf;
					model.actUpdated(true);
				}
				
				scope.docFunction.getDocProf = function(file){
					var profSelect = scope.groupCriteria.find(function (e) {
						return e.name === 'scanProfSelector';
					})
					profSelect.selectedList = []
					if(file.profs && file.profs.length > 0){
						file.profs.forEach(function(prof){	
							if (profSelect && typeof profSelect.select === 'function') {
								profSelect.select(prof);
							}
						})
					}
				}
				
				scope.checkIfPdf = function(){
					return model.scan().files.selected && model.scan().files.selected.origName && model.scan().files.selected.t == "pdfviewer"
				}
				
				scope.checkIfImg = function(){
					return model.scan().files.selected && model.scan().files.selected.origName && model.scan().files.selected.t == "imgviewer"
				}
				
				/**
				 * COMMENT: SCAN SAVE @function
				 *
				 * Sauvegarde le document numeriser, la fonction checkPatient() permet d'assurer que la "form"" est ok
				 * saveDoc permet la sauvegarde ainsi que la suppression du document dans le dossier si ouvert
				 * et de choisir un nouveau document à afficher
				 * 	
				 */
				function checkPatient(){
					return model.scan().files.selected && model.scan().files.selected.patient 
							&& ((model.scan().files.selected.profs && model.scan().files.selected.profs.length > 0 && model.scan().files.selected.profs[0] != undefined) 
							|| (model.scan().selectedLabels.some((obj) => obj.id == -2)))
				}
				
				scope.isSaving = false;
				scope.isDeletingDoc = false;
				scope.saveDoc = function(frm){
					if(!model.scan().files.selected.name && model.scan().selectedLabels.some((obj) => obj.id == -1)){
						model.scan().files.selected.name = $filter('translate')('PatientMedSummary');
						frm.$valid = true;
					} else if(!model.scan().files.selected.name && model.scan().selectedLabels.some((obj) => obj.id == -2)){
						if(model.scan().currDate){
							date = angular.copy(model.scan().currDate);
							time = moment(date).startOf('day').format("YYYY-MM-DD");
						}else{
							time = moment().format("YYYY-MM-DD");
						}
						model.scan().files.selected.name = $filter('translate')('ENCOUNTER') + " ("+ time +")";
						frm.$valid = true;
					}
					scope.frmErrors = PatientFormService.getFormErrors(frm);
					if(frm.$valid && checkPatient()){
						scope.isSaving = true;
						delete scope.frmErrors;
						let toSave = scope.prepareDocForSave(model.scan().files.selected, model.scan().createTask)
						DocAccessor.save(toSave, function(res){
							if(model.scan().directoryHandler){
								scope.isDeletingDoc = true;
								let fileName = model.scan().files.selected.origName;
								model.scan().directoryHandler.removeEntry(fileName).then(function(){
									console.log('fichier retirer avec succès')
									scope.isDeletingDoc = false;
								}, function(error){
									console.log(error)
									scope.isDeletingDoc = false;
								})
							}
							scope.deleteFromList(model.scan().files.selected);
							if(model.scan().files.list.length > 0){
								scope.switchFile(model.scan().files.list[0]);
								const index = model.scan().selectedLabels.findIndex((obj) => obj.id == -2);
								if (index > -1) {
									model.scan().selectedLabels[index].selected = false;
								}
								if(model.scan().chosenProfLabel){
									delete model.scan().chosenProfLabel;
								}
							} else {
								scope.docFunction.resetDoc();
								delete model.scan().files.selected
							}
							scope.isSaving = false
							model.actUpdated(true);
							
						}, function(err) {
							console.log(err);
//							model.notice().warn($filter('translate')('error') + ": " + err);										
							scope.isSaving = false;			
						});	
					} else if(frm.$valid){
						scope.frmErrors = [{msg : $filter('translate')('scan_err_par')}];	
					}
				}
				
				/**
				 * COMMENT: SCAN ALERT @function
				 *
				 * seenByProfAlert et createTaskAlert permette d'afficher une alerte pour avertir l'utilisateur
				 * du comportement attendu des checkbox. Un true/false gloable est ajouter afin de ne pas "spammer"
				 * l'utilisateur inutilement
				 * 	
				 */
				scope.seenByProfAlert = function(){
					if(model.scan().seenByProfAlert){
						model.scan().seenByProfAlert = !model.scan().seenByProfAlert;
						var qconfirmOptions = {
							title: $filter('translate')('seen_by_prof_alert'),
							qconfirm: {hideCancel: true}
						};
						QConfirm.open(qconfirmOptions).then(function(proceed){
							if(!proceed){
								model.scan().seenByProf = false;
							}
						});
					}
				}
				
				scope.createTaskAlert = function(){
					if(model.scan().createTaskAlert){
						model.scan().createTaskAlert = !model.scan().createTaskAlert;
						var qconfirmOptions = {
							title: $filter('translate')('create_task_alert'),
							qconfirm: {hideCancel: true}
						};
						QConfirm.open(qconfirmOptions).then(function(proceed){
							if(!proceed){
								model.scan().createTask = false;
							}
						});
					}
				}
				
				/**
				 * COMMENT: SCAN LABEL @function
				 *
				 * Vérifie les étiquettes sélectionner et les rajoutes dans le model
				 * Ajoute aussi une vue de type "FlView" qui permet la sélection du prof si l'étiquette rencontre est sélectionner
				 * Les méthodes pour s'occuper du modal doit être passer en paramètre sinon ce n'est pas fonctionnel
				 * 	
				 */			
				scope.$watch('listDocLabels|filter:{selected:true}', function (nv, ov) {
					model.scan().selectedLabels = nv.map(function (option) {
						if(option.id == -2 && !ov.some((obj) => obj.id == -2)){
							FlView.open({templateUrl: "/dashboard/resources/ofys/doc/doc_link_prof.html?v=bf", 
											closeLabelModal: scope.closeLabelModal,
											selectEncProf: scope.selectEncProf,
											focusable: scope.focusable}, 
											{backdrop: 'static',windowClass:'recallmodal'})
						}
				   		return option;
					});
				}, true);
		
				scope.closeLabelModal = function(){
					const index = model.scan().selectedLabels.findIndex((obj) => obj.id == -2);
					if (index > -1) {
						model.scan().selectedLabels[index].selected = false;
					}
					if(model.scan().chosenProfLabel){
						delete model.scan().chosenProfLabel;
					}
					model.actUpdated(true);
				}
				
				scope.selectEncProf = function(prof){
					model.scan().chosenProfLabel = prof;
			        return prof.lastName + ', '+ prof.firstName;
				}
				
				scope.focusable = {};
				
				/**
				 * COMMENT: SCAN PATIENT @function
				 *
				 * Permet la recherche, la sélection et la suppresion du patient dans la forme
				 * utilise la directive searchPatient de patient.js
				 * 	
				 */
				scope.getPatientName = function(patient){
					return patient.firstName + " " + patient.lastName;
				}
				
				scope.removePatient = function(){
					delete model.scan().files.selected.patient;
					delete model.scan().files.selected.idPatient;
					model.actUpdated(true);
				}
				
				scope.patientSearch = {
		            onSelect:function(pat){
						if(model.scan().files.selected){
							pat.viewbag = {limitations:Rights.getConsent()};
			            	model.scan().files.selected.patient = pat;
							model.scan().files.selected.idPatient = pat.id;
							model.scan().files.selected.profs = [];
							if(pat.treatingProfessionnal){
								model.scan().files.selected.profs.push(model.store.profs.list().find(function(prof){
									return prof.id == pat.treatingProfessionnal && prof.isProfTx
								}))
							}
							
							if(model.scan().files.selected.profs && !model.scan().files.selected.profs[0]){
								delete model.scan().files.selected.profs;
								model.scan().files.selected.profs = [];
								if(scope.onCallProf){
									model.scan().files.selected.profs.push(scope.onCallProf);
								}
							}
							if(model.scan().files.selected.profs && model.scan().files.selected.profs[0]){
								var profSelect = scope.groupCriteria.find(function (e) {
									return e.name === 'scanProfSelector';
								})
								profSelect.selectedList = []
								if (profSelect && typeof profSelect.select === 'function') {
									profSelect.select(model.scan().files.selected.profs[0]);
								}
							}
						}
						model.actUpdated(true);
		            }
		        }
				
				scope.showPatientHtml = function(pat) {
					return patientShowTitles.showPatientHtml(pat);
				};
				
				/**
				 * COMMENT: SCAN PROF @function
				 *
				 * Utilise les searchPeriodCriteria (voir appointment.js pour un fontionnement plus complet) 
				 * pour gérer les profs. profList(q) contient une vérification pour empêcher l'ajout de prof non traitant
				 * 	
				 */
				function SearchPeriodResults(idProfessionnal) {
					this.idProfessionnal = idProfessionnal
				}
				
				SearchPeriodResults.prototype.getProfStr = function () {
					var periodResults = this;
					if (!periodResults.profStr && periodResults.idProfessionnal) {
						model.store.profs.get(periodResults.idProfessionnal, function(prof){
							periodResults.profStr = prof.lastName + ", " + prof.firstName
						})
					}
					return this.profStr
				}
		
				scope.profList = $filter('orderBy')(model.store.profs.filter.treating.list(), ['lastName', 'firstName']);
				function profList (q){
					return $q(function (resolve, reject){
						resolve(scope.profList.filter((a) => {
							if(model.scan().files.selected && model.scan().files.selected.profs){
								return (!model.scan().files.selected.profs.find(e => e.id == a.id)) && a.id > -1
									 && a.str.toLowerCase().includes(q.toLowerCase());
							} else {
								return true;
							}
						}))
					})
					
				}
				
				scope.groupCriteria = [];
				scope.groupCriteria.push({
					name: "scanProfSelector",
					list: profList,
					selectable: false,
					selectedList: [],
					selectorName:function (prof) {
						return prof.lastName + ', '+ prof.firstName + (prof.isOnCall == true ? " (" +$filter("translate")("on_call") + ")" : "");
					},
					getForCriteria: function (criteria) {
						criteria.professionnals = [];
						if (this.selectedList.length > 0 && criteria) {
							for (var i = 0; i < this.selectedList.length; i++) {
								criteria.professionnals.push(this.selectedList[i].obj.id)
							}
		
						}
					},
//					inputPlaceHolder: $filter("translate")("FILTER_BY_PROF"),
				});
				
				
				/**
				 * COMMENT: SCAN PROF @watch
				 *
				 * Gère les profs ajouter/supprimer
				 * 	
				 */
				scope.$watchCollection('groupCriteria[0].selectedList', function (nv) {
					if(model.scan().files.selected && scope.groupCriteria[0].select){
						var indexOnCall = undefined;
						model.scan().files.selected.profs = [];
						for(let i = 0; i < nv.length; i++){
							if(nv[i].obj.isOnCall && nv.length > 1){
								indexOnCall = i;
							}else{
								model.scan().files.selected.profs.push(nv[i].obj)	
							}	
						}
						if(indexOnCall > -1){
							nv.splice(indexOnCall, 1)
						}
					}
				})
				angular.element(function () {
				    scope.docFunction.getDocProf(model.scan().files.selected);
				});
				
				function initialFocus(){
                    $timeout(function(){
                        if(scope.docFunction.focus){
                            scope.docFunction.focus();
                        }
                    }, 50)
                };
                
                initialFocus();
			}
		};
	}]);
	
	scan.directive('scanEditDoc', ['model', function(model){

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/doc/scan_edit_doc.html?v=bf',
			//scope: true,
			link: function(scope){
				
			}
		};
	}])
})();