/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.communication.XFaxSend;
import ca.infodata.ofys.data.middle.dataobjects.communication.XFaxStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import java.text.ParseException;
import org.apache.commons.lang3.time.FastDateFormat;

public class CFaxSend
extends CEditableDataObject {
    private static final long serialVersionUID = 1L;
    public String className = CFaxSend.class.getSimpleName();
    public int uid;
    public Integer id;
    public String account;
    public String fileName;
    public String destination;
    public String stamp;
    public String document;
    public XFaxStatus status;
    public int statusId;
    public Long faxId;
    public String statusString;
    public Boolean withCoverPage;
    public String coverPageLangue;
    public String coverPageFrom;
    public String coverPageOrganisation;
    public String coverPageSubject;
    public String coverPageNote;
    public Integer idUser;
    public CPatient patient;
    public Integer idPatient;
    public byte[] picture;
    public String viewerUrl;
    public String user;
    public short resend;

    public CFaxSend() {
    }

    public CFaxSend(XFaxSend x) {
        this.init(x);
    }

    public void init(XFaxSend x) {
        this.uid = Utils.getNewAtomicInteger();
        this.className = CFaxSend.class.getSimpleName();
        this.id = x.getId();
        this.idPatient = x.getIdPatient();
        this.patient = x.getPatient() == null ? null : new CPatient((XPatient)x.getPatient());
        this.account = x.getAccount();
        this.coverPageFrom = x.getCoverPageFrom();
        this.coverPageLangue = x.getCoverPageLangue();
        this.coverPageNote = x.getCoverPageNote();
        this.coverPageOrganisation = x.getCoverPageOrganisation();
        this.coverPageSubject = x.getCoverPageSubject();
        this.destination = x.getDestination();
        this.document = x.getDocument();
        this.faxId = x.getFaxId() == null || x.getFaxId() == -1L ? null : x.getFaxId();
        this.fileName = x.getFileName();
        this.idUser = x.getIdUser();
        this.stamp = FastDateFormat.getInstance((String)(FormatDateProvider.getFormatDate().toString() + " HH:mm")).format(x.getStamp());
        this.status = x.getStatus();
        this.statusId = x.getStatus().getValue();
        this.statusString = x.getStatusString();
        this.resend = x.getResend();
    }

    public String getFileName() {
        String res = "";
        if (this.fileName != null && !this.fileName.equals("")) {
            res = res + this.fileName.replaceAll("[\\s \\/]", "_");
        }
        return res;
    }

    public XFaxSend x() {
        XFaxSend x = new XFaxSend();
        x.setId(this.id);
        x.setIdPatient(this.id);
        x.setAccount(this.account);
        x.setCoverPageFrom(this.coverPageFrom);
        x.setCoverPageLangue(this.coverPageLangue);
        x.setCoverPageNote(this.coverPageNote);
        x.setCoverPageOrganisation(this.coverPageOrganisation);
        x.setCoverPageSubject(this.coverPageSubject);
        x.setDestination(this.destination);
        x.setDocument(this.document);
        x.setFaxId(this.faxId);
        x.setFileName(this.fileName);
        x.setIdUser(this.idUser);
        try {
            x.setStamp(FastDateFormat.getInstance((String)(FormatDateProvider.getFormatDate().toString() + " HH:mm")).parse(this.stamp));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        x.setStatus(this.status);
        x.setStatusString(this.statusString);
        x.setResend(this.resend);
        return x;
    }

    public <T> CEditableDataObject convertc(T type) {
        XFaxSend x = (XFaxSend)XFaxSend.class.cast(type);
        this.init(x);
        return this;
    }

    public XFaxSend convertx() {
        return this.x();
    }
}

